/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.util.Formatter;
import java.util.Locale;
import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.HypoExponentialDist;
import umontreal.iro.lecuyer.util.PrintfFormat;
import umontreal.iro.lecuyer.util.RootFinder;

public class HypoExponentialDistQuick
extends HypoExponentialDist {
    private double[] m_H;

    private static double[] computeH(double[] lambda) {
        int k = lambda.length;
        double[] H = new double[k];
        for (int i = 0; i < k; ++i) {
            int j;
            double tem = 1.0;
            for (j = 0; j < i; ++j) {
                tem *= lambda[j] / (lambda[j] - lambda[i]);
            }
            for (j = i + 1; j < k; ++j) {
                tem *= lambda[j] / (lambda[j] - lambda[i]);
            }
            H[i] = tem;
        }
        return H;
    }

    private static double m_density(double[] lambda, double[] H, double x) {
        if (x < 0.0) {
            return 0.0;
        }
        int k = lambda.length;
        double prob = 0.0;
        for (int j = 0; j < k; ++j) {
            prob += lambda[j] * H[j] * Math.exp(-lambda[j] * x);
        }
        return prob;
    }

    private static double m_barF(double[] lambda, double[] H, double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        int k = lambda.length;
        double prob = 0.0;
        for (int j = 0; j < k; ++j) {
            prob += H[j] * Math.exp(-lambda[j] * x);
        }
        return prob;
    }

    public HypoExponentialDistQuick(double[] lambda) {
        super(lambda);
        this.m_H = HypoExponentialDistQuick.computeH(lambda);
    }

    public double density(double x) {
        return HypoExponentialDistQuick.m_density(this.m_lambda, this.m_H, x);
    }

    public double cdf(double x) {
        return 1.0 - HypoExponentialDistQuick.m_barF(this.m_lambda, this.m_H, x);
    }

    public double barF(double x) {
        return HypoExponentialDistQuick.m_barF(this.m_lambda, this.m_H, x);
    }

    public double inverseF(double u) {
        return HypoExponentialDistQuick.m_inverseF(this.m_lambda, this.m_H, u);
    }

    public static double density(double[] lambda, double x) {
        HypoExponentialDistQuick.testLambda(lambda);
        double[] H = HypoExponentialDistQuick.computeH(lambda);
        return HypoExponentialDistQuick.m_density(lambda, H, x);
    }

    public static double cdf(double[] lambda, double x) {
        return 1.0 - HypoExponentialDistQuick.barF(lambda, x);
    }

    public static double barF(double[] lambda, double x) {
        HypoExponentialDistQuick.testLambda(lambda);
        double[] H = HypoExponentialDistQuick.computeH(lambda);
        return HypoExponentialDistQuick.m_barF(lambda, H, x);
    }

    public static double inverseF(double[] lambda, double u) {
        HypoExponentialDistQuick.testLambda(lambda);
        double[] H = HypoExponentialDistQuick.computeH(lambda);
        return HypoExponentialDistQuick.m_inverseF(lambda, H, u);
    }

    private static double m_inverseF(double[] lambda, double[] H, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return 0.0;
        }
        double EPS = 1.0E-12;
        myFunc fonc = new myFunc(lambda, u);
        double x1 = HypoExponentialDistQuick.getMean(lambda);
        double v = 1.0 - HypoExponentialDistQuick.m_barF(lambda, H, x1);
        if (u <= v) {
            return RootFinder.brentDekker(0.0, x1, fonc, 1.0E-12);
        }
        double x2 = 4.0 * x1 + 1.0;
        v = 1.0 - HypoExponentialDistQuick.m_barF(lambda, H, x2);
        while (v < u) {
            x1 = x2;
            x2 = 4.0 * x2;
            v = 1.0 - HypoExponentialDistQuick.m_barF(lambda, H, x2);
        }
        return RootFinder.brentDekker(x1, x2, fonc, 1.0E-12);
    }

    public void setLambda(double[] lambda) {
        super.setLambda(lambda);
        this.m_H = HypoExponentialDistQuick.computeH(lambda);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        formatter.format(this.getClass().getSimpleName() + " : lambda = {" + PrintfFormat.NEWLINE, new Object[0]);
        int k = this.m_lambda.length;
        for (int i = 0; i < k; ++i) {
            formatter.format("   %f%n", this.m_lambda[i]);
        }
        formatter.format("}%n", new Object[0]);
        return sb.toString();
    }

    private static class myFunc
    implements MathFunction {
        private double[] m_lam;
        private double m_u;

        public myFunc(double[] lam, double u) {
            this.m_lam = lam;
            this.m_u = u;
        }

        public double evaluate(double x) {
            return this.m_u - HypoExponentialDistQuick.cdf(this.m_lam, x);
        }
    }
}

