/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class CramerVonMisesDist
extends ContinuousDistribution {
    protected int n;

    public CramerVonMisesDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        return CramerVonMisesDist.density(this.n, x);
    }

    public double cdf(double x) {
        return CramerVonMisesDist.cdf(this.n, x);
    }

    public double barF(double x) {
        return CramerVonMisesDist.barF(this.n, x);
    }

    public double inverseF(double u) {
        return CramerVonMisesDist.inverseF(this.n, u);
    }

    public double getMean() {
        return CramerVonMisesDist.getMean(this.n);
    }

    public double getVariance() {
        return CramerVonMisesDist.getVariance(this.n);
    }

    public double getStandardDeviation() {
        return CramerVonMisesDist.getStandardDeviation(this.n);
    }

    public static double density(int n, double x) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (x <= 1.0 / (12.0 * (double)n) || x >= (double)n / 3.0) {
            return 0.0;
        }
        if (n == 1) {
            return 1.0 / Math.sqrt(x - 0.08333333333333333);
        }
        if (x <= 0.002 || x > 3.95) {
            return 0.0;
        }
        throw new UnsupportedOperationException("density not implemented.");
    }

    public static double cdf(int n, double x) {
        double termS;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (n == 1) {
            if (x <= 0.08333333333333333) {
                return 0.0;
            }
            if (x >= 0.3333333333333333) {
                return 1.0;
            }
            return 2.0 * Math.sqrt(x - 0.08333333333333333);
        }
        if (x <= 1.0 / (12.0 * (double)n)) {
            return 0.0;
        }
        if (x <= ((double)n + 3.0) / (12.0 * (double)n * (double)n)) {
            double t = Num.lnFactorial(n) - Num.lnGamma(1.0 + 0.5 * (double)n) + 0.5 * (double)n * Math.log(Math.PI * (x - 1.0 / (12.0 * (double)n)));
            return Math.exp(t);
        }
        if (x <= 0.002) {
            return 0.0;
        }
        if (x > 3.95 || x >= (double)n / 3.0) {
            return 1.0;
        }
        double EPSILON = 2.220446049250313E-16;
        int JMAX = 20;
        int j = 0;
        double termX = 0.0625 / x;
        double Res = 0.0;
        double[] A = new double[]{1.0, 1.11803398875, 1.125, 1.12673477358, 1.1274116945, 1.12774323743, 1.1279296875, 1.12804477649, 1.12812074678, 1.12817350091};
        do {
            double termJ = 4 * j + 1;
            double arg = termJ * termJ * termX;
            termS = A[j] * Math.exp(-arg) * Num.besselK025(arg);
            Res += termS;
        } while (!(termS < 2.220446049250313E-16) && ++j <= 20);
        if (j > 20) {
            System.err.println("cramerVonMises: iterations have not converged");
        }
        Res /= Math.PI * Math.sqrt(x);
        double Cor = x < 0.0092 ? 0.0 : (x < 0.03 ? -0.0121763 + x * (2.56672 - 132.571 * x) : (x < 0.06 ? 0.108688 + x * (-7.14677 + 58.0662 * x) : (x < 0.19 ? -0.0539444 + x * (-2.22024 + x * (25.0407 - 64.9233 * x)) : (x < 0.5 ? -0.251455 + x * (2.46087 + x * (-8.92836 + x * (14.0988 - x * (5.5204 + 4.61784 * x)))) : (x <= 1.1 ? 0.0782122 + x * (-0.519924 + x * (1.75148 + x * (-2.72035 + x * (1.94487 - 0.524911 * x)))) : Math.exp(-0.244889 - 4.26506 * x))))));
        if ((Res += Cor / (double)n) <= 1.0) {
            return Res;
        }
        return 1.0;
    }

    public static double barF(int n, double x) {
        return 1.0 - CramerVonMisesDist.cdf(n, x);
    }

    public static double inverseF(int n, double u) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u >= 1.0) {
            return (double)n / 3.0;
        }
        if (u <= 0.0) {
            return 1.0 / (12.0 * (double)n);
        }
        if (n == 1) {
            return 0.08333333333333333 + 0.25 * u * u;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.0, 10.0, f, 1.0E-6);
    }

    public static double getMean(int n) {
        return 0.16666666666666666;
    }

    public static double getVariance(int n) {
        return (4.0 * (double)n - 3.0) / (180.0 * (double)n);
    }

    public static double getStandardDeviation(int n) {
        return Math.sqrt(CramerVonMisesDist.getVariance(n));
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.supportA = 1.0 / (12.0 * (double)n);
        this.supportB = (double)n / 3.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - CramerVonMisesDist.cdf(this.n, x);
        }
    }
}

