/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.math.plot.PlotPanel;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.plots.Plot;

public class LegendPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    PlotCanvas plotCanvas;
    PlotPanel plotPanel;
    LinkedList<Legend> legends;
    public static int INVISIBLE = -1;
    public static int VERTICAL = 0;
    public static int HORIZONTAL = 1;
    int orientation;
    private int maxHeight;
    private int maxWidth;
    JPanel container;
    private int inset = 5;

    public LegendPanel(PlotPanel _plotPanel, int _orientation) {
        this.plotPanel = _plotPanel;
        this.plotCanvas = this.plotPanel.plotCanvas;
        this.plotCanvas.attachLegend(this);
        this.orientation = _orientation;
        this.container = new JPanel();
        this.container.setBackground(this.plotCanvas.getBackground());
        this.container.setLayout(new GridLayout(1, 1, this.inset, this.inset));
        this.container.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), null));
        this.updateLegends();
        this.setBackground(this.plotCanvas.getBackground());
        this.addComponentListener(this);
        this.setLayout(new GridBagLayout());
        this.add(this.container);
    }

    public void updateLegends() {
        if (this.orientation != INVISIBLE) {
            this.container.removeAll();
            this.maxHeight = 1;
            this.maxWidth = 1;
            this.legends = new LinkedList();
            for (Plot plot : this.plotCanvas.getPlots()) {
                if (!plot.getVisible()) continue;
                Legend l = new Legend(plot);
                this.legends.add(l);
                this.maxWidth = (int)Math.max((double)this.maxWidth, l.getPreferredSize().getWidth());
                this.maxHeight = (int)Math.max((double)this.maxHeight, l.getPreferredSize().getHeight());
                this.container.add(l);
            }
            this.updateSize();
        }
    }

    private void updateSize() {
        if (this.orientation == VERTICAL) {
            int nh = 1;
            if (this.maxHeight < this.plotCanvas.getHeight()) {
                nh = this.plotCanvas.getHeight() / (this.maxHeight + this.inset);
            }
            int nw = 1 + this.legends.size() / nh;
            ((GridLayout)this.container.getLayout()).setColumns(nw);
            ((GridLayout)this.container.getLayout()).setRows(1 + this.legends.size() / nw);
            this.container.setPreferredSize(new Dimension((this.maxWidth + this.inset) * nw, (this.maxHeight + this.inset) * (1 + this.legends.size() / nw)));
        } else if (this.orientation == HORIZONTAL) {
            int nw = 1;
            if (this.maxWidth < this.plotCanvas.getWidth()) {
                nw = this.plotCanvas.getWidth() / (this.maxWidth + this.inset);
            }
            int nh = 1 + this.legends.size() / nw;
            ((GridLayout)this.container.getLayout()).setRows(nh);
            ((GridLayout)this.container.getLayout()).setColumns(1 + this.legends.size() / nh);
            this.container.setPreferredSize(new Dimension((this.maxWidth + this.inset) * (1 + this.legends.size() / nh), (this.maxHeight + this.inset) * nh));
        }
        this.container.updateUI();
    }

    public void note(int i) {
        if (this.orientation != INVISIBLE && this.legends != null && this.legends.size() > i) {
            this.legends.get(i).setBackground(PlotCanvas.NOTE_COLOR);
            this.legends.get((int)i).name.setForeground(this.plotPanel.getBackground());
        }
    }

    public void nonote(int i) {
        if (this.orientation != INVISIBLE && this.legends != null && this.legends.size() > i) {
            this.legends.get(i).setBackground(this.plotPanel.getBackground());
            this.legends.get((int)i).name.setForeground(PlotCanvas.NOTE_COLOR);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.orientation != INVISIBLE) {
            this.updateSize();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public class Legend
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JPanel color;
        JLabel name;
        Plot plot;
        Border colorborder;

        public Legend(Plot p) {
            this.plot = p;
            this.setLayout(new BorderLayout(2, 2));
            this.color = new JPanel();
            this.colorborder = BorderFactory.createMatteBorder(2, 1, 2, 1, Color.WHITE);
            this.color.setBorder(this.colorborder);
            this.name = new JLabel();
            this.name.setFont(LegendPanel.this.plotPanel.getFont());
            this.setBackground(Color.WHITE);
            this.update();
            this.add((Component)this.color, "West");
            this.add((Component)this.name, "Center");
            this.name.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 16 && LegendPanel.this.plotCanvas.allowEdit && e.getClickCount() > 1) {
                        Legend.this.editText();
                    }
                    if (LegendPanel.this.plotCanvas.allowNote && e.getClickCount() <= 1) {
                        Legend.this.note_nonote();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.color.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 16 && LegendPanel.this.plotCanvas.allowEdit && e.getClickCount() > 1) {
                        Legend.this.editColor();
                    }
                    if (LegendPanel.this.plotCanvas.allowNote && e.getClickCount() <= 1) {
                        Legend.this.note_nonote();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }

        public void editText() {
            String name1 = JOptionPane.showInputDialog(LegendPanel.this.plotCanvas, "Choose name", this.plot.getName());
            if (name1 != null) {
                this.plot.setName(name1);
                this.update();
                LegendPanel.this.updateLegends();
            }
        }

        public void editColor() {
            Color c = JColorChooser.showDialog(LegendPanel.this.plotCanvas, "Choose plot color", this.plot.getColor());
            if (c != null) {
                this.plot.setColor(c);
                this.update();
                LegendPanel.this.plotCanvas.repaint();
            }
        }

        public void update() {
            int size = this.name.getFont().getSize();
            this.color.setSize(new Dimension(size, size));
            this.color.setPreferredSize(new Dimension(size, size));
            this.color.setBackground(this.plot.getColor());
            this.name.setText(this.plot.getName());
            this.repaint();
        }

        public void note_nonote() {
            this.plot.noted = !this.plot.noted;
            LegendPanel.this.plotCanvas.repaint();
        }
    }
}

