"""A machine learning approach to variant filtering using XGBoost

ExtremeVariantFilter is a machine learning based approach to variant filtering.
Provided models were trained on stLFR libraries from Complete Genomics.
These were generated from cell lines for HG001, HG002, HG003, HG004 and HG005.
This package provides functionality for applying existing models to VCFs,
as well as developing models based on personal or existing data.

Commands
--------
apply_filter (--vcf STR) (--snp-model STR) (--indel-model STR) [--verbose]
    Apply models generated by train_model to a VCF.

train_model (--true-pos STR) (--false-pos STR) (--type STR) [--out STR] [--njobs INT] [--verbose]
    Train a model to be saved and used to filter VCFs.

Functions
---------
Open_VCF(vcf_path)
    Given a vcf path returns a vcf loaded into memory as a DataFrame

Split_Info(info)
    Given a vcf info column, returns necessary info fields as a dict

Get_Calls_Info(vcf)
    Given a vcf returns encoded genotypes, reference and alternate
    allele depths, reference allele percentage and alternate
    allele ratio as a DataFrame

check_type(poly)
    Ensures input for polymorphism type is an accepted value

Get_Header(vcf_path)
    Splits header from input vcf and stores it as a a list

Check_SNP(vcf)
    Checks whether input variant is a SNP and returns a boolean

Predict_Var(vcf, snp_mdl, ind_mdl)
    Given a vcf, snp and indel models, returns a prediction as to
    whether or not the variant is real or now

Add_Filter(vcf)
    Updates the filter column value based on a variants predicted
    truth value

Get_Name(path)
    Given the path to the vcf, returns the root file name
    with '.filter.vcf' appended

Write_VCF(table, header, outname)
    Outputs the updated vcf with filter values added

Make_Table(vcf, label)
    Given a path for a true positive or false positive vcf and a label,
    loads the vcf into memory as a DataFrame and appends the label to
    the last column

Get_Training_Table(tp_vcf, fp_vcf)
    Given a true and false positive vcf paths, calls
    Make_Table() for both and then appends the
    DataFrames together

Get_Training_Tables(tp_fp_tup)
    Given a set of comma seperated true and false vcf paths,
    calls Make_Table for all paths and then appends the
    DataFrames together

Build_Model(poly, njobs)
    Returns an XGBoost classifier object with particular
    characteristics depending on whether it is being built
    to classify SNPs or InDels
"""

from .variant_filtering import *
