% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_plots.R
\name{plot_insertions}
\alias{plot_insertions}
\title{Plots insertions using ggplot2.}
\usage{
plot_insertions(alignments, config, id, cut_buffer = 5,
  xlab_spacing = 4)
}
\arguments{
\item{alignments}{(data.frame) Loaded alignment information from
alignments_events.csv file.}

\item{config}{(data.frame) Loaded table from config_summary.csv file.}

\item{id}{(string or vector of strings) Name of the ID column from config
file or name of multiple IDs if it is
possible to group them. First amplicon will be used as the basis for plot.}

\item{cut_buffer}{(numeric) Default is 5, you should specify the same as
used in the analysis.}

\item{xlab_spacing}{(numeric) Spacing of the x axis labels. Default is 4.}
}
\value{
(insertions plot) gtable object of insertions plot
}
\description{
This function plots insertions in relation to the amplicon. Top plot is for
the forward reads, middle one shows
amplicon sequence, and bottom plot is for reverse reads.
}
\examples{
#example config
config <- read.csv(system.file("extdata", "results", "config_summary.csv",
                               package = "amplican"))
#example alignments results
alignments_file <- system.file("extdata", "results", "alignments",
                               "events_filtered_shifted_normalized.csv",
                               package = "amplican")
alignments <- read.csv(alignments_file)
p <- plot_insertions(alignments, config, c('ID_1','ID_3'))

}
\seealso{
Other specialized plots: \code{\link{metaplot_deletions}},
  \code{\link{metaplot_insertions}},
  \code{\link{metaplot_mismatches}},
  \code{\link{plot_cuts}}, \code{\link{plot_deletions}},
  \code{\link{plot_heterogeneity}},
  \code{\link{plot_mismatches}},
  \code{\link{plot_variants}}
}
\concept{specialized plots}
