% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_plots.R
\name{plot_heterogeneity}
\alias{plot_heterogeneity}
\title{Plots heterogeneity of the reads using ggplot2.}
\usage{
plot_heterogeneity(alignments, config, level = "ID",
  colors = c("#000000", "#F0E442"), bins = c(0, 5, seq(10, 100, 10)))
}
\arguments{
\item{alignments}{(data.frame) Loaded alignment information from
alignments_events.csv file.}

\item{config}{(data.frame) Loaded table from config_summary.csv file.}

\item{level}{(string) Name of the column from config
file specifying levels to group by.}

\item{colors}{(html colors vector) Two colours for gradient,
eg. c('#000000', '#F0E442').}

\item{bins}{(numeric vector) Numeric vector from 0 to 100 specifying bins eg.
c(0, 5, seq(10, 100, 10)).}
}
\value{
(heterogeneity plot) ggplot2 object of heterogeneity plot
}
\description{
This function creates stacked barplot explaining
reads heterogeneity. It groups reads
by user defined levels and measures how unique are reads in
this level. Uniqueness of reads is simplified to the bins and
colored according to the color gradient. Default color black
indicates very high heterogeneity of the reads. The more yellow (default)
the more similar are reads and less heterogeneous.
}
\examples{
#example config
config <- read.csv(system.file("extdata", "results", "config_summary.csv",
                               package = "amplican"))
#example alignments results
alignments_file <- system.file("extdata", "results", "alignments",
                               "events_filtered_shifted_normalized.csv",
                               package = "amplican")
alignments <- read.csv(alignments_file)
plot_heterogeneity(alignments[alignments$consensus, ], config)

}
\seealso{
Other specialized plots: \code{\link{metaplot_deletions}},
  \code{\link{metaplot_insertions}},
  \code{\link{metaplot_mismatches}},
  \code{\link{plot_cuts}}, \code{\link{plot_deletions}},
  \code{\link{plot_insertions}},
  \code{\link{plot_mismatches}},
  \code{\link{plot_variants}}
}
\concept{specialized plots}
