% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_general.R
\name{pairToEvents}
\alias{pairToEvents}
\title{Read "pair" format of EMBOSS needle into GRanges as events.}
\usage{
pairToEvents(file, ID = "NA", strand_info = "+")
}
\arguments{
\item{file}{(character) File path.}

\item{ID}{(character) ID of the experiment, will be used as seqnames of the
reutner ranges.}

\item{strand_info}{(character) Strand to assign.}
}
\value{
(\code{\link{GRanges}}) Same as events.
}
\description{
Parse EMBOSS needle (or needleall) "pair" format into GRanges representation
with events of deletions, insertions and mismatches. Make sure that each file
corresponds to single subject (single amplicon). Assumes that bottom sequence
"-bsequence" corresponds to the "subject" and full sequence alignment is
returned.
}
