% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_plots.R
\name{metaplot_mismatches}
\alias{metaplot_mismatches}
\title{MetaPlots mismatches using ggplot2.}
\usage{
metaplot_mismatches(alnmt, config, group, selection)
}
\arguments{
\item{alnmt}{(data.frame) Loaded alignment information from
alignments_events.csv file.}

\item{config}{(data.frame) Loaded table from config_summary.csv file.}

\item{group}{(string) Name of the column from the config file to use for
grouping. Events are subselected based on this column and values from
selection.}

\item{selection}{(string or vector of strings) Values from config column
specified in group argument.}
}
\value{
(mismatches metaplot) ggplot2 object of mismatches metaplot
}
\description{
Plots mismatches in relation to the amplicons for given
\code{selection} vector that groups values by given config \code{group}.
All reads should
already be converted to their relative position to their respective amplicon
using \code{\link{amplicanMap}}.
Zero position on new coordinates is the most left UPPER case letter of
the respective amplicon. This function filters out all alignment events
that have amplicons without UPPER case defined.
Top plot is for the forward reads and bottom plot is for reverse reads.
}
\examples{
#example config
config <- read.csv(system.file("extdata", "results", "config_summary.csv",
                               package = "amplican"))
#example alignments results
alignments_file <- system.file("extdata", "results", "alignments",
                               "events_filtered_shifted_normalized.csv",
                               package = "amplican")
alignments <- read.csv(alignments_file)
metaplot_mismatches(alignments,
                    config, "Group", "Betty")

}
\seealso{
Other specialized plots: \code{\link{metaplot_deletions}},
  \code{\link{metaplot_insertions}},
  \code{\link{plot_cuts}}, \code{\link{plot_deletions}},
  \code{\link{plot_heterogeneity}},
  \code{\link{plot_insertions}},
  \code{\link{plot_mismatches}},
  \code{\link{plot_variants}}
}
\concept{specialized plots}
