% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_alignment.R
\name{makeAlignment}
\alias{makeAlignment}
\title{Make alignments helper.}
\usage{
makeAlignment(cfgT, average_quality, min_quality, scoring_matrix,
  gap_opening, gap_extension, fastqfiles, primer_mismatch, donor_mismatch)
}
\arguments{
\item{cfgT}{config file as data table}

\item{average_quality}{(numeric) The FASTQ file have a quality for each
nucleotide, depending on sequencing technology there exist many formats.
This package uses \code{\link[ShortRead]{readFastq}} to parse the reads.
If the average quality of the reads fall below value of
\code{average_quality} then sequence is filtered. Default is 0.}

\item{min_quality}{(numeric)  Similar as in average_quality, but depicts
the minimum quality for ALL nucleotides in given read. If one of nucleotides
has quality BELLOW \code{min_quality}, then the sequence is filtered.
Default is 20.}

\item{scoring_matrix}{(matrix) Default is 'NUC44'. Pass desired matrix using
\code{\link{nucleotideSubstitutionMatrix}}.}

\item{gap_opening}{(numeric) The opening gap score.}

\item{gap_extension}{(numeric) The gap extension score.}

\item{fastqfiles}{(numeric) Normally you want to use both FASTQ files. But in
some special cases, you may want to use only the forward file, or only
the reverse file. Possible options:
\itemize{
 \item{0}{ Use both FASTQ files.}
 \item{0.5}{ Use both FASTQ files, but only for one of the reads (forward or
 reverse) is required to have primer perfectly matched to sequence - eg. use
 when reverse reads are trimmed of primers, but forward reads have forward
 primer in the sequence.}
 \item{1}{ Use only the forward FASTQ file.}
 \item{2}{ Use only the reverse FASTQ file.}
}}

\item{primer_mismatch}{(numeric) Decide how many mismatches are allowed
during primer matching of the reads, that groups reads by experiments.
When \code{primer_mismatch = 0} no mismatches are allowed, which can increase
number of unasssigned read.}

\item{donor_mismatch}{(numeric) How many events of length 1 (mismatches,
deletions and insertions of length 1) are allowed when aligning toward the
donor template. This parameter is only used when donor template is specified.
The higher the parameter the less strict will be algorithm accepting read as
HDR. Set to 0 if only perfect alignments to the donor template marked as HDR,
unadvised due to error rate of the sequencers.}
}
\value{
amplicanAlignment object for this barcode experiments
}
\description{
Aligning reads to the amplicons for each ID in this barcode, constructing
amplicanAlignment. Assume that all IDs here belong to the same barcode.
}
\keyword{internal}
