% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_filters.R
\name{findPD}
\alias{findPD}
\title{Find PRIMER DIMER reads.}
\usage{
findPD(aln, cfgT, PRIMER_DIMER = 30)
}
\arguments{
\item{aln}{(data.frame) Should contain events from alignments in
\code{\link{GRanges}} style with columns eg. seqnames, width, start, end.}

\item{cfgT}{(data.frame) Needs columns Forward_Primer, ReversePrimer and
Amplicon.}

\item{PRIMER_DIMER}{(numeric) Value specifying buffer for PRIMER DIMER
detection. For a given read it will be recognized as PRIMER DIMER when
alignment will introduce gap of size bigger than: \cr
\code{length of amplicon - (lengths of PRIMERS + PRIMER_DIMER value)}}
}
\value{
(logical) Where TRUE indicates event classified as PRIMER DIMER
}
\description{
Use to filter reads that are most likely PRIMER DIMERS.
}
\examples{
file_path <- system.file("extdata", "results", "alignments",
                         "raw_events.csv", package = "amplican")
aln <- data.table::fread(file_path)
cfgT <- data.table::fread(
  system.file("extdata", "results", "config_summary.csv",
              package = "amplican"))
findPD(aln, cfgT)

}
\seealso{
\code{\link{findEOP}} \code{\link{findLQR}}

Other filters: \code{\link{findEOP}}, \code{\link{findLQR}}
}
\concept{filters}
