% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_filters.R
\name{findLQR}
\alias{findLQR}
\title{Find Off-targets and Fragmented alignments from reads.}
\usage{
findLQR(aln)
}
\arguments{
\item{aln}{(data.frame) Should contain events from alignments in GRanges
style with columns eg. seqnames, width, start, end, score.}
}
\value{
(logical vector) where TRUE indicates events that are
potential off-targets or low quality alignments.
}
\description{
Will try to detect off-targets and low quality alignments (outliers). It
tries k-means clustering on normalized number of events per read and read
alignment score. If there are 3 clusters (decided based on silhouette
criterion) cluster with high event count and low alignment score will be
marked for filtering. When there is less than 1000
scores in \code{aln} it will filter nothing.
}
\examples{
file_path <- system.file("extdata", "results", "alignments",
                         "raw_events.csv", package = "amplican")
aln <- data.table::fread(file_path)
aln <- aln[seqnames == "ID_1"] # for first experiment
findLQR(aln)

}
\seealso{
\code{\link{findPD}} \code{\link{findEOP}}

Other filters: \code{\link{findEOP}}, \code{\link{findPD}}
}
\concept{filters}
