% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlignmentsExperimentSet-class.R
\name{extractEvents}
\alias{extractEvents}
\title{Extract AlignmentsExperimentSet events into data.frame.}
\usage{
extractEvents(object, use_parallel = FALSE)
}
\arguments{
\item{object}{(AlignmentsExperimentSet)}

\item{use_parallel}{(boolean) Set to TRUE, if you have registered
multicore back-end with \code{\link[BiocParallel]{register}}.}
}
\value{
(data.frame) Compatible with \code{\link{GRanges}}
style.
}
\description{
Extracts events (insertions, deletions, mismatches) from alignments into
data.frame. Can use multiple cores as process is quite slow. All events are
relative towards forward strand. "-" in strand column indicates which events
were from reverse reads.
}
\examples{
file_path <- system.file("extdata", "results", "alignments",
                         "AlignmentsExperimentSet.rds", package = "amplican")
aln <- readRDS(file_path)
extractEvents(aln)

}
\keyword{internal}
