% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_rmd.R
\name{amplican_print_reads}
\alias{amplican_print_reads}
\title{Pretty print forward and reverse reads aligned to each other.}
\usage{
amplican_print_reads(forward, reverse)
}
\arguments{
\item{forward}{(character or vector of characters) Forward reads.}

\item{reverse}{(character or vector of characters) Will be reverse
complemented before alignment.}
}
\value{
Vector with alignments ready to be printed.
}
\description{
Usefull and needed for barcode reports.
}
\examples{
# load example data
unassigned_file <- system.file('extdata', 'results',  'alignments',
                               'unassigned_reads.csv', package = 'amplican')
unassigned <- data.table::setDF(data.table::fread(unassigned_file))
# sort by frequency
unassigned <- unassigned[order(unassigned$BarcodeFrequency,
                               decreasing = TRUE), ]
# print alignment of most frequent unassigned reads
cat(amplican_print_reads(unassigned[1, 'Forward'],
                         unassigned[1, 'Reverse']),
          sep = "\\n")

}
