% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplicanSummarize.R
\name{amplicanSummarize}
\alias{amplicanSummarize}
\title{Summarize how many reads have frameshift and how many reads have deletions.}
\usage{
amplicanSummarize(aln, cfgT)
}
\arguments{
\item{aln}{(data.frame) Contains events from the alignments.}

\item{cfgT}{(data.frame) Config file with the experiments details.}
}
\value{
(data.frame) As cfgT, but with extra columns.
}
\description{
Before using this function make sure events are filtered to represent
consensus with \code{amplicanConsensus}, if you use both forward and
reverse reads. If you want to calculate metrics over expected cut site,
filter events using \code{amplicanOverlap}.
}
\details{
Adds columns to cfgT:
\itemize{
\item{ReadsCut}{ Count of reads with deletions overlapping expected
cut site.}
\item{Reads_Frameshifted}{ Count of reads with frameshift
overlapping expected cut site.}
}
}
\examples{
file_path <- system.file("extdata", "results", "alignments",
                         "events_filtered_shifted_normalized.csv",
                         package = "amplican")
aln <- data.table::fread(file_path)
cfgT <- data.table::fread(
  system.file("extdata", "results", "config_summary.csv",
              package = "amplican"))
amplicanSummarize(aln, cfgT)

}
\seealso{
Other analysis steps: \code{\link{amplicanAlign}},
  \code{\link{amplicanConsensus}},
  \code{\link{amplicanFilter}}, \code{\link{amplicanMap}},
  \code{\link{amplicanNormalize}},
  \code{\link{amplicanOverlap}},
  \code{\link{amplicanPipelineConservative}},
  \code{\link{amplicanPipeline}},
  \code{\link{amplicanReport}}
}
\concept{analysis steps}
