% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplicanSummarize.R
\name{amplicanOverlap}
\alias{amplicanOverlap}
\title{Check which events overlap expected cut sites.}
\usage{
amplicanOverlap(aln, cfgT, cut_buffer = 5, relative = FALSE)
}
\arguments{
\item{aln}{(data.frame) Contains relevant events in GRanges style.}

\item{cfgT}{(data.frame) Contains amplicon sequences.}

\item{cut_buffer}{(numeric) Number of bases that should expand 5' and 3' of
the specified expected cut sites.}

\item{relative}{(boolean) Sets whether events are relative to the position of
the target site.}
}
\value{
(bolean vector) Where TRUE means that given event overlaps cut site.
}
\description{
To determine which deletions, insertions and mismatches (events) are probably
created by CRISPR we check whether they overlap expected cut sites. Expected
cut sites should be specified in UPPER CASE letters in the amplicon
sequences.
}
\examples{
file_path <- system.file("test_data", "test_aln.csv", package = "amplican")
aln <- data.table::fread(file_path)
cfgT <- data.table::fread(
  system.file("test_data", "test_cfg.csv", package = "amplican"))
all(aln$overlaps == amplicanOverlap(aln, cfgT))

}
\seealso{
Other analysis steps: \code{\link{amplicanAlign}},
  \code{\link{amplicanConsensus}},
  \code{\link{amplicanFilter}}, \code{\link{amplicanMap}},
  \code{\link{amplicanNormalize}},
  \code{\link{amplicanPipelineConservative}},
  \code{\link{amplicanPipeline}},
  \code{\link{amplicanReport}},
  \code{\link{amplicanSummarize}}
}
\concept{analysis steps}
