% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplicanSummarize.R
\name{amplicanConsensus}
\alias{amplicanConsensus}
\title{Extract consensus out of forward and reverse events.}
\usage{
amplicanConsensus(aln, cfgT, overlaps = "overlaps", promiscuous = TRUE)
}
\arguments{
\item{aln}{(data.frame) Contains relevant events in GRanges style.}

\item{cfgT}{(data.frame) Should be table containing at least
positions of primers in the amplicons and their identifiers}

\item{overlaps}{(character) Specifies which metadata column of \code{aln}
indicates which events are overlapping expected cut site.}

\item{promiscuous}{(boolean) Allows to relax consensus rules. When TRUE will
allow Indels that are not confirmed by the other strand (when both are used).}
}
\value{
(bolean vector) Where TRUE means that given event represents
consensus out of forward and reverse reads.
}
\description{
When forward and reverse reads are in agreement on the events (eg. deletion)
\code{amplicanConsensus} will mark forward event as TRUE indicating that he
represents consensus.
In cases where forward and reverse read agree only partially, for example,
they share the same start of the deletion, but they have different end
\code{amplicanConsensus} will pick the version of
read with higher alignment score, in situation where both of the reads
overlap expected cut site, otherwise both events will be rejected and marked
FALSE. When there are events only on one of the strands they will be
rejected.
}
\details{
In situation where you have only forward or only reverse reads don't use this
function and assign all TRUE to all of your events.

Consensus out of the forward + reverse reads is required for
\code{amplicanSummary}, and \code{amplicanConsensus} requires
\code{amplicanOverlap}.
}
\examples{
file_path <- system.file("test_data", "test_aln.csv", package = "amplican")
aln <- data.table::fread(file_path)
cfgT <- data.table::fread(
  system.file("test_data", "test_cfg.csv", package = "amplican"))
all(aln$consensus == amplicanConsensus(aln, cfgT))

}
\seealso{
Other analysis steps: \code{\link{amplicanAlign}},
  \code{\link{amplicanFilter}}, \code{\link{amplicanMap}},
  \code{\link{amplicanNormalize}},
  \code{\link{amplicanOverlap}},
  \code{\link{amplicanPipelineConservative}},
  \code{\link{amplicanPipeline}},
  \code{\link{amplicanReport}},
  \code{\link{amplicanSummarize}}
}
\concept{analysis steps}
