#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "optimization.h"

float Find_max_quad(float x1, float x2, float x3,
		    float y1, float y2, float y3,
		    float MIN, float MAX)
{
  if((y2<y1)&&(y2<y3)){
    if(y1>y3){
      return((x1+MIN)/2);
    }else{
      return((x3+MAX)/2);
    }
  }
  float yprime_1=((y1-y2)/(x1-x2));
  float yprime_2=((y2-y3)/(x2-x3));
  float a=(yprime_1-yprime_2)/(x1-x3);
  if(a>0){
    // Second derivative is positive, no maximum!
    if(y1>y3){
      return((x1+MIN)/2);
    }else{
      return((x3+MAX)/2);
    }
  }
  float b=yprime_1-a*(x1+x2);
  float x0=-b/(2*a);
  if(x0<MIN){x0=0.5*(x1+MIN);}
  else if(x0>MAX){x0=0.5*(x3+MAX);}
  return(x0);
}
    
void Rearrange_points(float *x1, float *x2, float *x3,
		      float *y1, float *y2, float *y3,
		      float x0, float y0)
{
  if(x0<*x1){
    *x3=*x2; *y3=*y2;
    *x2=*x1; *y2=*y1;
    *x1=x0;  *y1=y0;
  }else if(x0<*x2){
    *x3=*x2; *y3=*y2;
    *x2=x0;  *y2=y0;
  }else if(x0<*x3){
    *x1=*x2; *y1=*y2;
    *x2=x0; *y2=y0;
  }else{
    *x1=*x2; *y1=*y2;
    *x2=*x3; *y2=*y3;
    *x3=x0;  *y3=y0;
  }
}


