#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "Genome_profile_aux.h"
#include "Poisson_score_aux.h"

#define NAMEPEAKS "Peaks"
#define EXT ".bed"

int Ini_peaks;

static int Find_peaks(struct origin *ori,
		      long **x_scr, float **y_scr, long *nn, //float **z_scr
		      int Ncr, float Thr, int WINHALF);

static int Copy_peaks(struct origin *ori_ini, struct origin *ori, int N_ori);

void Print_peak(FILE *file_out, struct origin ori);
static void Print_Peaks_new(struct origin *ori, char *nameout, char *nameold);
static void Print_Peaks_nomatch(struct origin *ori_old, int N_ori_old,
				char *nameout);
static void Print_Peaks(struct origin *ori, char *nameout);
void Plot_profile(struct origin *ori, int p,
		  long **xprof, float **yprof, long *nprof,
		  char *name_prof, char *nameout);
void New_peaks(struct origin *peak2, int *N_new,
	       struct origin *peak1, int N);
void Confirmed_peaks(struct origin *peak2, int *N_new,
		     struct origin *peak1, int N);

int Get_peaks(double *Discriminant_score,
	      double **Prof_score, double *Prof_ori,
	      long **x_scr, float **y_scr, long *nn, int Ncr,
	      struct origin *ori_old, int N_ori_old,
	      long ***xprof, float ***yprof, long **nprof,
	      char **name_prof, int N_prof,
	      int DCLUST, float Size_Min, int WINHALF,
	      int WINSIZE, int Stat_Comp, int DTOL, float MC,
	      char *file_old, float Thr,
	      int PRINT, float THR, char *NAMEOUT)
{
  struct origin ori[ORIMAX], ori_ini[ORIMAX], *ori1;
  int joined[ORIMAX], removed[ORIMAX];
  int N_ori=Find_peaks(ori, x_scr, y_scr, nn, Ncr, Thr, WINHALF); //z_scr
  // printf("Initial set of %d peaks ", N_ori);
   
  // Copy origins before joining
  int N_ori_ini=Copy_peaks(ori_ini, ori, N_ori);

  // Join clusters
  // N_ori=Make_cluster_1(ori, N_ori, joined, DCLUST);
  N_ori=Make_cluster_thr(ori, N_ori, joined, DCLUST,
			 x_scr, y_scr, nn, Ncr, Thr);
  // printf(" After clustering: %d ", N_ori);

  // Eliminate small fragments
  if(Size_Min > 1){
    N_ori=Remove_fragments(ori, N_ori, removed, Size_Min);
  }

  // Join again without testing threshold
  N_ori=Make_cluster_1(ori, N_ori, joined, DCLUST);

  if(N_ori<2*Ncr){
    printf("Too few peaks found with threshold= %.2f\n", Thr); 
    return(0);
  }

  // Output
  /* printf("Threshold window Positives");
     for(p=0; p<N_prof; p++)printf(" %s", name_prof[p]);
     printf("\n");
     printf("%4.1f %3d  %3d\n", Thr, WINDOW, N_ori);*/
  printf("%4.1f ", Thr);

  int N_ori_max=N_ori_ini;
  if(N_ori_old>N_ori_max){N_ori_max=N_ori_old;}

  /*
  // Statistics before joining
  Profile_score(Prof_ori,Prof_score,xprof,yprof,nprof,N_prof,ori_ini);
  Sizediff_stat(ori_ini, Prof_ori, Prof_score, N_prof,
  name_prof, "oridist_ini.dat");
  */

  if(PRINT){
    // Random origins
    struct origin *oriran=Extract_peaks(ori, N_ori, Ncr); //NULL
    Profile_score(Prof_ori,Prof_score,Discriminant_score,
		  xprof,yprof,nprof,N_prof,oriran,N_ori);
    Sizediff_stat(oriran, Prof_ori, Prof_score, Discriminant_score,
		  N_prof, name_prof, "Properties_Random.dat", 1);
    free(oriran);
  }

  // Statistics after joining
  Profile_score(Prof_ori, Prof_score, Discriminant_score,
		xprof, yprof, nprof, N_prof,ori, N_ori_max);
  char nameout[200]; sprintf(nameout, "Properties_%s.dat", NAMEOUT);
  Sizediff_stat(ori, Prof_ori, Prof_score,Discriminant_score,
		N_prof, name_prof, nameout, PRINT);

  // Compare with old predictions, if any
  char namefound[200]; FILE *file_found;
  if(N_ori_old){
    float over_1, over_2, over_1r, over_2r;
    int n_match=0, n_match_old=0;
    float dist=Dist_peaks(ori,N_ori,ori_old,N_ori_old);
    printf(" %.0f", dist);
    dist=Dist_peaks(ori_old,N_ori_old,ori,N_ori);
    printf(" %.0f", dist);

    // Overlap with random peaks
    struct origin *ori2=Extract_peaks(ori_old, N_ori_old, Ncr);
    Count_matches(&n_match,&n_match_old,DTOL,ori,N_ori,ori2,N_ori_old);
    over_1r=(float)n_match_old/N_ori_old;
    over_2r=(float)n_match/N_ori;
    free(ori2);

    // Overlap with predictions
    Count_matches(&n_match, &n_match_old,DTOL,ori,N_ori,ori_old,N_ori_old);
    over_1=(float)n_match_old/N_ori_old;
    over_2=(float)n_match/N_ori;

    printf("  %.3f %.3f %.3f",  over_1, over_2, over_1*over_2);
    printf("  %.1f %.1f %.1f",  over_1/over_1r, over_2/over_2r,
	   over_1*over_2/(over_1r*over_2r));
  }
  printf("\n");

  if(PRINT){

    // Print peaks
    sprintf(nameout, "%s_ALL_W%d_T%.1f_J%d_S%.0f.bed",
	    NAMEOUT, WINSIZE, THR, DCLUST, Size_Min);
    Print_Peaks(ori, nameout);


    if(N_ori_old){
      sprintf(nameout, "%s_notfound.bed", file_old);
      Print_Peaks_nomatch(ori_old, N_ori_old, nameout);

      char nameold[200];
      sprintf(nameold, "%s_OLD_W%d_T%.1f_J%d.bed",
	      NAMEOUT, WINSIZE, THR, DCLUST);
      sprintf(nameout, "%s_NEW_W%d_T%.1f_J%d.bed",
	      NAMEOUT, WINSIZE, THR, DCLUST);
      Print_Peaks_new(ori, nameout, nameold);

      // Statistics of peaks present / not present in previous set
      int N_peak=0;
      struct origin *peak2=malloc(N_ori*sizeof(struct origin));
      New_peaks(peak2, &N_peak, ori, N_ori);
      Profile_score(Prof_ori, Prof_score, Discriminant_score,
		    xprof, yprof, nprof, N_prof, peak2, N_peak);
      Sizediff_stat(peak2, Prof_ori, Prof_score, Discriminant_score,
		    N_prof, name_prof, "Properties_NewPeaks.dat", PRINT);

      Confirmed_peaks(peak2, &N_peak, ori, N_ori);
      Profile_score(Prof_ori, Prof_score, Discriminant_score,
		    xprof, yprof, nprof, N_prof, peak2, N_peak);
      sprintf(nameout, "Properties_Common%s.dat", NAMEOUT);
      Sizediff_stat(peak2, Prof_ori, Prof_score, Discriminant_score,
		    N_prof, name_prof, nameout, PRINT);
      free(peak2);

      peak2=malloc(N_ori_old*sizeof(struct origin));
      New_peaks(peak2, &N_peak, ori_old, N_ori_old);
      Profile_score(Prof_ori, Prof_score, Discriminant_score,
		    xprof, yprof, nprof, N_prof, peak2, N_peak);
      Sizediff_stat(peak2, Prof_ori, Prof_score, Discriminant_score, N_prof,
		    name_prof, "Properties_UnconfirmedPeaks.dat", PRINT);

      Profile_score(Prof_ori, Prof_score, Discriminant_score,
		    xprof, yprof, nprof, N_prof,ori_old, N_ori_old);
      Sizediff_stat(ori_old, Prof_ori, Prof_score,
		    Discriminant_score, N_prof, name_prof,
		    "Properties_ReferencePeaks.dat", 1);
      free(peak2);


    }

    /************* Metaplots ******************/
    int p;
    for(p=0; p<N_prof; p++){
      sprintf(nameout, "Metaplots_%s.dat", NAMEOUT);
      Plot_profile(ori,p,xprof[p],yprof[p],nprof[p],name_prof[p],nameout);
    }
    if(N_ori_old){
      for(p=0; p<N_prof; p++){
	Plot_profile(ori_old, p, xprof[p], yprof[p], nprof[p],
		     name_prof[p], "Metaplots_reference.dat");
      }
    }

  }
  return(N_ori);
}

int Find_peaks(struct origin *ori,
	       long **x_scr, float **y_scr, long *nn, //float **z_scr
	       int Ncr, float Thr, int WINHALF)
{
  int N_ori=0, i, k, k2;
  struct origin *ori1;
  for(k=0; k<Ncr; k++){
    int sel=0, cr=k+1, nsel=0, end=0; 
    long *x=x_scr[k];
    float *z=y_scr[k];
    for(i=0; i<nn[k]; i++){
      if(z[i]>Thr){
	if(sel==0){
	  // Start peak
	  sel=1; ori1=ori+N_ori; ori1->ini=x[i]-WINHALF; ori1->cr=cr;
	  ori1->xsum=0; ori1->norm=0; N_ori++;
	  if(N_ori>ORIMAX){
	    printf("ERROR, too many origins (increase ORIMAX = %d)\n",
		   ORIMAX); exit(8);
	  }
	  if(ori1->ini<0){
	    printf("WARNING!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
	    printf("chr %d Ini= %ld end= %ld\n",ori1->cr,ori1->ini,ori1->end);
	    printf("x= %ld winhalf= %d\n", x[i], WINHALF);
	    exit(8);
	  }
	}
	ori1->xsum+=x[i]*z[i]; ori1->norm+=z[i]; nsel++;
      }else if(sel){
	ori1->end=x[i-1]+WINHALF; sel=0; end++;
      }
    }
    if(sel)ori1->end=x[i-1]+WINHALF;
    //printf("Chromosome %d, Thr %.2f peaks: %d selected: %d %d end: %d\n",
    //	   k+1, Thr, N_ori, nsel, nn[k]-nsel, end);
  }
  for(i=0; i<N_ori; i++)Set_ori(ori+i, i);
  ori[N_ori-1].next=NULL;
  return(N_ori);
}

 int Copy_peaks(struct origin *ori_ini, struct origin *ori, int N_ori)
{
  struct origin *ori1=ori_ini; int i;
  for(i=0; i<N_ori; i++){
    *ori1=ori[i]; ori1->next=ori1+1; ori1++;
  }
  ori_ini[N_ori-1].next=NULL;
  return(N_ori);
}

void Print_peak(FILE *file_out, struct origin ori){
  /*if(PRINT==0){
    fprintf(file_out, "%d\t%ld\t%ld\n", ori.cr, ori.ini, ori.end);
    }else{*/
  if(ori.size>SIZEMAX)fprintf(file_out, "#");
  fprintf(file_out, "%d\t%ld\t%ld\n",
	  ori.cr, ori.ini, ori.end);
}

void Print_Peaks(struct origin *ori, char *nameout)
{
  FILE *file_out=Open_file_w(nameout);
  //fprintf(file_out, "%s", parameters);
  struct origin *ori1=ori; int Np=0;
  while(ori1!=NULL){
    Print_peak(file_out, *ori1); Np++; ori1=ori1->next;
  }
  fclose(file_out);
  printf("Printing %d peaks in %s\n", Np, nameout);
}

void Print_Peaks_nomatch(struct origin *ori_old, int N_ori_old, char *nameout)
{ 
  int i, Np=0;
  FILE *file_out=Open_file_w(nameout);
  for(i=0; i<N_ori_old; i++){
    if(ori_old[i].match==0){
      Print_peak(file_out, ori_old[i]); Np++;
    }
  }
  fclose(file_out);
  printf("Printing %d previous not confirmed peaks in %s\n",Np, nameout);
}

void Print_Peaks_new(struct origin *ori, char *nameout, char *nameold)
{
  FILE *file_out=Open_file_w(nameold);
  FILE *file_new=Open_file_w(nameout);
  struct origin *ori1=ori; int Np=0, Np_new=0;
  while(ori1!=NULL){
    if(ori1->match==0){
      Print_peak(file_new, *ori1); Np_new++;
    }else{
      Print_peak(file_out, *ori1); Np++;
    }
    ori1=ori1->next;
  }
  fclose(file_out); fclose(file_new); 
  printf("Printing %d previous confirmed peaks in %s\n",
	 Np, nameold);
  printf("Printing %d new peaks in %s\n",
	 Np_new, nameout);
}

void New_peaks(struct origin *peak2, int *N_new, struct origin *peak, int N)
{
  struct origin *peak1=peak;
  struct origin *p2=peak2; int i; *N_new=0;
  while(peak1!=NULL){
    if(peak1->match==0){
      *p2=*peak1; p2->lab=(*N_new); p2->next=p2+1;
      p2++; (*N_new)++;
    }
    peak1=peak1->next;
  }
  (p2-1)->next=NULL;
}

void Confirmed_peaks(struct origin *peak2, int *N_new,
		     struct origin *peak, int N)
{
  struct origin *peak1=peak;
  struct origin *p2=peak2; int i; *N_new=0;
  while(peak1!=NULL){
    if(peak1->match){
      *p2=*peak1; p2->lab=(*N_new); p2->next=p2+1;
      p2++; (*N_new)++;
    }
    peak1=peak1->next;
  }
  (p2-1)->next=NULL;
}


void Plot_profile(struct origin *ori, int p,
		  long **xprof, float **yprof,
		  long *nprof, char *name_prof,
		  char *nameout)
{
  int cr, cr_old=-1, i, j, nj, N_ori=0; long *xp; float *yp, w;
  struct origin *ori1=ori;
  int NBIN=80;
  float BINSIZE=50;
  int LENGTH=(NBIN*BINSIZE)/2;
  double *Prof=malloc(NBIN*sizeof(double));
  int *norm=malloc(NBIN*sizeof(int));
  for(i=0; i<NBIN; i++){Prof[i]=0; norm[i]=0;}
  double Prof_ave=0, Prof_dev=0, normtot=0;

  while(ori1!=NULL){
    if(ori1->cr-1 !=cr_old){
      cr=ori1->cr-1; cr_old=cr; j=0;
      nj=nprof[cr]; xp=xprof[cr]; yp=yprof[cr];
    }
    long xmin=ori1->xo-LENGTH, xmax=ori1->xo+LENGTH;
    while((j<nj)&&(*xp<xmin)){  //ini
      Prof_ave+=*yp; Prof_dev+=(*yp)*(*yp); normtot++;
      j++; xp++; yp++;
    }
    while((j<nj)&&(*xp<=xmax)){ //end
      int bin=(*xp-ori1->xo+LENGTH)/BINSIZE;
      if(bin < NBIN){
	Prof[bin]+=(*yp); norm[bin]++;
      }
      Prof_ave+=*yp; Prof_dev+=(*yp)*(*yp); normtot++;
      j++; xp++; yp++;
    }
    ori1=ori1->next;
  }

  FILE *file_out;
  if(p==0){
    file_out=fopen(nameout, "w");
    printf("Writing %s\n", nameout);
  }else{
    file_out=fopen(nameout, "a");
  }
  fprintf(file_out, "# %s\n", name_prof);
  Prof_ave/=normtot;
  Prof_dev=sqrt(Prof_dev/normtot-Prof_ave*Prof_ave);
  for(i=0; i<NBIN; i++){
    fprintf(file_out, "%.0f %.3g\n",
	    i*BINSIZE-LENGTH,(Prof[i]/norm[i]-Prof_ave)/Prof_dev);
  }
  fprintf(file_out, "&\n");
  fclose(file_out); free(Prof); free(norm);

}
