#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#define PEAKSIZE_DEF 125  // Origins located at xo +- PEAKSIZE
int PEAKSIZE;
#define SIZEMAX 10000

#define NCHAR 400

struct origin{
  int cr;
  int match;
  int mult;
  long ini, end;
  int size;
  float xo, x1, x2;
  double xsum, norm;
  int lab;
  struct origin *next;
  //float d_l, d_r;
};

void Count_matches(int *n_match1, int *n_match2, float DTOL,
		   struct origin *ori1, int N_ori1,
		   struct origin *ori2, int N_ori2);
float Dist_peaks(struct origin *ori1, int N_ori1,
		 struct origin *ori2, int N_ori2);
int Overlap(struct origin ori1, struct origin ori2, float DTOL);
int Join(struct origin *ori2, struct origin *ori3, int *joined);
float Corr_coeff(float *xx, float *yy, int n);
struct origin *Extract_peaks(struct origin *ori_old, int N_ori, int Ncr);
void Read_name(int *nc, char **file, char *PATH, char *string, int nmax);
int Read_file(long **x, float **y, char *file);
int Read_file_3f(long **x, float **y, float **z, char *file);
struct origin *Read_origins(int *nori, char *file);
void Set_ori(struct origin *orii, int i);
int Read_file_3(long **kk, float **x1, float **x2, char *file);
void Output_name(char *nameout, char *namein, char *ext);
void Shift_coord(long **x_new, long *x_old, long n);
FILE *Open_file_w(char *name);
void Sizediff_stat(struct origin *ori, double *Prof_ori, double **Prof_score,
		   double *Discriminant_score, int N_prof, char **name_prof,
		   char *nameout, int PRINTALL);
int Make_cluster_1(struct origin *ori, int N_ori, int *joined, float DCLUST);
void Make_cluster_4(struct origin *ori, int N_ori, int *joined, float DCLUST);
int Make_cluster_thr(struct origin *ori, int N_ori, int *joined, float DCLUST,
		     long **xx, float **zz, long *nn, int Nchr, float Thr);
void Profile_score(double *Prof_ori, double **Prof_score,
		   double *Discriminant_score,
		   long ***xprof, float ***yprof, long **nprof, int N_prof,
		   struct origin *ori, int N_ori);
int Remove_fragments(struct origin *ori, int N_ori, int *removed,
		     float Size_min);
int Get_peaks(double *Discriminant_score,
	      double **Prof_score, double *Prof_ori,
	      long **x_scr, float **y_scr, long *nn, int Ncr,
	      struct origin *ori_old, int N_ori_old,
	      long ***xprof, float ***yprof, long **nprof,
	      char **name_prof, int N_prof,
	      int DCLUST, float Size_Min, int WINHALF,
	      int WINSIZE, int Stat_Comp, int DTOL, float MC,
	      char *file_old, float Thr,
	      int PRINT, float THR, char *NAMEOUT);
void Print_peak(FILE *file_out, struct origin ori);
#define ORIMAX 1000000 // Maximum number of origins
