#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "Genome_profile_aux.h"
#include "random3.h"

#define ZSCORE 1 // Print Z score of properties (1) or raw properties (0)?
#define NCHAR 400
#define VERBOSE 0

unsigned long randomgenerator(void);
int INIRAN;
float RANFACTOR;

int Count_columns(char *string);
void Print_ave(double *ave, double *dev,
	       double sum1, double sum2, double norm, char *name,
	       FILE *file_out);
char *Extension(char *string);
int Get_step_wig(char *string);
void Intersect_peaks(struct origin *peak,
		     struct origin *peak1,
		     struct origin *peak2);
float Sum_score(long *k2, long ini, long end,
		float *z, long *x, long k, long m);

void Read_name(int *n, char **file, char *PATH, char *string, int nmax)
{
  char name[NCHAR];
  if(*n>nmax){
    printf("ERROR, too many input files, maximum %d\n", nmax);
    exit(8);
  }
  sscanf(string, "%s", name);
  file[*n]=malloc(NCHAR*sizeof(char));
  sprintf(file[*n], "%s%s", PATH, name);
  //printf("File to read: %s\n", file[*n]);
  (*n)++;
}

int Read_file(long **x, float **y, char *file){
  long n=0; char string[1000];
  FILE *file_in=fopen(file, "r");
  int WIG=0, step=0, ncol=1;
  // Check if exists
  if(file_in==NULL){
    printf("ERROR, file %s does not exist\n", file); exit(8);
  }
  if(strncmp(Extension(file), "wig", 3)==0){
    //fgets(string, sizeof(string), file_in);
    fgets(string, sizeof(string), file_in);
    step=Get_step_wig(string); WIG=1;
  }
  // Count lines and allocate
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue; n++;
    if(n==2)ncol=Count_columns(string);
  }
  fclose(file_in);
  (*x)=malloc(n*sizeof(long));
  (*y)=malloc(n*sizeof(float));

  // Report
  printf("Reading file %s ", file);
  if(WIG)printf("(wig format), step= %d ", step);
  printf("%d columns, %d lines\n", ncol, n);
  if((ncol==1)&&(step==0)){
    printf("ERROR, only one column but step not reported\n"); exit(8);
  }

  // Read
  n=0;
  long *xx=*x, xxcount=(1-step)/2, xxn, xxo=0;
  float *yy=*y;
  char word[100];
  file_in=fopen(file, "r");
  if(WIG){
    //fgets(string, sizeof(string), file_in);
    fgets(string, sizeof(string), file_in);
  }
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue;
    if(ncol==1){
      sscanf(string, "%f", yy);
      xxcount+=step; *xx=xxcount;
    }else{
      sscanf(string, "%ld%s", &xxn, word);
      if(word[0]=='n'){*yy=0;}
      else{sscanf(word, "%f", yy);}
      *xx=(xxn+xxo+1)/2; xxo=xxn;
    }
    n++; xx++; yy++;
  }
  fclose(file_in);
  printf("x[0]= %ld x_last=%ld\n", (*x)[0], *(xx-1));
  return(n);
}

int Read_file_3f(long **x, float **y, float **z, char *file){
  long n=0; char string[1000];
  FILE *file_in=fopen(file, "r");
  // Check if exists
  if(file_in==NULL){
    printf("ERROR, file %s does not exist\n", file); exit(8);
  }
  // Count lines and allocate
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue; n++;
  }
  fclose(file_in);
  (*x)=malloc(n*sizeof(long));
  (*y)=malloc(n*sizeof(float));
  (*z)=malloc(n*sizeof(float));

  // Read
  n=0;
  file_in=fopen(file, "r");
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue;
    sscanf(string, "%ld%f%f", &((*x)[n]), &((*y)[n]), &((*z)[n])); n++; 
  }
  fclose(file_in);
  return(n);
}

void Output_name(char *nameout, char *namein, char *ext){
  char *s=namein, *si=namein;
  while((*s!='\0')&&(*s!='\n')){
    if(*s=='/'){si=s+1;}
    else if(*s==' '){*s='-';}
    s++;
  }
  sprintf(nameout, "%s%s",si, ext);
}


int Read_file_3(long **kk, float **x1, float **x2, char *file)
{
  if(file==NULL)return(0);
  FILE *file_in=fopen(file, "r");
  // Check if exists
  if(file_in==NULL){
    printf("ERROR, file %s does not exist\n", file); exit(8);
  }
  // Count lines and allocate
  long n=0; char string[1000];
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue; n++;
  }
  fclose(file_in);
  (*x1)=malloc(n*sizeof(float));
  (*x2)=malloc(n*sizeof(float));
  (*kk)=malloc(n*sizeof(long));

  // Read
  n=0;
  file_in=fopen(file, "r");
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue;
    sscanf(string, "%ld%f%f", &((*kk)[n]), &((*x1)[n]), &((*x2)[n])); n++; 
  }
  fclose(file_in);
  return(n); 
}

int Read_window(char *file){
  int win=1; char string[200];
  FILE *file_in=fopen(file, "r");
  fgets(string, sizeof(string), file_in);
  if(strncmp(string, "#WINDOW=",8)==0){
    sscanf(string, "%d", &win);
  }else{
    printf("WARNING, window size not found in %s\n", file);
    printf("Setting default value %d\n", win);
  }
  fclose(file_in);
  return(win);
}

void Shift_coord(long **x_new, long *x_old, long n)
{
  int i;
  (*x_new)=malloc(n*sizeof(long));
  long x0=0, *x1=*x_new, *x2=x_old;
  for(i=0; i<n; i++){
    *x1=0.5*(x0+*x2); x0=*x2; x1++; x2++;
  }
}

float Corr_coeff(float *xx, float *yy, int n)
{
  float *x=xx, *y=yy; int i;
  double x1=0, x2=0, y1=0, y2=0, xy=0;
  for(i=0; i<n; i++){
    x1+=(*x); x2+=(*x)*(*x);
    y1+=(*y); y2+=(*y)*(*y);
    xy+=(*x)*(*y); x++; y++;
  }
  x1/=n; y1/=n;
  xy=(xy-n*x1*y1)/sqrt((x2-n*x1*x1)*(y2-n*y1*y1));
  return(xy);
}

FILE *Open_file_w(char *name)
{
  FILE *file_out=fopen(name, "w");
  printf("\nWriting %s\n", name);
  return(file_out);
}

struct origin *Read_origins(int *nori, char *file)
{
  if(file==NULL)return(0);
  FILE *file_in=fopen(file, "r");
  // Check if exists
  if(file_in==NULL){
    printf("ERROR, file %s does not exist\n", file); exit(8);
  }
  // Count lines and allocate
  int n=0; char string[1000];
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue; n++;
  }
  fclose(file_in);
  if(n==0)return(NULL); *nori=n;

  // Read
  struct origin *ori=malloc(n*sizeof(struct origin)), *orii=ori; 
  int i=0, s=0, mult=0;
  file_in=fopen(file, "r");
  while(fgets(string, sizeof(string), file_in)!=NULL){
    if(string[0]=='#')continue; char *ptr=string;
    if((string[0]=='c')||(string[0]=='C'))ptr+=3;
    s=sscanf(ptr, "%d%ld%ld%d",&(orii->cr), &(orii->ini), &(orii->end), &mult);
    if(mult>0){orii->mult=mult;}else{orii->mult=1;}
    orii->norm=0; Set_ori(orii, i);
    i++;  orii++;
  }
  ori[n-1].next=NULL;
  fclose(file_in);
  return(ori); 
}

void Set_ori(struct origin *orii, int i){
  orii->size=orii->end-orii->ini+1;
  /*if(orii->norm){
    orii->xo=orii->xsum/orii->norm;
    if((orii->xo>=orii->end)||(orii->xo<=orii->ini)){
      printf("ERROR in set ori, wrong mid point %.0f (%.0f-%.0f)\n",
	     orii->xo, orii->ini, orii->end); exit(8);
    }
    }else{
    orii->xo=(orii->end+orii->ini)/2;
    }*/
  orii->xo=(orii->end+orii->ini)/2;
  orii->x1=orii->xo-PEAKSIZE;
  orii->x2=orii->xo+PEAKSIZE;
  orii->match=0;
  orii->lab=i;
  orii->next=orii+1;
}

int Overlap(struct origin ori1, struct origin ori2, float DTOL)
{
  if(ori1.cr!=ori2.cr)return(0);
  if((ori2.ini>ori1.end+DTOL)||(ori1.ini>ori2.end+DTOL))return(0);
  //iif((ori2.x1>ori1.x2+DTOL)||(ori1.x1>ori2.x2+DTOL))return(0);
  return(1);
}

void Count_matches(int *n_match1, int *n_match2, float DTOL,
		   struct origin *ori1, int N_ori1,
		   struct origin *ori2, int N_ori2)
{
  int i1, i2=0, match=0;
  struct origin *ori1_p=ori1, *ori2_p=ori2;
  for(i1=0; i1<N_ori1; i1++)ori1[i1].match=0;
  for(i2=0; i2<N_ori2; i2++)ori2[i2].match=0;
  while(1){
    while((ori1_p->cr<ori2_p->cr)||
	  ((ori1_p->cr==ori2_p->cr)&&(ori1_p->end+DTOL<ori2_p->ini))){
      ori1_p=ori1_p->next; if(ori1_p==NULL)goto count;
    }
    while((ori2_p->cr<ori1_p->cr)||
	  ((ori2_p->cr==ori1_p->cr)&&(ori2_p->end+DTOL<ori1_p->ini))){
      ori2_p=ori2_p->next; if(ori2_p==NULL)goto count;
    }
    if(Overlap(*ori1_p, *ori2_p, DTOL)){
      ori1_p->match=1; ori2_p->match=1;
      if(ori1_p->end<ori2_p->end){
	ori1_p=ori1_p->next; if(ori1_p==NULL)goto count;
      }else{
	ori2_p=ori2_p->next; if(ori2_p==NULL)goto count;
      }
    }
  }
 count:
  (*n_match1)=0; ori1_p=ori1;
  while(ori1_p!=NULL){(*n_match1)+=ori1_p->match; ori1_p=ori1_p->next;}
  (*n_match2)=0; ori2_p=ori2;
  while(ori2_p!=NULL){(*n_match2)+=ori2_p->match; ori2_p=ori2_p->next;}
}

int Unify_peaks(struct origin *ori,
		struct origin *ori1, int N_ori1,
		struct origin *ori2, int N_ori2,
		float DTOL)
{
  int Np=0, i, match=0;
  struct origin *ori1_p=ori1, *ori2_p=ori2, *ori_p=ori-1;
  for(i=0; i<(N_ori1+N_ori2); i++){
    ori[i].ini=-1; ori[i].end=-1; ori[i].match=0;
  }
  for(i=0; i<N_ori1; i++)ori1[i].match=0;
  for(i=0; i<N_ori2; i++)ori2[i].match=0;
  printf("Mult 1: ");
  for(i=0; i<60; i++)printf("%d", ori1[i].mult); printf("\n");
  printf("Mult 2: ");
  for(i=0; i<60; i++)printf("%d", ori2[i].mult); printf("\n");

  while(1){
    while((ori1_p->cr<ori2_p->cr)||
	  ((ori1_p->cr==ori2_p->cr)&&(ori1_p->end+DTOL<ori2_p->ini))){
      if(ori1_p->match==0){ori_p++; *ori_p=*ori1_p; Np++;}
      ori1_p=ori1_p->next; if(ori1_p==NULL)goto count_2;
    }
    while((ori2_p->cr<ori1_p->cr)||
	  ((ori2_p->cr==ori1_p->cr)&&(ori2_p->end+DTOL<ori1_p->ini))){
      if(ori2_p->match==0){ori_p++; *ori_p=*ori2_p; Np++;}
      ori2_p=ori2_p->next; if(ori2_p==NULL)goto count_2;
    }
    if(Overlap(*ori1_p, *ori2_p, DTOL)){
      if((ori1_p->match==0)&&(ori2_p->match==0)){ori_p++; Np++;}
      Intersect_peaks(ori_p, ori1_p, ori2_p);
      ori_p->match=1; ori1_p->match=1; ori2_p->match=1;
      if(ori1_p->end<ori2_p->end){
	ori1_p=ori1_p->next; if(ori1_p==NULL)goto count_2;
      }else{
	ori2_p=ori2_p->next; if(ori2_p==NULL)goto count_2;
      }
    }
  }
 count_2:
  while(ori1_p!=NULL){
    if(ori1_p->match==0){ori_p++; *ori_p=*ori1_p; Np++;}
    ori1_p=ori1_p->next;
  }
  while(ori2_p!=NULL){
    if(ori2_p->match==0){ori_p++; *ori_p=*ori2_p; Np++;}
    ori2_p=ori2_p->next;
  }
  for(i=0; i<Np; i++)ori[i].next=ori+i+1;
  ori[Np-1].next=NULL;
  return(Np);
}

void Intersect_peaks(struct origin *peak,
		     struct origin *peak1,
		     struct origin *peak2)
{
  peak->cr=peak1->cr;
  if(peak1->ini<peak2->ini){
    if((peak->ini<0)||(peak->ini>peak1->ini))peak->ini=peak1->ini;
  }else{
    if((peak->ini<0)||(peak->ini>peak2->ini))peak->ini=peak2->ini;
  }
  if(peak1->end>peak2->end){
    if((peak->end<0)||(peak->end<peak1->end))peak->end=peak1->end;
  }else{
    if((peak->end<0)||(peak->end<peak2->end))peak->end=peak2->end;
  }
  if(peak->match==0){peak->mult=peak1->mult+peak2->mult;}
}

float Dist_peaks(struct origin *ori1, int N_ori1,
		 struct origin *ori2, int N_ori2)
{
  double d_sum=0; float d1, d2;
  struct origin *ori=ori1, *ori_l=ori2, *ori_r;
  while(ori!=NULL){
    while((ori_l!=NULL)&&(ori_l->cr<ori->cr))ori_l=ori_l->next;
    if(ori_l!=NULL)ori_r=ori_l->next;
    while((ori_l!=NULL)&&(ori_l->cr==ori->cr)&&
	  (ori_r!=NULL)&&(ori_r->cr==ori->cr)&&(ori_r->xo < ori->xo)){
      ori_l=ori_r; ori_r=ori_l->next;
    }
    if((ori_l!=NULL)&&(ori_l->cr==ori->cr))
      {d1=fabs(ori_l->xo-ori->xo);}else{d1=10000000;}
    if((ori_r!=NULL)&&(ori_r->cr==ori->cr))
      {d2=fabs(ori_r->xo-ori->xo);}else{d2=10000000;}
    if(d1<d2){d_sum+=d1;}else{d_sum+=d2;}
    ori=ori->next;
  }
  return(d_sum/N_ori1);
}

struct origin *Extract_peaks(struct origin *ori_old, int N_ori, int Ncr)
{
  struct origin *ori=malloc(N_ori*sizeof(struct origin));
  int i, cr; float *size=malloc(Ncr*sizeof(int));
  unsigned long iran;
  for(i=0; i<Ncr; i++)size[i]=0;
  if(INIRAN==0){
    INIRAN=1;
    iran=randomgenerator();
    InitRandom( (RANDOMTYPE)iran);
    RANFACTOR=pow(12.0,1/3.0);
  }

  for(i=0; i<N_ori; i++){
    cr=ori_old[i].cr-1;
    if(ori_old[i].end > size[cr])size[cr]=ori_old[i].end;
  }
  struct origin *cr_ori=malloc(Ncr*sizeof(struct origin));
  for(i=0; i<Ncr; i++)cr_ori[i].next=NULL;
  struct origin *orii, *orij1, *orij2;
  for(i=0; i<N_ori; i++){
    cr=ori_old[i].cr-1;
    orii=ori+i;
    orii->cr=ori_old[i].cr;
    orii->size=ori_old[i].size;
    float ini=RandomFloating()*size[cr];
    orii->ini=ini;
    orii->end=ini+orii->size-1;
    orii->xo=(orii->end+orii->ini)/2;
    orii->x1=orii->xo-PEAKSIZE;
    orii->x2=orii->xo+PEAKSIZE;
    // Sort
    orij1=cr_ori+cr; orij2=orij1->next;
    while(orij2!=NULL){
      if(orii->ini<orij2->ini){
	orij1->next=orii; orii->next=orij2; break;
      }
      orij1=orij2; orij2=orij2->next;
    }
    if(orij2==NULL){orij1->next=orii; orii->next=NULL;}
  }
  // Copy
  struct origin *orinew=malloc(N_ori*sizeof(struct origin));
  i=0;
  for(cr=0; cr<Ncr; cr++){
    orii=cr_ori[cr].next;
    while(orii!=NULL){
      orinew[i]=*orii;
      orinew[i].next=orinew+i+1;
      orinew[i].lab=i;
      orii=orii->next; i++;
    }
  }
  orinew[N_ori-1].next=NULL;
  free(ori);
  return(orinew);
}


unsigned long randomgenerator(void){
     
     unsigned long tm;
     time_t seconds;
     
     time(&seconds);
     srand((unsigned)(seconds % 65536));
     do   /* waiting time equal 1 second */
       tm= clock();
     while (tm/CLOCKS_PER_SEC < (unsigned)(1));
     
     return((unsigned long) (rand()));

}

int Join(struct origin *ori1, struct origin *ori2, int *joined)
{
  joined[ori1->lab]=1;
  joined[ori2->lab]=1;
  ori1->end=ori2->end;
  ori1->next=ori2->next;
  /*if(ori1->norm){
    ori1->norm+=ori2->norm;
    ori1->xsum+=ori2->xsum;
    ori1->xo=ori1->xsum/ori1->norm;
    if((ori1->xo>=ori1->end)||(ori1->xo<=ori1->ini)){
      printf("ERROR in join, wrong mid point %.0f (%.0f-%.0f)\n",
	     ori1->xo, ori1->ini, ori1->end); exit(8);
    }
    }else{*/
    ori1->xo=(ori1->end+ori1->ini)/2.;
    //}
  ori1->x1=ori1->xo-PEAKSIZE;
  ori1->x2=ori1->xo+PEAKSIZE;
  ori1->size=ori1->end-ori1->ini+1;
  return(1);
}

void Sizediff_stat(struct origin *ori, double *Prof_ori, double **Prof_score,
		   double *Discriminant_score,
		   int N_prof, char **name_prof, char *nameout, int PRINTALL)
{
  //int MM = 3+2*N_prof;
  int M0=2; int MM = M0+N_prof;
  char *namex[MM]; int p, i, k, j, M;
  struct origin *ori1=NULL, *ori2=ori, *ori3=ori->next;
  struct origin *ori_next, *omax, *omin;
  double x_1[MM], x_2[MM], ave, dev, norm=0;
  float s, d, d1, d2;
  if(Prof_score){M=MM;}else{M=MM-N_prof;} //-2*N_prof;
  for(i=0; i<MM; i++){
    x_1[i]=0; x_2[i]=0; namex[i]=malloc(40*sizeof(char));
  }
  strcpy(namex[0], "size/10^3");
  strcpy(namex[1], "min_dist/10^4");
  for(i=0; i<N_prof; i++)strcpy(namex[M0+i],  name_prof[i]);

  // Print to file
  FILE *file_out;
  if(PRINTALL){file_out=Open_file_w(nameout);}
  else{file_out=fopen(nameout, "w");}
  fprintf(file_out, "### ");
  for(i=0; i<M; i++)fprintf(file_out," %s",namex[i]);
  fprintf(file_out, " chr x_peak\n");
  fprintf(file_out, "### "); for(i=0; i<M; i++)fprintf(file_out, " 1");
  fprintf(file_out, " 0 0\n");
  fprintf(file_out, "### "); for(i=0; i<M; i++)fprintf(file_out, " 1");
  fprintf(file_out, " 0 0\n");
  while(ori2!=NULL){
    norm++;
    if((ori1!=NULL)&&(ori1->cr==ori2->cr)){d1=ori2->ini-ori1->end;}
    else{d1=1000000000;}
    ori3=ori2->next;
    if((ori3!=NULL)&&(ori3->cr==ori2->cr)){d2=ori3->ini-ori2->end;}
    else{d2=1000000000;}
    if(d1<d2){ori_next=ori1; d=d1;}else{ori_next=ori3; d=d2;}
    /*if(ori2->size>ori_next->size){omax=ori2; omin=ori_next;}
    else{omin=ori2; omax=ori_next;}
    xx[2]=omin->size/omax->size;*/

    if(ori2->size>SIZEMAX)fprintf(file_out, "#");
    i=0; s=ori2->size;
    fprintf(file_out, "%.4g ", s/1000); x_1[i]+=s; x_2[i]+=s*s;
    i=1; s=d;
    fprintf(file_out, "%.4g ",s/10000); x_1[i]+=s; x_2[i]+=s*s;
    for(j=0; j<N_prof; j++){
      s=Prof_score[j][ori2->lab]; i++;
      fprintf(file_out, "%.4g ", s); x_1[i]+=s; x_2[i]+=s*s;
    }
    fprintf(file_out, " %d %.0f\n", ori2->cr, ori2->xo);
  next1:     ori1=ori2; ori2=ori1->next;
  }

  // Print to file
  fprintf(file_out, "# Profile sqrt(N_ori)(<S>_ori-<S>_noori)/s_noori");
  fprintf(file_out," (<S>_ori-<S>_noori)/s_ori\n");
  for(p=0; p<N_prof; p++){
    fprintf(file_out, "# %15s: %.4g  %.4g\n",
	    name_prof[p], Prof_ori[p], Discriminant_score[p]);
  }

  // Print to screen
  if((PRINTALL)&&(VERBOSE)){
    printf("num ");
    for(i=0; i<M; i++)printf(" %s", namex[i]);
    printf("\n");
    printf("%5.0f  ", norm);
    for(i=0; i<M; i++){
      Print_ave(&ave, &dev, x_1[i], x_2[i], norm, namex[i], file_out);
      printf("  %.3g %.2g", ave, dev);
    }
    printf("\n");
    for(i=0; i<M; i++)printf(" %s", namex[i]); printf("\n");
  }
  printf("%5.0f  ", norm);
  for(i=0; i<M0; i++)printf("%.0f ", x_1[i]/norm);
  for(i=0; i<N_prof; i++)printf("%.3f ", Discriminant_score[i]);
  if(PRINTALL && VERBOSE)printf("\n");
  fclose(file_out);
}

void Print_ave(double *ave, double *dev,
	       double sum1, double sum2, double norm, char *name,
	       FILE *file_out)
{
  *ave=sum1/norm;
  *dev=sum2/norm-(*ave)*(*ave); *dev=sqrt(*dev/norm);
  char string[1000];
  sprintf(string, "# %10s: ave=%.3g %.3g\n", name, *ave, *dev);
  fprintf(file_out, "%s", string);
  //printf("%s", string);
}

void Make_cluster_4(struct origin *ori, int N_ori, int *joined, float DCLUST)
{
  int i;
  for(i=0; i<N_ori; i++)joined[i]=0;
  int njoin=1, inicr=1;
  float d1, d2, d3;
  while(njoin){
    njoin=0;
    struct origin *ori1=NULL, *ori2=NULL, *ori3=NULL, *ori4=ori;
    while(ori4!=NULL){
      if(ori1==NULL){
	inicr=1; ori1=ori;
      }else if(ori4->cr!=ori3->cr){
	inicr=1; ori1=ori4;
	// Join at end of chromosome
	if((d2<DCLUST)&&(d2<d1)){
	  njoin+=Join(ori2, ori3, joined);
	}
      }
      if(inicr){
	inicr=0;
	ori2=ori1->next; d1=ori2->xo-ori1->xo;
	ori3=ori2->next; d2=ori3->xo-ori2->xo;
	if((d1<DCLUST)&&(d1<d2)){
	  njoin+=Join(ori2, ori3, joined);
	  ori2=ori1->next; d1=ori2->xo-ori1->xo;
	  ori3=ori2->next; d2=ori3->xo-ori2->xo;
	}
	ori4=ori3->next; d3=ori4->xo-ori3->xo;
      }
      if((d2<DCLUST)&&(d2<d1)&&(d2<d3)){
	// join 2 and 3
	njoin+=Join(ori2, ori3, joined);
	ori3=ori2->next; d2=ori3->xo-ori2->xo;
	ori4=ori3->next; if(ori4==NULL)break;
	d3=ori4->xo-ori3->xo;
	
      }
      ori1=ori2; ori2=ori3; ori3=ori4; ori4=ori3->next;
      if(ori4==NULL)break;
      d1=d2; d2=d3; d3=ori4->xo-ori3->xo;
    }
  }
}

int Make_cluster_1(struct origin *ori, int N_ori, int *joined, float DCLUST)
{
  int i, n=2;   float d1;
  for(i=0; i<N_ori; i++)joined[i]=0;
  struct origin *ori1=ori, *ori2=ori1->next;
  while(ori2!=NULL){
    if(ori2->cr!=ori1->cr){
      ori1=ori2; ori2=ori2->next;
      if(ori2==NULL)break;
    }
    d1=ori2->ini-ori1->end;
    if(d1<DCLUST){
      // join 2 and 1
      Join(ori1, ori2, joined);
    }else{
      ori1=ori2; n++;
    }
    ori2=ori2->next;
  }
  return(n);
}

int Make_cluster_thr(struct origin *ori, int N_ori, int *joined, float DCLUST,
		     long **xx, float **zz, long *nn, int Nchr, float Thr)
{
  long *x=xx[0], m=nn[0], k=0, k2=0;
  float *z=zz[0], d1, zj; int i, n=2;
  for(i=0; i<N_ori; i++)joined[i]=0;
  struct origin *ori1=ori, *ori2=ori1->next;
  while(ori2!=NULL){
    if(ori2->cr!=ori1->cr){
      int c=ori2->cr-1;
      x=xx[c]; m=nn[c]; z=zz[c]; k=0; k2=0;
      ori1=ori2; ori2=ori2->next;
      if(ori2==NULL)break;
    }
    d1=ori2->ini-ori1->end;
    if(d1<DCLUST){
      // join 2 and 1
      if((k2>k)&&(k2<ori1->ini))k=k2; 
      zj=Sum_score(&k2, ori1->ini, ori2->end, z, x, k, m);
      if(zj>Thr){
	Join(ori1, ori2, joined); goto next;
      }
    }
    ori1=ori2; n++; // Not joined
  next:
    ori2=ori2->next;
  }
  return(n);
}

void Profile_score(double *Prof_ori, double **Prof_score,
		   double *Discriminant_score,
		   long ***xprof, float ***yprof, long **nprof,
		   int N_prof, struct origin *ori, int N_ORI)
{
  int p, i;
  int *norm_ori=malloc(N_ORI*sizeof(int));
  for(p=0; p<N_prof; p++){
    double Prof_norm=0, Prof_1=0, Prof_2=0;
    int cr, cr_old=-1, j, nj, N_ori=0;
    long *xp; float *yp, w;
    struct origin *ori1=ori;
    double ori_norm=0;
    double Prof_ori_1=0, Prof_ori_2=0, *Ps;
    for(i=0; i<N_ORI; i++)norm_ori[i]=0;
    if(Prof_score){
      Ps=Prof_score[p];
      for(i=0; i<N_ORI; i++)Ps[i]=0;
    }
    while(ori1!=NULL){
      if(ori1->cr-1 !=cr_old){
	cr=ori1->cr-1; cr_old=cr; j=0; nj=nprof[p][cr];
	xp=xprof[p][cr]; yp=yprof[p][cr];
      }
      while((j<nj)&&(*xp<ori1->x1)){  //ini
	Prof_1 +=(*yp); Prof_2+=(*yp)*(*yp);
	Prof_norm  ++; j++; xp++; yp++;
      }
      while((j<nj)&&(*xp<=ori1->x2)){ //end
	if(Prof_score){
	  Ps[ori1->lab]+=(*yp);
	  norm_ori[ori1->lab]++;
	}
	Prof_ori_1+=(*yp);
	Prof_ori_2+=(*yp)*(*yp);
	ori_norm++;
	j++; xp++; yp++;
      }
      ori1=ori1->next; N_ori++;
    }

    // Mean score of no-peaks
    Prof_1/=Prof_norm;
    Prof_2=sqrt(Prof_2/Prof_norm-Prof_1*Prof_1);
    // Mean score of peaks
    Prof_ori_1/=ori_norm;
    Prof_ori_2=sqrt(Prof_ori_2/ori_norm-Prof_ori_1*Prof_ori_1);
    // Score of individual peaks
    if(Prof_score){
      ori1=ori; 
      while(ori1!=NULL){
	w=norm_ori[ori1->lab];
	if(w)Ps[ori1->lab]/=w;
	if(ZSCORE)Prof_score[p][ori1->lab]=(Ps[ori1->lab]-Prof_1)/Prof_2;
	Prof_score[p][ori1->lab]=Ps[ori1->lab];
	ori1=ori1->next;
      }
    }
    Prof_ori[p]=sqrt((float)N_ori)*(Prof_ori_1-Prof_1)/Prof_2;
    // Normalize by standard dev. of peaks. It has drawbacks.
    Discriminant_score[p]=(Prof_ori_1-Prof_1)/sqrt(Prof_2*Prof_ori_2);
    //sqrt((float)N_ori)
    // Discriminant_score[p]=(Prof_ori_1-Prof_1)/Prof_2;
  }
  free(norm_ori);
}

int Remove_fragments(struct origin *ori, int N_ori, int *removed,
		     float Size_min)
{
  int n=N_ori, i;
  struct origin *ori1=ori, *ori2;
  while((ori1!=NULL)&&(ori1->size<Size_min)){
    removed[ori1->lab]=1; n--; ori1=ori1->next; 
  }
  if(ori1==NULL)return(0);
  if(ori1!=ori){*ori=*ori1; ori1=ori;}
  ori2=ori1->next;
  while(ori2!=NULL){
    if(ori2->size<Size_min){
      removed[ori2->lab]=1; n--; ori1->next=ori2->next;
    }else{
      removed[ori2->lab]=0; ori1=ori2;
    }
    ori2=ori2->next;
  }
  printf("Removing fragments with size < %.0f ", Size_min);
  printf("obtaining %d from %d origins\n", n, N_ori);
  return(n);
}

char *Extension(char *string){
  char *s=string, *s0=s; int i=0, l=sizeof(string);
  while(*s!='\0'){if(*s=='.')s0=s+1; s++;}
  return(s0);
}

int Get_step_wig(char *string){
  char *s=string; int i, l=sizeof(string), step;
  while(*s!='\n'){
    if((strncmp(s, "step=", 5)==0)||(strncmp(s, "span=", 5)==0)){
      sscanf(s+5, "%d", &step);
      return(step);
    }
    s++;
  }
  printf("ERROR, step not found in wig file, %s", string); //exit(8);
}

int Count_columns(char *string){
  int m=0; char *ptr=string;
  while(*ptr!='\n'){
    if((*ptr!=' ')&&(*ptr!='\t')){
      m++;
      while((*ptr!=' ')&&(*ptr!='\t')&&(*ptr!='\n'))ptr++;
    }else{
      ptr++;
    }
  }
  return(m);
}


float Sum_score(long *k2, long ini, long end,
		float *z, long *x, long k, long m)
{
  float zj=0; int n=0; long i;
  for(i=k; i<m; i++){
    if(x[i]>end)break;
    if(x[i]>ini)zj+=z[i]; n++;
  }
  *k2=i;
  return(zj/n);
}
