// automatically generated from python modules tenkit.constants

package tenkit_py

// autogenerated from tenkit.constants

const ALLELE_FRACTION_FILTER = `(AO[0] < 2 || AO[0]/(AO[0] + RO) < 0.15)`
const BCL_PROCESSOR_FASTQ_MODE = `BCL_PROCESSOR`
const BC_QUAL_CUTOFFS = [4]int{
	15,
	20,
	25,
	30,
}
const CHROMIUM = `Chromium`
const CHROMIUM_LOT10_PART_A = [8]string{
	`CAGCACG`,
	`CATGATG`,
	`ATCAACG`,
	`GATAAGA`,
	`CTGGTTC`,
	`CGATTCC`,
	`AGGTGAG`,
	`GGCCTGA`,
}
const CHROMIUM_LOT11_PART_A = [8]string{
	`ACAGTTG`,
	`TAAGCAC`,
	`ATCTTTG`,
	`TCTTGCG`,
	`TACATGG`,
	`CAAGGTT`,
	`AGGCTGC`,
	`GGTCGTG`,
}
const CHROMIUM_LOT12_PART_A = [8]string{
	`CCATTAT`,
	`GTTGCGG`,
	`AGGGTAG`,
	`GCCCAAG`,
	`TGTGCCT`,
	`ATTCTTG`,
	`GGTGCCA`,
	`GTATAGC`,
}
const CHROMIUM_LOT13_PART_A = [8]string{
	`GGCATCG`,
	`GACTGAT`,
	`TGGTGTA`,
	`TCCGTTG`,
	`CCTTCAG`,
	`CAGGCCA`,
	`GCACCGA`,
	`AGATCCA`,
}
const CHROMIUM_LOT1_PART_A = [8]string{
	`AGAGCGA`,
	`CGATTGA`,
	`TAGACCA`,
	`AAATGCC`,
	`CTTTGCG`,
	`TCAGCAA`,
	`CTCCTAG`,
	`ATTATCC`,
}
const CHROMIUM_LOT2_PART_A = [8]string{
	`GACACTA`,
	`CCCTCTC`,
	`ATCGCGG`,
	`CTGGCAG`,
	`CCAGCTT`,
	`CATAGCA`,
	`CGTGTTC`,
	`GCACCAG`,
}
const CHROMIUM_LOT3_PART_A = [8]string{
	`ATGTGAC`,
	`GACGTCG`,
	`ACTGGCG`,
	`TGGCAAT`,
	`GAGGGTA`,
	`GTTTCGC`,
	`CAAGTGT`,
	`TTGAAGC`,
}
const CHROMIUM_LOT4_PART_A = [8]string{
	`CGATCCT`,
	`TGTTGCC`,
	`ACCTATT`,
	`ACAACTG`,
	`CTGTGTC`,
	`CTGGAAT`,
	`CAGAGTT`,
	`GGGCTGT`,
}
const CHROMIUM_LOT5_PART_A = [8]string{
	`TAGCTCC`,
	`CAATTTC`,
	`GCTCGAG`,
	`GAAGGCA`,
	`CGGCATG`,
	`TATTCCA`,
	`TCTCTGG`,
	`AGGTACT`,
}
const CHROMIUM_LOT6_PART_A = [8]string{
	`ACTTGCC`,
	`GTGAGTT`,
	`GTTGTCC`,
	`CATAACG`,
	`TCGTAAG`,
	`TTATCCA`,
	`GTGGAGA`,
	`TCCTGCA`,
}
const CHROMIUM_LOT7_PART_A = [8]string{
	`TAAGCCA`,
	`TCGGTGG`,
	`AAGGTAA`,
	`GGAACAG`,
	`GTGGAAG`,
	`TTAGACG`,
	`ATCCTAT`,
	`TTCCGTG`,
}
const CHROMIUM_LOT8_PART_A = [8]string{
	`GGTTTAG`,
	`CGTATAG`,
	`ATAGGCT`,
	`CTCTCGA`,
	`GTCTTAT`,
	`GATTGCA`,
	`TGAGCTA`,
	`ACGCGTG`,
}
const CHROMIUM_LOT9_PART_A = [8]string{
	`CGACACG`,
	`TCTCGTG`,
	`TGATGAC`,
	`TGCGTAA`,
	`TACCCTG`,
	`AGGTGCC`,
	`CTTGTGC`,
	`GCATGGC`,
}

var CHROMIUM_LOT_MAP = map[string][8]string{
	`Chromium Lot 13`: [8]string{
		`GGCATCG`,
		`GACTGAT`,
		`TGGTGTA`,
		`TCCGTTG`,
		`CCTTCAG`,
		`CAGGCCA`,
		`GCACCGA`,
		`AGATCCA`,
	},
	`Chromium Lot 12`: [8]string{
		`CCATTAT`,
		`GTTGCGG`,
		`AGGGTAG`,
		`GCCCAAG`,
		`TGTGCCT`,
		`ATTCTTG`,
		`GGTGCCA`,
		`GTATAGC`,
	},
	`Chromium Lot 11`: [8]string{
		`ACAGTTG`,
		`TAAGCAC`,
		`ATCTTTG`,
		`TCTTGCG`,
		`TACATGG`,
		`CAAGGTT`,
		`AGGCTGC`,
		`GGTCGTG`,
	},
	`Chromium Lot 10`: [8]string{
		`CAGCACG`,
		`CATGATG`,
		`ATCAACG`,
		`GATAAGA`,
		`CTGGTTC`,
		`CGATTCC`,
		`AGGTGAG`,
		`GGCCTGA`,
	},
	`Chromium Lot 7`: [8]string{
		`TAAGCCA`,
		`TCGGTGG`,
		`AAGGTAA`,
		`GGAACAG`,
		`GTGGAAG`,
		`TTAGACG`,
		`ATCCTAT`,
		`TTCCGTG`,
	},
	`Chromium Lot 6`: [8]string{
		`ACTTGCC`,
		`GTGAGTT`,
		`GTTGTCC`,
		`CATAACG`,
		`TCGTAAG`,
		`TTATCCA`,
		`GTGGAGA`,
		`TCCTGCA`,
	},
	`Chromium Lot 5`: [8]string{
		`TAGCTCC`,
		`CAATTTC`,
		`GCTCGAG`,
		`GAAGGCA`,
		`CGGCATG`,
		`TATTCCA`,
		`TCTCTGG`,
		`AGGTACT`,
	},
	`Chromium Lot 4`: [8]string{
		`CGATCCT`,
		`TGTTGCC`,
		`ACCTATT`,
		`ACAACTG`,
		`CTGTGTC`,
		`CTGGAAT`,
		`CAGAGTT`,
		`GGGCTGT`,
	},
	`Chromium Lot 3`: [8]string{
		`ATGTGAC`,
		`GACGTCG`,
		`ACTGGCG`,
		`TGGCAAT`,
		`GAGGGTA`,
		`GTTTCGC`,
		`CAAGTGT`,
		`TTGAAGC`,
	},
	`Chromium Lot 2`: [8]string{
		`GACACTA`,
		`CCCTCTC`,
		`ATCGCGG`,
		`CTGGCAG`,
		`CCAGCTT`,
		`CATAGCA`,
		`CGTGTTC`,
		`GCACCAG`,
	},
	`Chromium Lot 1`: [8]string{
		`AGAGCGA`,
		`CGATTGA`,
		`TAGACCA`,
		`AAATGCC`,
		`CTTTGCG`,
		`TCAGCAA`,
		`CTCCTAG`,
		`ATTATCC`,
	},
	`Chromium Lot 9`: [8]string{
		`CGACACG`,
		`TCTCGTG`,
		`TGATGAC`,
		`TGCGTAA`,
		`TACCCTG`,
		`AGGTGCC`,
		`CTTGTGC`,
		`GCATGGC`,
	},
	`Chromium Lot 8`: [8]string{
		`GGTTTAG`,
		`CGTATAG`,
		`ATAGGCT`,
		`CTCTCGA`,
		`GTCTTAT`,
		`GATTGCA`,
		`TGAGCTA`,
		`ACGCGTG`,
	},
}

const COVERAGE_TRIM_TAIL = 0.01
const CUSTOMER_LEFT_TAIL_COVERAGE = 5
const DEFAULT_HIGH_MAPQ = 60
const DEMULTIPLEX_BARCODE_LENGTH = 14
const DEMULTIPLEX_DEFAULT_SAMPLE_INDEX_LENGTH = 8
const DUPLICATE_SUBSAMPLE_COVERAGES = [8]float64{
	16.0,
	8.0,
	4.0,
	2.0,
	1.0,
	0.5,
	0.25,
	0.125,
}

var FLUIDICS_PARAMS = map[string]map[string]float64{
	`Chromium`: map[string]float64{
		`total_z2_vol_input`: 9e-05,
		`z2_vol_per_gem`:     2.45e-11,
	},
	`GemCode`: map[string]float64{
		`total_z2_vol_input`: 6.5e-05,
		`z2_vol_per_gem`:     1.44e-10,
	},
}

const FRAGMENT_LINK_DISTANCE = 30000
const FRAGMENT_PHASING_THRESHOLD = 0.995
const FRAG_LEN_HIST_BIN_SIZE = 100
const FRAG_LEN_HIST_BIN_SIZE_FOR_LW_MODE = 2000
const GEMCODE = `GemCode`
const GEMCODE_LOT16_PART_A = [8]string{
	`CAAGTC`,
	`ACAAAG`,
	`CTGGAT`,
	`TTGTCT`,
	`AGCCTA`,
	`GGGAAC`,
	`TTCCTA`,
	`CCGTAA`,
}
const GEMCODE_LOT17_PART_A = [8]string{
	`AGTCCA`,
	`CAGGAG`,
	`CAATGC`,
	`CAATCG`,
	`AACAGA`,
	`TTACTC`,
	`ACTGAC`,
	`TAAGCC`,
}
const GEMCODE_LOT18_PART_A = [8]string{
	`GCATGT`,
	`CCAACA`,
	`TCGGTA`,
	`ATCGTG`,
	`ATTCTC`,
	`CGTTAG`,
	`TTCACT`,
	`GGTTTG`,
}
const GEMCODE_LOT19_PART_A = [8]string{
	`CTTTCA`,
	`TTGTTC`,
	`TAGCCA`,
	`GCGTAT`,
	`CGTACA`,
	`CCTTCG`,
	`CACACA`,
	`TACTTC`,
}
const GEMCODE_LOT1_PART_A = [8]string{
	`GGGTGA`,
	`TTCATC`,
	`CACAAC`,
	`GAAGAT`,
	`CAGCAT`,
	`CGTCAA`,
	`GAAACA`,
	`TGTTTC`,
}
const GEMCODE_LOT20_PART_A = [8]string{
	`CTTCAT`,
	`ATTCCT`,
	`GTCTCC`,
	`CAGGGA`,
	`ATCCGA`,
	`CGAATC`,
	`AAACCC`,
	`CGCTAA`,
}
const GEMCODE_LOT21_PART_A = [8]string{
	`CAGATC`,
	`AATCCG`,
	`TACGTG`,
	`GAACAA`,
	`AGAGCG`,
	`CCAGAT`,
	`CGCTTC`,
	`TTATCC`,
}

var GEMCODE_LOT_MAP = map[string][8]string{
	`GemCode Lot 18`: [8]string{
		`GCATGT`,
		`CCAACA`,
		`TCGGTA`,
		`ATCGTG`,
		`ATTCTC`,
		`CGTTAG`,
		`TTCACT`,
		`GGTTTG`,
	},
	`GemCode Lot 19`: [8]string{
		`CTTTCA`,
		`TTGTTC`,
		`TAGCCA`,
		`GCGTAT`,
		`CGTACA`,
		`CCTTCG`,
		`CACACA`,
		`TACTTC`,
	},
	`GemCode Lots 1-15`: [8]string{
		`GGGTGA`,
		`TTCATC`,
		`CACAAC`,
		`GAAGAT`,
		`CAGCAT`,
		`CGTCAA`,
		`GAAACA`,
		`TGTTTC`,
	},
	`GemCode Lot 21`: [8]string{
		`CAGATC`,
		`AATCCG`,
		`TACGTG`,
		`GAACAA`,
		`AGAGCG`,
		`CCAGAT`,
		`CGCTTC`,
		`TTATCC`,
	},
	`GemCode Lot 20`: [8]string{
		`CTTCAT`,
		`ATTCCT`,
		`GTCTCC`,
		`CAGGGA`,
		`ATCCGA`,
		`CGAATC`,
		`AAACCC`,
		`CGCTAA`,
	},
	`GemCode Lot 16`: [8]string{
		`CAAGTC`,
		`ACAAAG`,
		`CTGGAT`,
		`TTGTCT`,
		`AGCCTA`,
		`GGGAAC`,
		`TTCCTA`,
		`CCGTAA`,
	},
	`GemCode Lot 17`: [8]string{
		`AGTCCA`,
		`CAGGAG`,
		`CAATGC`,
		`CAATCG`,
		`AACAGA`,
		`TTACTC`,
		`ACTGAC`,
		`TAAGCC`,
	},
}

const GLOBAL_NOFILE_PATH = `/proc/sys/fs/file-max`
const HAPLOTYPE_BAM_TAG = `HP`
const HIGH_CONF_MAPQ = 60
const ILLUMINA_MAX_QUAL = 50
const ILLUMINA_QUAL_OFFSET = 33
const ILMN_BCL2FASTQ_FASTQ_MODE = `ILMN_BCL2FASTQ`
const INSERT_MAPQ_CUTOFFS = [3]int{
	0,
	30,
	60,
}
const LARIAT_RESCUE_FILTER = `(((RESCUED+NOT_RESCUED) > 0 & RESCUED/(RESCUED+NOT_RESCUED) > 0.1) & (MMD == -1 | MMD >= 3.0)) `
const MAX_INSERT_SIZE = 10000
const MAX_TARGET_DIST = 10000
const MIN_GLOBAL_NOFILE = 32768
const MIN_MATE_OFFSET_DUP_FILTER = 20
const MIN_PROCESS_NOFILE = 1024
const MODERATE_CONF_MAPQ = 29
const MOLECULE_ID_BAM_TAG = `MI`
const NG_PER_BP = 1.1454e-12

var PACKAGE_VERSION_CMDS = [12]map[string]string{
	map[string]string{
		`cmd`:  `mrc --version`,
		`name`: `mrc`,
	},
	map[string]string{
		`cmd`:  `mrp --version`,
		`name`: `mrp`,
	},
	map[string]string{
		`cmd`:  `python --version 2>&1 | cat `,
		`name`: `Anaconda`,
	},
	map[string]string{
		`cmd`:  `python -c "import numpy; print numpy.__version__"`,
		`name`: `numpy`,
	},
	map[string]string{
		`cmd`:  `python -c "import scipy; print scipy.__version__"`,
		`name`: `scipy`,
	},
	map[string]string{
		`cmd`:  `python -c "import pysam; print pysam.__version__"`,
		`name`: `pysam`,
	},
	map[string]string{
		`cmd`:  `python -c "import vcf; print vcf.VERSION"`,
		`name`: `PyVCF`,
	},
	map[string]string{
		`cmd`:  `python -c "import h5py; print h5py.__version__"`,
		`name`: `h5py`,
	},
	map[string]string{
		`cmd`:  `python -c "import pandas; print pandas.__version__"`,
		`name`: `pandas`,
	},
	map[string]string{
		`cmd`:  `bwa 2>&1 | grep "^ *Version"`,
		`name`: `bwa`,
	},
	map[string]string{
		`cmd`:  `samtools 2>&1 | grep "^ *Version"`,
		`name`: `samtools`,
	},
	map[string]string{
		`cmd`:  `freebayes -h | grep ^version`,
		`name`: `freebayes`,
	},
}

const PARALLEL_LOCUS_SIZE = 40000000
const PARALLEL_NUM_READS_SIZE = 1000000
const PHASE_SET_BAM_TAG = `PS`
const PHASING_CONF_BAM_TAG = `PC`
const PROCESSED_BARCODE_TAG = `BX`
const QUAL_FILTER = `(%QUAL <= 15 || (AF[0] > 0.5 && %QUAL < 50))`
const RAW_BARCODE_QUAL_TAG = `QX`
const RAW_BARCODE_TAG = `RX`
const READ_MATE_CHIM_TOO_CLOSE_DIST = 20
const READ_MATE_FAR_DIST = 5000
const REQUIRED_MIN_READS = 3
const REQUIRED_NUM_READS = 3

var SAMPLE_INDEX_MAP = map[string][4]string{
	`SI-P02-B4`: [4]string{
		`ACTTCATA`,
		`GAGATGAC`,
		`TGCCGTGG`,
		`CTAGACCT`,
	},
	`220027`: [4]string{
		`TCGCCATA`,
		`GTATACAC`,
		`AATGGTGG`,
		`CGCATGCT`,
	},
	`SI-P02-F8`: [4]string{
		`CATGAACA`,
		`TCACTCGC`,
		`AGCTGGAT`,
		`GTGACTTG`,
	},
	`SI-P03-H12`: [4]string{
		`ACGAGTAG`,
		`CAATCCCT`,
		`GTCCAGGC`,
		`TGTGTATA`,
	},
	`SI-P03-H10`: [4]string{
		`ATTTCAGC`,
		`CGAGTGAT`,
		`GACCGCCA`,
		`TCGAATTG`,
	},
	`SI-P03-H11`: [4]string{
		`AGGATCGA`,
		`CACGATTC`,
		`GTATCGAG`,
		`TCTCGACT`,
	},
	`SI-P02-H9`: [4]string{
		`ACACTGTT`,
		`CAGGATGG`,
		`GGCTGAAC`,
		`TTTACCCA`,
	},
	`SI-P02-F9`: [4]string{
		`CAAGCTCC`,
		`GTTCACTG`,
		`TCGTGAAA`,
		`AGCATGGT`,
	},
	`SI-3A-E3`: [4]string{
		`AACAAGTC`,
		`CGGCTCCA`,
		`GTATGTAT`,
		`TCTGCAGG`,
	},
	`SI-P01-G12`: [4]string{
		`CATGCGTA`,
		`ACCCGCAC`,
		`TGATATCG`,
		`GTGATAGT`,
	},
	`SI-P01-G11`: [4]string{
		`AGGGCGTT`,
		`CTATACGC`,
		`TACATAAG`,
		`GCTCGTCA`,
	},
	`SI-P01-G10`: [4]string{
		`CGGAGACT`,
		`TCCTATGA`,
		`ATACTGAG`,
		`GATGCCTC`,
	},
	`SI-P03-E8`: [4]string{
		`AGCCTATG`,
		`CTAACGCA`,
		`GCTTACAT`,
		`TAGGGTGC`,
	},
	`SI-P2-H7`: [4]string{
		`AGCTATCA`,
		`CATATAAC`,
		`TCAGGGTG`,
		`GTGCCCGT`,
	},
	`SI-GA-B1`: [4]string{
		`GTAATCTT`,
		`TCCGGAAG`,
		`AGTTCGGC`,
		`CAGCATCA`,
	},
	`SI-GA-B2`: [4]string{
		`TACTCTTC`,
		`CCTGTGCG`,
		`GGACACGT`,
		`ATGAGAAA`,
	},
	`SI-GA-B3`: [4]string{
		`GTGTATTA`,
		`TGTGCGGG`,
		`ACCATAAC`,
		`CAACGCCT`,
	},
	`SI-GA-B4`: [4]string{
		`ACTTCATA`,
		`GAGATGAC`,
		`TGCCGTGG`,
		`CTAGACCT`,
	},
	`SI-GA-B5`: [4]string{
		`AATAATGG`,
		`CCAGGGCA`,
		`TGCCTCAT`,
		`GTGTCATC`,
	},
	`SI-GA-B6`: [4]string{
		`CGTTAATC`,
		`GCCACGCT`,
		`TTACTCAG`,
		`AAGGGTGA`,
	},
	`SI-GA-B7`: [4]string{
		`AAACCTCA`,
		`GCCTTGGT`,
		`CTGGACTC`,
		`TGTAGAAG`,
	},
	`SI-GA-B8`: [4]string{
		`AAAGTGCT`,
		`GCTACCTG`,
		`TGCTGTAA`,
		`CTGCAAGC`,
	},
	`SI-GA-B9`: [4]string{
		`CTGTAACT`,
		`TCTAGCGA`,
		`AGAGTGTG`,
		`GACCCTAC`,
	},
	`SI-P02-A12`: [4]string{
		`AGTGGAAC`,
		`GTCTCCTT`,
		`TCACATCA`,
		`CAGATGGG`,
	},
	`SI-P2-E8`: [4]string{
		`ATAGTTAC`,
		`TGCTGAGT`,
		`CCTACGTA`,
		`GAGCACCG`,
	},
	`SI-P2-F11`: [4]string{
		`GCGAGAGT`,
		`TACGTTCA`,
		`AGTCCCAC`,
		`CTATAGTG`,
	},
	`SI-P2-B10`: [4]string{
		`ACCGTATG`,
		`GATTAGAT`,
		`CTGACTGA`,
		`TGACGCCC`,
	},
	`SI-P2-B11`: [4]string{
		`GTTCCTCA`,
		`AGGTACGC`,
		`TAAGTATG`,
		`CCCAGGAT`,
	},
	`SI-P2-B12`: [4]string{
		`TACCACCA`,
		`CTAAGTTT`,
		`GGGTCAAG`,
		`ACTGTGGC`,
	},
	`SI-P2-E6`: [4]string{
		`CTGCGGCT`,
		`GACTCAAA`,
		`AGAAACTC`,
		`TCTGTTGG`,
	},
	`SI-P02-D2`: [4]string{
		`TAACAAGG`,
		`GGTTCCTC`,
		`ATCATGCA`,
		`CCGGGTAT`,
	},
	`SI-P03-A7`: [4]string{
		`AGGTCATA`,
		`CTCATCAT`,
		`GCTGAGGG`,
		`TAACGTCC`,
	},
	`SI-P03-A6`: [4]string{
		`ACGGGACT`,
		`CTTTCGAC`,
		`GAACATGA`,
		`TGCATCTG`,
	},
	`SI-P03-A5`: [4]string{
		`ATTGGGAA`,
		`CAGTCTGG`,
		`GGCATACT`,
		`TCACACTC`,
	},
	`SI-P03-A4`: [4]string{
		`AGAACGCC`,
		`CATGGCAG`,
		`GTCTTTGA`,
		`TCGCAATT`,
	},
	`SI-P03-A3`: [4]string{
		`AAAGCATA`,
		`CTGCAGCC`,
		`GCCTTTAT`,
		`TGTAGCGG`,
	},
	`SI-P03-A2`: [4]string{
		`AGCCCTTT`,
		`CAAGTCCA`,
		`GTGAGAAG`,
		`TCTTAGGC`,
	},
	`SI-P03-A1`: [4]string{
		`AAACGGCG`,
		`CCTACCAT`,
		`GGCGTTTC`,
		`TTGTAAGA`,
	},
	`SI-P03-A9`: [4]string{
		`ACAACTTG`,
		`CTCCAACA`,
		`GAGTGCGT`,
		`TGTGTGAC`,
	},
	`SI-P03-A8`: [4]string{
		`ATGATACG`,
		`CCACAGAA`,
		`GACTGTTC`,
		`TGTGCCGT`,
	},
	`SI-3A-G3`: [4]string{
		`ATGTCCAG`,
		`CGACGTCA`,
		`GCTATAGC`,
		`TACGAGTT`,
	},
	`SI-3A-G2`: [4]string{
		`ATAACCTA`,
		`CGGTGAGC`,
		`GATCTTAT`,
		`TCCGAGCG`,
	},
	`SI-3A-G1`: [4]string{
		`ATGCGATT`,
		`CATATGCG`,
		`GGATACGA`,
		`TCCGCTAC`,
	},
	`SI-3A-G7`: [4]string{
		`ATTACCGG`,
		`CAGTAATT`,
		`GCCGGTAA`,
		`TGACTGCC`,
	},
	`SI-3A-G6`: [4]string{
		`AGCACTGG`,
		`CATTACAC`,
		`GTGCGACA`,
		`TCAGTGTT`,
	},
	`SI-3A-G5`: [4]string{
		`ATGAAGTA`,
		`CGCCGAAC`,
		`GAAGCTCG`,
		`TCTTTCGT`,
	},
	`SI-3A-G4`: [4]string{
		`AGCTTCTC`,
		`CCTGCGGT`,
		`GTACAACG`,
		`TAGAGTAA`,
	},
	`SI-P2-D4`: [4]string{
		`CCCTAACA`,
		`ATTCCGAT`,
		`TGGATTGC`,
		`GAAGGCTG`,
	},
	`SI-P2-D5`: [4]string{
		`CTCGTCAC`,
		`GATCAGCA`,
		`ACAACAGG`,
		`TGGTGTTT`,
	},
	`SI-3A-G9`: [4]string{
		`AGTCTCAG`,
		`CAATGGCA`,
		`GCCGAAGT`,
		`TTGACTTC`,
	},
	`SI-3A-G8`: [4]string{
		`AAGTACTC`,
		`CTTGGAGA`,
		`GGAACTCT`,
		`TCCCTGAG`,
	},
	`SI-P2-D1`: [4]string{
		`CACTCGGA`,
		`GCTGAATT`,
		`TGAAGTAC`,
		`ATGCTCCG`,
	},
	`SI-P2-D2`: [4]string{
		`TAACAAGG`,
		`GGTTCCTC`,
		`ATCATGCA`,
		`CCGGGTAT`,
	},
	`SI-P2-D3`: [4]string{
		`ACATTACT`,
		`TTTGGGTA`,
		`CAGCCCAC`,
		`GGCAATGG`,
	},
	`SI-GA-G4`: [4]string{
		`GCGATGTG`,
		`AGATACAA`,
		`TTTCCACT`,
		`CACGGTGC`,
	},
	`SI-P02-C8`: [4]string{
		`GTTGAGAA`,
		`AGATCTGG`,
		`TCGATACT`,
		`CACCGCTC`,
	},
	`SI-P02-E12`: [4]string{
		`ACCGGCTC`,
		`GAGTTAGT`,
		`CGTCCTAG`,
		`TTAAAGCA`,
	},
	`SI-P02-E10`: [4]string{
		`AAATGTGC`,
		`GGGCAAAT`,
		`TCTATCCG`,
		`CTCGCGTA`,
	},
	`SI-P02-C9`: [4]string{
		`GCGCAGAA`,
		`ATCTTACC`,
		`TATGGTGT`,
		`CGAACCTG`,
	},
	`SI-P2-G11`: [4]string{
		`TTATCGTT`,
		`AGCAGAGC`,
		`CATCTCCA`,
		`GCGGATAG`,
	},
	`SI-P2-G10`: [4]string{
		`TCGCCAGC`,
		`AATGTTAG`,
		`CGATAGCT`,
		`GTCAGCTA`,
	},
	`SI-P2-G12`: [4]string{
		`ATTCTAAG`,
		`CCCGATTA`,
		`TGGAGGCT`,
		`GAATCCGC`,
	},
	`SI-P02-C6`: [4]string{
		`ATTACTTC`,
		`TGCGAACT`,
		`GCATTCGG`,
		`CAGCGGAA`,
	},
	`SI-P03-E9`: [4]string{
		`AGTAAGCA`,
		`CCGGTAAT`,
		`GTATCTTC`,
		`TACCGCGG`,
	},
	`SI-3A-B12`: [4]string{
		`ACGCTTGG`,
		`CGCTACAT`,
		`GAAAGACA`,
		`TTTGCGTC`,
	},
	`SI-P02-D9`: [4]string{
		`AGGAGATG`,
		`GATGTGGT`,
		`CTACATCC`,
		`TCCTCCAA`,
	},
	`SI-3A-B10`: [4]string{
		`ACCATTAA`,
		`CTGGACGT`,
		`GAACGGTC`,
		`TGTTCACG`,
	},
	`SI-3A-B11`: [4]string{
		`ATGGTCGC`,
		`CGACATAG`,
		`GATTCGCT`,
		`TCCAGATA`,
	},
	`SI-GA-A11`: [4]string{
		`GTCCGGTC`,
		`AAGATCAT`,
		`CCTGAAGG`,
		`TGATCTCA`,
	},
	`SI-GA-A10`: [4]string{
		`GAAACCCT`,
		`TTTCTGTC`,
		`CCGTGTGA`,
		`AGCGAAAG`,
	},
	`SI-GA-A12`: [4]string{
		`AGTGGAAC`,
		`GTCTCCTT`,
		`TCACATCA`,
		`CAGATGGG`,
	},
	`SI-P02-C4`: [4]string{
		`ACAATTCA`,
		`TGCGCAGC`,
		`CATCACTT`,
		`GTGTGGAG`,
	},
	`SI-P02-A11`: [4]string{
		`GTCCGGTC`,
		`AAGATCAT`,
		`CCTGAAGG`,
		`TGATCTCA`,
	},
	`SI-P02-C5`: [4]string{
		`CGACTTGA`,
		`TACAGACT`,
		`ATTGCGTG`,
		`GCGTACAC`,
	},
	`SI-P01-B8`: [4]string{
		`ACGTTCAC`,
		`TGCCCAGA`,
		`CAAGGTCT`,
		`GTTAAGTG`,
	},
	`SI-P01-B9`: [4]string{
		`AAGCGTGT`,
		`CTTGACCG`,
		`TGATTAAC`,
		`GCCACGTA`,
	},
	`SI-P2-D10`: [4]string{
		`CAATACCC`,
		`TGTCTATG`,
		`ACCACGAA`,
		`GTGGGTGT`,
	},
	`SI-P2-D11`: [4]string{
		`CTTTGCGG`,
		`TGCACAAA`,
		`AAGCAGTC`,
		`GCAGTTCT`,
	},
	`SI-P01-B4`: [4]string{
		`GACAGGCT`,
		`CCTCTAAC`,
		`AGGGACTG`,
		`TTATCTGA`,
	},
	`SI-P01-B5`: [4]string{
		`TCATGCGA`,
		`ATCGTACT`,
		`CATCAGTG`,
		`GGGACTAC`,
	},
	`SI-P01-B6`: [4]string{
		`GCGCACCT`,
		`AACGCGAA`,
		`CTATTTGG`,
		`TGTAGATC`,
	},
	`SI-P01-B7`: [4]string{
		`TCCACACG`,
		`CTTCTGTT`,
		`GAATGCAC`,
		`AGGGATGA`,
	},
	`SI-P01-B1`: [4]string{
		`CTAGCTGT`,
		`GCCAACAA`,
		`AGGCTACC`,
		`TATTGGTG`,
	},
	`SI-P01-B2`: [4]string{
		`GGTCGAGC`,
		`TTAGATTG`,
		`CCCACCCA`,
		`AAGTTGAT`,
	},
	`SI-P01-B3`: [4]string{
		`TCATCCTT`,
		`ATTGGACG`,
		`CAGCTTAC`,
		`GGCAAGGA`,
	},
	`SI-P03-H1`: [4]string{
		`AAACTCAT`,
		`CGGGAGTA`,
		`GTCACAGG`,
		`TCTTGTCC`,
	},
	`SI-P03-H2`: [4]string{
		`AACGGTCA`,
		`CCGAACTC`,
		`GGTCCAAG`,
		`TTATTGGT`,
	},
	`SI-P03-H3`: [4]string{
		`ACACCTAA`,
		`CGTTTGGG`,
		`GACAAACC`,
		`TTGGGCTT`,
	},
	`SI-P03-H4`: [4]string{
		`ACTGGAGC`,
		`CGGTCGTG`,
		`GAAATCAA`,
		`TTCCATCT`,
	},
	`SI-P03-H5`: [4]string{
		`ATAGTATG`,
		`CCGCGTCT`,
		`GGCTCCAC`,
		`TATAAGGA`,
	},
	`SI-P03-H6`: [4]string{
		`AAGCATAA`,
		`CCCATCGC`,
		`GGTTGATG`,
		`TTAGCGCT`,
	},
	`SI-P03-H7`: [4]string{
		`AACGGGTG`,
		`CTAATTCT`,
		`GCTTCAAC`,
		`TGGCACGA`,
	},
	`SI-P03-H8`: [4]string{
		`AAGAGCGG`,
		`CTTGTTAT`,
		`GGCCCATC`,
		`TCATAGCA`,
	},
	`SI-P03-H9`: [4]string{
		`ACCTGCCA`,
		`CTTCATAC`,
		`GGAATATG`,
		`TAGGCGGT`,
	},
	`SI-P02-C1`: [4]string{
		`CCACTTAT`,
		`AACTGGCG`,
		`TTGGCATA`,
		`GGTAACGC`,
	},
	`SI-P02-F11`: [4]string{
		`GCGAGAGT`,
		`TACGTTCA`,
		`AGTCCCAC`,
		`CTATAGTG`,
	},
	`SI-P02-F10`: [4]string{
		`GCTTGGCT`,
		`AAACAAAC`,
		`CGGGCTTA`,
		`TTCATCGG`,
	},
	`SI-P02-F12`: [4]string{
		`TGATGCAT`,
		`GCTACTGA`,
		`CACCTGCC`,
		`ATGGAATG`,
	},
	`SI-P03-B10`: [4]string{
		`ACCATTAA`,
		`CTGGACGT`,
		`GAACGGTC`,
		`TGTTCACG`,
	},
	`SI-P03-B11`: [4]string{
		`ATGGTCGC`,
		`CGACATAG`,
		`GATTCGCT`,
		`TCCAGATA`,
	},
	`SI-P03-B12`: [4]string{
		`ACGCTTGG`,
		`CGCTACAT`,
		`GAAAGACA`,
		`TTTGCGTC`,
	},
	`SI-P02-G10`: [4]string{
		`TCGCCAGC`,
		`AATGTTAG`,
		`CGATAGCT`,
		`GTCAGCTA`,
	},
	`SI-P02-H3`: [4]string{
		`CCAAGATG`,
		`AGGCCCGA`,
		`TACGTGAC`,
		`GTTTATCT`,
	},
	`SI-P02-A2`: [4]string{
		`TTTCATGA`,
		`ACGTCCCT`,
		`CGCATGTG`,
		`GAAGGAAC`,
	},
	`SI-GA-B12`: [4]string{
		`TACCACCA`,
		`CTAAGTTT`,
		`GGGTCAAG`,
		`ACTGTGGC`,
	},
	`SI-GA-B10`: [4]string{
		`ACCGTATG`,
		`GATTAGAT`,
		`CTGACTGA`,
		`TGACGCCC`,
	},
	`SI-GA-B11`: [4]string{
		`GTTCCTCA`,
		`AGGTACGC`,
		`TAAGTATG`,
		`CCCAGGAT`,
	},
	`SI-P03-G9`: [4]string{
		`AGTCTCAG`,
		`CAATGGCA`,
		`GCCGAAGT`,
		`TTGACTTC`,
	},
	`SI-P03-G8`: [4]string{
		`AAGTACTC`,
		`CTTGGAGA`,
		`GGAACTCT`,
		`TCCCTGAG`,
	},
	`SI-P03-G5`: [4]string{
		`ATGAAGTA`,
		`CGCCGAAC`,
		`GAAGCTCG`,
		`TCTTTCGT`,
	},
	`SI-P03-G4`: [4]string{
		`AGCTTCTC`,
		`CCTGCGGT`,
		`GTACAACG`,
		`TAGAGTAA`,
	},
	`SI-P03-G7`: [4]string{
		`ATTACCGG`,
		`CAGTAATT`,
		`GCCGGTAA`,
		`TGACTGCC`,
	},
	`SI-P03-G6`: [4]string{
		`AGCACTGG`,
		`CATTACAC`,
		`GTGCGACA`,
		`TCAGTGTT`,
	},
	`SI-P03-G1`: [4]string{
		`ATGCGATT`,
		`CATATGCG`,
		`GGATACGA`,
		`TCCGCTAC`,
	},
	`SI-P03-G3`: [4]string{
		`ATGTCCAG`,
		`CGACGTCA`,
		`GCTATAGC`,
		`TACGAGTT`,
	},
	`SI-P03-G2`: [4]string{
		`ATAACCTA`,
		`CGGTGAGC`,
		`GATCTTAT`,
		`TCCGAGCG`,
	},
	`SI-3A-E9`: [4]string{
		`AGTAAGCA`,
		`CCGGTAAT`,
		`GTATCTTC`,
		`TACCGCGG`,
	},
	`SI-3A-E8`: [4]string{
		`AGCCTATG`,
		`CTAACGCA`,
		`GCTTACAT`,
		`TAGGGTGC`,
	},
	`SI-P02-H2`: [4]string{
		`TAATGACC`,
		`ATGCCTTA`,
		`GCCGAGAT`,
		`CGTATCGG`,
	},
	`SI-3A-E1`: [4]string{
		`ACGAAAGC`,
		`CGCCCGTA`,
		`GTTTGCCT`,
		`TAAGTTAG`,
	},
	`SI-P03-E12`: [4]string{
		`ACGCGGAA`,
		`CGCTATCC`,
		`GTTGCATG`,
		`TAAATCGT`,
	},
	`SI-P03-E11`: [4]string{
		`ATCGCCAT`,
		`CATAAAGG`,
		`GGGTTTCC`,
		`TCACGGTA`,
	},
	`SI-P03-E10`: [4]string{
		`ATTGTTTC`,
		`CGCAGGAG`,
		`GCACCAGT`,
		`TAGTACCA`,
	},
	`SI-3A-E5`: [4]string{
		`ATCCAAGG`,
		`CCGTTGAA`,
		`GGAAGCTC`,
		`TATGCTCT`,
	},
	`SI-3A-E4`: [4]string{
		`AGCTGACG`,
		`CCGGTGTC`,
		`GTAAACAT`,
		`TATCCTGA`,
	},
	`SI-3A-E7`: [4]string{
		`AAGACGTG`,
		`CCATGTGT`,
		`GTTCACAA`,
		`TGCGTACC`,
	},
	`SI-3A-E6`: [4]string{
		`ATTGAAAC`,
		`CAGCCCGA`,
		`GCCATTTG`,
		`TGATGGCT`,
	},
	`SI-P01-E9`: [4]string{
		`AGTAAGCA`,
		`TACCGCGG`,
		`CCGGTAAT`,
		`GTATCTTC`,
	},
	`SI-P01-E8`: [4]string{
		`GCTTACAT`,
		`TAGGGTGC`,
		`AGCCTATG`,
		`CTAACGCA`,
	},
	`SI-P2-F1`: [4]string{
		`GTTGCAGC`,
		`TGGAATTA`,
		`CAATGGAG`,
		`ACCCTCCT`,
	},
	`SI-P2-F6`: [4]string{
		`CGGAGCAC`,
		`GACCTATT`,
		`ACTTAGGA`,
		`TTAGCTCG`,
	},
	`SI-P2-F7`: [4]string{
		`CGTGCAGA`,
		`AACAAGAT`,
		`TCGCTTCG`,
		`GTATGCTC`,
	},
	`SI-P2-F4`: [4]string{
		`CCCAATAG`,
		`GTGTCGCT`,
		`AGAGTCGC`,
		`TATCGATA`,
	},
	`SI-P2-F5`: [4]string{
		`GACTACGT`,
		`CTAGCGAG`,
		`TCTATATC`,
		`AGGCGTCA`,
	},
	`SI-P01-E1`: [4]string{
		`CGCCCGTA`,
		`GTTTGCCT`,
		`TAAGTTAG`,
		`ACGAAAGC`,
	},
	`SI-P01-E3`: [4]string{
		`TCTGCAGG`,
		`CGGCTCCA`,
		`AACAAGTC`,
		`GTATGTAT`,
	},
	`SI-P01-E2`: [4]string{
		`TCATCAAG`,
		`GTTGGTCC`,
		`AGGCTGGT`,
		`CACAACTA`,
	},
	`SI-P01-E5`: [4]string{
		`CCGTTGAA`,
		`TATGCTCT`,
		`ATCCAAGG`,
		`GGAAGCTC`,
	},
	`SI-P01-E4`: [4]string{
		`GTAAACAT`,
		`TATCCTGA`,
		`AGCTGACG`,
		`CCGGTGTC`,
	},
	`SI-P01-E7`: [4]string{
		`AAGACGTG`,
		`CCATGTGT`,
		`GTTCACAA`,
		`TGCGTACC`,
	},
	`SI-P01-E6`: [4]string{
		`TGATGGCT`,
		`GCCATTTG`,
		`ATTGAAAC`,
		`CAGCCCGA`,
	},
	`SI-P01-F12`: [4]string{
		`AATTGAAC`,
		`TGGACCCT`,
		`CCAGTGGA`,
		`GTCCATTG`,
	},
	`SI-P2-H9`: [4]string{
		`ACACTGTT`,
		`CAGGATGG`,
		`GGCTGAAC`,
		`TTTACCCA`,
	},
	`SI-P01-F10`: [4]string{
		`TCGACAAT`,
		`GAATACTG`,
		`ATTCGTGC`,
		`CGCGTGCA`,
	},
	`SI-P01-F11`: [4]string{
		`GAACCCGG`,
		`AGCAGTTA`,
		`TCGTAGAT`,
		`CTTGTACC`,
	},
	`SI-P2-F3`: [4]string{
		`TTCAGGTG`,
		`ACGGACAT`,
		`GATCTTGA`,
		`CGATCACC`,
	},
	`SI-P2-H1`: [4]string{
		`GTATGTCA`,
		`TGTCAGAC`,
		`CACGTCGG`,
		`ACGACATT`,
	},
	`SI-P2-H2`: [4]string{
		`TAATGACC`,
		`ATGCCTTA`,
		`GCCGAGAT`,
		`CGTATCGG`,
	},
	`SI-P2-H3`: [4]string{
		`CCAAGATG`,
		`AGGCCCGA`,
		`TACGTGAC`,
		`GTTTATCT`,
	},
	`SI-P2-H4`: [4]string{
		`GCCATTCC`,
		`CAAGAATT`,
		`TTGCCGGA`,
		`AGTTGCAG`,
	},
	`SI-P2-H5`: [4]string{
		`CCACTACA`,
		`GATTCTGG`,
		`TGCGGCTT`,
		`ATGAAGAC`,
	},
	`SI-P2-H6`: [4]string{
		`TAGGATAA`,
		`CCTTTGTC`,
		`GTACGCGG`,
		`AGCACACT`,
	},
	`SI-P2-D9`: [4]string{
		`AGGAGATG`,
		`GATGTGGT`,
		`CTACATCC`,
		`TCCTCCAA`,
	},
	`SI-P02-G2`: [4]string{
		`TGATTCTA`,
		`ACTAGGAG`,
		`CAGCCACT`,
		`GTCGATGC`,
	},
	`SI-P02-G3`: [4]string{
		`CCTCATTC`,
		`AGCATCCG`,
		`GTGGCAAT`,
		`TAATGGGA`,
	},
	`SI-P02-G1`: [4]string{
		`ATGAATCT`,
		`GATCTCAG`,
		`CCAGGAGC`,
		`TGCTCGTA`,
	},
	`SI-GA-F8`: [4]string{
		`CATGAACA`,
		`TCACTCGC`,
		`AGCTGGAT`,
		`GTGACTTG`,
	},
	`SI-GA-F9`: [4]string{
		`CAAGCTCC`,
		`GTTCACTG`,
		`TCGTGAAA`,
		`AGCATGGT`,
	},
	`SI-P02-B2`: [4]string{
		`TACTCTTC`,
		`CCTGTGCG`,
		`GGACACGT`,
		`ATGAGAAA`,
	},
	`SI-P2-C8`: [4]string{
		`GTTGAGAA`,
		`AGATCTGG`,
		`TCGATACT`,
		`CACCGCTC`,
	},
	`SI-P01-E11`: [4]string{
		`ATCGCCAT`,
		`TCACGGTA`,
		`GGGTTTCC`,
		`CATAAAGG`,
	},
	`SI-P01-E10`: [4]string{
		`GCACCAGT`,
		`CGCAGGAG`,
		`TAGTACCA`,
		`ATTGTTTC`,
	},
	`SI-GA-F6`: [4]string{
		`CGGAGCAC`,
		`GACCTATT`,
		`ACTTAGGA`,
		`TTAGCTCG`,
	},
	`SI-P01-E12`: [4]string{
		`CGCTATCC`,
		`ACGCGGAA`,
		`TAAATCGT`,
		`GTTGCATG`,
	},
	`SI-GA-F1`: [4]string{
		`GTTGCAGC`,
		`TGGAATTA`,
		`CAATGGAG`,
		`ACCCTCCT`,
	},
	`SI-GA-F2`: [4]string{
		`TTTACATG`,
		`CGCGATAC`,
		`ACGCGGGT`,
		`GAATTCCA`,
	},
	`SI-GA-F3`: [4]string{
		`TTCAGGTG`,
		`ACGGACAT`,
		`GATCTTGA`,
		`CGATCACC`,
	},
	`SI-P02-H12`: [4]string{
		`GACAGCAT`,
		`TTTGTACA`,
		`AGGCCGTG`,
		`CCATATGC`,
	},
	`SI-GA-G12`: [4]string{
		`ATTCTAAG`,
		`CCCGATTA`,
		`TGGAGGCT`,
		`GAATCCGC`,
	},
	`220030`: [4]string{
		`ATCTAGCT`,
		`GAGCGTAC`,
		`TCAGCCTG`,
		`CGTATAGA`,
	},
	`SI-P2-F12`: [4]string{
		`TGATGCAT`,
		`GCTACTGA`,
		`CACCTGCC`,
		`ATGGAATG`,
	},
	`SI-P02-D12`: [4]string{
		`GCACAATG`,
		`CTTGGTAC`,
		`TGCACCGT`,
		`AAGTTGCA`,
	},
	`SI-P2-A3`: [4]string{
		`CAGTACTG`,
		`AGTAGTCT`,
		`GCAGTAGA`,
		`TTCCCGAC`,
	},
	`SI-P2-A2`: [4]string{
		`TTTCATGA`,
		`ACGTCCCT`,
		`CGCATGTG`,
		`GAAGGAAC`,
	},
	`SI-P2-A1`: [4]string{
		`GGTTTACT`,
		`CTAAACGG`,
		`TCGGCGTC`,
		`AACCGTAA`,
	},
	`SI-P02-G4`: [4]string{
		`GCGATGTG`,
		`AGATACAA`,
		`TTTCCACT`,
		`CACGGTGC`,
	},
	`SI-P2-A7`: [4]string{
		`ACAGAGGT`,
		`TATAGTTG`,
		`CGGTCCCA`,
		`GTCCTAAC`,
	},
	`SI-P2-A6`: [4]string{
		`CGCTATGT`,
		`GCTGTCCA`,
		`TTGAGATC`,
		`AAACCGAG`,
	},
	`SI-P2-A5`: [4]string{
		`CTAGGTGA`,
		`TCGTTCAG`,
		`AGCCAATT`,
		`GATACGCC`,
	},
	`SI-GA-A8`: [4]string{
		`GCATCTCC`,
		`TGTAAGGT`,
		`CTGCGATG`,
		`AACGTCAA`,
	},
	`SI-P2-H12`: [4]string{
		`GACAGCAT`,
		`TTTGTACA`,
		`AGGCCGTG`,
		`CCATATGC`,
	},
	`SI-P02-B8`: [4]string{
		`AAAGTGCT`,
		`GCTACCTG`,
		`TGCTGTAA`,
		`CTGCAAGC`,
	},
	`SI-P2-A9`: [4]string{
		`TCTTAAAG`,
		`CGAGGCTC`,
		`GTCCTTCT`,
		`AAGACGGA`,
	},
	`SI-P2-A8`: [4]string{
		`GCATCTCC`,
		`TGTAAGGT`,
		`CTGCGATG`,
		`AACGTCAA`,
	},
	`SI-P03-E3`: [4]string{
		`AACAAGTC`,
		`CGGCTCCA`,
		`GTATGTAT`,
		`TCTGCAGG`,
	},
	`SI-008`: [4]string{
		`GGCAGAAA`,
		`ACGGTTCT`,
		`CATTCGTC`,
		`TTACACGG`,
	},
	`SI-P03-E1`: [4]string{
		`ACGAAAGC`,
		`CGCCCGTA`,
		`GTTTGCCT`,
		`TAAGTTAG`,
	},
	`SI-P02-F2`: [4]string{
		`TTTACATG`,
		`CGCGATAC`,
		`ACGCGGGT`,
		`GAATTCCA`,
	},
	`SI-P03-E7`: [4]string{
		`AAGACGTG`,
		`CCATGTGT`,
		`GTTCACAA`,
		`TGCGTACC`,
	},
	`SI-P03-E6`: [4]string{
		`ATTGAAAC`,
		`CAGCCCGA`,
		`GCCATTTG`,
		`TGATGGCT`,
	},
	`SI-P03-E5`: [4]string{
		`ATCCAAGG`,
		`CCGTTGAA`,
		`GGAAGCTC`,
		`TATGCTCT`,
	},
	`SI-P03-E4`: [4]string{
		`AGCTGACG`,
		`CCGGTGTC`,
		`GTAAACAT`,
		`TATCCTGA`,
	},
	`SI-001`: [4]string{
		`TCGCCATA`,
		`GTATACAC`,
		`AATGGTGG`,
		`CGCATGCT`,
	},
	`SI-003`: [4]string{
		`TGACGTCG`,
		`CTTGTGTA`,
		`ACGACCGT`,
		`GACTAAAC`,
	},
	`SI-002`: [4]string{
		`TATCCTCG`,
		`GCGAGGTC`,
		`CGCTTCAA`,
		`ATAGAAGT`,
	},
	`SI-005`: [4]string{
		`CCGTTCCC`,
		`ATACAGTT`,
		`TGTAGTAA`,
		`GACGCAGG`,
	},
	`SI-004`: [4]string{
		`ATCTAGCT`,
		`GAGCGTAC`,
		`TCAGCCTG`,
		`CGTATAGA`,
	},
	`SI-007`: [4]string{
		`CTGCCTTG`,
		`ACTAGCCC`,
		`GGCTAGAT`,
		`TAAGTAGA`,
	},
	`SI-006`: [4]string{
		`TCAATTGG`,
		`AGTTAGAA`,
		`GAGCGCTT`,
		`CTCGCACC`,
	},
	`SI-P02-G5`: [4]string{
		`GAGCAAGA`,
		`TCTGTGAT`,
		`CGCAGTTC`,
		`ATATCCCG`,
	},
	`SI-3A-C9`: [4]string{
		`AGATCGGT`,
		`CATCGTCG`,
		`GTCATATA`,
		`TCGGACAC`,
	},
	`SI-3A-C8`: [4]string{
		`AGCTCGAG`,
		`CAGGAAGA`,
		`GCACGTTT`,
		`TTTATCCC`,
	},
	`SI-3A-C7`: [4]string{
		`ACACCGGG`,
		`CATAATCC`,
		`GGCGGAAT`,
		`TTGTTCTA`,
	},
	`SI-3A-C6`: [4]string{
		`ACTCAGAC`,
		`CGCTCAGG`,
		`GAGGTTTA`,
		`TTAAGCCT`,
	},
	`SI-3A-C5`: [4]string{
		`ATGCATTC`,
		`CACTGACT`,
		`GGTACGGG`,
		`TCAGTCAA`,
	},
	`SI-3A-C4`: [4]string{
		`ACATTGGC`,
		`CTTAGTCA`,
		`GAGCCCAT`,
		`TGCGAATG`,
	},
	`SI-3A-C3`: [4]string{
		`ACGTTACA`,
		`CGTAGGTT`,
		`GACGACGG`,
		`TTACCTAC`,
	},
	`SI-3A-C2`: [4]string{
		`AATCACTA`,
		`CCGAGAAC`,
		`GTAGTGCG`,
		`TGCTCTGT`,
	},
	`SI-3A-C1`: [4]string{
		`AGACTTTC`,
		`CCGAGGCA`,
		`GATGCAGT`,
		`TTCTACAG`,
	},
	`SI-P02-A3`: [4]string{
		`CAGTACTG`,
		`AGTAGTCT`,
		`GCAGTAGA`,
		`TTCCCGAC`,
	},
	`220033`: [4]string{
		`CTGCCTTG`,
		`ACTAGCCC`,
		`GGCTAGAT`,
		`TAAGTAGA`,
	},
	`SI-P01-G9`: [4]string{
		`TTGACTTC`,
		`GCCGAAGT`,
		`CAATGGCA`,
		`AGTCTCAG`,
	},
	`SI-P01-G8`: [4]string{
		`AAGTACTC`,
		`GGAACTCT`,
		`TCCCTGAG`,
		`CTTGGAGA`,
	},
	`SI-P01-G7`: [4]string{
		`GCCGGTAA`,
		`TGACTGCC`,
		`ATTACCGG`,
		`CAGTAATT`,
	},
	`SI-P01-G6`: [4]string{
		`GTGCGACA`,
		`TCAGTGTT`,
		`AGCACTGG`,
		`CATTACAC`,
	},
	`SI-P01-G5`: [4]string{
		`ATGAAGTA`,
		`GAAGCTCG`,
		`TCTTTCGT`,
		`CGCCGAAC`,
	},
	`SI-P01-G4`: [4]string{
		`CCTGCGGT`,
		`GTACAACG`,
		`AGCTTCTC`,
		`TAGAGTAA`,
	},
	`SI-P01-G3`: [4]string{
		`TACGAGTT`,
		`ATGTCCAG`,
		`GCTATAGC`,
		`CGACGTCA`,
	},
	`SI-P01-G2`: [4]string{
		`CGGTGAGC`,
		`ATAACCTA`,
		`TCCGAGCG`,
		`GATCTTAT`,
	},
	`SI-P01-G1`: [4]string{
		`CATATGCG`,
		`ATGCGATT`,
		`TCCGCTAC`,
		`GGATACGA`,
	},
	`SI-3A-E2`: [4]string{
		`AGGCTGGT`,
		`CACAACTA`,
		`GTTGGTCC`,
		`TCATCAAG`,
	},
	`SI-P03-G11`: [4]string{
		`AGGGCGTT`,
		`CTATACGC`,
		`GCTCGTCA`,
		`TACATAAG`,
	},
	`SI-P03-G10`: [4]string{
		`ATACTGAG`,
		`CGGAGACT`,
		`GATGCCTC`,
		`TCCTATGA`,
	},
	`SI-P03-G12`: [4]string{
		`ACCCGCAC`,
		`CATGCGTA`,
		`GTGATAGT`,
		`TGATATCG`,
	},
	`SI-3A-C12`: [4]string{
		`ATCCGGCA`,
		`CCGTTATG`,
		`GGTAATGT`,
		`TAAGCCAC`,
	},
	`SI-3A-C11`: [4]string{
		`ACCGAACA`,
		`CGACTCTT`,
		`GTTTGTGG`,
		`TAGACGAC`,
	},
	`SI-3A-C10`: [4]string{
		`ATCTGATC`,
		`CGTGCTAA`,
		`GAGAAGGG`,
		`TCACTCCT`,
	},
	`SI-P02-E8`: [4]string{
		`ATAGTTAC`,
		`TGCTGAGT`,
		`CCTACGTA`,
		`GAGCACCG`,
	},
	`SI-P02-E9`: [4]string{
		`TTGTTTCC`,
		`GGAGGAGG`,
		`CCTAACAA`,
		`AACCCGTT`,
	},
	`SI-P02-A10`: [4]string{
		`GAAACCCT`,
		`TTTCTGTC`,
		`CCGTGTGA`,
		`AGCGAAAG`,
	},
	`SI-P02-D8`: [4]string{
		`GCAACAAA`,
		`TAGTTGTC`,
		`CGCCATCG`,
		`ATTGGCGT`,
	},
	`SI-P02-E1`: [4]string{
		`TGGTAAAC`,
		`GAAAGGGT`,
		`ACTGCTCG`,
		`CTCCTCTA`,
	},
	`SI-P2-E12`: [4]string{
		`ACCGGCTC`,
		`GAGTTAGT`,
		`CGTCCTAG`,
		`TTAAAGCA`,
	},
	`SI-P2-E11`: [4]string{
		`AAGCGCTG`,
		`CGTTTGAT`,
		`GTAGCACA`,
		`TCCAATGC`,
	},
	`220034`: [4]string{
		`GGCAGAAA`,
		`ACGGTTCT`,
		`CATTCGTC`,
		`TTACACGG`,
	},
	`SI-P02-E4`: [4]string{
		`TTCGCCCT`,
		`GGATGGGC`,
		`AATCAATG`,
		`CCGATTAA`,
	},
	`SI-P02-E2`: [4]string{
		`GTGGTACC`,
		`TACTATAG`,
		`ACAAGGTA`,
		`CGTCCCGT`,
	},
	`SI-P02-E6`: [4]string{
		`CTGCGGCT`,
		`GACTCAAA`,
		`AGAAACTC`,
		`TCTGTTGG`,
	},
	`SI-P02-E7`: [4]string{
		`CACGCCTT`,
		`GTATATAG`,
		`TCTCGGGC`,
		`AGGATACA`,
	},
	`SI-GA-D2`: [4]string{
		`TAACAAGG`,
		`GGTTCCTC`,
		`ATCATGCA`,
		`CCGGGTAT`,
	},
	`SI-GA-D3`: [4]string{
		`ACATTACT`,
		`TTTGGGTA`,
		`CAGCCCAC`,
		`GGCAATGG`,
	},
	`SI-GA-D1`: [4]string{
		`CACTCGGA`,
		`GCTGAATT`,
		`TGAAGTAC`,
		`ATGCTCCG`,
	},
	`SI-GA-D6`: [4]string{
		`CATGCGAT`,
		`TGATATTC`,
		`GTGATCGA`,
		`ACCCGACG`,
	},
	`SI-GA-D7`: [4]string{
		`ATTTGCTA`,
		`TAGACACC`,
		`CCACAGGG`,
		`GGCGTTAT`,
	},
	`SI-GA-D4`: [4]string{
		`CCCTAACA`,
		`ATTCCGAT`,
		`TGGATTGC`,
		`GAAGGCTG`,
	},
	`SI-GA-D5`: [4]string{
		`CTCGTCAC`,
		`GATCAGCA`,
		`ACAACAGG`,
		`TGGTGTTT`,
	},
	`SI-GA-D8`: [4]string{
		`GCAACAAA`,
		`TAGTTGTC`,
		`CGCCATCG`,
		`ATTGGCGT`,
	},
	`SI-GA-D9`: [4]string{
		`AGGAGATG`,
		`GATGTGGT`,
		`CTACATCC`,
		`TCCTCCAA`,
	},
	`SI-P02-E5`: [4]string{
		`CATTAGCG`,
		`TTCGCTGA`,
		`ACAAGAAT`,
		`GGGCTCTC`,
	},
	`SI-3A-H8`: [4]string{
		`AAGAGCGG`,
		`CTTGTTAT`,
		`GGCCCATC`,
		`TCATAGCA`,
	},
	`SI-3A-H9`: [4]string{
		`ACCTGCCA`,
		`CTTCATAC`,
		`GGAATATG`,
		`TAGGCGGT`,
	},
	`SI-3A-H2`: [4]string{
		`AACGGTCA`,
		`CCGAACTC`,
		`GGTCCAAG`,
		`TTATTGGT`,
	},
	`SI-3A-H3`: [4]string{
		`ACACCTAA`,
		`CGTTTGGG`,
		`GACAAACC`,
		`TTGGGCTT`,
	},
	`SI-3A-H1`: [4]string{
		`AAACTCAT`,
		`CGGGAGTA`,
		`GTCACAGG`,
		`TCTTGTCC`,
	},
	`SI-3A-H6`: [4]string{
		`AAGCATAA`,
		`CCCATCGC`,
		`GGTTGATG`,
		`TTAGCGCT`,
	},
	`SI-3A-H7`: [4]string{
		`AACGGGTG`,
		`CTAATTCT`,
		`GCTTCAAC`,
		`TGGCACGA`,
	},
	`SI-3A-H4`: [4]string{
		`ACTGGAGC`,
		`CGGTCGTG`,
		`GAAATCAA`,
		`TTCCATCT`,
	},
	`SI-3A-H5`: [4]string{
		`ATAGTATG`,
		`CCGCGTCT`,
		`GGCTCCAC`,
		`TATAAGGA`,
	},
	`SI-3A-D10`: [4]string{
		`AGATAACA`,
		`CTTATTTG`,
		`GCGGGCAT`,
		`TACCCGGC`,
	},
	`SI-3A-D11`: [4]string{
		`ATATGAGA`,
		`CACCTCAG`,
		`GCTACTTC`,
		`TGGGAGCT`,
	},
	`SI-3A-D12`: [4]string{
		`AGAAACGT`,
		`CACTCAAC`,
		`GCTGTGTA`,
		`TTGCGTCG`,
	},
	`SI-P02-B12`: [4]string{
		`TACCACCA`,
		`CTAAGTTT`,
		`GGGTCAAG`,
		`ACTGTGGC`,
	},
	`SI-P01-C12`: [4]string{
		`TAAGCCAC`,
		`CCGTTATG`,
		`GGTAATGT`,
		`ATCCGGCA`,
	},
	`SI-P01-C11`: [4]string{
		`GTTTGTGG`,
		`ACCGAACA`,
		`TAGACGAC`,
		`CGACTCTT`,
	},
	`SI-P01-C10`: [4]string{
		`CGTGCTAA`,
		`TCACTCCT`,
		`ATCTGATC`,
		`GAGAAGGG`,
	},
	`SI-GA-C12`: [4]string{
		`TCTCGTTT`,
		`GGCTAGCG`,
		`ATGACCGC`,
		`CAAGTAAA`,
	},
	`SI-GA-C11`: [4]string{
		`GAGGATCT`,
		`AGACCATA`,
		`TCCTGCGC`,
		`CTTATGAG`,
	},
	`SI-GA-C10`: [4]string{
		`TCTCAGTG`,
		`GAGACTAT`,
		`CGCTTAGC`,
		`ATAGGCCA`,
	},
	`SI-P02-G9`: [4]string{
		`TAGGACGT`,
		`ATCCCACA`,
		`GGAATGTC`,
		`CCTTGTAG`,
	},
	`SI-P2-F8`: [4]string{
		`CATGAACA`,
		`TCACTCGC`,
		`AGCTGGAT`,
		`GTGACTTG`,
	},
	`SI-3A-A5`: [4]string{
		`ATTGGGAA`,
		`CAGTCTGG`,
		`GGCATACT`,
		`TCACACTC`,
	},
	`SI-3A-A4`: [4]string{
		`AGAACGCC`,
		`CATGGCAG`,
		`GTCTTTGA`,
		`TCGCAATT`,
	},
	`SI-3A-A7`: [4]string{
		`AGGTCATA`,
		`CTCATCAT`,
		`GCTGAGGG`,
		`TAACGTCC`,
	},
	`SI-3A-A6`: [4]string{
		`ACGGGACT`,
		`CTTTCGAC`,
		`GAACATGA`,
		`TGCATCTG`,
	},
	`SI-3A-A1`: [4]string{
		`AAACGGCG`,
		`CCTACCAT`,
		`GGCGTTTC`,
		`TTGTAAGA`,
	},
	`SI-3A-A3`: [4]string{
		`AAAGCATA`,
		`CTGCAGCC`,
		`GCCTTTAT`,
		`TGTAGCGG`,
	},
	`SI-3A-A2`: [4]string{
		`AGCCCTTT`,
		`CAAGTCCA`,
		`GTGAGAAG`,
		`TCTTAGGC`,
	},
	`SI-3A-A11`: [4]string{
		`ACCAGTCC`,
		`CTTTCCTT`,
		`GGACAGGG`,
		`TAGGTAAA`,
	},
	`SI-P2-G6`: [4]string{
		`CTGACGCG`,
		`GGTCGTAC`,
		`TCCTTCTT`,
		`AAAGAAGA`,
	},
	`SI-P03-D12`: [4]string{
		`AGAAACGT`,
		`CACTCAAC`,
		`GCTGTGTA`,
		`TTGCGTCG`,
	},
	`SI-3A-A8`: [4]string{
		`ATGATACG`,
		`CCACAGAA`,
		`GACTGTTC`,
		`TGTGCCGT`,
	},
	`SI-P03-D10`: [4]string{
		`AGATAACA`,
		`CTTATTTG`,
		`GCGGGCAT`,
		`TACCCGGC`,
	},
	`SI-P03-D11`: [4]string{
		`ATATGAGA`,
		`CACCTCAG`,
		`GCTACTTC`,
		`TGGGAGCT`,
	},
	`SI-P01-A5`: [4]string{
		`CAGTCTGG`,
		`TCACACTC`,
		`ATTGGGAA`,
		`GGCATACT`,
	},
	`SI-P01-A4`: [4]string{
		`CATGGCAG`,
		`AGAACGCC`,
		`GTCTTTGA`,
		`TCGCAATT`,
	},
	`SI-P01-A7`: [4]string{
		`CTCATCAT`,
		`TAACGTCC`,
		`AGGTCATA`,
		`GCTGAGGG`,
	},
	`SI-P01-A6`: [4]string{
		`CTTTCGAC`,
		`ACGGGACT`,
		`TGCATCTG`,
		`GAACATGA`,
	},
	`SI-P01-A1`: [4]string{
		`TTGTAAGA`,
		`GGCGTTTC`,
		`CCTACCAT`,
		`AAACGGCG`,
	},
	`SI-P01-A3`: [4]string{
		`AAAGCATA`,
		`GCCTTTAT`,
		`CTGCAGCC`,
		`TGTAGCGG`,
	},
	`SI-P01-A2`: [4]string{
		`AGCCCTTT`,
		`TCTTAGGC`,
		`GTGAGAAG`,
		`CAAGTCCA`,
	},
	`SI-GA-D10`: [4]string{
		`CAATACCC`,
		`TGTCTATG`,
		`ACCACGAA`,
		`GTGGGTGT`,
	},
	`SI-GA-D11`: [4]string{
		`CTTTGCGG`,
		`TGCACAAA`,
		`AAGCAGTC`,
		`GCAGTTCT`,
	},
	`SI-GA-D12`: [4]string{
		`GCACAATG`,
		`CTTGGTAC`,
		`TGCACCGT`,
		`AAGTTGCA`,
	},
	`SI-3A-A12`: [4]string{
		`ACTACTGT`,
		`CGGGAACG`,
		`GACCTCTC`,
		`TTATGGAA`,
	},
	`SI-P01-A9`: [4]string{
		`GAGTGCGT`,
		`CTCCAACA`,
		`ACAACTTG`,
		`TGTGTGAC`,
	},
	`SI-P01-A8`: [4]string{
		`GACTGTTC`,
		`ATGATACG`,
		`CCACAGAA`,
		`TGTGCCGT`,
	},
	`SI-P02-C7`: [4]string{
		`GTCTCTCG`,
		`AATCTCTC`,
		`CGGAGGGA`,
		`TCAGAAAT`,
	},
	`SI-P02-D10`: [4]string{
		`CAATACCC`,
		`TGTCTATG`,
		`ACCACGAA`,
		`GTGGGTGT`,
	},
	`SI-P02-C11`: [4]string{
		`GAGGATCT`,
		`AGACCATA`,
		`TCCTGCGC`,
		`CTTATGAG`,
	},
	`SI-P01-H8`: [4]string{
		`AAGAGCGG`,
		`TCATAGCA`,
		`GGCCCATC`,
		`CTTGTTAT`,
	},
	`SI-P01-H9`: [4]string{
		`GGAATATG`,
		`ACCTGCCA`,
		`CTTCATAC`,
		`TAGGCGGT`,
	},
	`SI-P01-H6`: [4]string{
		`AAGCATAA`,
		`CCCATCGC`,
		`TTAGCGCT`,
		`GGTTGATG`,
	},
	`SI-P01-H7`: [4]string{
		`TGGCACGA`,
		`AACGGGTG`,
		`CTAATTCT`,
		`GCTTCAAC`,
	},
	`SI-P01-H4`: [4]string{
		`TTCCATCT`,
		`ACTGGAGC`,
		`CGGTCGTG`,
		`GAAATCAA`,
	},
	`SI-P01-H5`: [4]string{
		`ATAGTATG`,
		`TATAAGGA`,
		`GGCTCCAC`,
		`CCGCGTCT`,
	},
	`SI-P01-H2`: [4]string{
		`CCGAACTC`,
		`AACGGTCA`,
		`TTATTGGT`,
		`GGTCCAAG`,
	},
	`SI-P01-H3`: [4]string{
		`TTGGGCTT`,
		`GACAAACC`,
		`ACACCTAA`,
		`CGTTTGGG`,
	},
	`SI-P01-H1`: [4]string{
		`TCTTGTCC`,
		`CGGGAGTA`,
		`GTCACAGG`,
		`AAACTCAT`,
	},
	`SI-P03-B2`: [4]string{
		`AAGTTGAT`,
		`CCCACCCA`,
		`GGTCGAGC`,
		`TTAGATTG`,
	},
	`SI-P03-B3`: [4]string{
		`ATTGGACG`,
		`CAGCTTAC`,
		`GGCAAGGA`,
		`TCATCCTT`,
	},
	`SI-P03-B1`: [4]string{
		`AGGCTACC`,
		`CTAGCTGT`,
		`GCCAACAA`,
		`TATTGGTG`,
	},
	`SI-P03-B6`: [4]string{
		`AACGCGAA`,
		`CTATTTGG`,
		`GCGCACCT`,
		`TGTAGATC`,
	},
	`SI-P03-B7`: [4]string{
		`AGGGATGA`,
		`CTTCTGTT`,
		`GAATGCAC`,
		`TCCACACG`,
	},
	`SI-P03-B4`: [4]string{
		`AGGGACTG`,
		`CCTCTAAC`,
		`GACAGGCT`,
		`TTATCTGA`,
	},
	`SI-P03-B5`: [4]string{
		`ATCGTACT`,
		`CATCAGTG`,
		`GGGACTAC`,
		`TCATGCGA`,
	},
	`220031`: [4]string{
		`CCGTTCCC`,
		`ATACAGTT`,
		`TGTAGTAA`,
		`GACGCAGG`,
	},
	`SI-P03-B8`: [4]string{
		`ACGTTCAC`,
		`CAAGGTCT`,
		`GTTAAGTG`,
		`TGCCCAGA`,
	},
	`SI-P03-B9`: [4]string{
		`AAGCGTGT`,
		`CTTGACCG`,
		`GCCACGTA`,
		`TGATTAAC`,
	},
	`SI-P01-D10`: [4]string{
		`CTTATTTG`,
		`GCGGGCAT`,
		`AGATAACA`,
		`TACCCGGC`,
	},
	`SI-P01-D11`: [4]string{
		`GCTACTTC`,
		`CACCTCAG`,
		`ATATGAGA`,
		`TGGGAGCT`,
	},
	`SI-P01-D12`: [4]string{
		`GCTGTGTA`,
		`AGAAACGT`,
		`CACTCAAC`,
		`TTGCGTCG`,
	},
	`SI-P2-C9`: [4]string{
		`GCGCAGAA`,
		`ATCTTACC`,
		`TATGGTGT`,
		`CGAACCTG`,
	},
	`SI-3A-F1`: [4]string{
		`ATCGCTCC`,
		`CCGTACAG`,
		`GATAGGTA`,
		`TGACTAGT`,
	},
	`SI-3A-F2`: [4]string{
		`ATGGTTAG`,
		`CATTGATA`,
		`GCAAACGC`,
		`TGCCCGCT`,
	},
	`SI-3A-F3`: [4]string{
		`AGTCTGTA`,
		`CAGAATAG`,
		`GCCTCCGT`,
		`TTAGGACC`,
	},
	`SI-3A-F4`: [4]string{
		`AACGACAC`,
		`CGTCCTCT`,
		`GCATGATA`,
		`TTGATGGG`,
	},
	`SI-3A-F5`: [4]string{
		`AACACAGC`,
		`CGGTTTAG`,
		`GTACGGCT`,
		`TCTGACTA`,
	},
	`SI-3A-F6`: [4]string{
		`ATGCCGGC`,
		`CCTAATTA`,
		`GACTTCCT`,
		`TGAGGAAG`,
	},
	`SI-3A-F7`: [4]string{
		`ACCCGAGA`,
		`CAAACTTT`,
		`GGTTAGAC`,
		`TTGGTCCG`,
	},
	`SI-3A-F8`: [4]string{
		`AGTTGGGA`,
		`CCAGAAAG`,
		`GTGCCCTC`,
		`TACATTCT`,
	},
	`SI-3A-F9`: [4]string{
		`AGTTAGTT`,
		`CACGCACG`,
		`GTACTTAA`,
		`TCGAGCGC`,
	},
	`SI-P2-C3`: [4]string{
		`TCAGCCGT`,
		`CAGAGGCC`,
		`GGTCAATA`,
		`ATCTTTAG`,
	},
	`SI-P2-C2`: [4]string{
		`CCTAGACC`,
		`ATCTCTGT`,
		`TAGCTCTA`,
		`GGAGAGAG`,
	},
	`SI-P2-C5`: [4]string{
		`CGACTTGA`,
		`TACAGACT`,
		`ATTGCGTG`,
		`GCGTACAC`,
	},
	`SI-P2-C4`: [4]string{
		`ACAATTCA`,
		`TGCGCAGC`,
		`CATCACTT`,
		`GTGTGGAG`,
	},
	`SI-P2-C7`: [4]string{
		`GTCTCTCG`,
		`AATCTCTC`,
		`CGGAGGGA`,
		`TCAGAAAT`,
	},
	`SI-P2-C6`: [4]string{
		`ATTACTTC`,
		`TGCGAACT`,
		`GCATTCGG`,
		`CAGCGGAA`,
	},
	`SI-GA-H8`: [4]string{
		`TTGTTGAT`,
		`GCTCAACC`,
		`CAAAGTGG`,
		`AGCGCCTA`,
	},
	`SI-GA-H9`: [4]string{
		`ACACTGTT`,
		`CAGGATGG`,
		`GGCTGAAC`,
		`TTTACCCA`,
	},
	`SI-GA-H6`: [4]string{
		`TAGGATAA`,
		`CCTTTGTC`,
		`GTACGCGG`,
		`AGCACACT`,
	},
	`SI-GA-H7`: [4]string{
		`AGCTATCA`,
		`CATATAAC`,
		`TCAGGGTG`,
		`GTGCCCGT`,
	},
	`SI-GA-H4`: [4]string{
		`GCCATTCC`,
		`CAAGAATT`,
		`TTGCCGGA`,
		`AGTTGCAG`,
	},
	`SI-GA-H5`: [4]string{
		`CCACTACA`,
		`GATTCTGG`,
		`TGCGGCTT`,
		`ATGAAGAC`,
	},
	`SI-GA-H2`: [4]string{
		`TAATGACC`,
		`ATGCCTTA`,
		`GCCGAGAT`,
		`CGTATCGG`,
	},
	`SI-GA-H3`: [4]string{
		`CCAAGATG`,
		`AGGCCCGA`,
		`TACGTGAC`,
		`GTTTATCT`,
	},
	`SI-GA-H1`: [4]string{
		`GTATGTCA`,
		`TGTCAGAC`,
		`CACGTCGG`,
		`ACGACATT`,
	},
	`SI-P02-H8`: [4]string{
		`TTGTTGAT`,
		`GCTCAACC`,
		`CAAAGTGG`,
		`AGCGCCTA`,
	},
	`SI-P02-H5`: [4]string{
		`CCACTACA`,
		`GATTCTGG`,
		`TGCGGCTT`,
		`ATGAAGAC`,
	},
	`SI-P02-C2`: [4]string{
		`CCTAGACC`,
		`ATCTCTGT`,
		`TAGCTCTA`,
		`GGAGAGAG`,
	},
	`SI-P2-H8`: [4]string{
		`TTGTTGAT`,
		`GCTCAACC`,
		`CAAAGTGG`,
		`AGCGCCTA`,
	},
	`SI-P01-C9`: [4]string{
		`AGATCGGT`,
		`CATCGTCG`,
		`GTCATATA`,
		`TCGGACAC`,
	},
	`SI-P01-C8`: [4]string{
		`TTTATCCC`,
		`GCACGTTT`,
		`CAGGAAGA`,
		`AGCTCGAG`,
	},
	`SI-P2-A12`: [4]string{
		`AGTGGAAC`,
		`GTCTCCTT`,
		`TCACATCA`,
		`CAGATGGG`,
	},
	`SI-P2-A11`: [4]string{
		`GTCCGGTC`,
		`AAGATCAT`,
		`CCTGAAGG`,
		`TGATCTCA`,
	},
	`SI-P2-A10`: [4]string{
		`GAAACCCT`,
		`TTTCTGTC`,
		`CCGTGTGA`,
		`AGCGAAAG`,
	},
	`SI-P01-C3`: [4]string{
		`ACGTTACA`,
		`TTACCTAC`,
		`GACGACGG`,
		`CGTAGGTT`,
	},
	`SI-P01-C2`: [4]string{
		`CCGAGAAC`,
		`TGCTCTGT`,
		`GTAGTGCG`,
		`AATCACTA`,
	},
	`SI-P01-C1`: [4]string{
		`GATGCAGT`,
		`AGACTTTC`,
		`TTCTACAG`,
		`CCGAGGCA`,
	},
	`SI-P01-C7`: [4]string{
		`GGCGGAAT`,
		`ACACCGGG`,
		`CATAATCC`,
		`TTGTTCTA`,
	},
	`SI-P01-C6`: [4]string{
		`CGCTCAGG`,
		`GAGGTTTA`,
		`ACTCAGAC`,
		`TTAAGCCT`,
	},
	`SI-P01-C5`: [4]string{
		`TCAGTCAA`,
		`CACTGACT`,
		`ATGCATTC`,
		`GGTACGGG`,
	},
	`SI-P01-C4`: [4]string{
		`ACATTGGC`,
		`GAGCCCAT`,
		`CTTAGTCA`,
		`TGCGAATG`,
	},
	`SI-GA-C3`: [4]string{
		`TCAGCCGT`,
		`CAGAGGCC`,
		`GGTCAATA`,
		`ATCTTTAG`,
	},
	`SI-GA-C2`: [4]string{
		`CCTAGACC`,
		`ATCTCTGT`,
		`TAGCTCTA`,
		`GGAGAGAG`,
	},
	`SI-GA-C1`: [4]string{
		`CCACTTAT`,
		`AACTGGCG`,
		`TTGGCATA`,
		`GGTAACGC`,
	},
	`SI-GA-C7`: [4]string{
		`GTCTCTCG`,
		`AATCTCTC`,
		`CGGAGGGA`,
		`TCAGAAAT`,
	},
	`SI-GA-C6`: [4]string{
		`ATTACTTC`,
		`TGCGAACT`,
		`GCATTCGG`,
		`CAGCGGAA`,
	},
	`SI-GA-C5`: [4]string{
		`CGACTTGA`,
		`TACAGACT`,
		`ATTGCGTG`,
		`GCGTACAC`,
	},
	`SI-GA-C4`: [4]string{
		`ACAATTCA`,
		`TGCGCAGC`,
		`CATCACTT`,
		`GTGTGGAG`,
	},
	`SI-GA-C9`: [4]string{
		`GCGCAGAA`,
		`ATCTTACC`,
		`TATGGTGT`,
		`CGAACCTG`,
	},
	`SI-GA-C8`: [4]string{
		`GTTGAGAA`,
		`AGATCTGG`,
		`TCGATACT`,
		`CACCGCTC`,
	},
	`SI-P02-C3`: [4]string{
		`TCAGCCGT`,
		`CAGAGGCC`,
		`GGTCAATA`,
		`ATCTTTAG`,
	},
	`SI-P02-H1`: [4]string{
		`GTATGTCA`,
		`TGTCAGAC`,
		`CACGTCGG`,
		`ACGACATT`,
	},
	`SI-T2-3`: [4]string{
		`GCTGATAT`,
		`TGCCGAGC`,
		`AAATTGCG`,
		`CTGACCTA`,
	},
	`SI-P02-F1`: [4]string{
		`GTTGCAGC`,
		`TGGAATTA`,
		`CAATGGAG`,
		`ACCCTCCT`,
	},
	`SI-P02-B11`: [4]string{
		`GTTCCTCA`,
		`AGGTACGC`,
		`TAAGTATG`,
		`CCCAGGAT`,
	},
	`SI-P02-B10`: [4]string{
		`ACCGTATG`,
		`GATTAGAT`,
		`CTGACTGA`,
		`TGACGCCC`,
	},
	`SI-T2-2`: [4]string{
		`GGGTCGAA`,
		`ATCCGCCC`,
		`TCTATAGT`,
		`CAAGATTG`,
	},
	`SI-P02-G12`: [4]string{
		`ATTCTAAG`,
		`CCCGATTA`,
		`TGGAGGCT`,
		`GAATCCGC`,
	},
	`SI-P02-H7`: [4]string{
		`AGCTATCA`,
		`CATATAAC`,
		`TCAGGGTG`,
		`GTGCCCGT`,
	},
	`SI-P02-H6`: [4]string{
		`TAGGATAA`,
		`CCTTTGTC`,
		`GTACGCGG`,
		`AGCACACT`,
	},
	`SI-P02-A4`: [4]string{
		`TATGATTC`,
		`CCCACAGT`,
		`ATGCTGAA`,
		`GGATGCCG`,
	},
	`SI-P02-A5`: [4]string{
		`CTAGGTGA`,
		`TCGTTCAG`,
		`AGCCAATT`,
		`GATACGCC`,
	},
	`SI-P02-A6`: [4]string{
		`CGCTATGT`,
		`GCTGTCCA`,
		`TTGAGATC`,
		`AAACCGAG`,
	},
	`SI-P02-A7`: [4]string{
		`ACAGAGGT`,
		`TATAGTTG`,
		`CGGTCCCA`,
		`GTCCTAAC`,
	},
	`SI-GA-F12`: [4]string{
		`TGATGCAT`,
		`GCTACTGA`,
		`CACCTGCC`,
		`ATGGAATG`,
	},
	`SI-P02-A1`: [4]string{
		`GGTTTACT`,
		`CTAAACGG`,
		`TCGGCGTC`,
		`AACCGTAA`,
	},
	`SI-GA-F10`: [4]string{
		`GCTTGGCT`,
		`AAACAAAC`,
		`CGGGCTTA`,
		`TTCATCGG`,
	},
	`SI-GA-F11`: [4]string{
		`GCGAGAGT`,
		`TACGTTCA`,
		`AGTCCCAC`,
		`CTATAGTG`,
	},
	`SI-3A-E11`: [4]string{
		`ATCGCCAT`,
		`CATAAAGG`,
		`GGGTTTCC`,
		`TCACGGTA`,
	},
	`SI-3A-E10`: [4]string{
		`ATTGTTTC`,
		`CGCAGGAG`,
		`GCACCAGT`,
		`TAGTACCA`,
	},
	`SI-3A-E12`: [4]string{
		`ACGCGGAA`,
		`CGCTATCC`,
		`GTTGCATG`,
		`TAAATCGT`,
	},
	`SI-P02-A8`: [4]string{
		`GCATCTCC`,
		`TGTAAGGT`,
		`CTGCGATG`,
		`AACGTCAA`,
	},
	`SI-P02-A9`: [4]string{
		`TCTTAAAG`,
		`CGAGGCTC`,
		`GTCCTTCT`,
		`AAGACGGA`,
	},
	`SI-P02-G11`: [4]string{
		`TTATCGTT`,
		`AGCAGAGC`,
		`CATCTCCA`,
		`GCGGATAG`,
	},
	`SI-GA-E5`: [4]string{
		`CATTAGCG`,
		`TTCGCTGA`,
		`ACAAGAAT`,
		`GGGCTCTC`,
	},
	`SI-P2-G9`: [4]string{
		`TAGGACGT`,
		`ATCCCACA`,
		`GGAATGTC`,
		`CCTTGTAG`,
	},
	`SI-P2-C11`: [4]string{
		`GAGGATCT`,
		`AGACCATA`,
		`TCCTGCGC`,
		`CTTATGAG`,
	},
	`SI-P2-C10`: [4]string{
		`TCTCAGTG`,
		`GAGACTAT`,
		`CGCTTAGC`,
		`ATAGGCCA`,
	},
	`SI-P2-C12`: [4]string{
		`TCTCGTTT`,
		`GGCTAGCG`,
		`ATGACCGC`,
		`CAAGTAAA`,
	},
	`SI-GA-H10`: [4]string{
		`GTAATTGC`,
		`AGTCGCTT`,
		`CACGAGAA`,
		`TCGTCACG`,
	},
	`SI-GA-H11`: [4]string{
		`GGCGAGTA`,
		`ACTTCTAT`,
		`CAAATACG`,
		`TTGCGCGC`,
	},
	`SI-GA-H12`: [4]string{
		`GACAGCAT`,
		`TTTGTACA`,
		`AGGCCGTG`,
		`CCATATGC`,
	},
	`SI-3A-D6`: [4]string{
		`ATGCCAAA`,
		`CCTTATCG`,
		`GAAGTCTT`,
		`TGCAGGGC`,
	},
	`SI-3A-D7`: [4]string{
		`AACTTAGA`,
		`CCGGATCC`,
		`GGTCGCAT`,
		`TTAACGTG`,
	},
	`SI-3A-D4`: [4]string{
		`AAATCGTC`,
		`CTTCGAAT`,
		`GCGATCGG`,
		`TGCGATCA`,
	},
	`SI-3A-D5`: [4]string{
		`AGACGGAT`,
		`CCTTTAGA`,
		`GTCGACTC`,
		`TAGACTCG`,
	},
	`SI-3A-D2`: [4]string{
		`ACATTCCG`,
		`CTGCGGTA`,
		`GACACAAT`,
		`TGTGATGC`,
	},
	`SI-3A-D3`: [4]string{
		`ACTTCACT`,
		`CGAAGTTG`,
		`GAGCACGC`,
		`TTCGTGAA`,
	},
	`SI-P2-E9`: [4]string{
		`TTGTTTCC`,
		`GGAGGAGG`,
		`CCTAACAA`,
		`AACCCGTT`,
	},
	`SI-3A-D1`: [4]string{
		`AGCTGCGT`,
		`CAACCATC`,
		`GTGGAGCA`,
		`TCTATTAG`,
	},
	`SI-P2-E7`: [4]string{
		`CACGCCTT`,
		`GTATATAG`,
		`TCTCGGGC`,
		`AGGATACA`,
	},
	`SI-P2-D8`: [4]string{
		`GCAACAAA`,
		`TAGTTGTC`,
		`CGCCATCG`,
		`ATTGGCGT`,
	},
	`SI-P2-E5`: [4]string{
		`CATTAGCG`,
		`TTCGCTGA`,
		`ACAAGAAT`,
		`GGGCTCTC`,
	},
	`SI-P2-E4`: [4]string{
		`TTCGCCCT`,
		`GGATGGGC`,
		`AATCAATG`,
		`CCGATTAA`,
	},
	`SI-P2-E3`: [4]string{
		`AGGTATTG`,
		`CTCCTAGT`,
		`TCAAGGCC`,
		`GATGCCAA`,
	},
	`SI-P2-E2`: [4]string{
		`GTGGTACC`,
		`TACTATAG`,
		`ACAAGGTA`,
		`CGTCCCGT`,
	},
	`SI-3A-D8`: [4]string{
		`AATCTTTG`,
		`CTCAAGAC`,
		`GGATGAGT`,
		`TCGGCCCA`,
	},
	`SI-3A-D9`: [4]string{
		`ACCTACTG`,
		`CAAGGGAC`,
		`GGGACACA`,
		`TTTCTTGT`,
	},
	`SI-P02-E3`: [4]string{
		`AGGTATTG`,
		`CTCCTAGT`,
		`TCAAGGCC`,
		`GATGCCAA`,
	},
	`SI-3A-F12`: [4]string{
		`AATTGAAC`,
		`CCAGTGGA`,
		`GTCCATTG`,
		`TGGACCCT`,
	},
	`SI-3A-F10`: [4]string{
		`ATTCGTGC`,
		`CGCGTGCA`,
		`GAATACTG`,
		`TCGACAAT`,
	},
	`SI-3A-F11`: [4]string{
		`AGCAGTTA`,
		`CTTGTACC`,
		`GAACCCGG`,
		`TCGTAGAT`,
	},
	`SI-P01-B12`: [4]string{
		`GAAAGACA`,
		`CGCTACAT`,
		`ACGCTTGG`,
		`TTTGCGTC`,
	},
	`SI-P02-D1`: [4]string{
		`CACTCGGA`,
		`GCTGAATT`,
		`TGAAGTAC`,
		`ATGCTCCG`,
	},
	`SI-P01-B10`: [4]string{
		`ACCATTAA`,
		`CTGGACGT`,
		`GAACGGTC`,
		`TGTTCACG`,
	},
	`SI-P01-B11`: [4]string{
		`TCCAGATA`,
		`GATTCGCT`,
		`CGACATAG`,
		`ATGGTCGC`,
	},
	`SI-P02-G6`: [4]string{
		`CTGACGCG`,
		`GGTCGTAC`,
		`TCCTTCTT`,
		`AAAGAAGA`,
	},
	`SI-P2-C1`: [4]string{
		`CCACTTAT`,
		`AACTGGCG`,
		`TTGGCATA`,
		`GGTAACGC`,
	},
	`SI-P2-D6`: [4]string{
		`CATGCGAT`,
		`TGATATTC`,
		`GTGATCGA`,
		`ACCCGACG`,
	},
	`SI-P02-G7`: [4]string{
		`GGTATGCA`,
		`CTCGAAAT`,
		`ACACCTTC`,
		`TAGTGCGG`,
	},
	`SI-GA-A9`: [4]string{
		`TCTTAAAG`,
		`CGAGGCTC`,
		`GTCCTTCT`,
		`AAGACGGA`,
	},
	`SI-GA-E7`: [4]string{
		`CACGCCTT`,
		`GTATATAG`,
		`TCTCGGGC`,
		`AGGATACA`,
	},
	`SI-P02-F3`: [4]string{
		`TTCAGGTG`,
		`ACGGACAT`,
		`GATCTTGA`,
		`CGATCACC`,
	},
	`SI-P2-D7`: [4]string{
		`ATTTGCTA`,
		`TAGACACC`,
		`CCACAGGG`,
		`GGCGTTAT`,
	},
	`SI-P02-F5`: [4]string{
		`GACTACGT`,
		`CTAGCGAG`,
		`TCTATATC`,
		`AGGCGTCA`,
	},
	`SI-P02-F4`: [4]string{
		`CCCAATAG`,
		`GTGTCGCT`,
		`AGAGTCGC`,
		`TATCGATA`,
	},
	`SI-P02-F7`: [4]string{
		`CGTGCAGA`,
		`AACAAGAT`,
		`TCGCTTCG`,
		`GTATGCTC`,
	},
	`SI-P02-F6`: [4]string{
		`CGGAGCAC`,
		`GACCTATT`,
		`ACTTAGGA`,
		`TTAGCTCG`,
	},
	`SI-GA-A1`: [4]string{
		`GGTTTACT`,
		`CTAAACGG`,
		`TCGGCGTC`,
		`AACCGTAA`,
	},
	`220032`: [4]string{
		`TCAATTGG`,
		`AGTTAGAA`,
		`GAGCGCTT`,
		`CTCGCACC`,
	},
	`SI-GA-A3`: [4]string{
		`CAGTACTG`,
		`AGTAGTCT`,
		`GCAGTAGA`,
		`TTCCCGAC`,
	},
	`SI-GA-A2`: [4]string{
		`TTTCATGA`,
		`ACGTCCCT`,
		`CGCATGTG`,
		`GAAGGAAC`,
	},
	`SI-GA-A5`: [4]string{
		`CTAGGTGA`,
		`TCGTTCAG`,
		`AGCCAATT`,
		`GATACGCC`,
	},
	`SI-GA-A4`: [4]string{
		`TATGATTC`,
		`CCCACAGT`,
		`ATGCTGAA`,
		`GGATGCCG`,
	},
	`SI-GA-A7`: [4]string{
		`ACAGAGGT`,
		`TATAGTTG`,
		`CGGTCCCA`,
		`GTCCTAAC`,
	},
	`SI-GA-A6`: [4]string{
		`CGCTATGT`,
		`GCTGTCCA`,
		`TTGAGATC`,
		`AAACCGAG`,
	},
	`SI-P2-F9`: [4]string{
		`CAAGCTCC`,
		`GTTCACTG`,
		`TCGTGAAA`,
		`AGCATGGT`,
	},
	`SI-GA-F4`: [4]string{
		`CCCAATAG`,
		`GTGTCGCT`,
		`AGAGTCGC`,
		`TATCGATA`,
	},
	`SI-P02-H10`: [4]string{
		`GTAATTGC`,
		`AGTCGCTT`,
		`CACGAGAA`,
		`TCGTCACG`,
	},
	`SI-GA-F5`: [4]string{
		`GACTACGT`,
		`CTAGCGAG`,
		`TCTATATC`,
		`AGGCGTCA`,
	},
	`SI-P03-F10`: [4]string{
		`ATTCGTGC`,
		`CGCGTGCA`,
		`GAATACTG`,
		`TCGACAAT`,
	},
	`SI-P03-F11`: [4]string{
		`AGCAGTTA`,
		`CTTGTACC`,
		`GAACCCGG`,
		`TCGTAGAT`,
	},
	`SI-P03-F12`: [4]string{
		`AATTGAAC`,
		`CCAGTGGA`,
		`GTCCATTG`,
		`TGGACCCT`,
	},
	`SI-GA-E11`: [4]string{
		`AAGCGCTG`,
		`CGTTTGAT`,
		`GTAGCACA`,
		`TCCAATGC`,
	},
	`SI-GA-E10`: [4]string{
		`AAATGTGC`,
		`GGGCAAAT`,
		`TCTATCCG`,
		`CTCGCGTA`,
	},
	`SI-P02-G8`: [4]string{
		`TATGAGCT`,
		`CCGATAGC`,
		`ATACCCAA`,
		`GGCTGTTG`,
	},
	`SI-GA-E12`: [4]string{
		`ACCGGCTC`,
		`GAGTTAGT`,
		`CGTCCTAG`,
		`TTAAAGCA`,
	},
	`SI-GA-F7`: [4]string{
		`CGTGCAGA`,
		`AACAAGAT`,
		`TCGCTTCG`,
		`GTATGCTC`,
	},
	`SI-P02-H11`: [4]string{
		`GGCGAGTA`,
		`ACTTCTAT`,
		`CAAATACG`,
		`TTGCGCGC`,
	},
	`SI-P01-A11`: [4]string{
		`CTTTCCTT`,
		`TAGGTAAA`,
		`ACCAGTCC`,
		`GGACAGGG`,
	},
	`SI-P01-A10`: [4]string{
		`ACAGCAAC`,
		`TTTCGCGA`,
		`CGCAATTT`,
		`GAGTTGCG`,
	},
	`SI-P01-A12`: [4]string{
		`TTATGGAA`,
		`ACTACTGT`,
		`CGGGAACG`,
		`GACCTCTC`,
	},
	`SI-3A-A10`: [4]string{
		`ACAGCAAC`,
		`CGCAATTT`,
		`GAGTTGCG`,
		`TTTCGCGA`,
	},
	`SI-P2-G7`: [4]string{
		`GGTATGCA`,
		`CTCGAAAT`,
		`ACACCTTC`,
		`TAGTGCGG`,
	},
	`SI-P03-F8`: [4]string{
		`AGTTGGGA`,
		`CCAGAAAG`,
		`GTGCCCTC`,
		`TACATTCT`,
	},
	`SI-P03-F9`: [4]string{
		`AGTTAGTT`,
		`CACGCACG`,
		`GTACTTAA`,
		`TCGAGCGC`,
	},
	`SI-P03-F6`: [4]string{
		`ATGCCGGC`,
		`CCTAATTA`,
		`GACTTCCT`,
		`TGAGGAAG`,
	},
	`SI-P03-F7`: [4]string{
		`ACCCGAGA`,
		`CAAACTTT`,
		`GGTTAGAC`,
		`TTGGTCCG`,
	},
	`SI-P03-F4`: [4]string{
		`AACGACAC`,
		`CGTCCTCT`,
		`GCATGATA`,
		`TTGATGGG`,
	},
	`SI-P03-F5`: [4]string{
		`AACACAGC`,
		`CGGTTTAG`,
		`GTACGGCT`,
		`TCTGACTA`,
	},
	`SI-P03-F2`: [4]string{
		`ATGGTTAG`,
		`CATTGATA`,
		`GCAAACGC`,
		`TGCCCGCT`,
	},
	`SI-P03-F3`: [4]string{
		`AGTCTGTA`,
		`CAGAATAG`,
		`GCCTCCGT`,
		`TTAGGACC`,
	},
	`SI-P03-F1`: [4]string{
		`ATCGCTCC`,
		`CCGTACAG`,
		`GATAGGTA`,
		`TGACTAGT`,
	},
	`SI-3A-B8`: [4]string{
		`ACGTTCAC`,
		`CAAGGTCT`,
		`GTTAAGTG`,
		`TGCCCAGA`,
	},
	`SI-3A-B9`: [4]string{
		`AAGCGTGT`,
		`CTTGACCG`,
		`GCCACGTA`,
		`TGATTAAC`,
	},
	`SI-3A-B4`: [4]string{
		`AGGGACTG`,
		`CCTCTAAC`,
		`GACAGGCT`,
		`TTATCTGA`,
	},
	`SI-3A-B5`: [4]string{
		`ATCGTACT`,
		`CATCAGTG`,
		`GGGACTAC`,
		`TCATGCGA`,
	},
	`SI-3A-B6`: [4]string{
		`AACGCGAA`,
		`CTATTTGG`,
		`GCGCACCT`,
		`TGTAGATC`,
	},
	`SI-3A-B7`: [4]string{
		`AGGGATGA`,
		`CTTCTGTT`,
		`GAATGCAC`,
		`TCCACACG`,
	},
	`SI-3A-B1`: [4]string{
		`AGGCTACC`,
		`CTAGCTGT`,
		`GCCAACAA`,
		`TATTGGTG`,
	},
	`SI-3A-B2`: [4]string{
		`AAGTTGAT`,
		`CCCACCCA`,
		`GGTCGAGC`,
		`TTAGATTG`,
	},
	`SI-3A-B3`: [4]string{
		`ATTGGACG`,
		`CAGCTTAC`,
		`GGCAAGGA`,
		`TCATCCTT`,
	},
	`SI-P2-G5`: [4]string{
		`GAGCAAGA`,
		`TCTGTGAT`,
		`CGCAGTTC`,
		`ATATCCCG`,
	},
	`SI-P2-G4`: [4]string{
		`GCGATGTG`,
		`AGATACAA`,
		`TTTCCACT`,
		`CACGGTGC`,
	},
	`SI-P01-D8`: [4]string{
		`AATCTTTG`,
		`GGATGAGT`,
		`CTCAAGAC`,
		`TCGGCCCA`,
	},
	`SI-P01-D9`: [4]string{
		`CAAGGGAC`,
		`ACCTACTG`,
		`GGGACACA`,
		`TTTCTTGT`,
	},
	`SI-P2-G1`: [4]string{
		`ATGAATCT`,
		`GATCTCAG`,
		`CCAGGAGC`,
		`TGCTCGTA`,
	},
	`SI-P03-A12`: [4]string{
		`ACTACTGT`,
		`CGGGAACG`,
		`GACCTCTC`,
		`TTATGGAA`,
	},
	`SI-P03-A11`: [4]string{
		`ACCAGTCC`,
		`CTTTCCTT`,
		`GGACAGGG`,
		`TAGGTAAA`,
	},
	`SI-P03-A10`: [4]string{
		`ACAGCAAC`,
		`CGCAATTT`,
		`GAGTTGCG`,
		`TTTCGCGA`,
	},
	`SI-P01-D2`: [4]string{
		`ACATTCCG`,
		`GACACAAT`,
		`CTGCGGTA`,
		`TGTGATGC`,
	},
	`SI-P01-D3`: [4]string{
		`GAGCACGC`,
		`CGAAGTTG`,
		`TTCGTGAA`,
		`ACTTCACT`,
	},
	`SI-P01-D1`: [4]string{
		`AGCTGCGT`,
		`GTGGAGCA`,
		`TCTATTAG`,
		`CAACCATC`,
	},
	`SI-P01-D6`: [4]string{
		`GAAGTCTT`,
		`TGCAGGGC`,
		`ATGCCAAA`,
		`CCTTATCG`,
	},
	`SI-P01-D7`: [4]string{
		`CCGGATCC`,
		`GGTCGCAT`,
		`TTAACGTG`,
		`AACTTAGA`,
	},
	`SI-P01-D4`: [4]string{
		`AAATCGTC`,
		`GCGATCGG`,
		`CTTCGAAT`,
		`TGCGATCA`,
	},
	`SI-P01-D5`: [4]string{
		`GTCGACTC`,
		`AGACGGAT`,
		`CCTTTAGA`,
		`TAGACTCG`,
	},
	`SI-3A-H10`: [4]string{
		`ATTTCAGC`,
		`CGAGTGAT`,
		`GACCGCCA`,
		`TCGAATTG`,
	},
	`SI-P02-H4`: [4]string{
		`GCCATTCC`,
		`CAAGAATT`,
		`TTGCCGGA`,
		`AGTTGCAG`,
	},
	`SI-P02-E11`: [4]string{
		`AAGCGCTG`,
		`CGTTTGAT`,
		`GTAGCACA`,
		`TCCAATGC`,
	},
	`SI-P2-G3`: [4]string{
		`CCTCATTC`,
		`AGCATCCG`,
		`GTGGCAAT`,
		`TAATGGGA`,
	},
	`SI-GA-E4`: [4]string{
		`TTCGCCCT`,
		`GGATGGGC`,
		`AATCAATG`,
		`CCGATTAA`,
	},
	`SI-P2-G2`: [4]string{
		`TGATTCTA`,
		`ACTAGGAG`,
		`CAGCCACT`,
		`GTCGATGC`,
	},
	`SI-3A-H12`: [4]string{
		`ACGAGTAG`,
		`CAATCCCT`,
		`GTCCAGGC`,
		`TGTGTATA`,
	},
	`SI-GA-E6`: [4]string{
		`CTGCGGCT`,
		`GACTCAAA`,
		`AGAAACTC`,
		`TCTGTTGG`,
	},
	`SI-P2-E10`: [4]string{
		`AAATGTGC`,
		`GGGCAAAT`,
		`TCTATCCG`,
		`CTCGCGTA`,
	},
	`SI-GA-E1`: [4]string{
		`TGGTAAAC`,
		`GAAAGGGT`,
		`ACTGCTCG`,
		`CTCCTCTA`,
	},
	`SI-P02-D7`: [4]string{
		`ATTTGCTA`,
		`TAGACACC`,
		`CCACAGGG`,
		`GGCGTTAT`,
	},
	`SI-P02-D6`: [4]string{
		`CATGCGAT`,
		`TGATATTC`,
		`GTGATCGA`,
		`ACCCGACG`,
	},
	`SI-P02-D5`: [4]string{
		`CTCGTCAC`,
		`GATCAGCA`,
		`ACAACAGG`,
		`TGGTGTTT`,
	},
	`SI-P02-D4`: [4]string{
		`CCCTAACA`,
		`ATTCCGAT`,
		`TGGATTGC`,
		`GAAGGCTG`,
	},
	`SI-P02-D3`: [4]string{
		`ACATTACT`,
		`TTTGGGTA`,
		`CAGCCCAC`,
		`GGCAATGG`,
	},
	`SI-GA-E3`: [4]string{
		`AGGTATTG`,
		`CTCCTAGT`,
		`TCAAGGCC`,
		`GATGCCAA`,
	},
	`SI-GA-G9`: [4]string{
		`TAGGACGT`,
		`ATCCCACA`,
		`GGAATGTC`,
		`CCTTGTAG`,
	},
	`SI-GA-G8`: [4]string{
		`TATGAGCT`,
		`CCGATAGC`,
		`ATACCCAA`,
		`GGCTGTTG`,
	},
	`SI-GA-G7`: [4]string{
		`GGTATGCA`,
		`CTCGAAAT`,
		`ACACCTTC`,
		`TAGTGCGG`,
	},
	`SI-GA-G6`: [4]string{
		`CTGACGCG`,
		`GGTCGTAC`,
		`TCCTTCTT`,
		`AAAGAAGA`,
	},
	`SI-GA-G5`: [4]string{
		`GAGCAAGA`,
		`TCTGTGAT`,
		`CGCAGTTC`,
		`ATATCCCG`,
	},
	`SI-P03-C6`: [4]string{
		`ACTCAGAC`,
		`CGCTCAGG`,
		`GAGGTTTA`,
		`TTAAGCCT`,
	},
	`SI-GA-G3`: [4]string{
		`CCTCATTC`,
		`AGCATCCG`,
		`GTGGCAAT`,
		`TAATGGGA`,
	},
	`SI-GA-G2`: [4]string{
		`TGATTCTA`,
		`ACTAGGAG`,
		`CAGCCACT`,
		`GTCGATGC`,
	},
	`SI-GA-G1`: [4]string{
		`ATGAATCT`,
		`GATCTCAG`,
		`CCAGGAGC`,
		`TGCTCGTA`,
	},
	`SI-P2-G8`: [4]string{
		`TATGAGCT`,
		`CCGATAGC`,
		`ATACCCAA`,
		`GGCTGTTG`,
	},
	`SI-GA-E2`: [4]string{
		`GTGGTACC`,
		`TACTATAG`,
		`ACAAGGTA`,
		`CGTCCCGT`,
	},
	`SI-P2-B6`: [4]string{
		`CGTTAATC`,
		`GCCACGCT`,
		`TTACTCAG`,
		`AAGGGTGA`,
	},
	`SI-P2-B7`: [4]string{
		`AAACCTCA`,
		`GCCTTGGT`,
		`CTGGACTC`,
		`TGTAGAAG`,
	},
	`SI-P2-B4`: [4]string{
		`ACTTCATA`,
		`GAGATGAC`,
		`TGCCGTGG`,
		`CTAGACCT`,
	},
	`SI-P2-B5`: [4]string{
		`AATAATGG`,
		`CCAGGGCA`,
		`TGCCTCAT`,
		`GTGTCATC`,
	},
	`SI-P2-B2`: [4]string{
		`TACTCTTC`,
		`CCTGTGCG`,
		`GGACACGT`,
		`ATGAGAAA`,
	},
	`SI-P2-B3`: [4]string{
		`GTGTATTA`,
		`TGTGCGGG`,
		`ACCATAAC`,
		`CAACGCCT`,
	},
	`SI-P2-B1`: [4]string{
		`GTAATCTT`,
		`TCCGGAAG`,
		`AGTTCGGC`,
		`CAGCATCA`,
	},
	`SI-P2-F10`: [4]string{
		`GCTTGGCT`,
		`AAACAAAC`,
		`CGGGCTTA`,
		`TTCATCGG`,
	},
	`SI-3A-A9`: [4]string{
		`ACAACTTG`,
		`CTCCAACA`,
		`GAGTGCGT`,
		`TGTGTGAC`,
	},
	`SI-GA-G11`: [4]string{
		`TTATCGTT`,
		`AGCAGAGC`,
		`CATCTCCA`,
		`GCGGATAG`,
	},
	`SI-GA-G10`: [4]string{
		`TCGCCAGC`,
		`AATGTTAG`,
		`CGATAGCT`,
		`GTCAGCTA`,
	},
	`SI-P2-B8`: [4]string{
		`AAAGTGCT`,
		`GCTACCTG`,
		`TGCTGTAA`,
		`CTGCAAGC`,
	},
	`SI-P2-B9`: [4]string{
		`CTGTAACT`,
		`TCTAGCGA`,
		`AGAGTGTG`,
		`GACCCTAC`,
	},
	`SI-P03-D4`: [4]string{
		`AAATCGTC`,
		`CTTCGAAT`,
		`GCGATCGG`,
		`TGCGATCA`,
	},
	`SI-P03-D5`: [4]string{
		`AGACGGAT`,
		`CCTTTAGA`,
		`GTCGACTC`,
		`TAGACTCG`,
	},
	`SI-P03-D6`: [4]string{
		`ATGCCAAA`,
		`CCTTATCG`,
		`GAAGTCTT`,
		`TGCAGGGC`,
	},
	`SI-P03-D7`: [4]string{
		`AACTTAGA`,
		`CCGGATCC`,
		`GGTCGCAT`,
		`TTAACGTG`,
	},
	`SI-P03-D1`: [4]string{
		`AGCTGCGT`,
		`CAACCATC`,
		`GTGGAGCA`,
		`TCTATTAG`,
	},
	`SI-P03-D2`: [4]string{
		`ACATTCCG`,
		`CTGCGGTA`,
		`GACACAAT`,
		`TGTGATGC`,
	},
	`SI-P03-D3`: [4]string{
		`ACTTCACT`,
		`CGAAGTTG`,
		`GAGCACGC`,
		`TTCGTGAA`,
	},
	`SI-P2-H11`: [4]string{
		`GGCGAGTA`,
		`ACTTCTAT`,
		`CAAATACG`,
		`TTGCGCGC`,
	},
	`SI-P03-D8`: [4]string{
		`AATCTTTG`,
		`CTCAAGAC`,
		`GGATGAGT`,
		`TCGGCCCA`,
	},
	`SI-P03-D9`: [4]string{
		`ACCTACTG`,
		`CAAGGGAC`,
		`GGGACACA`,
		`TTTCTTGT`,
	},
	`SI-P2-D12`: [4]string{
		`GCACAATG`,
		`CTTGGTAC`,
		`TGCACCGT`,
		`AAGTTGCA`,
	},
	`SI-P2-A4`: [4]string{
		`TATGATTC`,
		`CCCACAGT`,
		`ATGCTGAA`,
		`GGATGCCG`,
	},
	`SI-P2-F2`: [4]string{
		`TTTACATG`,
		`CGCGATAC`,
		`ACGCGGGT`,
		`GAATTCCA`,
	},
	`SI-P01-F1`: [4]string{
		`TGACTAGT`,
		`GATAGGTA`,
		`CCGTACAG`,
		`ATCGCTCC`,
	},
	`SI-P01-F2`: [4]string{
		`TGCCCGCT`,
		`GCAAACGC`,
		`CATTGATA`,
		`ATGGTTAG`,
	},
	`SI-P01-F3`: [4]string{
		`TTAGGACC`,
		`AGTCTGTA`,
		`GCCTCCGT`,
		`CAGAATAG`,
	},
	`SI-P01-F4`: [4]string{
		`GCATGATA`,
		`CGTCCTCT`,
		`AACGACAC`,
		`TTGATGGG`,
	},
	`SI-P01-F5`: [4]string{
		`TCTGACTA`,
		`GTACGGCT`,
		`CGGTTTAG`,
		`AACACAGC`,
	},
	`SI-P01-F6`: [4]string{
		`GACTTCCT`,
		`TGAGGAAG`,
		`ATGCCGGC`,
		`CCTAATTA`,
	},
	`SI-P01-F7`: [4]string{
		`GGTTAGAC`,
		`CAAACTTT`,
		`ACCCGAGA`,
		`TTGGTCCG`,
	},
	`SI-P01-F8`: [4]string{
		`AGTTGGGA`,
		`TACATTCT`,
		`CCAGAAAG`,
		`GTGCCCTC`,
	},
	`SI-P01-F9`: [4]string{
		`AGTTAGTT`,
		`GTACTTAA`,
		`CACGCACG`,
		`TCGAGCGC`,
	},
	`SI-P2-H10`: [4]string{
		`GTAATTGC`,
		`AGTCGCTT`,
		`CACGAGAA`,
		`TCGTCACG`,
	},
	`SI-P2-E1`: [4]string{
		`TGGTAAAC`,
		`GAAAGGGT`,
		`ACTGCTCG`,
		`CTCCTCTA`,
	},
	`SI-P03-C11`: [4]string{
		`ACCGAACA`,
		`CGACTCTT`,
		`GTTTGTGG`,
		`TAGACGAC`,
	},
	`SI-P03-C10`: [4]string{
		`ATCTGATC`,
		`CGTGCTAA`,
		`GAGAAGGG`,
		`TCACTCCT`,
	},
	`SI-T2-1`: [4]string{
		`GGGTGATC`,
		`TTACCGAT`,
		`AATGACGA`,
		`CCCATTCG`,
	},
	`SI-P03-C12`: [4]string{
		`ATCCGGCA`,
		`CCGTTATG`,
		`GGTAATGT`,
		`TAAGCCAC`,
	},
	`SI-T2-7`: [4]string{
		`AAATCTGT`,
		`GTCCAACC`,
		`TCTGGCTG`,
		`CGGATGAA`,
	},
	`SI-T2-6`: [4]string{
		`TATTGAGA`,
		`GTAGTCAG`,
		`CGCCATTC`,
		`ACGACGCT`,
	},
	`SI-T2-5`: [4]string{
		`GAATACAA`,
		`AGCATACC`,
		`TCGGGTTT`,
		`CTTCCGGG`,
	},
	`SI-T2-4`: [4]string{
		`ACTTCTGA`,
		`TTCATCTT`,
		`CGACGACG`,
		`GAGGAGAC`,
	},
	`SI-T2-8`: [4]string{
		`CCTTGAAC`,
		`GAAATCGG`,
		`TGGCCTCT`,
		`ATCGAGTA`,
	},
	`SI-P02-D11`: [4]string{
		`CTTTGCGG`,
		`TGCACAAA`,
		`AAGCAGTC`,
		`GCAGTTCT`,
	},
	`SI-P02-C10`: [4]string{
		`TCTCAGTG`,
		`GAGACTAT`,
		`CGCTTAGC`,
		`ATAGGCCA`,
	},
	`SI-P02-B9`: [4]string{
		`CTGTAACT`,
		`TCTAGCGA`,
		`AGAGTGTG`,
		`GACCCTAC`,
	},
	`SI-3A-G12`: [4]string{
		`ACCCGCAC`,
		`CATGCGTA`,
		`GTGATAGT`,
		`TGATATCG`,
	},
	`SI-3A-G11`: [4]string{
		`AGGGCGTT`,
		`CTATACGC`,
		`GCTCGTCA`,
		`TACATAAG`,
	},
	`SI-3A-G10`: [4]string{
		`ATACTGAG`,
		`CGGAGACT`,
		`GATGCCTC`,
		`TCCTATGA`,
	},
	`SI-P02-B5`: [4]string{
		`AATAATGG`,
		`CCAGGGCA`,
		`TGCCTCAT`,
		`GTGTCATC`,
	},
	`220028`: [4]string{
		`TATCCTCG`,
		`GCGAGGTC`,
		`CGCTTCAA`,
		`ATAGAAGT`,
	},
	`SI-P02-B7`: [4]string{
		`AAACCTCA`,
		`GCCTTGGT`,
		`CTGGACTC`,
		`TGTAGAAG`,
	},
	`SI-P02-B6`: [4]string{
		`CGTTAATC`,
		`GCCACGCT`,
		`TTACTCAG`,
		`AAGGGTGA`,
	},
	`SI-P02-B1`: [4]string{
		`GTAATCTT`,
		`TCCGGAAG`,
		`AGTTCGGC`,
		`CAGCATCA`,
	},
	`SI-P02-C12`: [4]string{
		`TCTCGTTT`,
		`GGCTAGCG`,
		`ATGACCGC`,
		`CAAGTAAA`,
	},
	`SI-P02-B3`: [4]string{
		`GTGTATTA`,
		`TGTGCGGG`,
		`ACCATAAC`,
		`CAACGCCT`,
	},
	`220029`: [4]string{
		`TGACGTCG`,
		`CTTGTGTA`,
		`ACGACCGT`,
		`GACTAAAC`,
	},
	`SI-P03-C1`: [4]string{
		`AGACTTTC`,
		`CCGAGGCA`,
		`GATGCAGT`,
		`TTCTACAG`,
	},
	`SI-3A-H11`: [4]string{
		`AGGATCGA`,
		`CACGATTC`,
		`GTATCGAG`,
		`TCTCGACT`,
	},
	`SI-P03-C3`: [4]string{
		`ACGTTACA`,
		`CGTAGGTT`,
		`GACGACGG`,
		`TTACCTAC`,
	},
	`SI-P03-C2`: [4]string{
		`AATCACTA`,
		`CCGAGAAC`,
		`GTAGTGCG`,
		`TGCTCTGT`,
	},
	`SI-P03-C5`: [4]string{
		`ATGCATTC`,
		`CACTGACT`,
		`GGTACGGG`,
		`TCAGTCAA`,
	},
	`SI-P03-C4`: [4]string{
		`ACATTGGC`,
		`CTTAGTCA`,
		`GAGCCCAT`,
		`TGCGAATG`,
	},
	`SI-P03-C7`: [4]string{
		`ACACCGGG`,
		`CATAATCC`,
		`GGCGGAAT`,
		`TTGTTCTA`,
	},
	`SI-P03-E2`: [4]string{
		`AGGCTGGT`,
		`CACAACTA`,
		`GTTGGTCC`,
		`TCATCAAG`,
	},
	`SI-P03-C9`: [4]string{
		`AGATCGGT`,
		`CATCGTCG`,
		`GTCATATA`,
		`TCGGACAC`,
	},
	`SI-P03-C8`: [4]string{
		`AGCTCGAG`,
		`CAGGAAGA`,
		`GCACGTTT`,
		`TTTATCCC`,
	},
	`SI-GA-E9`: [4]string{
		`TTGTTTCC`,
		`GGAGGAGG`,
		`CCTAACAA`,
		`AACCCGTT`,
	},
	`SI-GA-E8`: [4]string{
		`ATAGTTAC`,
		`TGCTGAGT`,
		`CCTACGTA`,
		`GAGCACCG`,
	},
	`SI-P01-H10`: [4]string{
		`GACCGCCA`,
		`TCGAATTG`,
		`ATTTCAGC`,
		`CGAGTGAT`,
	},
	`SI-P01-H11`: [4]string{
		`TCTCGACT`,
		`AGGATCGA`,
		`CACGATTC`,
		`GTATCGAG`,
	},
	`SI-P01-H12`: [4]string{
		`TGTGTATA`,
		`GTCCAGGC`,
		`CAATCCCT`,
		`ACGAGTAG`,
	},
}

const SAMPLE_INDEX_QUAL_TAG = `QT`
const SAMPLE_INDEX_TAG = `BC`
const SI_001 = [4]string{
	`TCGCCATA`,
	`GTATACAC`,
	`AATGGTGG`,
	`CGCATGCT`,
}
const SI_002 = [4]string{
	`TATCCTCG`,
	`GCGAGGTC`,
	`CGCTTCAA`,
	`ATAGAAGT`,
}
const SI_003 = [4]string{
	`TGACGTCG`,
	`CTTGTGTA`,
	`ACGACCGT`,
	`GACTAAAC`,
}
const SI_004 = [4]string{
	`ATCTAGCT`,
	`GAGCGTAC`,
	`TCAGCCTG`,
	`CGTATAGA`,
}
const SI_005 = [4]string{
	`CCGTTCCC`,
	`ATACAGTT`,
	`TGTAGTAA`,
	`GACGCAGG`,
}
const SI_006 = [4]string{
	`TCAATTGG`,
	`AGTTAGAA`,
	`GAGCGCTT`,
	`CTCGCACC`,
}
const SI_007 = [4]string{
	`CTGCCTTG`,
	`ACTAGCCC`,
	`GGCTAGAT`,
	`TAAGTAGA`,
}
const SI_008 = [4]string{
	`GGCAGAAA`,
	`ACGGTTCT`,
	`CATTCGTC`,
	`TTACACGG`,
}
const SI_3A_A1 = [4]string{
	`AAACGGCG`,
	`CCTACCAT`,
	`GGCGTTTC`,
	`TTGTAAGA`,
}
const SI_3A_A10 = [4]string{
	`ACAGCAAC`,
	`CGCAATTT`,
	`GAGTTGCG`,
	`TTTCGCGA`,
}
const SI_3A_A11 = [4]string{
	`ACCAGTCC`,
	`CTTTCCTT`,
	`GGACAGGG`,
	`TAGGTAAA`,
}
const SI_3A_A12 = [4]string{
	`ACTACTGT`,
	`CGGGAACG`,
	`GACCTCTC`,
	`TTATGGAA`,
}
const SI_3A_A2 = [4]string{
	`AGCCCTTT`,
	`CAAGTCCA`,
	`GTGAGAAG`,
	`TCTTAGGC`,
}
const SI_3A_A3 = [4]string{
	`AAAGCATA`,
	`CTGCAGCC`,
	`GCCTTTAT`,
	`TGTAGCGG`,
}
const SI_3A_A4 = [4]string{
	`AGAACGCC`,
	`CATGGCAG`,
	`GTCTTTGA`,
	`TCGCAATT`,
}
const SI_3A_A5 = [4]string{
	`ATTGGGAA`,
	`CAGTCTGG`,
	`GGCATACT`,
	`TCACACTC`,
}
const SI_3A_A6 = [4]string{
	`ACGGGACT`,
	`CTTTCGAC`,
	`GAACATGA`,
	`TGCATCTG`,
}
const SI_3A_A7 = [4]string{
	`AGGTCATA`,
	`CTCATCAT`,
	`GCTGAGGG`,
	`TAACGTCC`,
}
const SI_3A_A8 = [4]string{
	`ATGATACG`,
	`CCACAGAA`,
	`GACTGTTC`,
	`TGTGCCGT`,
}
const SI_3A_A9 = [4]string{
	`ACAACTTG`,
	`CTCCAACA`,
	`GAGTGCGT`,
	`TGTGTGAC`,
}
const SI_3A_B1 = [4]string{
	`AGGCTACC`,
	`CTAGCTGT`,
	`GCCAACAA`,
	`TATTGGTG`,
}
const SI_3A_B10 = [4]string{
	`ACCATTAA`,
	`CTGGACGT`,
	`GAACGGTC`,
	`TGTTCACG`,
}
const SI_3A_B11 = [4]string{
	`ATGGTCGC`,
	`CGACATAG`,
	`GATTCGCT`,
	`TCCAGATA`,
}
const SI_3A_B12 = [4]string{
	`ACGCTTGG`,
	`CGCTACAT`,
	`GAAAGACA`,
	`TTTGCGTC`,
}
const SI_3A_B2 = [4]string{
	`AAGTTGAT`,
	`CCCACCCA`,
	`GGTCGAGC`,
	`TTAGATTG`,
}
const SI_3A_B3 = [4]string{
	`ATTGGACG`,
	`CAGCTTAC`,
	`GGCAAGGA`,
	`TCATCCTT`,
}
const SI_3A_B4 = [4]string{
	`AGGGACTG`,
	`CCTCTAAC`,
	`GACAGGCT`,
	`TTATCTGA`,
}
const SI_3A_B5 = [4]string{
	`ATCGTACT`,
	`CATCAGTG`,
	`GGGACTAC`,
	`TCATGCGA`,
}
const SI_3A_B6 = [4]string{
	`AACGCGAA`,
	`CTATTTGG`,
	`GCGCACCT`,
	`TGTAGATC`,
}
const SI_3A_B7 = [4]string{
	`AGGGATGA`,
	`CTTCTGTT`,
	`GAATGCAC`,
	`TCCACACG`,
}
const SI_3A_B8 = [4]string{
	`ACGTTCAC`,
	`CAAGGTCT`,
	`GTTAAGTG`,
	`TGCCCAGA`,
}
const SI_3A_B9 = [4]string{
	`AAGCGTGT`,
	`CTTGACCG`,
	`GCCACGTA`,
	`TGATTAAC`,
}
const SI_3A_C1 = [4]string{
	`AGACTTTC`,
	`CCGAGGCA`,
	`GATGCAGT`,
	`TTCTACAG`,
}
const SI_3A_C10 = [4]string{
	`ATCTGATC`,
	`CGTGCTAA`,
	`GAGAAGGG`,
	`TCACTCCT`,
}
const SI_3A_C11 = [4]string{
	`ACCGAACA`,
	`CGACTCTT`,
	`GTTTGTGG`,
	`TAGACGAC`,
}
const SI_3A_C12 = [4]string{
	`ATCCGGCA`,
	`CCGTTATG`,
	`GGTAATGT`,
	`TAAGCCAC`,
}
const SI_3A_C2 = [4]string{
	`AATCACTA`,
	`CCGAGAAC`,
	`GTAGTGCG`,
	`TGCTCTGT`,
}
const SI_3A_C3 = [4]string{
	`ACGTTACA`,
	`CGTAGGTT`,
	`GACGACGG`,
	`TTACCTAC`,
}
const SI_3A_C4 = [4]string{
	`ACATTGGC`,
	`CTTAGTCA`,
	`GAGCCCAT`,
	`TGCGAATG`,
}
const SI_3A_C5 = [4]string{
	`ATGCATTC`,
	`CACTGACT`,
	`GGTACGGG`,
	`TCAGTCAA`,
}
const SI_3A_C6 = [4]string{
	`ACTCAGAC`,
	`CGCTCAGG`,
	`GAGGTTTA`,
	`TTAAGCCT`,
}
const SI_3A_C7 = [4]string{
	`ACACCGGG`,
	`CATAATCC`,
	`GGCGGAAT`,
	`TTGTTCTA`,
}
const SI_3A_C8 = [4]string{
	`AGCTCGAG`,
	`CAGGAAGA`,
	`GCACGTTT`,
	`TTTATCCC`,
}
const SI_3A_C9 = [4]string{
	`AGATCGGT`,
	`CATCGTCG`,
	`GTCATATA`,
	`TCGGACAC`,
}
const SI_3A_D1 = [4]string{
	`AGCTGCGT`,
	`CAACCATC`,
	`GTGGAGCA`,
	`TCTATTAG`,
}
const SI_3A_D10 = [4]string{
	`AGATAACA`,
	`CTTATTTG`,
	`GCGGGCAT`,
	`TACCCGGC`,
}
const SI_3A_D11 = [4]string{
	`ATATGAGA`,
	`CACCTCAG`,
	`GCTACTTC`,
	`TGGGAGCT`,
}
const SI_3A_D12 = [4]string{
	`AGAAACGT`,
	`CACTCAAC`,
	`GCTGTGTA`,
	`TTGCGTCG`,
}
const SI_3A_D2 = [4]string{
	`ACATTCCG`,
	`CTGCGGTA`,
	`GACACAAT`,
	`TGTGATGC`,
}
const SI_3A_D3 = [4]string{
	`ACTTCACT`,
	`CGAAGTTG`,
	`GAGCACGC`,
	`TTCGTGAA`,
}
const SI_3A_D4 = [4]string{
	`AAATCGTC`,
	`CTTCGAAT`,
	`GCGATCGG`,
	`TGCGATCA`,
}
const SI_3A_D5 = [4]string{
	`AGACGGAT`,
	`CCTTTAGA`,
	`GTCGACTC`,
	`TAGACTCG`,
}
const SI_3A_D6 = [4]string{
	`ATGCCAAA`,
	`CCTTATCG`,
	`GAAGTCTT`,
	`TGCAGGGC`,
}
const SI_3A_D7 = [4]string{
	`AACTTAGA`,
	`CCGGATCC`,
	`GGTCGCAT`,
	`TTAACGTG`,
}
const SI_3A_D8 = [4]string{
	`AATCTTTG`,
	`CTCAAGAC`,
	`GGATGAGT`,
	`TCGGCCCA`,
}
const SI_3A_D9 = [4]string{
	`ACCTACTG`,
	`CAAGGGAC`,
	`GGGACACA`,
	`TTTCTTGT`,
}
const SI_3A_E1 = [4]string{
	`ACGAAAGC`,
	`CGCCCGTA`,
	`GTTTGCCT`,
	`TAAGTTAG`,
}
const SI_3A_E10 = [4]string{
	`ATTGTTTC`,
	`CGCAGGAG`,
	`GCACCAGT`,
	`TAGTACCA`,
}
const SI_3A_E11 = [4]string{
	`ATCGCCAT`,
	`CATAAAGG`,
	`GGGTTTCC`,
	`TCACGGTA`,
}
const SI_3A_E12 = [4]string{
	`ACGCGGAA`,
	`CGCTATCC`,
	`GTTGCATG`,
	`TAAATCGT`,
}
const SI_3A_E2 = [4]string{
	`AGGCTGGT`,
	`CACAACTA`,
	`GTTGGTCC`,
	`TCATCAAG`,
}
const SI_3A_E3 = [4]string{
	`AACAAGTC`,
	`CGGCTCCA`,
	`GTATGTAT`,
	`TCTGCAGG`,
}
const SI_3A_E4 = [4]string{
	`AGCTGACG`,
	`CCGGTGTC`,
	`GTAAACAT`,
	`TATCCTGA`,
}
const SI_3A_E5 = [4]string{
	`ATCCAAGG`,
	`CCGTTGAA`,
	`GGAAGCTC`,
	`TATGCTCT`,
}
const SI_3A_E6 = [4]string{
	`ATTGAAAC`,
	`CAGCCCGA`,
	`GCCATTTG`,
	`TGATGGCT`,
}
const SI_3A_E7 = [4]string{
	`AAGACGTG`,
	`CCATGTGT`,
	`GTTCACAA`,
	`TGCGTACC`,
}
const SI_3A_E8 = [4]string{
	`AGCCTATG`,
	`CTAACGCA`,
	`GCTTACAT`,
	`TAGGGTGC`,
}
const SI_3A_E9 = [4]string{
	`AGTAAGCA`,
	`CCGGTAAT`,
	`GTATCTTC`,
	`TACCGCGG`,
}
const SI_3A_F1 = [4]string{
	`ATCGCTCC`,
	`CCGTACAG`,
	`GATAGGTA`,
	`TGACTAGT`,
}
const SI_3A_F10 = [4]string{
	`ATTCGTGC`,
	`CGCGTGCA`,
	`GAATACTG`,
	`TCGACAAT`,
}
const SI_3A_F11 = [4]string{
	`AGCAGTTA`,
	`CTTGTACC`,
	`GAACCCGG`,
	`TCGTAGAT`,
}
const SI_3A_F12 = [4]string{
	`AATTGAAC`,
	`CCAGTGGA`,
	`GTCCATTG`,
	`TGGACCCT`,
}
const SI_3A_F2 = [4]string{
	`ATGGTTAG`,
	`CATTGATA`,
	`GCAAACGC`,
	`TGCCCGCT`,
}
const SI_3A_F3 = [4]string{
	`AGTCTGTA`,
	`CAGAATAG`,
	`GCCTCCGT`,
	`TTAGGACC`,
}
const SI_3A_F4 = [4]string{
	`AACGACAC`,
	`CGTCCTCT`,
	`GCATGATA`,
	`TTGATGGG`,
}
const SI_3A_F5 = [4]string{
	`AACACAGC`,
	`CGGTTTAG`,
	`GTACGGCT`,
	`TCTGACTA`,
}
const SI_3A_F6 = [4]string{
	`ATGCCGGC`,
	`CCTAATTA`,
	`GACTTCCT`,
	`TGAGGAAG`,
}
const SI_3A_F7 = [4]string{
	`ACCCGAGA`,
	`CAAACTTT`,
	`GGTTAGAC`,
	`TTGGTCCG`,
}
const SI_3A_F8 = [4]string{
	`AGTTGGGA`,
	`CCAGAAAG`,
	`GTGCCCTC`,
	`TACATTCT`,
}
const SI_3A_F9 = [4]string{
	`AGTTAGTT`,
	`CACGCACG`,
	`GTACTTAA`,
	`TCGAGCGC`,
}
const SI_3A_G1 = [4]string{
	`ATGCGATT`,
	`CATATGCG`,
	`GGATACGA`,
	`TCCGCTAC`,
}
const SI_3A_G10 = [4]string{
	`ATACTGAG`,
	`CGGAGACT`,
	`GATGCCTC`,
	`TCCTATGA`,
}
const SI_3A_G11 = [4]string{
	`AGGGCGTT`,
	`CTATACGC`,
	`GCTCGTCA`,
	`TACATAAG`,
}
const SI_3A_G12 = [4]string{
	`ACCCGCAC`,
	`CATGCGTA`,
	`GTGATAGT`,
	`TGATATCG`,
}
const SI_3A_G2 = [4]string{
	`ATAACCTA`,
	`CGGTGAGC`,
	`GATCTTAT`,
	`TCCGAGCG`,
}
const SI_3A_G3 = [4]string{
	`ATGTCCAG`,
	`CGACGTCA`,
	`GCTATAGC`,
	`TACGAGTT`,
}
const SI_3A_G4 = [4]string{
	`AGCTTCTC`,
	`CCTGCGGT`,
	`GTACAACG`,
	`TAGAGTAA`,
}
const SI_3A_G5 = [4]string{
	`ATGAAGTA`,
	`CGCCGAAC`,
	`GAAGCTCG`,
	`TCTTTCGT`,
}
const SI_3A_G6 = [4]string{
	`AGCACTGG`,
	`CATTACAC`,
	`GTGCGACA`,
	`TCAGTGTT`,
}
const SI_3A_G7 = [4]string{
	`ATTACCGG`,
	`CAGTAATT`,
	`GCCGGTAA`,
	`TGACTGCC`,
}
const SI_3A_G8 = [4]string{
	`AAGTACTC`,
	`CTTGGAGA`,
	`GGAACTCT`,
	`TCCCTGAG`,
}
const SI_3A_G9 = [4]string{
	`AGTCTCAG`,
	`CAATGGCA`,
	`GCCGAAGT`,
	`TTGACTTC`,
}
const SI_3A_H1 = [4]string{
	`AAACTCAT`,
	`CGGGAGTA`,
	`GTCACAGG`,
	`TCTTGTCC`,
}
const SI_3A_H10 = [4]string{
	`ATTTCAGC`,
	`CGAGTGAT`,
	`GACCGCCA`,
	`TCGAATTG`,
}
const SI_3A_H11 = [4]string{
	`AGGATCGA`,
	`CACGATTC`,
	`GTATCGAG`,
	`TCTCGACT`,
}
const SI_3A_H12 = [4]string{
	`ACGAGTAG`,
	`CAATCCCT`,
	`GTCCAGGC`,
	`TGTGTATA`,
}
const SI_3A_H2 = [4]string{
	`AACGGTCA`,
	`CCGAACTC`,
	`GGTCCAAG`,
	`TTATTGGT`,
}
const SI_3A_H3 = [4]string{
	`ACACCTAA`,
	`CGTTTGGG`,
	`GACAAACC`,
	`TTGGGCTT`,
}
const SI_3A_H4 = [4]string{
	`ACTGGAGC`,
	`CGGTCGTG`,
	`GAAATCAA`,
	`TTCCATCT`,
}
const SI_3A_H5 = [4]string{
	`ATAGTATG`,
	`CCGCGTCT`,
	`GGCTCCAC`,
	`TATAAGGA`,
}
const SI_3A_H6 = [4]string{
	`AAGCATAA`,
	`CCCATCGC`,
	`GGTTGATG`,
	`TTAGCGCT`,
}
const SI_3A_H7 = [4]string{
	`AACGGGTG`,
	`CTAATTCT`,
	`GCTTCAAC`,
	`TGGCACGA`,
}
const SI_3A_H8 = [4]string{
	`AAGAGCGG`,
	`CTTGTTAT`,
	`GGCCCATC`,
	`TCATAGCA`,
}
const SI_3A_H9 = [4]string{
	`ACCTGCCA`,
	`CTTCATAC`,
	`GGAATATG`,
	`TAGGCGGT`,
}
const SI_GA_A1 = [4]string{
	`GGTTTACT`,
	`CTAAACGG`,
	`TCGGCGTC`,
	`AACCGTAA`,
}
const SI_GA_A10 = [4]string{
	`GAAACCCT`,
	`TTTCTGTC`,
	`CCGTGTGA`,
	`AGCGAAAG`,
}
const SI_GA_A11 = [4]string{
	`GTCCGGTC`,
	`AAGATCAT`,
	`CCTGAAGG`,
	`TGATCTCA`,
}
const SI_GA_A12 = [4]string{
	`AGTGGAAC`,
	`GTCTCCTT`,
	`TCACATCA`,
	`CAGATGGG`,
}
const SI_GA_A2 = [4]string{
	`TTTCATGA`,
	`ACGTCCCT`,
	`CGCATGTG`,
	`GAAGGAAC`,
}
const SI_GA_A3 = [4]string{
	`CAGTACTG`,
	`AGTAGTCT`,
	`GCAGTAGA`,
	`TTCCCGAC`,
}
const SI_GA_A4 = [4]string{
	`TATGATTC`,
	`CCCACAGT`,
	`ATGCTGAA`,
	`GGATGCCG`,
}
const SI_GA_A5 = [4]string{
	`CTAGGTGA`,
	`TCGTTCAG`,
	`AGCCAATT`,
	`GATACGCC`,
}
const SI_GA_A6 = [4]string{
	`CGCTATGT`,
	`GCTGTCCA`,
	`TTGAGATC`,
	`AAACCGAG`,
}
const SI_GA_A7 = [4]string{
	`ACAGAGGT`,
	`TATAGTTG`,
	`CGGTCCCA`,
	`GTCCTAAC`,
}
const SI_GA_A8 = [4]string{
	`GCATCTCC`,
	`TGTAAGGT`,
	`CTGCGATG`,
	`AACGTCAA`,
}
const SI_GA_A9 = [4]string{
	`TCTTAAAG`,
	`CGAGGCTC`,
	`GTCCTTCT`,
	`AAGACGGA`,
}
const SI_GA_B1 = [4]string{
	`GTAATCTT`,
	`TCCGGAAG`,
	`AGTTCGGC`,
	`CAGCATCA`,
}
const SI_GA_B10 = [4]string{
	`ACCGTATG`,
	`GATTAGAT`,
	`CTGACTGA`,
	`TGACGCCC`,
}
const SI_GA_B11 = [4]string{
	`GTTCCTCA`,
	`AGGTACGC`,
	`TAAGTATG`,
	`CCCAGGAT`,
}
const SI_GA_B12 = [4]string{
	`TACCACCA`,
	`CTAAGTTT`,
	`GGGTCAAG`,
	`ACTGTGGC`,
}
const SI_GA_B2 = [4]string{
	`TACTCTTC`,
	`CCTGTGCG`,
	`GGACACGT`,
	`ATGAGAAA`,
}
const SI_GA_B3 = [4]string{
	`GTGTATTA`,
	`TGTGCGGG`,
	`ACCATAAC`,
	`CAACGCCT`,
}
const SI_GA_B4 = [4]string{
	`ACTTCATA`,
	`GAGATGAC`,
	`TGCCGTGG`,
	`CTAGACCT`,
}
const SI_GA_B5 = [4]string{
	`AATAATGG`,
	`CCAGGGCA`,
	`TGCCTCAT`,
	`GTGTCATC`,
}
const SI_GA_B6 = [4]string{
	`CGTTAATC`,
	`GCCACGCT`,
	`TTACTCAG`,
	`AAGGGTGA`,
}
const SI_GA_B7 = [4]string{
	`AAACCTCA`,
	`GCCTTGGT`,
	`CTGGACTC`,
	`TGTAGAAG`,
}
const SI_GA_B8 = [4]string{
	`AAAGTGCT`,
	`GCTACCTG`,
	`TGCTGTAA`,
	`CTGCAAGC`,
}
const SI_GA_B9 = [4]string{
	`CTGTAACT`,
	`TCTAGCGA`,
	`AGAGTGTG`,
	`GACCCTAC`,
}
const SI_GA_C1 = [4]string{
	`CCACTTAT`,
	`AACTGGCG`,
	`TTGGCATA`,
	`GGTAACGC`,
}
const SI_GA_C10 = [4]string{
	`TCTCAGTG`,
	`GAGACTAT`,
	`CGCTTAGC`,
	`ATAGGCCA`,
}
const SI_GA_C11 = [4]string{
	`GAGGATCT`,
	`AGACCATA`,
	`TCCTGCGC`,
	`CTTATGAG`,
}
const SI_GA_C12 = [4]string{
	`TCTCGTTT`,
	`GGCTAGCG`,
	`ATGACCGC`,
	`CAAGTAAA`,
}
const SI_GA_C2 = [4]string{
	`CCTAGACC`,
	`ATCTCTGT`,
	`TAGCTCTA`,
	`GGAGAGAG`,
}
const SI_GA_C3 = [4]string{
	`TCAGCCGT`,
	`CAGAGGCC`,
	`GGTCAATA`,
	`ATCTTTAG`,
}
const SI_GA_C4 = [4]string{
	`ACAATTCA`,
	`TGCGCAGC`,
	`CATCACTT`,
	`GTGTGGAG`,
}
const SI_GA_C5 = [4]string{
	`CGACTTGA`,
	`TACAGACT`,
	`ATTGCGTG`,
	`GCGTACAC`,
}
const SI_GA_C6 = [4]string{
	`ATTACTTC`,
	`TGCGAACT`,
	`GCATTCGG`,
	`CAGCGGAA`,
}
const SI_GA_C7 = [4]string{
	`GTCTCTCG`,
	`AATCTCTC`,
	`CGGAGGGA`,
	`TCAGAAAT`,
}
const SI_GA_C8 = [4]string{
	`GTTGAGAA`,
	`AGATCTGG`,
	`TCGATACT`,
	`CACCGCTC`,
}
const SI_GA_C9 = [4]string{
	`GCGCAGAA`,
	`ATCTTACC`,
	`TATGGTGT`,
	`CGAACCTG`,
}
const SI_GA_D1 = [4]string{
	`CACTCGGA`,
	`GCTGAATT`,
	`TGAAGTAC`,
	`ATGCTCCG`,
}
const SI_GA_D10 = [4]string{
	`CAATACCC`,
	`TGTCTATG`,
	`ACCACGAA`,
	`GTGGGTGT`,
}
const SI_GA_D11 = [4]string{
	`CTTTGCGG`,
	`TGCACAAA`,
	`AAGCAGTC`,
	`GCAGTTCT`,
}
const SI_GA_D12 = [4]string{
	`GCACAATG`,
	`CTTGGTAC`,
	`TGCACCGT`,
	`AAGTTGCA`,
}
const SI_GA_D2 = [4]string{
	`TAACAAGG`,
	`GGTTCCTC`,
	`ATCATGCA`,
	`CCGGGTAT`,
}
const SI_GA_D3 = [4]string{
	`ACATTACT`,
	`TTTGGGTA`,
	`CAGCCCAC`,
	`GGCAATGG`,
}
const SI_GA_D4 = [4]string{
	`CCCTAACA`,
	`ATTCCGAT`,
	`TGGATTGC`,
	`GAAGGCTG`,
}
const SI_GA_D5 = [4]string{
	`CTCGTCAC`,
	`GATCAGCA`,
	`ACAACAGG`,
	`TGGTGTTT`,
}
const SI_GA_D6 = [4]string{
	`CATGCGAT`,
	`TGATATTC`,
	`GTGATCGA`,
	`ACCCGACG`,
}
const SI_GA_D7 = [4]string{
	`ATTTGCTA`,
	`TAGACACC`,
	`CCACAGGG`,
	`GGCGTTAT`,
}
const SI_GA_D8 = [4]string{
	`GCAACAAA`,
	`TAGTTGTC`,
	`CGCCATCG`,
	`ATTGGCGT`,
}
const SI_GA_D9 = [4]string{
	`AGGAGATG`,
	`GATGTGGT`,
	`CTACATCC`,
	`TCCTCCAA`,
}
const SI_GA_E1 = [4]string{
	`TGGTAAAC`,
	`GAAAGGGT`,
	`ACTGCTCG`,
	`CTCCTCTA`,
}
const SI_GA_E10 = [4]string{
	`AAATGTGC`,
	`GGGCAAAT`,
	`TCTATCCG`,
	`CTCGCGTA`,
}
const SI_GA_E11 = [4]string{
	`AAGCGCTG`,
	`CGTTTGAT`,
	`GTAGCACA`,
	`TCCAATGC`,
}
const SI_GA_E12 = [4]string{
	`ACCGGCTC`,
	`GAGTTAGT`,
	`CGTCCTAG`,
	`TTAAAGCA`,
}
const SI_GA_E2 = [4]string{
	`GTGGTACC`,
	`TACTATAG`,
	`ACAAGGTA`,
	`CGTCCCGT`,
}
const SI_GA_E3 = [4]string{
	`AGGTATTG`,
	`CTCCTAGT`,
	`TCAAGGCC`,
	`GATGCCAA`,
}
const SI_GA_E4 = [4]string{
	`TTCGCCCT`,
	`GGATGGGC`,
	`AATCAATG`,
	`CCGATTAA`,
}
const SI_GA_E5 = [4]string{
	`CATTAGCG`,
	`TTCGCTGA`,
	`ACAAGAAT`,
	`GGGCTCTC`,
}
const SI_GA_E6 = [4]string{
	`CTGCGGCT`,
	`GACTCAAA`,
	`AGAAACTC`,
	`TCTGTTGG`,
}
const SI_GA_E7 = [4]string{
	`CACGCCTT`,
	`GTATATAG`,
	`TCTCGGGC`,
	`AGGATACA`,
}
const SI_GA_E8 = [4]string{
	`ATAGTTAC`,
	`TGCTGAGT`,
	`CCTACGTA`,
	`GAGCACCG`,
}
const SI_GA_E9 = [4]string{
	`TTGTTTCC`,
	`GGAGGAGG`,
	`CCTAACAA`,
	`AACCCGTT`,
}
const SI_GA_F1 = [4]string{
	`GTTGCAGC`,
	`TGGAATTA`,
	`CAATGGAG`,
	`ACCCTCCT`,
}
const SI_GA_F10 = [4]string{
	`GCTTGGCT`,
	`AAACAAAC`,
	`CGGGCTTA`,
	`TTCATCGG`,
}
const SI_GA_F11 = [4]string{
	`GCGAGAGT`,
	`TACGTTCA`,
	`AGTCCCAC`,
	`CTATAGTG`,
}
const SI_GA_F12 = [4]string{
	`TGATGCAT`,
	`GCTACTGA`,
	`CACCTGCC`,
	`ATGGAATG`,
}
const SI_GA_F2 = [4]string{
	`TTTACATG`,
	`CGCGATAC`,
	`ACGCGGGT`,
	`GAATTCCA`,
}
const SI_GA_F3 = [4]string{
	`TTCAGGTG`,
	`ACGGACAT`,
	`GATCTTGA`,
	`CGATCACC`,
}
const SI_GA_F4 = [4]string{
	`CCCAATAG`,
	`GTGTCGCT`,
	`AGAGTCGC`,
	`TATCGATA`,
}
const SI_GA_F5 = [4]string{
	`GACTACGT`,
	`CTAGCGAG`,
	`TCTATATC`,
	`AGGCGTCA`,
}
const SI_GA_F6 = [4]string{
	`CGGAGCAC`,
	`GACCTATT`,
	`ACTTAGGA`,
	`TTAGCTCG`,
}
const SI_GA_F7 = [4]string{
	`CGTGCAGA`,
	`AACAAGAT`,
	`TCGCTTCG`,
	`GTATGCTC`,
}
const SI_GA_F8 = [4]string{
	`CATGAACA`,
	`TCACTCGC`,
	`AGCTGGAT`,
	`GTGACTTG`,
}
const SI_GA_F9 = [4]string{
	`CAAGCTCC`,
	`GTTCACTG`,
	`TCGTGAAA`,
	`AGCATGGT`,
}
const SI_GA_G1 = [4]string{
	`ATGAATCT`,
	`GATCTCAG`,
	`CCAGGAGC`,
	`TGCTCGTA`,
}
const SI_GA_G10 = [4]string{
	`TCGCCAGC`,
	`AATGTTAG`,
	`CGATAGCT`,
	`GTCAGCTA`,
}
const SI_GA_G11 = [4]string{
	`TTATCGTT`,
	`AGCAGAGC`,
	`CATCTCCA`,
	`GCGGATAG`,
}
const SI_GA_G12 = [4]string{
	`ATTCTAAG`,
	`CCCGATTA`,
	`TGGAGGCT`,
	`GAATCCGC`,
}
const SI_GA_G2 = [4]string{
	`TGATTCTA`,
	`ACTAGGAG`,
	`CAGCCACT`,
	`GTCGATGC`,
}
const SI_GA_G3 = [4]string{
	`CCTCATTC`,
	`AGCATCCG`,
	`GTGGCAAT`,
	`TAATGGGA`,
}
const SI_GA_G4 = [4]string{
	`GCGATGTG`,
	`AGATACAA`,
	`TTTCCACT`,
	`CACGGTGC`,
}
const SI_GA_G5 = [4]string{
	`GAGCAAGA`,
	`TCTGTGAT`,
	`CGCAGTTC`,
	`ATATCCCG`,
}
const SI_GA_G6 = [4]string{
	`CTGACGCG`,
	`GGTCGTAC`,
	`TCCTTCTT`,
	`AAAGAAGA`,
}
const SI_GA_G7 = [4]string{
	`GGTATGCA`,
	`CTCGAAAT`,
	`ACACCTTC`,
	`TAGTGCGG`,
}
const SI_GA_G8 = [4]string{
	`TATGAGCT`,
	`CCGATAGC`,
	`ATACCCAA`,
	`GGCTGTTG`,
}
const SI_GA_G9 = [4]string{
	`TAGGACGT`,
	`ATCCCACA`,
	`GGAATGTC`,
	`CCTTGTAG`,
}
const SI_GA_H1 = [4]string{
	`GTATGTCA`,
	`TGTCAGAC`,
	`CACGTCGG`,
	`ACGACATT`,
}
const SI_GA_H10 = [4]string{
	`GTAATTGC`,
	`AGTCGCTT`,
	`CACGAGAA`,
	`TCGTCACG`,
}
const SI_GA_H11 = [4]string{
	`GGCGAGTA`,
	`ACTTCTAT`,
	`CAAATACG`,
	`TTGCGCGC`,
}
const SI_GA_H12 = [4]string{
	`GACAGCAT`,
	`TTTGTACA`,
	`AGGCCGTG`,
	`CCATATGC`,
}
const SI_GA_H2 = [4]string{
	`TAATGACC`,
	`ATGCCTTA`,
	`GCCGAGAT`,
	`CGTATCGG`,
}
const SI_GA_H3 = [4]string{
	`CCAAGATG`,
	`AGGCCCGA`,
	`TACGTGAC`,
	`GTTTATCT`,
}
const SI_GA_H4 = [4]string{
	`GCCATTCC`,
	`CAAGAATT`,
	`TTGCCGGA`,
	`AGTTGCAG`,
}
const SI_GA_H5 = [4]string{
	`CCACTACA`,
	`GATTCTGG`,
	`TGCGGCTT`,
	`ATGAAGAC`,
}
const SI_GA_H6 = [4]string{
	`TAGGATAA`,
	`CCTTTGTC`,
	`GTACGCGG`,
	`AGCACACT`,
}
const SI_GA_H7 = [4]string{
	`AGCTATCA`,
	`CATATAAC`,
	`TCAGGGTG`,
	`GTGCCCGT`,
}
const SI_GA_H8 = [4]string{
	`TTGTTGAT`,
	`GCTCAACC`,
	`CAAAGTGG`,
	`AGCGCCTA`,
}
const SI_GA_H9 = [4]string{
	`ACACTGTT`,
	`CAGGATGG`,
	`GGCTGAAC`,
	`TTTACCCA`,
}
const SI_P01_A1 = [4]string{
	`TTGTAAGA`,
	`GGCGTTTC`,
	`CCTACCAT`,
	`AAACGGCG`,
}
const SI_P01_A10 = [4]string{
	`ACAGCAAC`,
	`TTTCGCGA`,
	`CGCAATTT`,
	`GAGTTGCG`,
}
const SI_P01_A11 = [4]string{
	`CTTTCCTT`,
	`TAGGTAAA`,
	`ACCAGTCC`,
	`GGACAGGG`,
}
const SI_P01_A12 = [4]string{
	`TTATGGAA`,
	`ACTACTGT`,
	`CGGGAACG`,
	`GACCTCTC`,
}
const SI_P01_A2 = [4]string{
	`AGCCCTTT`,
	`TCTTAGGC`,
	`GTGAGAAG`,
	`CAAGTCCA`,
}
const SI_P01_A3 = [4]string{
	`AAAGCATA`,
	`GCCTTTAT`,
	`CTGCAGCC`,
	`TGTAGCGG`,
}
const SI_P01_A4 = [4]string{
	`CATGGCAG`,
	`AGAACGCC`,
	`GTCTTTGA`,
	`TCGCAATT`,
}
const SI_P01_A5 = [4]string{
	`CAGTCTGG`,
	`TCACACTC`,
	`ATTGGGAA`,
	`GGCATACT`,
}
const SI_P01_A6 = [4]string{
	`CTTTCGAC`,
	`ACGGGACT`,
	`TGCATCTG`,
	`GAACATGA`,
}
const SI_P01_A7 = [4]string{
	`CTCATCAT`,
	`TAACGTCC`,
	`AGGTCATA`,
	`GCTGAGGG`,
}
const SI_P01_A8 = [4]string{
	`GACTGTTC`,
	`ATGATACG`,
	`CCACAGAA`,
	`TGTGCCGT`,
}
const SI_P01_A9 = [4]string{
	`GAGTGCGT`,
	`CTCCAACA`,
	`ACAACTTG`,
	`TGTGTGAC`,
}
const SI_P01_B1 = [4]string{
	`CTAGCTGT`,
	`GCCAACAA`,
	`AGGCTACC`,
	`TATTGGTG`,
}
const SI_P01_B10 = [4]string{
	`ACCATTAA`,
	`CTGGACGT`,
	`GAACGGTC`,
	`TGTTCACG`,
}
const SI_P01_B11 = [4]string{
	`TCCAGATA`,
	`GATTCGCT`,
	`CGACATAG`,
	`ATGGTCGC`,
}
const SI_P01_B12 = [4]string{
	`GAAAGACA`,
	`CGCTACAT`,
	`ACGCTTGG`,
	`TTTGCGTC`,
}
const SI_P01_B2 = [4]string{
	`GGTCGAGC`,
	`TTAGATTG`,
	`CCCACCCA`,
	`AAGTTGAT`,
}
const SI_P01_B3 = [4]string{
	`TCATCCTT`,
	`ATTGGACG`,
	`CAGCTTAC`,
	`GGCAAGGA`,
}
const SI_P01_B4 = [4]string{
	`GACAGGCT`,
	`CCTCTAAC`,
	`AGGGACTG`,
	`TTATCTGA`,
}
const SI_P01_B5 = [4]string{
	`TCATGCGA`,
	`ATCGTACT`,
	`CATCAGTG`,
	`GGGACTAC`,
}
const SI_P01_B6 = [4]string{
	`GCGCACCT`,
	`AACGCGAA`,
	`CTATTTGG`,
	`TGTAGATC`,
}
const SI_P01_B7 = [4]string{
	`TCCACACG`,
	`CTTCTGTT`,
	`GAATGCAC`,
	`AGGGATGA`,
}
const SI_P01_B8 = [4]string{
	`ACGTTCAC`,
	`TGCCCAGA`,
	`CAAGGTCT`,
	`GTTAAGTG`,
}
const SI_P01_B9 = [4]string{
	`AAGCGTGT`,
	`CTTGACCG`,
	`TGATTAAC`,
	`GCCACGTA`,
}
const SI_P01_C1 = [4]string{
	`GATGCAGT`,
	`AGACTTTC`,
	`TTCTACAG`,
	`CCGAGGCA`,
}
const SI_P01_C10 = [4]string{
	`CGTGCTAA`,
	`TCACTCCT`,
	`ATCTGATC`,
	`GAGAAGGG`,
}
const SI_P01_C11 = [4]string{
	`GTTTGTGG`,
	`ACCGAACA`,
	`TAGACGAC`,
	`CGACTCTT`,
}
const SI_P01_C12 = [4]string{
	`TAAGCCAC`,
	`CCGTTATG`,
	`GGTAATGT`,
	`ATCCGGCA`,
}
const SI_P01_C2 = [4]string{
	`CCGAGAAC`,
	`TGCTCTGT`,
	`GTAGTGCG`,
	`AATCACTA`,
}
const SI_P01_C3 = [4]string{
	`ACGTTACA`,
	`TTACCTAC`,
	`GACGACGG`,
	`CGTAGGTT`,
}
const SI_P01_C4 = [4]string{
	`ACATTGGC`,
	`GAGCCCAT`,
	`CTTAGTCA`,
	`TGCGAATG`,
}
const SI_P01_C5 = [4]string{
	`TCAGTCAA`,
	`CACTGACT`,
	`ATGCATTC`,
	`GGTACGGG`,
}
const SI_P01_C6 = [4]string{
	`CGCTCAGG`,
	`GAGGTTTA`,
	`ACTCAGAC`,
	`TTAAGCCT`,
}
const SI_P01_C7 = [4]string{
	`GGCGGAAT`,
	`ACACCGGG`,
	`CATAATCC`,
	`TTGTTCTA`,
}
const SI_P01_C8 = [4]string{
	`TTTATCCC`,
	`GCACGTTT`,
	`CAGGAAGA`,
	`AGCTCGAG`,
}
const SI_P01_C9 = [4]string{
	`AGATCGGT`,
	`CATCGTCG`,
	`GTCATATA`,
	`TCGGACAC`,
}
const SI_P01_D1 = [4]string{
	`AGCTGCGT`,
	`GTGGAGCA`,
	`TCTATTAG`,
	`CAACCATC`,
}
const SI_P01_D10 = [4]string{
	`CTTATTTG`,
	`GCGGGCAT`,
	`AGATAACA`,
	`TACCCGGC`,
}
const SI_P01_D11 = [4]string{
	`GCTACTTC`,
	`CACCTCAG`,
	`ATATGAGA`,
	`TGGGAGCT`,
}
const SI_P01_D12 = [4]string{
	`GCTGTGTA`,
	`AGAAACGT`,
	`CACTCAAC`,
	`TTGCGTCG`,
}
const SI_P01_D2 = [4]string{
	`ACATTCCG`,
	`GACACAAT`,
	`CTGCGGTA`,
	`TGTGATGC`,
}
const SI_P01_D3 = [4]string{
	`GAGCACGC`,
	`CGAAGTTG`,
	`TTCGTGAA`,
	`ACTTCACT`,
}
const SI_P01_D4 = [4]string{
	`AAATCGTC`,
	`GCGATCGG`,
	`CTTCGAAT`,
	`TGCGATCA`,
}
const SI_P01_D5 = [4]string{
	`GTCGACTC`,
	`AGACGGAT`,
	`CCTTTAGA`,
	`TAGACTCG`,
}
const SI_P01_D6 = [4]string{
	`GAAGTCTT`,
	`TGCAGGGC`,
	`ATGCCAAA`,
	`CCTTATCG`,
}
const SI_P01_D7 = [4]string{
	`CCGGATCC`,
	`GGTCGCAT`,
	`TTAACGTG`,
	`AACTTAGA`,
}
const SI_P01_D8 = [4]string{
	`AATCTTTG`,
	`GGATGAGT`,
	`CTCAAGAC`,
	`TCGGCCCA`,
}
const SI_P01_D9 = [4]string{
	`CAAGGGAC`,
	`ACCTACTG`,
	`GGGACACA`,
	`TTTCTTGT`,
}
const SI_P01_E1 = [4]string{
	`CGCCCGTA`,
	`GTTTGCCT`,
	`TAAGTTAG`,
	`ACGAAAGC`,
}
const SI_P01_E10 = [4]string{
	`GCACCAGT`,
	`CGCAGGAG`,
	`TAGTACCA`,
	`ATTGTTTC`,
}
const SI_P01_E11 = [4]string{
	`ATCGCCAT`,
	`TCACGGTA`,
	`GGGTTTCC`,
	`CATAAAGG`,
}
const SI_P01_E12 = [4]string{
	`CGCTATCC`,
	`ACGCGGAA`,
	`TAAATCGT`,
	`GTTGCATG`,
}
const SI_P01_E2 = [4]string{
	`TCATCAAG`,
	`GTTGGTCC`,
	`AGGCTGGT`,
	`CACAACTA`,
}
const SI_P01_E3 = [4]string{
	`TCTGCAGG`,
	`CGGCTCCA`,
	`AACAAGTC`,
	`GTATGTAT`,
}
const SI_P01_E4 = [4]string{
	`GTAAACAT`,
	`TATCCTGA`,
	`AGCTGACG`,
	`CCGGTGTC`,
}
const SI_P01_E5 = [4]string{
	`CCGTTGAA`,
	`TATGCTCT`,
	`ATCCAAGG`,
	`GGAAGCTC`,
}
const SI_P01_E6 = [4]string{
	`TGATGGCT`,
	`GCCATTTG`,
	`ATTGAAAC`,
	`CAGCCCGA`,
}
const SI_P01_E7 = [4]string{
	`AAGACGTG`,
	`CCATGTGT`,
	`GTTCACAA`,
	`TGCGTACC`,
}
const SI_P01_E8 = [4]string{
	`GCTTACAT`,
	`TAGGGTGC`,
	`AGCCTATG`,
	`CTAACGCA`,
}
const SI_P01_E9 = [4]string{
	`AGTAAGCA`,
	`TACCGCGG`,
	`CCGGTAAT`,
	`GTATCTTC`,
}
const SI_P01_F1 = [4]string{
	`TGACTAGT`,
	`GATAGGTA`,
	`CCGTACAG`,
	`ATCGCTCC`,
}
const SI_P01_F10 = [4]string{
	`TCGACAAT`,
	`GAATACTG`,
	`ATTCGTGC`,
	`CGCGTGCA`,
}
const SI_P01_F11 = [4]string{
	`GAACCCGG`,
	`AGCAGTTA`,
	`TCGTAGAT`,
	`CTTGTACC`,
}
const SI_P01_F12 = [4]string{
	`AATTGAAC`,
	`TGGACCCT`,
	`CCAGTGGA`,
	`GTCCATTG`,
}
const SI_P01_F2 = [4]string{
	`TGCCCGCT`,
	`GCAAACGC`,
	`CATTGATA`,
	`ATGGTTAG`,
}
const SI_P01_F3 = [4]string{
	`TTAGGACC`,
	`AGTCTGTA`,
	`GCCTCCGT`,
	`CAGAATAG`,
}
const SI_P01_F4 = [4]string{
	`GCATGATA`,
	`CGTCCTCT`,
	`AACGACAC`,
	`TTGATGGG`,
}
const SI_P01_F5 = [4]string{
	`TCTGACTA`,
	`GTACGGCT`,
	`CGGTTTAG`,
	`AACACAGC`,
}
const SI_P01_F6 = [4]string{
	`GACTTCCT`,
	`TGAGGAAG`,
	`ATGCCGGC`,
	`CCTAATTA`,
}
const SI_P01_F7 = [4]string{
	`GGTTAGAC`,
	`CAAACTTT`,
	`ACCCGAGA`,
	`TTGGTCCG`,
}
const SI_P01_F8 = [4]string{
	`AGTTGGGA`,
	`TACATTCT`,
	`CCAGAAAG`,
	`GTGCCCTC`,
}
const SI_P01_F9 = [4]string{
	`AGTTAGTT`,
	`GTACTTAA`,
	`CACGCACG`,
	`TCGAGCGC`,
}
const SI_P01_G1 = [4]string{
	`CATATGCG`,
	`ATGCGATT`,
	`TCCGCTAC`,
	`GGATACGA`,
}
const SI_P01_G10 = [4]string{
	`CGGAGACT`,
	`TCCTATGA`,
	`ATACTGAG`,
	`GATGCCTC`,
}
const SI_P01_G11 = [4]string{
	`AGGGCGTT`,
	`CTATACGC`,
	`TACATAAG`,
	`GCTCGTCA`,
}
const SI_P01_G12 = [4]string{
	`CATGCGTA`,
	`ACCCGCAC`,
	`TGATATCG`,
	`GTGATAGT`,
}
const SI_P01_G2 = [4]string{
	`CGGTGAGC`,
	`ATAACCTA`,
	`TCCGAGCG`,
	`GATCTTAT`,
}
const SI_P01_G3 = [4]string{
	`TACGAGTT`,
	`ATGTCCAG`,
	`GCTATAGC`,
	`CGACGTCA`,
}
const SI_P01_G4 = [4]string{
	`CCTGCGGT`,
	`GTACAACG`,
	`AGCTTCTC`,
	`TAGAGTAA`,
}
const SI_P01_G5 = [4]string{
	`ATGAAGTA`,
	`GAAGCTCG`,
	`TCTTTCGT`,
	`CGCCGAAC`,
}
const SI_P01_G6 = [4]string{
	`GTGCGACA`,
	`TCAGTGTT`,
	`AGCACTGG`,
	`CATTACAC`,
}
const SI_P01_G7 = [4]string{
	`GCCGGTAA`,
	`TGACTGCC`,
	`ATTACCGG`,
	`CAGTAATT`,
}
const SI_P01_G8 = [4]string{
	`AAGTACTC`,
	`GGAACTCT`,
	`TCCCTGAG`,
	`CTTGGAGA`,
}
const SI_P01_G9 = [4]string{
	`TTGACTTC`,
	`GCCGAAGT`,
	`CAATGGCA`,
	`AGTCTCAG`,
}
const SI_P01_H1 = [4]string{
	`TCTTGTCC`,
	`CGGGAGTA`,
	`GTCACAGG`,
	`AAACTCAT`,
}
const SI_P01_H10 = [4]string{
	`GACCGCCA`,
	`TCGAATTG`,
	`ATTTCAGC`,
	`CGAGTGAT`,
}
const SI_P01_H11 = [4]string{
	`TCTCGACT`,
	`AGGATCGA`,
	`CACGATTC`,
	`GTATCGAG`,
}
const SI_P01_H12 = [4]string{
	`TGTGTATA`,
	`GTCCAGGC`,
	`CAATCCCT`,
	`ACGAGTAG`,
}
const SI_P01_H2 = [4]string{
	`CCGAACTC`,
	`AACGGTCA`,
	`TTATTGGT`,
	`GGTCCAAG`,
}
const SI_P01_H3 = [4]string{
	`TTGGGCTT`,
	`GACAAACC`,
	`ACACCTAA`,
	`CGTTTGGG`,
}
const SI_P01_H4 = [4]string{
	`TTCCATCT`,
	`ACTGGAGC`,
	`CGGTCGTG`,
	`GAAATCAA`,
}
const SI_P01_H5 = [4]string{
	`ATAGTATG`,
	`TATAAGGA`,
	`GGCTCCAC`,
	`CCGCGTCT`,
}
const SI_P01_H6 = [4]string{
	`AAGCATAA`,
	`CCCATCGC`,
	`TTAGCGCT`,
	`GGTTGATG`,
}
const SI_P01_H7 = [4]string{
	`TGGCACGA`,
	`AACGGGTG`,
	`CTAATTCT`,
	`GCTTCAAC`,
}
const SI_P01_H8 = [4]string{
	`AAGAGCGG`,
	`TCATAGCA`,
	`GGCCCATC`,
	`CTTGTTAT`,
}
const SI_P01_H9 = [4]string{
	`GGAATATG`,
	`ACCTGCCA`,
	`CTTCATAC`,
	`TAGGCGGT`,
}
const SI_P03_A1 = [4]string{
	`AAACGGCG`,
	`CCTACCAT`,
	`GGCGTTTC`,
	`TTGTAAGA`,
}
const SI_P03_A10 = [4]string{
	`ACAGCAAC`,
	`CGCAATTT`,
	`GAGTTGCG`,
	`TTTCGCGA`,
}
const SI_P03_A11 = [4]string{
	`ACCAGTCC`,
	`CTTTCCTT`,
	`GGACAGGG`,
	`TAGGTAAA`,
}
const SI_P03_A12 = [4]string{
	`ACTACTGT`,
	`CGGGAACG`,
	`GACCTCTC`,
	`TTATGGAA`,
}
const SI_P03_A2 = [4]string{
	`AGCCCTTT`,
	`CAAGTCCA`,
	`GTGAGAAG`,
	`TCTTAGGC`,
}
const SI_P03_A3 = [4]string{
	`AAAGCATA`,
	`CTGCAGCC`,
	`GCCTTTAT`,
	`TGTAGCGG`,
}
const SI_P03_A4 = [4]string{
	`AGAACGCC`,
	`CATGGCAG`,
	`GTCTTTGA`,
	`TCGCAATT`,
}
const SI_P03_A5 = [4]string{
	`ATTGGGAA`,
	`CAGTCTGG`,
	`GGCATACT`,
	`TCACACTC`,
}
const SI_P03_A6 = [4]string{
	`ACGGGACT`,
	`CTTTCGAC`,
	`GAACATGA`,
	`TGCATCTG`,
}
const SI_P03_A7 = [4]string{
	`AGGTCATA`,
	`CTCATCAT`,
	`GCTGAGGG`,
	`TAACGTCC`,
}
const SI_P03_A8 = [4]string{
	`ATGATACG`,
	`CCACAGAA`,
	`GACTGTTC`,
	`TGTGCCGT`,
}
const SI_P03_A9 = [4]string{
	`ACAACTTG`,
	`CTCCAACA`,
	`GAGTGCGT`,
	`TGTGTGAC`,
}
const SI_P03_B1 = [4]string{
	`AGGCTACC`,
	`CTAGCTGT`,
	`GCCAACAA`,
	`TATTGGTG`,
}
const SI_P03_B10 = [4]string{
	`ACCATTAA`,
	`CTGGACGT`,
	`GAACGGTC`,
	`TGTTCACG`,
}
const SI_P03_B11 = [4]string{
	`ATGGTCGC`,
	`CGACATAG`,
	`GATTCGCT`,
	`TCCAGATA`,
}
const SI_P03_B12 = [4]string{
	`ACGCTTGG`,
	`CGCTACAT`,
	`GAAAGACA`,
	`TTTGCGTC`,
}
const SI_P03_B2 = [4]string{
	`AAGTTGAT`,
	`CCCACCCA`,
	`GGTCGAGC`,
	`TTAGATTG`,
}
const SI_P03_B3 = [4]string{
	`ATTGGACG`,
	`CAGCTTAC`,
	`GGCAAGGA`,
	`TCATCCTT`,
}
const SI_P03_B4 = [4]string{
	`AGGGACTG`,
	`CCTCTAAC`,
	`GACAGGCT`,
	`TTATCTGA`,
}
const SI_P03_B5 = [4]string{
	`ATCGTACT`,
	`CATCAGTG`,
	`GGGACTAC`,
	`TCATGCGA`,
}
const SI_P03_B6 = [4]string{
	`AACGCGAA`,
	`CTATTTGG`,
	`GCGCACCT`,
	`TGTAGATC`,
}
const SI_P03_B7 = [4]string{
	`AGGGATGA`,
	`CTTCTGTT`,
	`GAATGCAC`,
	`TCCACACG`,
}
const SI_P03_B8 = [4]string{
	`ACGTTCAC`,
	`CAAGGTCT`,
	`GTTAAGTG`,
	`TGCCCAGA`,
}
const SI_P03_B9 = [4]string{
	`AAGCGTGT`,
	`CTTGACCG`,
	`GCCACGTA`,
	`TGATTAAC`,
}
const SI_P03_C1 = [4]string{
	`AGACTTTC`,
	`CCGAGGCA`,
	`GATGCAGT`,
	`TTCTACAG`,
}
const SI_P03_C10 = [4]string{
	`ATCTGATC`,
	`CGTGCTAA`,
	`GAGAAGGG`,
	`TCACTCCT`,
}
const SI_P03_C11 = [4]string{
	`ACCGAACA`,
	`CGACTCTT`,
	`GTTTGTGG`,
	`TAGACGAC`,
}
const SI_P03_C12 = [4]string{
	`ATCCGGCA`,
	`CCGTTATG`,
	`GGTAATGT`,
	`TAAGCCAC`,
}
const SI_P03_C2 = [4]string{
	`AATCACTA`,
	`CCGAGAAC`,
	`GTAGTGCG`,
	`TGCTCTGT`,
}
const SI_P03_C3 = [4]string{
	`ACGTTACA`,
	`CGTAGGTT`,
	`GACGACGG`,
	`TTACCTAC`,
}
const SI_P03_C4 = [4]string{
	`ACATTGGC`,
	`CTTAGTCA`,
	`GAGCCCAT`,
	`TGCGAATG`,
}
const SI_P03_C5 = [4]string{
	`ATGCATTC`,
	`CACTGACT`,
	`GGTACGGG`,
	`TCAGTCAA`,
}
const SI_P03_C6 = [4]string{
	`ACTCAGAC`,
	`CGCTCAGG`,
	`GAGGTTTA`,
	`TTAAGCCT`,
}
const SI_P03_C7 = [4]string{
	`ACACCGGG`,
	`CATAATCC`,
	`GGCGGAAT`,
	`TTGTTCTA`,
}
const SI_P03_C8 = [4]string{
	`AGCTCGAG`,
	`CAGGAAGA`,
	`GCACGTTT`,
	`TTTATCCC`,
}
const SI_P03_C9 = [4]string{
	`AGATCGGT`,
	`CATCGTCG`,
	`GTCATATA`,
	`TCGGACAC`,
}
const SI_P03_D1 = [4]string{
	`AGCTGCGT`,
	`CAACCATC`,
	`GTGGAGCA`,
	`TCTATTAG`,
}
const SI_P03_D10 = [4]string{
	`AGATAACA`,
	`CTTATTTG`,
	`GCGGGCAT`,
	`TACCCGGC`,
}
const SI_P03_D11 = [4]string{
	`ATATGAGA`,
	`CACCTCAG`,
	`GCTACTTC`,
	`TGGGAGCT`,
}
const SI_P03_D12 = [4]string{
	`AGAAACGT`,
	`CACTCAAC`,
	`GCTGTGTA`,
	`TTGCGTCG`,
}
const SI_P03_D2 = [4]string{
	`ACATTCCG`,
	`CTGCGGTA`,
	`GACACAAT`,
	`TGTGATGC`,
}
const SI_P03_D3 = [4]string{
	`ACTTCACT`,
	`CGAAGTTG`,
	`GAGCACGC`,
	`TTCGTGAA`,
}
const SI_P03_D4 = [4]string{
	`AAATCGTC`,
	`CTTCGAAT`,
	`GCGATCGG`,
	`TGCGATCA`,
}
const SI_P03_D5 = [4]string{
	`AGACGGAT`,
	`CCTTTAGA`,
	`GTCGACTC`,
	`TAGACTCG`,
}
const SI_P03_D6 = [4]string{
	`ATGCCAAA`,
	`CCTTATCG`,
	`GAAGTCTT`,
	`TGCAGGGC`,
}
const SI_P03_D7 = [4]string{
	`AACTTAGA`,
	`CCGGATCC`,
	`GGTCGCAT`,
	`TTAACGTG`,
}
const SI_P03_D8 = [4]string{
	`AATCTTTG`,
	`CTCAAGAC`,
	`GGATGAGT`,
	`TCGGCCCA`,
}
const SI_P03_D9 = [4]string{
	`ACCTACTG`,
	`CAAGGGAC`,
	`GGGACACA`,
	`TTTCTTGT`,
}
const SI_P03_E1 = [4]string{
	`ACGAAAGC`,
	`CGCCCGTA`,
	`GTTTGCCT`,
	`TAAGTTAG`,
}
const SI_P03_E10 = [4]string{
	`ATTGTTTC`,
	`CGCAGGAG`,
	`GCACCAGT`,
	`TAGTACCA`,
}
const SI_P03_E11 = [4]string{
	`ATCGCCAT`,
	`CATAAAGG`,
	`GGGTTTCC`,
	`TCACGGTA`,
}
const SI_P03_E12 = [4]string{
	`ACGCGGAA`,
	`CGCTATCC`,
	`GTTGCATG`,
	`TAAATCGT`,
}
const SI_P03_E2 = [4]string{
	`AGGCTGGT`,
	`CACAACTA`,
	`GTTGGTCC`,
	`TCATCAAG`,
}
const SI_P03_E3 = [4]string{
	`AACAAGTC`,
	`CGGCTCCA`,
	`GTATGTAT`,
	`TCTGCAGG`,
}
const SI_P03_E4 = [4]string{
	`AGCTGACG`,
	`CCGGTGTC`,
	`GTAAACAT`,
	`TATCCTGA`,
}
const SI_P03_E5 = [4]string{
	`ATCCAAGG`,
	`CCGTTGAA`,
	`GGAAGCTC`,
	`TATGCTCT`,
}
const SI_P03_E6 = [4]string{
	`ATTGAAAC`,
	`CAGCCCGA`,
	`GCCATTTG`,
	`TGATGGCT`,
}
const SI_P03_E7 = [4]string{
	`AAGACGTG`,
	`CCATGTGT`,
	`GTTCACAA`,
	`TGCGTACC`,
}
const SI_P03_E8 = [4]string{
	`AGCCTATG`,
	`CTAACGCA`,
	`GCTTACAT`,
	`TAGGGTGC`,
}
const SI_P03_E9 = [4]string{
	`AGTAAGCA`,
	`CCGGTAAT`,
	`GTATCTTC`,
	`TACCGCGG`,
}
const SI_P03_F1 = [4]string{
	`ATCGCTCC`,
	`CCGTACAG`,
	`GATAGGTA`,
	`TGACTAGT`,
}
const SI_P03_F10 = [4]string{
	`ATTCGTGC`,
	`CGCGTGCA`,
	`GAATACTG`,
	`TCGACAAT`,
}
const SI_P03_F11 = [4]string{
	`AGCAGTTA`,
	`CTTGTACC`,
	`GAACCCGG`,
	`TCGTAGAT`,
}
const SI_P03_F12 = [4]string{
	`AATTGAAC`,
	`CCAGTGGA`,
	`GTCCATTG`,
	`TGGACCCT`,
}
const SI_P03_F2 = [4]string{
	`ATGGTTAG`,
	`CATTGATA`,
	`GCAAACGC`,
	`TGCCCGCT`,
}
const SI_P03_F3 = [4]string{
	`AGTCTGTA`,
	`CAGAATAG`,
	`GCCTCCGT`,
	`TTAGGACC`,
}
const SI_P03_F4 = [4]string{
	`AACGACAC`,
	`CGTCCTCT`,
	`GCATGATA`,
	`TTGATGGG`,
}
const SI_P03_F5 = [4]string{
	`AACACAGC`,
	`CGGTTTAG`,
	`GTACGGCT`,
	`TCTGACTA`,
}
const SI_P03_F6 = [4]string{
	`ATGCCGGC`,
	`CCTAATTA`,
	`GACTTCCT`,
	`TGAGGAAG`,
}
const SI_P03_F7 = [4]string{
	`ACCCGAGA`,
	`CAAACTTT`,
	`GGTTAGAC`,
	`TTGGTCCG`,
}
const SI_P03_F8 = [4]string{
	`AGTTGGGA`,
	`CCAGAAAG`,
	`GTGCCCTC`,
	`TACATTCT`,
}
const SI_P03_F9 = [4]string{
	`AGTTAGTT`,
	`CACGCACG`,
	`GTACTTAA`,
	`TCGAGCGC`,
}
const SI_P03_G1 = [4]string{
	`ATGCGATT`,
	`CATATGCG`,
	`GGATACGA`,
	`TCCGCTAC`,
}
const SI_P03_G10 = [4]string{
	`ATACTGAG`,
	`CGGAGACT`,
	`GATGCCTC`,
	`TCCTATGA`,
}
const SI_P03_G11 = [4]string{
	`AGGGCGTT`,
	`CTATACGC`,
	`GCTCGTCA`,
	`TACATAAG`,
}
const SI_P03_G12 = [4]string{
	`ACCCGCAC`,
	`CATGCGTA`,
	`GTGATAGT`,
	`TGATATCG`,
}
const SI_P03_G2 = [4]string{
	`ATAACCTA`,
	`CGGTGAGC`,
	`GATCTTAT`,
	`TCCGAGCG`,
}
const SI_P03_G3 = [4]string{
	`ATGTCCAG`,
	`CGACGTCA`,
	`GCTATAGC`,
	`TACGAGTT`,
}
const SI_P03_G4 = [4]string{
	`AGCTTCTC`,
	`CCTGCGGT`,
	`GTACAACG`,
	`TAGAGTAA`,
}
const SI_P03_G5 = [4]string{
	`ATGAAGTA`,
	`CGCCGAAC`,
	`GAAGCTCG`,
	`TCTTTCGT`,
}
const SI_P03_G6 = [4]string{
	`AGCACTGG`,
	`CATTACAC`,
	`GTGCGACA`,
	`TCAGTGTT`,
}
const SI_P03_G7 = [4]string{
	`ATTACCGG`,
	`CAGTAATT`,
	`GCCGGTAA`,
	`TGACTGCC`,
}
const SI_P03_G8 = [4]string{
	`AAGTACTC`,
	`CTTGGAGA`,
	`GGAACTCT`,
	`TCCCTGAG`,
}
const SI_P03_G9 = [4]string{
	`AGTCTCAG`,
	`CAATGGCA`,
	`GCCGAAGT`,
	`TTGACTTC`,
}
const SI_P03_H1 = [4]string{
	`AAACTCAT`,
	`CGGGAGTA`,
	`GTCACAGG`,
	`TCTTGTCC`,
}
const SI_P03_H10 = [4]string{
	`ATTTCAGC`,
	`CGAGTGAT`,
	`GACCGCCA`,
	`TCGAATTG`,
}
const SI_P03_H11 = [4]string{
	`AGGATCGA`,
	`CACGATTC`,
	`GTATCGAG`,
	`TCTCGACT`,
}
const SI_P03_H12 = [4]string{
	`ACGAGTAG`,
	`CAATCCCT`,
	`GTCCAGGC`,
	`TGTGTATA`,
}
const SI_P03_H2 = [4]string{
	`AACGGTCA`,
	`CCGAACTC`,
	`GGTCCAAG`,
	`TTATTGGT`,
}
const SI_P03_H3 = [4]string{
	`ACACCTAA`,
	`CGTTTGGG`,
	`GACAAACC`,
	`TTGGGCTT`,
}
const SI_P03_H4 = [4]string{
	`ACTGGAGC`,
	`CGGTCGTG`,
	`GAAATCAA`,
	`TTCCATCT`,
}
const SI_P03_H5 = [4]string{
	`ATAGTATG`,
	`CCGCGTCT`,
	`GGCTCCAC`,
	`TATAAGGA`,
}
const SI_P03_H6 = [4]string{
	`AAGCATAA`,
	`CCCATCGC`,
	`GGTTGATG`,
	`TTAGCGCT`,
}
const SI_P03_H7 = [4]string{
	`AACGGGTG`,
	`CTAATTCT`,
	`GCTTCAAC`,
	`TGGCACGA`,
}
const SI_P03_H8 = [4]string{
	`AAGAGCGG`,
	`CTTGTTAT`,
	`GGCCCATC`,
	`TCATAGCA`,
}
const SI_P03_H9 = [4]string{
	`ACCTGCCA`,
	`CTTCATAC`,
	`GGAATATG`,
	`TAGGCGGT`,
}
const SI_P2_A1 = [4]string{
	`GGTTTACT`,
	`CTAAACGG`,
	`TCGGCGTC`,
	`AACCGTAA`,
}
const SI_P2_A10 = [4]string{
	`GAAACCCT`,
	`TTTCTGTC`,
	`CCGTGTGA`,
	`AGCGAAAG`,
}
const SI_P2_A11 = [4]string{
	`GTCCGGTC`,
	`AAGATCAT`,
	`CCTGAAGG`,
	`TGATCTCA`,
}
const SI_P2_A12 = [4]string{
	`AGTGGAAC`,
	`GTCTCCTT`,
	`TCACATCA`,
	`CAGATGGG`,
}
const SI_P2_A2 = [4]string{
	`TTTCATGA`,
	`ACGTCCCT`,
	`CGCATGTG`,
	`GAAGGAAC`,
}
const SI_P2_A3 = [4]string{
	`CAGTACTG`,
	`AGTAGTCT`,
	`GCAGTAGA`,
	`TTCCCGAC`,
}
const SI_P2_A4 = [4]string{
	`TATGATTC`,
	`CCCACAGT`,
	`ATGCTGAA`,
	`GGATGCCG`,
}
const SI_P2_A5 = [4]string{
	`CTAGGTGA`,
	`TCGTTCAG`,
	`AGCCAATT`,
	`GATACGCC`,
}
const SI_P2_A6 = [4]string{
	`CGCTATGT`,
	`GCTGTCCA`,
	`TTGAGATC`,
	`AAACCGAG`,
}
const SI_P2_A7 = [4]string{
	`ACAGAGGT`,
	`TATAGTTG`,
	`CGGTCCCA`,
	`GTCCTAAC`,
}
const SI_P2_A8 = [4]string{
	`GCATCTCC`,
	`TGTAAGGT`,
	`CTGCGATG`,
	`AACGTCAA`,
}
const SI_P2_A9 = [4]string{
	`TCTTAAAG`,
	`CGAGGCTC`,
	`GTCCTTCT`,
	`AAGACGGA`,
}
const SI_P2_B1 = [4]string{
	`GTAATCTT`,
	`TCCGGAAG`,
	`AGTTCGGC`,
	`CAGCATCA`,
}
const SI_P2_B10 = [4]string{
	`ACCGTATG`,
	`GATTAGAT`,
	`CTGACTGA`,
	`TGACGCCC`,
}
const SI_P2_B11 = [4]string{
	`GTTCCTCA`,
	`AGGTACGC`,
	`TAAGTATG`,
	`CCCAGGAT`,
}
const SI_P2_B12 = [4]string{
	`TACCACCA`,
	`CTAAGTTT`,
	`GGGTCAAG`,
	`ACTGTGGC`,
}
const SI_P2_B2 = [4]string{
	`TACTCTTC`,
	`CCTGTGCG`,
	`GGACACGT`,
	`ATGAGAAA`,
}
const SI_P2_B3 = [4]string{
	`GTGTATTA`,
	`TGTGCGGG`,
	`ACCATAAC`,
	`CAACGCCT`,
}
const SI_P2_B4 = [4]string{
	`ACTTCATA`,
	`GAGATGAC`,
	`TGCCGTGG`,
	`CTAGACCT`,
}
const SI_P2_B5 = [4]string{
	`AATAATGG`,
	`CCAGGGCA`,
	`TGCCTCAT`,
	`GTGTCATC`,
}
const SI_P2_B6 = [4]string{
	`CGTTAATC`,
	`GCCACGCT`,
	`TTACTCAG`,
	`AAGGGTGA`,
}
const SI_P2_B7 = [4]string{
	`AAACCTCA`,
	`GCCTTGGT`,
	`CTGGACTC`,
	`TGTAGAAG`,
}
const SI_P2_B8 = [4]string{
	`AAAGTGCT`,
	`GCTACCTG`,
	`TGCTGTAA`,
	`CTGCAAGC`,
}
const SI_P2_B9 = [4]string{
	`CTGTAACT`,
	`TCTAGCGA`,
	`AGAGTGTG`,
	`GACCCTAC`,
}
const SI_P2_C1 = [4]string{
	`CCACTTAT`,
	`AACTGGCG`,
	`TTGGCATA`,
	`GGTAACGC`,
}
const SI_P2_C10 = [4]string{
	`TCTCAGTG`,
	`GAGACTAT`,
	`CGCTTAGC`,
	`ATAGGCCA`,
}
const SI_P2_C11 = [4]string{
	`GAGGATCT`,
	`AGACCATA`,
	`TCCTGCGC`,
	`CTTATGAG`,
}
const SI_P2_C12 = [4]string{
	`TCTCGTTT`,
	`GGCTAGCG`,
	`ATGACCGC`,
	`CAAGTAAA`,
}
const SI_P2_C2 = [4]string{
	`CCTAGACC`,
	`ATCTCTGT`,
	`TAGCTCTA`,
	`GGAGAGAG`,
}
const SI_P2_C3 = [4]string{
	`TCAGCCGT`,
	`CAGAGGCC`,
	`GGTCAATA`,
	`ATCTTTAG`,
}
const SI_P2_C4 = [4]string{
	`ACAATTCA`,
	`TGCGCAGC`,
	`CATCACTT`,
	`GTGTGGAG`,
}
const SI_P2_C5 = [4]string{
	`CGACTTGA`,
	`TACAGACT`,
	`ATTGCGTG`,
	`GCGTACAC`,
}
const SI_P2_C6 = [4]string{
	`ATTACTTC`,
	`TGCGAACT`,
	`GCATTCGG`,
	`CAGCGGAA`,
}
const SI_P2_C7 = [4]string{
	`GTCTCTCG`,
	`AATCTCTC`,
	`CGGAGGGA`,
	`TCAGAAAT`,
}
const SI_P2_C8 = [4]string{
	`GTTGAGAA`,
	`AGATCTGG`,
	`TCGATACT`,
	`CACCGCTC`,
}
const SI_P2_C9 = [4]string{
	`GCGCAGAA`,
	`ATCTTACC`,
	`TATGGTGT`,
	`CGAACCTG`,
}
const SI_P2_D1 = [4]string{
	`CACTCGGA`,
	`GCTGAATT`,
	`TGAAGTAC`,
	`ATGCTCCG`,
}
const SI_P2_D10 = [4]string{
	`CAATACCC`,
	`TGTCTATG`,
	`ACCACGAA`,
	`GTGGGTGT`,
}
const SI_P2_D11 = [4]string{
	`CTTTGCGG`,
	`TGCACAAA`,
	`AAGCAGTC`,
	`GCAGTTCT`,
}
const SI_P2_D12 = [4]string{
	`GCACAATG`,
	`CTTGGTAC`,
	`TGCACCGT`,
	`AAGTTGCA`,
}
const SI_P2_D2 = [4]string{
	`TAACAAGG`,
	`GGTTCCTC`,
	`ATCATGCA`,
	`CCGGGTAT`,
}
const SI_P2_D3 = [4]string{
	`ACATTACT`,
	`TTTGGGTA`,
	`CAGCCCAC`,
	`GGCAATGG`,
}
const SI_P2_D4 = [4]string{
	`CCCTAACA`,
	`ATTCCGAT`,
	`TGGATTGC`,
	`GAAGGCTG`,
}
const SI_P2_D5 = [4]string{
	`CTCGTCAC`,
	`GATCAGCA`,
	`ACAACAGG`,
	`TGGTGTTT`,
}
const SI_P2_D6 = [4]string{
	`CATGCGAT`,
	`TGATATTC`,
	`GTGATCGA`,
	`ACCCGACG`,
}
const SI_P2_D7 = [4]string{
	`ATTTGCTA`,
	`TAGACACC`,
	`CCACAGGG`,
	`GGCGTTAT`,
}
const SI_P2_D8 = [4]string{
	`GCAACAAA`,
	`TAGTTGTC`,
	`CGCCATCG`,
	`ATTGGCGT`,
}
const SI_P2_D9 = [4]string{
	`AGGAGATG`,
	`GATGTGGT`,
	`CTACATCC`,
	`TCCTCCAA`,
}
const SI_P2_E1 = [4]string{
	`TGGTAAAC`,
	`GAAAGGGT`,
	`ACTGCTCG`,
	`CTCCTCTA`,
}
const SI_P2_E10 = [4]string{
	`AAATGTGC`,
	`GGGCAAAT`,
	`TCTATCCG`,
	`CTCGCGTA`,
}
const SI_P2_E11 = [4]string{
	`AAGCGCTG`,
	`CGTTTGAT`,
	`GTAGCACA`,
	`TCCAATGC`,
}
const SI_P2_E12 = [4]string{
	`ACCGGCTC`,
	`GAGTTAGT`,
	`CGTCCTAG`,
	`TTAAAGCA`,
}
const SI_P2_E2 = [4]string{
	`GTGGTACC`,
	`TACTATAG`,
	`ACAAGGTA`,
	`CGTCCCGT`,
}
const SI_P2_E3 = [4]string{
	`AGGTATTG`,
	`CTCCTAGT`,
	`TCAAGGCC`,
	`GATGCCAA`,
}
const SI_P2_E4 = [4]string{
	`TTCGCCCT`,
	`GGATGGGC`,
	`AATCAATG`,
	`CCGATTAA`,
}
const SI_P2_E5 = [4]string{
	`CATTAGCG`,
	`TTCGCTGA`,
	`ACAAGAAT`,
	`GGGCTCTC`,
}
const SI_P2_E6 = [4]string{
	`CTGCGGCT`,
	`GACTCAAA`,
	`AGAAACTC`,
	`TCTGTTGG`,
}
const SI_P2_E7 = [4]string{
	`CACGCCTT`,
	`GTATATAG`,
	`TCTCGGGC`,
	`AGGATACA`,
}
const SI_P2_E8 = [4]string{
	`ATAGTTAC`,
	`TGCTGAGT`,
	`CCTACGTA`,
	`GAGCACCG`,
}
const SI_P2_E9 = [4]string{
	`TTGTTTCC`,
	`GGAGGAGG`,
	`CCTAACAA`,
	`AACCCGTT`,
}
const SI_P2_F1 = [4]string{
	`GTTGCAGC`,
	`TGGAATTA`,
	`CAATGGAG`,
	`ACCCTCCT`,
}
const SI_P2_F10 = [4]string{
	`GCTTGGCT`,
	`AAACAAAC`,
	`CGGGCTTA`,
	`TTCATCGG`,
}
const SI_P2_F11 = [4]string{
	`GCGAGAGT`,
	`TACGTTCA`,
	`AGTCCCAC`,
	`CTATAGTG`,
}
const SI_P2_F12 = [4]string{
	`TGATGCAT`,
	`GCTACTGA`,
	`CACCTGCC`,
	`ATGGAATG`,
}
const SI_P2_F2 = [4]string{
	`TTTACATG`,
	`CGCGATAC`,
	`ACGCGGGT`,
	`GAATTCCA`,
}
const SI_P2_F3 = [4]string{
	`TTCAGGTG`,
	`ACGGACAT`,
	`GATCTTGA`,
	`CGATCACC`,
}
const SI_P2_F4 = [4]string{
	`CCCAATAG`,
	`GTGTCGCT`,
	`AGAGTCGC`,
	`TATCGATA`,
}
const SI_P2_F5 = [4]string{
	`GACTACGT`,
	`CTAGCGAG`,
	`TCTATATC`,
	`AGGCGTCA`,
}
const SI_P2_F6 = [4]string{
	`CGGAGCAC`,
	`GACCTATT`,
	`ACTTAGGA`,
	`TTAGCTCG`,
}
const SI_P2_F7 = [4]string{
	`CGTGCAGA`,
	`AACAAGAT`,
	`TCGCTTCG`,
	`GTATGCTC`,
}
const SI_P2_F8 = [4]string{
	`CATGAACA`,
	`TCACTCGC`,
	`AGCTGGAT`,
	`GTGACTTG`,
}
const SI_P2_F9 = [4]string{
	`CAAGCTCC`,
	`GTTCACTG`,
	`TCGTGAAA`,
	`AGCATGGT`,
}
const SI_P2_G1 = [4]string{
	`ATGAATCT`,
	`GATCTCAG`,
	`CCAGGAGC`,
	`TGCTCGTA`,
}
const SI_P2_G10 = [4]string{
	`TCGCCAGC`,
	`AATGTTAG`,
	`CGATAGCT`,
	`GTCAGCTA`,
}
const SI_P2_G11 = [4]string{
	`TTATCGTT`,
	`AGCAGAGC`,
	`CATCTCCA`,
	`GCGGATAG`,
}
const SI_P2_G12 = [4]string{
	`ATTCTAAG`,
	`CCCGATTA`,
	`TGGAGGCT`,
	`GAATCCGC`,
}
const SI_P2_G2 = [4]string{
	`TGATTCTA`,
	`ACTAGGAG`,
	`CAGCCACT`,
	`GTCGATGC`,
}
const SI_P2_G3 = [4]string{
	`CCTCATTC`,
	`AGCATCCG`,
	`GTGGCAAT`,
	`TAATGGGA`,
}
const SI_P2_G4 = [4]string{
	`GCGATGTG`,
	`AGATACAA`,
	`TTTCCACT`,
	`CACGGTGC`,
}
const SI_P2_G5 = [4]string{
	`GAGCAAGA`,
	`TCTGTGAT`,
	`CGCAGTTC`,
	`ATATCCCG`,
}
const SI_P2_G6 = [4]string{
	`CTGACGCG`,
	`GGTCGTAC`,
	`TCCTTCTT`,
	`AAAGAAGA`,
}
const SI_P2_G7 = [4]string{
	`GGTATGCA`,
	`CTCGAAAT`,
	`ACACCTTC`,
	`TAGTGCGG`,
}
const SI_P2_G8 = [4]string{
	`TATGAGCT`,
	`CCGATAGC`,
	`ATACCCAA`,
	`GGCTGTTG`,
}
const SI_P2_G9 = [4]string{
	`TAGGACGT`,
	`ATCCCACA`,
	`GGAATGTC`,
	`CCTTGTAG`,
}
const SI_P2_H1 = [4]string{
	`GTATGTCA`,
	`TGTCAGAC`,
	`CACGTCGG`,
	`ACGACATT`,
}
const SI_P2_H10 = [4]string{
	`GTAATTGC`,
	`AGTCGCTT`,
	`CACGAGAA`,
	`TCGTCACG`,
}
const SI_P2_H11 = [4]string{
	`GGCGAGTA`,
	`ACTTCTAT`,
	`CAAATACG`,
	`TTGCGCGC`,
}
const SI_P2_H12 = [4]string{
	`GACAGCAT`,
	`TTTGTACA`,
	`AGGCCGTG`,
	`CCATATGC`,
}
const SI_P2_H2 = [4]string{
	`TAATGACC`,
	`ATGCCTTA`,
	`GCCGAGAT`,
	`CGTATCGG`,
}
const SI_P2_H3 = [4]string{
	`CCAAGATG`,
	`AGGCCCGA`,
	`TACGTGAC`,
	`GTTTATCT`,
}
const SI_P2_H4 = [4]string{
	`GCCATTCC`,
	`CAAGAATT`,
	`TTGCCGGA`,
	`AGTTGCAG`,
}
const SI_P2_H5 = [4]string{
	`CCACTACA`,
	`GATTCTGG`,
	`TGCGGCTT`,
	`ATGAAGAC`,
}
const SI_P2_H6 = [4]string{
	`TAGGATAA`,
	`CCTTTGTC`,
	`GTACGCGG`,
	`AGCACACT`,
}
const SI_P2_H7 = [4]string{
	`AGCTATCA`,
	`CATATAAC`,
	`TCAGGGTG`,
	`GTGCCCGT`,
}
const SI_P2_H8 = [4]string{
	`TTGTTGAT`,
	`GCTCAACC`,
	`CAAAGTGG`,
	`AGCGCCTA`,
}
const SI_P2_H9 = [4]string{
	`ACACTGTT`,
	`CAGGATGG`,
	`GGCTGAAC`,
	`TTTACCCA`,
}
const SI_T2_1 = [4]string{
	`GGGTGATC`,
	`TTACCGAT`,
	`AATGACGA`,
	`CCCATTCG`,
}
const SI_T2_2 = [4]string{
	`GGGTCGAA`,
	`ATCCGCCC`,
	`TCTATAGT`,
	`CAAGATTG`,
}
const SI_T2_3 = [4]string{
	`GCTGATAT`,
	`TGCCGAGC`,
	`AAATTGCG`,
	`CTGACCTA`,
}
const SI_T2_4 = [4]string{
	`ACTTCTGA`,
	`TTCATCTT`,
	`CGACGACG`,
	`GAGGAGAC`,
}
const SI_T2_5 = [4]string{
	`GAATACAA`,
	`AGCATACC`,
	`TCGGGTTT`,
	`CTTCCGGG`,
}
const SI_T2_6 = [4]string{
	`TATTGAGA`,
	`GTAGTCAG`,
	`CGCCATTC`,
	`ACGACGCT`,
}
const SI_T2_7 = [4]string{
	`AAATCTGT`,
	`GTCCAACC`,
	`TCTGGCTG`,
	`CGGATGAA`,
}
const SI_T2_8 = [4]string{
	`CCTTGAAC`,
	`GAAATCGG`,
	`TGGCCTCT`,
	`ATCGAGTA`,
}
const TARGET_MAPQ_CUTOFFS = [3]int{
	0,
	30,
	60,
}
const TRIM_QUAL_TAG = `TQ`
const TRIM_TAG = `TR`

var VARIANT_CALL_FILTER = map[string]string{
	`10X_RESCUED_MOLECULE_HIGH_DIVERSITY`: `(((RESCUED+NOT_RESCUED) > 0 & RESCUED/(RESCUED+NOT_RESCUED) > 0.1) & (MMD == -1 | MMD >= 3.0)) `,
	`10X_QUAL_FILTER`:                     `(%QUAL <= 15 || (AF[0] > 0.5 && %QUAL < 50))`,
	`10X_ALLELE_FRACTION_FILTER`:          `(AO[0] < 2 || AO[0]/(AO[0] + RO) < 0.15)`,
}
var VCF_WHITE_LIST_INFO_FIELDS = map[string]struct{}{
	`AA`:        struct{}{},
	`END`:       struct{}{},
	`AN`:        struct{}{},
	`TENX`:      struct{}{},
	`H2`:        struct{}{},
	`H3`:        struct{}{},
	`CIGAR`:     struct{}{},
	`DB`:        struct{}{},
	`SOMATIC`:   struct{}{},
	`1000G`:     struct{}{},
	`VALIDATED`: struct{}{},
}
var WHITELIST_TO_LOT_MAP = map[string]map[string][8]string{
	`884K-november-2015`: map[string][8]string{
		`GemCode Lot 18`: [8]string{
			`GCATGT`,
			`CCAACA`,
			`TCGGTA`,
			`ATCGTG`,
			`ATTCTC`,
			`CGTTAG`,
			`TTCACT`,
			`GGTTTG`,
		},
		`GemCode Lot 19`: [8]string{
			`CTTTCA`,
			`TTGTTC`,
			`TAGCCA`,
			`GCGTAT`,
			`CGTACA`,
			`CCTTCG`,
			`CACACA`,
			`TACTTC`,
		},
		`GemCode Lots 1-15`: [8]string{
			`GGGTGA`,
			`TTCATC`,
			`CACAAC`,
			`GAAGAT`,
			`CAGCAT`,
			`CGTCAA`,
			`GAAACA`,
			`TGTTTC`,
		},
		`GemCode Lot 21`: [8]string{
			`CAGATC`,
			`AATCCG`,
			`TACGTG`,
			`GAACAA`,
			`AGAGCG`,
			`CCAGAT`,
			`CGCTTC`,
			`TTATCC`,
		},
		`GemCode Lot 20`: [8]string{
			`CTTCAT`,
			`ATTCCT`,
			`GTCTCC`,
			`CAGGGA`,
			`ATCCGA`,
			`CGAATC`,
			`AAACCC`,
			`CGCTAA`,
		},
		`GemCode Lot 16`: [8]string{
			`CAAGTC`,
			`ACAAAG`,
			`CTGGAT`,
			`TTGTCT`,
			`AGCCTA`,
			`GGGAAC`,
			`TTCCTA`,
			`CCGTAA`,
		},
		`GemCode Lot 17`: [8]string{
			`AGTCCA`,
			`CAGGAG`,
			`CAATGC`,
			`CAATCG`,
			`AACAGA`,
			`TTACTC`,
			`ACTGAC`,
			`TAAGCC`,
		},
	},
	`4M-with-alts-february-2016`: map[string][8]string{
		`Chromium Lot 13`: [8]string{
			`GGCATCG`,
			`GACTGAT`,
			`TGGTGTA`,
			`TCCGTTG`,
			`CCTTCAG`,
			`CAGGCCA`,
			`GCACCGA`,
			`AGATCCA`,
		},
		`Chromium Lot 12`: [8]string{
			`CCATTAT`,
			`GTTGCGG`,
			`AGGGTAG`,
			`GCCCAAG`,
			`TGTGCCT`,
			`ATTCTTG`,
			`GGTGCCA`,
			`GTATAGC`,
		},
		`Chromium Lot 11`: [8]string{
			`ACAGTTG`,
			`TAAGCAC`,
			`ATCTTTG`,
			`TCTTGCG`,
			`TACATGG`,
			`CAAGGTT`,
			`AGGCTGC`,
			`GGTCGTG`,
		},
		`Chromium Lot 10`: [8]string{
			`CAGCACG`,
			`CATGATG`,
			`ATCAACG`,
			`GATAAGA`,
			`CTGGTTC`,
			`CGATTCC`,
			`AGGTGAG`,
			`GGCCTGA`,
		},
		`Chromium Lot 7`: [8]string{
			`TAAGCCA`,
			`TCGGTGG`,
			`AAGGTAA`,
			`GGAACAG`,
			`GTGGAAG`,
			`TTAGACG`,
			`ATCCTAT`,
			`TTCCGTG`,
		},
		`Chromium Lot 6`: [8]string{
			`ACTTGCC`,
			`GTGAGTT`,
			`GTTGTCC`,
			`CATAACG`,
			`TCGTAAG`,
			`TTATCCA`,
			`GTGGAGA`,
			`TCCTGCA`,
		},
		`Chromium Lot 5`: [8]string{
			`TAGCTCC`,
			`CAATTTC`,
			`GCTCGAG`,
			`GAAGGCA`,
			`CGGCATG`,
			`TATTCCA`,
			`TCTCTGG`,
			`AGGTACT`,
		},
		`Chromium Lot 4`: [8]string{
			`CGATCCT`,
			`TGTTGCC`,
			`ACCTATT`,
			`ACAACTG`,
			`CTGTGTC`,
			`CTGGAAT`,
			`CAGAGTT`,
			`GGGCTGT`,
		},
		`Chromium Lot 3`: [8]string{
			`ATGTGAC`,
			`GACGTCG`,
			`ACTGGCG`,
			`TGGCAAT`,
			`GAGGGTA`,
			`GTTTCGC`,
			`CAAGTGT`,
			`TTGAAGC`,
		},
		`Chromium Lot 2`: [8]string{
			`GACACTA`,
			`CCCTCTC`,
			`ATCGCGG`,
			`CTGGCAG`,
			`CCAGCTT`,
			`CATAGCA`,
			`CGTGTTC`,
			`GCACCAG`,
		},
		`Chromium Lot 1`: [8]string{
			`AGAGCGA`,
			`CGATTGA`,
			`TAGACCA`,
			`AAATGCC`,
			`CTTTGCG`,
			`TCAGCAA`,
			`CTCCTAG`,
			`ATTATCC`,
		},
		`Chromium Lot 9`: [8]string{
			`CGACACG`,
			`TCTCGTG`,
			`TGATGAC`,
			`TGCGTAA`,
			`TACCCTG`,
			`AGGTGCC`,
			`CTTGTGC`,
			`GCATGGC`,
		},
		`Chromium Lot 8`: [8]string{
			`GGTTTAG`,
			`CGTATAG`,
			`ATAGGCT`,
			`CTCTCGA`,
			`GTCTTAT`,
			`GATTGCA`,
			`TGAGCTA`,
			`ACGCGTG`,
		},
	},
}
