data {
  int<lower=0> N;
  int<lower=0> n_pair;
  int<lower=1,upper=n_pair> pair[N];
  vector[N] pre_test;
  vector[N] treatment;
  vector[N] y;
}
parameters {
  vector[2] beta;
  vector[n_pair] eta;
  real mu_a;
  real<lower=0,upper=100> sigma_a;
  real<lower=0,upper=100> sigma_y;
}
transformed parameters {
  vector[N] y_hat;
  vector[n_pair] a;

  a <- 100 * mu_a + sigma_a * eta;

  for (i in 1:N)
    y_hat[i] <- a[pair[i]] + beta[1] * treatment[i] + beta[2] * pre_test[i];
}
model {
  mu_a ~ normal(0, 1);
  beta ~ normal(0, 100);
  eta ~ normal(0, 1);

  y ~ normal(y_hat, sigma_y);
}
