#include <gtest/gtest.h>
#include <test/models/model_test_fixture.hpp>

class Models_BugsExamples_Vol1_Epil : 
  public Model_Test_Fixture<Models_BugsExamples_Vol1_Epil> {
protected:
  virtual void SetUp() {
  }
public:
  static std::vector<std::string> get_model_path() {
    std::vector<std::string> model_path;
    model_path.push_back("stan");
    model_path.push_back("example-models");
    model_path.push_back("bugs_examples");
    model_path.push_back("vol1");
    model_path.push_back("epil");
    model_path.push_back("epil");
    return model_path;
  }
  static bool has_data() {
    return true;
  }

  static bool has_init() {
    return false;
  }

  static int num_iterations() {
    return iterations;
  }

  static std::vector<int> skip_chains_test() {
    std::vector<int> params_to_skip;
    return params_to_skip;
  }

  static void populate_chains() {
    default_populate_chains();
  }

  static std::vector<std::pair<int, double> >
  get_expected_values() {
    using std::make_pair;
    std::vector<std::pair<int, double> > expected_values;
    
    expected_values.push_back(make_pair(chains->index("alpha_Age"), 0.4891));
    expected_values.push_back(make_pair(chains->index("alpha_BT"), 0.3496));
    expected_values.push_back(make_pair(chains->index("alpha_Base"), 0.8931));
    expected_values.push_back(make_pair(chains->index("alpha_Trt"), -0.9428));
    expected_values.push_back(make_pair(chains->index("alpha_V4"), -0.1027));
    expected_values.push_back(make_pair(chains->index("alpha0"), -1.435));
    expected_values.push_back(make_pair(chains->index("sigma_b"), 0.3624));
    expected_values.push_back(make_pair(chains->index("sigma_b1"), 0.4987));

    return expected_values;
  }

};

INSTANTIATE_TYPED_TEST_CASE_P(Models_BugsExamples_Vol1_Epil,
            Model_Test_Fixture,
            Models_BugsExamples_Vol1_Epil);
