// Code generated by protoc-gen-go.
// source: vtgate.proto
// DO NOT EDIT!

/*
Package vtgate is a generated protocol buffer package.

It is generated from these files:
	vtgate.proto

It has these top-level messages:
	Session
	ExecuteRequest
	ExecuteResponse
	ExecuteShardsRequest
	ExecuteShardsResponse
	ExecuteKeyspaceIdsRequest
	ExecuteKeyspaceIdsResponse
	ExecuteKeyRangesRequest
	ExecuteKeyRangesResponse
	ExecuteEntityIdsRequest
	ExecuteEntityIdsResponse
	ExecuteBatchRequest
	ExecuteBatchResponse
	BoundShardQuery
	ExecuteBatchShardsRequest
	ExecuteBatchShardsResponse
	BoundKeyspaceIdQuery
	ExecuteBatchKeyspaceIdsRequest
	ExecuteBatchKeyspaceIdsResponse
	StreamExecuteRequest
	StreamExecuteResponse
	StreamExecuteShardsRequest
	StreamExecuteShardsResponse
	StreamExecuteKeyspaceIdsRequest
	StreamExecuteKeyspaceIdsResponse
	StreamExecuteKeyRangesRequest
	StreamExecuteKeyRangesResponse
	BeginRequest
	BeginResponse
	CommitRequest
	CommitResponse
	RollbackRequest
	RollbackResponse
	ResolveTransactionRequest
	MessageStreamRequest
	MessageAckRequest
	ResolveTransactionResponse
	SplitQueryRequest
	SplitQueryResponse
	GetSrvKeyspaceRequest
	GetSrvKeyspaceResponse
	UpdateStreamRequest
	UpdateStreamResponse
*/
package vtgate

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import query "github.com/youtube/vitess/go/vt/proto/query"
import topodata "github.com/youtube/vitess/go/vt/proto/topodata"
import vtrpc "github.com/youtube/vitess/go/vt/proto/vtrpc"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Session objects are session cookies and are invalidated on
// use. Query results will contain updated session values.
// Their content should be opaque to the user.
type Session struct {
	InTransaction bool                    `protobuf:"varint,1,opt,name=in_transaction,json=inTransaction" json:"in_transaction,omitempty"`
	ShardSessions []*Session_ShardSession `protobuf:"bytes,2,rep,name=shard_sessions,json=shardSessions" json:"shard_sessions,omitempty"`
	// single_db specifies if the transaction should be restricted
	// to a single database.
	SingleDb bool `protobuf:"varint,3,opt,name=single_db,json=singleDb" json:"single_db,omitempty"`
	// autocommit specifies if the session is in autocommit mode.
	Autocommit bool `protobuf:"varint,4,opt,name=autocommit" json:"autocommit,omitempty"`
}

func (m *Session) Reset()                    { *m = Session{} }
func (m *Session) String() string            { return proto.CompactTextString(m) }
func (*Session) ProtoMessage()               {}
func (*Session) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Session) GetInTransaction() bool {
	if m != nil {
		return m.InTransaction
	}
	return false
}

func (m *Session) GetShardSessions() []*Session_ShardSession {
	if m != nil {
		return m.ShardSessions
	}
	return nil
}

func (m *Session) GetSingleDb() bool {
	if m != nil {
		return m.SingleDb
	}
	return false
}

func (m *Session) GetAutocommit() bool {
	if m != nil {
		return m.Autocommit
	}
	return false
}

type Session_ShardSession struct {
	Target        *query.Target `protobuf:"bytes,1,opt,name=target" json:"target,omitempty"`
	TransactionId int64         `protobuf:"varint,2,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *Session_ShardSession) Reset()                    { *m = Session_ShardSession{} }
func (m *Session_ShardSession) String() string            { return proto.CompactTextString(m) }
func (*Session_ShardSession) ProtoMessage()               {}
func (*Session_ShardSession) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0, 0} }

func (m *Session_ShardSession) GetTarget() *query.Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Session_ShardSession) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// ExecuteRequest is the payload to Execute.
type ExecuteRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated and should not be used.
	NotInTransaction bool `protobuf:"varint,5,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// keyspace_shard can be 'keyspace' or 'keyspace/shard'.
	KeyspaceShard string `protobuf:"bytes,6,opt,name=keyspace_shard,json=keyspaceShard" json:"keyspace_shard,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,7,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteRequest) Reset()                    { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()               {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ExecuteRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteRequest) GetKeyspaceShard() string {
	if m != nil {
		return m.KeyspaceShard
	}
	return ""
}

func (m *ExecuteRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteResponse is the returned value from Execute.
type ExecuteResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteResponse) Reset()                    { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()               {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ExecuteResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteShardsRequest is the payload to ExecuteShards.
type ExecuteShardsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to. A DML can only target one shard.
	Shards []string `protobuf:"bytes,5,rep,name=shards" json:"shards,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated and should not be used.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteShardsRequest) Reset()                    { *m = ExecuteShardsRequest{} }
func (m *ExecuteShardsRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteShardsRequest) ProtoMessage()               {}
func (*ExecuteShardsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ExecuteShardsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteShardsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteShardsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteShardsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteShardsRequest) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *ExecuteShardsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteShardsRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteShardsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteShardsResponse is the returned value from ExecuteShards.
type ExecuteShardsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteShardsResponse) Reset()                    { *m = ExecuteShardsResponse{} }
func (m *ExecuteShardsResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteShardsResponse) ProtoMessage()               {}
func (*ExecuteShardsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ExecuteShardsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteShardsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteShardsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteKeyspaceIdsRequest is the payload to ExecuteKeyspaceIds.
type ExecuteKeyspaceIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,5,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated and should not be used.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteKeyspaceIdsRequest) Reset()                    { *m = ExecuteKeyspaceIdsRequest{} }
func (m *ExecuteKeyspaceIdsRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteKeyspaceIdsRequest) ProtoMessage()               {}
func (*ExecuteKeyspaceIdsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ExecuteKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteKeyspaceIdsRequest) GetKeyspaceIds() [][]byte {
	if m != nil {
		return m.KeyspaceIds
	}
	return nil
}

func (m *ExecuteKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteKeyspaceIdsRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteKeyspaceIdsResponse is the returned value from ExecuteKeyspaceIds.
type ExecuteKeyspaceIdsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteKeyspaceIdsResponse) Reset()                    { *m = ExecuteKeyspaceIdsResponse{} }
func (m *ExecuteKeyspaceIdsResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteKeyspaceIdsResponse) ProtoMessage()               {}
func (*ExecuteKeyspaceIdsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ExecuteKeyspaceIdsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteKeyspaceIdsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyspaceIdsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteKeyRangesRequest is the payload to ExecuteKeyRanges.
type ExecuteKeyRangesRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// key_ranges contains the list of key ranges affected by this query.
	// Will be used to find the shards to send the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,5,rep,name=key_ranges,json=keyRanges" json:"key_ranges,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,6,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated and should not be used.
	NotInTransaction bool `protobuf:"varint,7,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,8,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteKeyRangesRequest) Reset()                    { *m = ExecuteKeyRangesRequest{} }
func (m *ExecuteKeyRangesRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteKeyRangesRequest) ProtoMessage()               {}
func (*ExecuteKeyRangesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ExecuteKeyRangesRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteKeyRangesRequest) GetKeyRanges() []*topodata.KeyRange {
	if m != nil {
		return m.KeyRanges
	}
	return nil
}

func (m *ExecuteKeyRangesRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteKeyRangesRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteKeyRangesRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteKeyRangesResponse is the returned value from ExecuteKeyRanges.
type ExecuteKeyRangesResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteKeyRangesResponse) Reset()                    { *m = ExecuteKeyRangesResponse{} }
func (m *ExecuteKeyRangesResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteKeyRangesResponse) ProtoMessage()               {}
func (*ExecuteKeyRangesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ExecuteKeyRangesResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteKeyRangesResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteKeyRangesResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteEntityIdsRequest is the payload to ExecuteEntityIds.
type ExecuteEntityIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,4,opt,name=keyspace" json:"keyspace,omitempty"`
	// entity_column_name is the column name to use.
	EntityColumnName string `protobuf:"bytes,5,opt,name=entity_column_name,json=entityColumnName" json:"entity_column_name,omitempty"`
	// entity_keyspace_ids are pairs of entity_column_name values
	// associated with its corresponding keyspace_id.
	EntityKeyspaceIds []*ExecuteEntityIdsRequest_EntityId `protobuf:"bytes,6,rep,name=entity_keyspace_ids,json=entityKeyspaceIds" json:"entity_keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,7,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// not_in_transaction is deprecated and should not be used.
	NotInTransaction bool `protobuf:"varint,8,opt,name=not_in_transaction,json=notInTransaction" json:"not_in_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,9,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteEntityIdsRequest) Reset()                    { *m = ExecuteEntityIdsRequest{} }
func (m *ExecuteEntityIdsRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteEntityIdsRequest) ProtoMessage()               {}
func (*ExecuteEntityIdsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ExecuteEntityIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ExecuteEntityIdsRequest) GetEntityColumnName() string {
	if m != nil {
		return m.EntityColumnName
	}
	return ""
}

func (m *ExecuteEntityIdsRequest) GetEntityKeyspaceIds() []*ExecuteEntityIdsRequest_EntityId {
	if m != nil {
		return m.EntityKeyspaceIds
	}
	return nil
}

func (m *ExecuteEntityIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteEntityIdsRequest) GetNotInTransaction() bool {
	if m != nil {
		return m.NotInTransaction
	}
	return false
}

func (m *ExecuteEntityIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

type ExecuteEntityIdsRequest_EntityId struct {
	// type is the type of the entity's value. Can be NULL_TYPE.
	Type query.Type `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	// value is the value for the entity. Not set if type is NULL_TYPE.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// keyspace_id is the associated keyspace_id for the entity.
	KeyspaceId []byte `protobuf:"bytes,3,opt,name=keyspace_id,json=keyspaceId,proto3" json:"keyspace_id,omitempty"`
}

func (m *ExecuteEntityIdsRequest_EntityId) Reset()         { *m = ExecuteEntityIdsRequest_EntityId{} }
func (m *ExecuteEntityIdsRequest_EntityId) String() string { return proto.CompactTextString(m) }
func (*ExecuteEntityIdsRequest_EntityId) ProtoMessage()    {}
func (*ExecuteEntityIdsRequest_EntityId) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{9, 0}
}

func (m *ExecuteEntityIdsRequest_EntityId) GetType() query.Type {
	if m != nil {
		return m.Type
	}
	return query.Type_NULL_TYPE
}

func (m *ExecuteEntityIdsRequest_EntityId) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *ExecuteEntityIdsRequest_EntityId) GetKeyspaceId() []byte {
	if m != nil {
		return m.KeyspaceId
	}
	return nil
}

// ExecuteEntityIdsResponse is the returned value from ExecuteEntityIds.
type ExecuteEntityIdsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *query.QueryResult `protobuf:"bytes,3,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteEntityIdsResponse) Reset()                    { *m = ExecuteEntityIdsResponse{} }
func (m *ExecuteEntityIdsResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteEntityIdsResponse) ProtoMessage()               {}
func (*ExecuteEntityIdsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ExecuteEntityIdsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteEntityIdsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteEntityIdsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch.
type ExecuteBatchRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// queries is a list of query and bind variables to execute.
	Queries []*query.BoundQuery `protobuf:"bytes,3,rep,name=queries" json:"queries,omitempty"`
	// tablet_type is the type of tablets that these queries is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// as_transaction is deprecated.
	// We cannot use the proto3 deprecated feature yet because
	// the php compiler doesn't recognize that construct.
	AsTransaction bool `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	// keyspace_shard can be 'keyspace' or 'keyspace/shard'.
	KeyspaceShard string `protobuf:"bytes,6,opt,name=keyspace_shard,json=keyspaceShard" json:"keyspace_shard,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,7,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteBatchRequest) Reset()                    { *m = ExecuteBatchRequest{} }
func (m *ExecuteBatchRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchRequest) ProtoMessage()               {}
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ExecuteBatchRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchRequest) GetQueries() []*query.BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchRequest) GetKeyspaceShard() string {
	if m != nil {
		return m.KeyspaceShard
	}
	return ""
}

func (m *ExecuteBatchRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch.
type ExecuteBatchResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// results contains the query results, only set if application level error is unset.
	Results []*query.ResultWithError `protobuf:"bytes,3,rep,name=results" json:"results,omitempty"`
}

func (m *ExecuteBatchResponse) Reset()                    { *m = ExecuteBatchResponse{} }
func (m *ExecuteBatchResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchResponse) ProtoMessage()               {}
func (*ExecuteBatchResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ExecuteBatchResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteBatchResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchResponse) GetResults() []*query.ResultWithError {
	if m != nil {
		return m.Results
	}
	return nil
}

// BoundShardQuery represents a single query request for the
// specified list of shards. This is used in a list for
// ExecuteBatchShardsRequest.
type BoundShardQuery struct {
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to. A DML can only target one shard.
	Shards []string `protobuf:"bytes,3,rep,name=shards" json:"shards,omitempty"`
}

func (m *BoundShardQuery) Reset()                    { *m = BoundShardQuery{} }
func (m *BoundShardQuery) String() string            { return proto.CompactTextString(m) }
func (*BoundShardQuery) ProtoMessage()               {}
func (*BoundShardQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *BoundShardQuery) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BoundShardQuery) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *BoundShardQuery) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

// ExecuteBatchShardsRequest is the payload to ExecuteBatchShards
type ExecuteBatchShardsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// queries carries all the queries to execute.
	Queries []*BoundShardQuery `protobuf:"bytes,3,rep,name=queries" json:"queries,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// as_transaction will execute the queries in this batch in a single transaction per shard, created for this purpose.
	// (this can be seen as adding a 'begin' before and 'commit' after the queries).
	// Only makes sense if tablet_type is master. If set, the Session is ignored.
	AsTransaction bool `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteBatchShardsRequest) Reset()                    { *m = ExecuteBatchShardsRequest{} }
func (m *ExecuteBatchShardsRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchShardsRequest) ProtoMessage()               {}
func (*ExecuteBatchShardsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ExecuteBatchShardsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteBatchShardsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchShardsRequest) GetQueries() []*BoundShardQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchShardsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteBatchShardsRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchShardsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchShardsResponse is the returned value from ExecuteBatchShards.
type ExecuteBatchShardsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Results []*query.QueryResult `protobuf:"bytes,3,rep,name=results" json:"results,omitempty"`
}

func (m *ExecuteBatchShardsResponse) Reset()                    { *m = ExecuteBatchShardsResponse{} }
func (m *ExecuteBatchShardsResponse) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchShardsResponse) ProtoMessage()               {}
func (*ExecuteBatchShardsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ExecuteBatchShardsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteBatchShardsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchShardsResponse) GetResults() []*query.QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// BoundKeyspaceIdQuery represents a single query request for the
// specified list of keyspace ids. This is used in a list for
// ExecuteBatchKeyspaceIdsRequest.
type BoundKeyspaceIdQuery struct {
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,3,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
}

func (m *BoundKeyspaceIdQuery) Reset()                    { *m = BoundKeyspaceIdQuery{} }
func (m *BoundKeyspaceIdQuery) String() string            { return proto.CompactTextString(m) }
func (*BoundKeyspaceIdQuery) ProtoMessage()               {}
func (*BoundKeyspaceIdQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *BoundKeyspaceIdQuery) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BoundKeyspaceIdQuery) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *BoundKeyspaceIdQuery) GetKeyspaceIds() [][]byte {
	if m != nil {
		return m.KeyspaceIds
	}
	return nil
}

// ExecuteBatchKeyspaceIdsRequest is the payload to ExecuteBatchKeyspaceId.
type ExecuteBatchKeyspaceIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data. It is returned by Begin.
	// Do not fill it in if outside of a transaction.
	Session *Session                `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	Queries []*BoundKeyspaceIdQuery `protobuf:"bytes,3,rep,name=queries" json:"queries,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,4,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// as_transaction will execute the queries in this batch in a single transaction per shard, created for this purpose.
	// (this can be seen as adding a 'begin' before and 'commit' after the queries).
	// Only makes sense if tablet_type is master. If set, the Session is ignored.
	AsTransaction bool `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteBatchKeyspaceIdsRequest) Reset()                    { *m = ExecuteBatchKeyspaceIdsRequest{} }
func (m *ExecuteBatchKeyspaceIdsRequest) String() string            { return proto.CompactTextString(m) }
func (*ExecuteBatchKeyspaceIdsRequest) ProtoMessage()               {}
func (*ExecuteBatchKeyspaceIdsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ExecuteBatchKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetQueries() []*BoundKeyspaceIdQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchKeyspaceIdsResponse is the returned value from ExecuteBatchKeyspaceId.
type ExecuteBatchKeyspaceIdsResponse struct {
	// error contains an application level error if necessary. Note the
	// session may have changed, even when an error is returned (for
	// instance if a database integrity error happened).
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// session is the updated session information (only returned inside a transaction).
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// result contains the query result, only set if error is unset.
	Results []*query.QueryResult `protobuf:"bytes,3,rep,name=results" json:"results,omitempty"`
}

func (m *ExecuteBatchKeyspaceIdsResponse) Reset()         { *m = ExecuteBatchKeyspaceIdsResponse{} }
func (m *ExecuteBatchKeyspaceIdsResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchKeyspaceIdsResponse) ProtoMessage()    {}
func (*ExecuteBatchKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18}
}

func (m *ExecuteBatchKeyspaceIdsResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *ExecuteBatchKeyspaceIdsResponse) GetResults() []*query.QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute.
type StreamExecuteRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// keyspace_shard can be 'keyspace' or 'keyspace/shard'.
	KeyspaceShard string `protobuf:"bytes,4,opt,name=keyspace_shard,json=keyspaceShard" json:"keyspace_shard,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,5,opt,name=options" json:"options,omitempty"`
}

func (m *StreamExecuteRequest) Reset()                    { *m = StreamExecuteRequest{} }
func (m *StreamExecuteRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteRequest) ProtoMessage()               {}
func (*StreamExecuteRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *StreamExecuteRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteRequest) GetKeyspaceShard() string {
	if m != nil {
		return m.KeyspaceShard
	}
	return ""
}

func (m *StreamExecuteRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteResponse is the returned value from StreamExecute.
type StreamExecuteResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *StreamExecuteResponse) Reset()                    { *m = StreamExecuteResponse{} }
func (m *StreamExecuteResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteResponse) ProtoMessage()               {}
func (*StreamExecuteResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *StreamExecuteResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// StreamExecuteShardsRequest is the payload to StreamExecuteShards.
type StreamExecuteShardsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to.
	Shards []string `protobuf:"bytes,4,rep,name=shards" json:"shards,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *StreamExecuteShardsRequest) Reset()                    { *m = StreamExecuteShardsRequest{} }
func (m *StreamExecuteShardsRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteShardsRequest) ProtoMessage()               {}
func (*StreamExecuteShardsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *StreamExecuteShardsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteShardsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteShardsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *StreamExecuteShardsRequest) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *StreamExecuteShardsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteShardsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteShardsResponse is the returned value from StreamExecuteShards.
type StreamExecuteShardsResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *StreamExecuteShardsResponse) Reset()                    { *m = StreamExecuteShardsResponse{} }
func (m *StreamExecuteShardsResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteShardsResponse) ProtoMessage()               {}
func (*StreamExecuteShardsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *StreamExecuteShardsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// StreamExecuteKeyspaceIdsRequest is the payload to StreamExecuteKeyspaceIds.
type StreamExecuteKeyspaceIdsRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
	// keyspace_ids contains the list of keyspace_ids affected by this query.
	// Will be used to find the shards to send the query to.
	KeyspaceIds [][]byte `protobuf:"bytes,4,rep,name=keyspace_ids,json=keyspaceIds,proto3" json:"keyspace_ids,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *StreamExecuteKeyspaceIdsRequest) Reset()         { *m = StreamExecuteKeyspaceIdsRequest{} }
func (m *StreamExecuteKeyspaceIdsRequest) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteKeyspaceIdsRequest) ProtoMessage()    {}
func (*StreamExecuteKeyspaceIdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{23}
}

func (m *StreamExecuteKeyspaceIdsRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteKeyspaceIdsRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteKeyspaceIdsRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *StreamExecuteKeyspaceIdsRequest) GetKeyspaceIds() [][]byte {
	if m != nil {
		return m.KeyspaceIds
	}
	return nil
}

func (m *StreamExecuteKeyspaceIdsRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteKeyspaceIdsRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteKeyspaceIdsResponse is the returned value from StreamExecuteKeyspaceIds.
type StreamExecuteKeyspaceIdsResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *StreamExecuteKeyspaceIdsResponse) Reset()         { *m = StreamExecuteKeyspaceIdsResponse{} }
func (m *StreamExecuteKeyspaceIdsResponse) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteKeyspaceIdsResponse) ProtoMessage()    {}
func (*StreamExecuteKeyspaceIdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{24}
}

func (m *StreamExecuteKeyspaceIdsResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// StreamExecuteKeyRangesRequest is the payload to StreamExecuteKeyRanges.
type StreamExecuteKeyRangesRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
	// key_ranges contains the list of key ranges affected by this query.
	// Will be used to find the shards to send the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,4,rep,name=key_ranges,json=keyRanges" json:"key_ranges,omitempty"`
	// tablet_type is the type of tablets that this query is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// options
	Options *query.ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *StreamExecuteKeyRangesRequest) Reset()                    { *m = StreamExecuteKeyRangesRequest{} }
func (m *StreamExecuteKeyRangesRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteKeyRangesRequest) ProtoMessage()               {}
func (*StreamExecuteKeyRangesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *StreamExecuteKeyRangesRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *StreamExecuteKeyRangesRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteKeyRangesRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *StreamExecuteKeyRangesRequest) GetKeyRanges() []*topodata.KeyRange {
	if m != nil {
		return m.KeyRanges
	}
	return nil
}

func (m *StreamExecuteKeyRangesRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *StreamExecuteKeyRangesRequest) GetOptions() *query.ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteKeyRangesResponse is the returned value from StreamExecuteKeyRanges.
type StreamExecuteKeyRangesResponse struct {
	// result contains the result data.
	// The first value contains only Fields information.
	// The next values contain the actual rows, a few values per result.
	Result *query.QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *StreamExecuteKeyRangesResponse) Reset()                    { *m = StreamExecuteKeyRangesResponse{} }
func (m *StreamExecuteKeyRangesResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamExecuteKeyRangesResponse) ProtoMessage()               {}
func (*StreamExecuteKeyRangesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *StreamExecuteKeyRangesResponse) GetResult() *query.QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// BeginRequest is the payload to Begin.
type BeginRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// single_db specifies if the transaction should be restricted
	// to a single database.
	SingleDb bool `protobuf:"varint,2,opt,name=single_db,json=singleDb" json:"single_db,omitempty"`
}

func (m *BeginRequest) Reset()                    { *m = BeginRequest{} }
func (m *BeginRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginRequest) ProtoMessage()               {}
func (*BeginRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *BeginRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *BeginRequest) GetSingleDb() bool {
	if m != nil {
		return m.SingleDb
	}
	return false
}

// BeginResponse is the returned value from Begin.
type BeginResponse struct {
	// session is the initial session information to use for subsequent queries.
	Session *Session `protobuf:"bytes,1,opt,name=session" json:"session,omitempty"`
}

func (m *BeginResponse) Reset()                    { *m = BeginResponse{} }
func (m *BeginResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginResponse) ProtoMessage()               {}
func (*BeginResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *BeginResponse) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

// CommitRequest is the payload to Commit.
type CommitRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data to commit.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
	// atomic specifies if the commit should go through the
	// 2PC workflow to ensure atomicity.
	Atomic bool `protobuf:"varint,3,opt,name=atomic" json:"atomic,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()               {}
func (*CommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *CommitRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *CommitRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

func (m *CommitRequest) GetAtomic() bool {
	if m != nil {
		return m.Atomic
	}
	return false
}

// CommitResponse is the returned value from Commit.
type CommitResponse struct {
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()               {}
func (*CommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

// RollbackRequest is the payload to Rollback.
type RollbackRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// session carries the current transaction data to rollback.
	Session *Session `protobuf:"bytes,2,opt,name=session" json:"session,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()               {}
func (*RollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *RollbackRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *RollbackRequest) GetSession() *Session {
	if m != nil {
		return m.Session
	}
	return nil
}

// RollbackResponse is the returned value from Rollback.
type RollbackResponse struct {
}

func (m *RollbackResponse) Reset()                    { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string            { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()               {}
func (*RollbackResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

// ResolveTransactionRequest is the payload to ResolveTransaction.
type ResolveTransactionRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// dtid is the dtid of the transaction to be resolved.
	Dtid string `protobuf:"bytes,2,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *ResolveTransactionRequest) Reset()                    { *m = ResolveTransactionRequest{} }
func (m *ResolveTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*ResolveTransactionRequest) ProtoMessage()               {}
func (*ResolveTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *ResolveTransactionRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *ResolveTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// MessageStreamRequest is the request payload for MessageStream.
type MessageStreamRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// shard to target the query to, for unsharded keyspaces.
	Shard string `protobuf:"bytes,3,opt,name=shard" json:"shard,omitempty"`
	// KeyRange to target the query to, for sharded keyspaces.
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,5,opt,name=name" json:"name,omitempty"`
}

func (m *MessageStreamRequest) Reset()                    { *m = MessageStreamRequest{} }
func (m *MessageStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*MessageStreamRequest) ProtoMessage()               {}
func (*MessageStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *MessageStreamRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *MessageStreamRequest) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *MessageStreamRequest) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *MessageStreamRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// MessageAckRequest is the request payload for MessageAck.
type MessageAckRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// Optional keyspace for message table.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// ids is the list of ids to ack.
	Ids []*query.Value `protobuf:"bytes,4,rep,name=ids" json:"ids,omitempty"`
}

func (m *MessageAckRequest) Reset()                    { *m = MessageAckRequest{} }
func (m *MessageAckRequest) String() string            { return proto.CompactTextString(m) }
func (*MessageAckRequest) ProtoMessage()               {}
func (*MessageAckRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *MessageAckRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *MessageAckRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *MessageAckRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MessageAckRequest) GetIds() []*query.Value {
	if m != nil {
		return m.Ids
	}
	return nil
}

// ResolveTransactionResponse is the returned value from Rollback.
type ResolveTransactionResponse struct {
}

func (m *ResolveTransactionResponse) Reset()                    { *m = ResolveTransactionResponse{} }
func (m *ResolveTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*ResolveTransactionResponse) ProtoMessage()               {}
func (*ResolveTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

// SplitQueryRequest is the payload to SplitQuery.
//
// SplitQuery takes a "SELECT" query and generates a list of queries called
// "query-parts". Each query-part consists of the original query with an
// added WHERE clause that restricts the query-part to operate only on
// rows whose values in the the columns listed in the "split_column" field
// of the request (see below) are in a particular range.
//
// It is guaranteed that the set of rows obtained from
// executing each query-part on a database snapshot
// and merging (without deduping) the results is equal to the set of rows
// obtained from executing the original query on the same snapshot
// with the rows containing NULL values in any of the split_column's excluded.
//
// This is typically called by the MapReduce master when reading from Vitess.
// There it's desirable that the sets of rows returned by the query-parts
// have roughly the same size.
type SplitQueryRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// The query and bind variables to produce splits for.
	// The given query must be a simple query of the form
	// SELECT <cols> FROM <table> WHERE <filter>.
	// It must not contain subqueries nor any of the keywords
	// JOIN, GROUP BY, ORDER BY, LIMIT, DISTINCT.
	// Furthermore, <table> must be a single “concrete” table.
	// It cannot be a view.
	Query *query.BoundQuery `protobuf:"bytes,3,opt,name=query" json:"query,omitempty"`
	// Each generated query-part will be restricted to rows whose values
	// in the columns listed in this field are in a particular range.
	// The list of columns named here must be a prefix of the list of
	// columns defining some index or primary key of the table
	// referenced in 'query'. For many tables using the primary key columns
	// (in order) is sufficient and this is the default if this field is omitted.
	// See the comment on the 'algorithm' field for more restrictions and
	// information.
	SplitColumn []string `protobuf:"bytes,4,rep,name=split_column,json=splitColumn" json:"split_column,omitempty"`
	// You can specify either an estimate of the number of query-parts to
	// generate or an estimate of the number of rows each query-part should
	// return.
	// Thus, exactly one of split_count or num_rows_per_query_part
	// should be nonzero.
	// The non-given parameter is calculated from the given parameter
	// using the formula: split_count * num_rows_per_query_pary = table_size,
	// where table_size is an approximation of the number of rows in the
	// table.
	// Note that if "split_count" is given it is regarded as an estimate.
	// The number of query-parts returned may differ slightly (in particular,
	// if it's not a whole multiple of the number of vitess shards).
	SplitCount          int64 `protobuf:"varint,5,opt,name=split_count,json=splitCount" json:"split_count,omitempty"`
	NumRowsPerQueryPart int64 `protobuf:"varint,6,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart" json:"num_rows_per_query_part,omitempty"`
	// The algorithm to use to split the query. The split algorithm is performed
	// on each database shard in parallel. The lists of query-parts generated
	// by the shards are merged and returned to the caller.
	// Two algorithms are supported:
	//  EQUAL_SPLITS
	//    If this algorithm is selected then only the first 'split_column' given
	//    is used (or the first primary key column if the 'split_column' field is
	//    empty). In the rest of this algorithm's description, we refer to
	//    this column as "the split column".
	//    The split column must have numeric type (integral or floating point).
	//    The algorithm works by taking the interval [min, max], where min and
	//    max are the minimum and maximum values of the split column in
	//    the table-shard, respectively, and partitioning it into 'split_count'
	//    sub-intervals of equal size. The added WHERE clause of each query-part
	//    restricts that part to rows whose value in the split column belongs to
	//    a particular sub-interval. This is fast, but requires that the
	//    distribution of values of the split column be uniform in [min, max]
	//    for the number of rows returned by each query part to be roughly the
	//    same.
	//  FULL_SCAN
	//    If this algorithm is used then the split_column must be the primary key
	//    columns (in order).
	//    This algorithm performs a full-scan of the table-shard referenced
	//    in 'query' to get "boundary" rows that are num_rows_per_query_part
	//    apart when the table is ordered by the columns listed in
	//    'split_column'. It then restricts each query-part to the rows
	//    located between two successive boundary rows.
	//    This algorithm supports multiple split_column's of any type,
	//    but is slower than EQUAL_SPLITS.
	Algorithm query.SplitQueryRequest_Algorithm `protobuf:"varint,7,opt,name=algorithm,enum=query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
	// TODO(erez): This field is no longer used by the server code.
	// Remove this field after this new server code is released to prod.
	// We must keep it for now, so that clients can still send it to the old
	// server code currently in production.
	UseSplitQueryV2 bool `protobuf:"varint,8,opt,name=use_split_query_v2,json=useSplitQueryV2" json:"use_split_query_v2,omitempty"`
}

func (m *SplitQueryRequest) Reset()                    { *m = SplitQueryRequest{} }
func (m *SplitQueryRequest) String() string            { return proto.CompactTextString(m) }
func (*SplitQueryRequest) ProtoMessage()               {}
func (*SplitQueryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *SplitQueryRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *SplitQueryRequest) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitColumn() []string {
	if m != nil {
		return m.SplitColumn
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitCount() int64 {
	if m != nil {
		return m.SplitCount
	}
	return 0
}

func (m *SplitQueryRequest) GetNumRowsPerQueryPart() int64 {
	if m != nil {
		return m.NumRowsPerQueryPart
	}
	return 0
}

func (m *SplitQueryRequest) GetAlgorithm() query.SplitQueryRequest_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return query.SplitQueryRequest_EQUAL_SPLITS
}

func (m *SplitQueryRequest) GetUseSplitQueryV2() bool {
	if m != nil {
		return m.UseSplitQueryV2
	}
	return false
}

// SplitQueryResponse is the returned value from SplitQuery.
type SplitQueryResponse struct {
	// splits contains the queries to run to fetch the entire data set.
	Splits []*SplitQueryResponse_Part `protobuf:"bytes,1,rep,name=splits" json:"splits,omitempty"`
}

func (m *SplitQueryResponse) Reset()                    { *m = SplitQueryResponse{} }
func (m *SplitQueryResponse) String() string            { return proto.CompactTextString(m) }
func (*SplitQueryResponse) ProtoMessage()               {}
func (*SplitQueryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *SplitQueryResponse) GetSplits() []*SplitQueryResponse_Part {
	if m != nil {
		return m.Splits
	}
	return nil
}

type SplitQueryResponse_KeyRangePart struct {
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	// key ranges to target the query to.
	KeyRanges []*topodata.KeyRange `protobuf:"bytes,2,rep,name=key_ranges,json=keyRanges" json:"key_ranges,omitempty"`
}

func (m *SplitQueryResponse_KeyRangePart) Reset()         { *m = SplitQueryResponse_KeyRangePart{} }
func (m *SplitQueryResponse_KeyRangePart) String() string { return proto.CompactTextString(m) }
func (*SplitQueryResponse_KeyRangePart) ProtoMessage()    {}
func (*SplitQueryResponse_KeyRangePart) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{38, 0}
}

func (m *SplitQueryResponse_KeyRangePart) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *SplitQueryResponse_KeyRangePart) GetKeyRanges() []*topodata.KeyRange {
	if m != nil {
		return m.KeyRanges
	}
	return nil
}

type SplitQueryResponse_ShardPart struct {
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	// shards to target the query to.
	Shards []string `protobuf:"bytes,2,rep,name=shards" json:"shards,omitempty"`
}

func (m *SplitQueryResponse_ShardPart) Reset()         { *m = SplitQueryResponse_ShardPart{} }
func (m *SplitQueryResponse_ShardPart) String() string { return proto.CompactTextString(m) }
func (*SplitQueryResponse_ShardPart) ProtoMessage()    {}
func (*SplitQueryResponse_ShardPart) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{38, 1}
}

func (m *SplitQueryResponse_ShardPart) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *SplitQueryResponse_ShardPart) GetShards() []string {
	if m != nil {
		return m.Shards
	}
	return nil
}

type SplitQueryResponse_Part struct {
	// query is the query and bind variables to execute.
	Query *query.BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// key_range_part is set if the query should be executed by
	// ExecuteKeyRanges.
	KeyRangePart *SplitQueryResponse_KeyRangePart `protobuf:"bytes,2,opt,name=key_range_part,json=keyRangePart" json:"key_range_part,omitempty"`
	// shard_part is set if the query should be executed by ExecuteShards.
	ShardPart *SplitQueryResponse_ShardPart `protobuf:"bytes,3,opt,name=shard_part,json=shardPart" json:"shard_part,omitempty"`
	// size is the approximate number of rows this query will return.
	Size int64 `protobuf:"varint,4,opt,name=size" json:"size,omitempty"`
}

func (m *SplitQueryResponse_Part) Reset()                    { *m = SplitQueryResponse_Part{} }
func (m *SplitQueryResponse_Part) String() string            { return proto.CompactTextString(m) }
func (*SplitQueryResponse_Part) ProtoMessage()               {}
func (*SplitQueryResponse_Part) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38, 2} }

func (m *SplitQueryResponse_Part) GetQuery() *query.BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SplitQueryResponse_Part) GetKeyRangePart() *SplitQueryResponse_KeyRangePart {
	if m != nil {
		return m.KeyRangePart
	}
	return nil
}

func (m *SplitQueryResponse_Part) GetShardPart() *SplitQueryResponse_ShardPart {
	if m != nil {
		return m.ShardPart
	}
	return nil
}

func (m *SplitQueryResponse_Part) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

// GetSrvKeyspaceRequest is the payload to GetSrvKeyspace.
type GetSrvKeyspaceRequest struct {
	// keyspace name to fetch.
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
}

func (m *GetSrvKeyspaceRequest) Reset()                    { *m = GetSrvKeyspaceRequest{} }
func (m *GetSrvKeyspaceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSrvKeyspaceRequest) ProtoMessage()               {}
func (*GetSrvKeyspaceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *GetSrvKeyspaceRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

// GetSrvKeyspaceResponse is the returned value from GetSrvKeyspace.
type GetSrvKeyspaceResponse struct {
	// srv_keyspace is the topology object for the SrvKeyspace.
	SrvKeyspace *topodata.SrvKeyspace `protobuf:"bytes,1,opt,name=srv_keyspace,json=srvKeyspace" json:"srv_keyspace,omitempty"`
}

func (m *GetSrvKeyspaceResponse) Reset()                    { *m = GetSrvKeyspaceResponse{} }
func (m *GetSrvKeyspaceResponse) String() string            { return proto.CompactTextString(m) }
func (*GetSrvKeyspaceResponse) ProtoMessage()               {}
func (*GetSrvKeyspaceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *GetSrvKeyspaceResponse) GetSrvKeyspace() *topodata.SrvKeyspace {
	if m != nil {
		return m.SrvKeyspace
	}
	return nil
}

// UpdateStreamRequest is the payload to UpdateStream.
type UpdateStreamRequest struct {
	// caller_id identifies the caller. This is the effective caller ID,
	// set by the application to further identify the caller.
	CallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=caller_id,json=callerId" json:"caller_id,omitempty"`
	// keyspace to target the query to.
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// shard to target the query to, for unsharded keyspaces.
	Shard string `protobuf:"bytes,3,opt,name=shard" json:"shard,omitempty"`
	// KeyRange to target the query to, for sharded keyspaces.
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// tablet_type is the type of tablets that this request is targeted to.
	TabletType topodata.TabletType `protobuf:"varint,5,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// timestamp is the timestamp to start the stream from.  It is
	// unused is event is set, and we are only streaming from the shard
	// described by event.shard.
	Timestamp int64 `protobuf:"varint,6,opt,name=timestamp" json:"timestamp,omitempty"`
	// event is the event to start the stream from.
	// Note it is only used if we are streaming from exactly the same shard
	// as this event was coming from. Otherwise we can't use this event,
	// and will use the timestamp as a starting point.
	Event *query.EventToken `protobuf:"bytes,7,opt,name=event" json:"event,omitempty"`
}

func (m *UpdateStreamRequest) Reset()                    { *m = UpdateStreamRequest{} }
func (m *UpdateStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateStreamRequest) ProtoMessage()               {}
func (*UpdateStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *UpdateStreamRequest) GetCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.CallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *UpdateStreamRequest) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *UpdateStreamRequest) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *UpdateStreamRequest) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *UpdateStreamRequest) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *UpdateStreamRequest) GetEvent() *query.EventToken {
	if m != nil {
		return m.Event
	}
	return nil
}

// UpdateStreamResponse is streamed by UpdateStream.
type UpdateStreamResponse struct {
	// event is one event from the stream.
	Event *query.StreamEvent `protobuf:"bytes,1,opt,name=event" json:"event,omitempty"`
	// resume_timestamp is the timestamp to resume streaming from if the
	// client is interrupted. If the Update Stream only goes to one
	// shard, this is equal to event.timestamp. If the Update Stream
	// goes to multiple shards and aggregates, this is the minimum value
	// of the current timestamp for all shards.
	ResumeTimestamp int64 `protobuf:"varint,2,opt,name=resume_timestamp,json=resumeTimestamp" json:"resume_timestamp,omitempty"`
}

func (m *UpdateStreamResponse) Reset()                    { *m = UpdateStreamResponse{} }
func (m *UpdateStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateStreamResponse) ProtoMessage()               {}
func (*UpdateStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *UpdateStreamResponse) GetEvent() *query.StreamEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *UpdateStreamResponse) GetResumeTimestamp() int64 {
	if m != nil {
		return m.ResumeTimestamp
	}
	return 0
}

func init() {
	proto.RegisterType((*Session)(nil), "vtgate.Session")
	proto.RegisterType((*Session_ShardSession)(nil), "vtgate.Session.ShardSession")
	proto.RegisterType((*ExecuteRequest)(nil), "vtgate.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "vtgate.ExecuteResponse")
	proto.RegisterType((*ExecuteShardsRequest)(nil), "vtgate.ExecuteShardsRequest")
	proto.RegisterType((*ExecuteShardsResponse)(nil), "vtgate.ExecuteShardsResponse")
	proto.RegisterType((*ExecuteKeyspaceIdsRequest)(nil), "vtgate.ExecuteKeyspaceIdsRequest")
	proto.RegisterType((*ExecuteKeyspaceIdsResponse)(nil), "vtgate.ExecuteKeyspaceIdsResponse")
	proto.RegisterType((*ExecuteKeyRangesRequest)(nil), "vtgate.ExecuteKeyRangesRequest")
	proto.RegisterType((*ExecuteKeyRangesResponse)(nil), "vtgate.ExecuteKeyRangesResponse")
	proto.RegisterType((*ExecuteEntityIdsRequest)(nil), "vtgate.ExecuteEntityIdsRequest")
	proto.RegisterType((*ExecuteEntityIdsRequest_EntityId)(nil), "vtgate.ExecuteEntityIdsRequest.EntityId")
	proto.RegisterType((*ExecuteEntityIdsResponse)(nil), "vtgate.ExecuteEntityIdsResponse")
	proto.RegisterType((*ExecuteBatchRequest)(nil), "vtgate.ExecuteBatchRequest")
	proto.RegisterType((*ExecuteBatchResponse)(nil), "vtgate.ExecuteBatchResponse")
	proto.RegisterType((*BoundShardQuery)(nil), "vtgate.BoundShardQuery")
	proto.RegisterType((*ExecuteBatchShardsRequest)(nil), "vtgate.ExecuteBatchShardsRequest")
	proto.RegisterType((*ExecuteBatchShardsResponse)(nil), "vtgate.ExecuteBatchShardsResponse")
	proto.RegisterType((*BoundKeyspaceIdQuery)(nil), "vtgate.BoundKeyspaceIdQuery")
	proto.RegisterType((*ExecuteBatchKeyspaceIdsRequest)(nil), "vtgate.ExecuteBatchKeyspaceIdsRequest")
	proto.RegisterType((*ExecuteBatchKeyspaceIdsResponse)(nil), "vtgate.ExecuteBatchKeyspaceIdsResponse")
	proto.RegisterType((*StreamExecuteRequest)(nil), "vtgate.StreamExecuteRequest")
	proto.RegisterType((*StreamExecuteResponse)(nil), "vtgate.StreamExecuteResponse")
	proto.RegisterType((*StreamExecuteShardsRequest)(nil), "vtgate.StreamExecuteShardsRequest")
	proto.RegisterType((*StreamExecuteShardsResponse)(nil), "vtgate.StreamExecuteShardsResponse")
	proto.RegisterType((*StreamExecuteKeyspaceIdsRequest)(nil), "vtgate.StreamExecuteKeyspaceIdsRequest")
	proto.RegisterType((*StreamExecuteKeyspaceIdsResponse)(nil), "vtgate.StreamExecuteKeyspaceIdsResponse")
	proto.RegisterType((*StreamExecuteKeyRangesRequest)(nil), "vtgate.StreamExecuteKeyRangesRequest")
	proto.RegisterType((*StreamExecuteKeyRangesResponse)(nil), "vtgate.StreamExecuteKeyRangesResponse")
	proto.RegisterType((*BeginRequest)(nil), "vtgate.BeginRequest")
	proto.RegisterType((*BeginResponse)(nil), "vtgate.BeginResponse")
	proto.RegisterType((*CommitRequest)(nil), "vtgate.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "vtgate.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "vtgate.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "vtgate.RollbackResponse")
	proto.RegisterType((*ResolveTransactionRequest)(nil), "vtgate.ResolveTransactionRequest")
	proto.RegisterType((*MessageStreamRequest)(nil), "vtgate.MessageStreamRequest")
	proto.RegisterType((*MessageAckRequest)(nil), "vtgate.MessageAckRequest")
	proto.RegisterType((*ResolveTransactionResponse)(nil), "vtgate.ResolveTransactionResponse")
	proto.RegisterType((*SplitQueryRequest)(nil), "vtgate.SplitQueryRequest")
	proto.RegisterType((*SplitQueryResponse)(nil), "vtgate.SplitQueryResponse")
	proto.RegisterType((*SplitQueryResponse_KeyRangePart)(nil), "vtgate.SplitQueryResponse.KeyRangePart")
	proto.RegisterType((*SplitQueryResponse_ShardPart)(nil), "vtgate.SplitQueryResponse.ShardPart")
	proto.RegisterType((*SplitQueryResponse_Part)(nil), "vtgate.SplitQueryResponse.Part")
	proto.RegisterType((*GetSrvKeyspaceRequest)(nil), "vtgate.GetSrvKeyspaceRequest")
	proto.RegisterType((*GetSrvKeyspaceResponse)(nil), "vtgate.GetSrvKeyspaceResponse")
	proto.RegisterType((*UpdateStreamRequest)(nil), "vtgate.UpdateStreamRequest")
	proto.RegisterType((*UpdateStreamResponse)(nil), "vtgate.UpdateStreamResponse")
}

func init() { proto.RegisterFile("vtgate.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1671 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5a, 0x4b, 0x6f, 0xdb, 0xc6,
	0x16, 0x06, 0x49, 0x3d, 0x8f, 0x1e, 0xb6, 0xc7, 0xb2, 0xa3, 0x28, 0xbe, 0xb6, 0x43, 0x5c, 0x23,
	0xce, 0x8d, 0xa1, 0xdc, 0x38, 0xf7, 0x85, 0xbb, 0xb9, 0x37, 0x76, 0x8c, 0x0b, 0x23, 0x37, 0x69,
	0x3a, 0x76, 0xd3, 0x16, 0x68, 0x40, 0xd0, 0xd2, 0xc0, 0x66, 0x25, 0x91, 0x0a, 0x67, 0xa8, 0xd4,
	0x5d, 0x14, 0xf9, 0x07, 0x69, 0x17, 0x05, 0x8a, 0xa0, 0x40, 0x51, 0xa0, 0xdb, 0x6e, 0x0b, 0x14,
	0xdd, 0x74, 0xd7, 0x65, 0xd1, 0x55, 0xf7, 0xfd, 0x03, 0x05, 0xba, 0xee, 0xa2, 0xe0, 0xcc, 0xf0,
	0x21, 0xda, 0x92, 0x65, 0xf9, 0x01, 0x65, 0x65, 0xce, 0x83, 0x67, 0xbe, 0xf9, 0xce, 0x37, 0xe7,
	0x1c, 0x0d, 0x0d, 0xc5, 0x1e, 0xdb, 0x37, 0x19, 0xa9, 0x77, 0x5d, 0x87, 0x39, 0x28, 0x23, 0x5a,
	0xb5, 0xc2, 0x33, 0x8f, 0xb8, 0x87, 0xa2, 0xb3, 0x56, 0x66, 0x4e, 0xd7, 0x69, 0x9a, 0xcc, 0x94,
	0xed, 0x42, 0x8f, 0xb9, 0xdd, 0x86, 0x68, 0xe8, 0x1f, 0xab, 0x90, 0xdd, 0x21, 0x94, 0x5a, 0x8e,
	0x8d, 0x56, 0xa0, 0x6c, 0xd9, 0x06, 0x73, 0x4d, 0x9b, 0x9a, 0x0d, 0x66, 0x39, 0x76, 0x55, 0x59,
	0x56, 0x56, 0x73, 0xb8, 0x64, 0xd9, 0xbb, 0x51, 0x27, 0xda, 0x84, 0x32, 0x3d, 0x30, 0xdd, 0xa6,
	0x41, 0xc5, 0x7b, 0xb4, 0xaa, 0x2e, 0x6b, 0xab, 0x85, 0xf5, 0x85, 0xba, 0xc4, 0x22, 0xed, 0xd5,
	0x77, 0xfc, 0x59, 0xb2, 0x81, 0x4b, 0x34, 0xd6, 0xa2, 0xe8, 0x1a, 0xe4, 0xa9, 0x65, 0xef, 0xb7,
	0x89, 0xd1, 0xdc, 0xab, 0x6a, 0x7c, 0x99, 0x9c, 0xe8, 0xb8, 0xbf, 0x87, 0x16, 0x01, 0x4c, 0x8f,
	0x39, 0x0d, 0xa7, 0xd3, 0xb1, 0x58, 0x35, 0xc5, 0x47, 0x63, 0x3d, 0xb5, 0xf7, 0xa0, 0x18, 0xb7,
	0x8d, 0x56, 0x20, 0xc3, 0x4c, 0x77, 0x9f, 0x30, 0x0e, 0xb8, 0xb0, 0x5e, 0xaa, 0x8b, 0xfd, 0xef,
	0xf2, 0x4e, 0x2c, 0x07, 0xfd, 0xfd, 0xc5, 0x36, 0x67, 0x58, 0xcd, 0xaa, 0xba, 0xac, 0xac, 0x6a,
	0xb8, 0x14, 0xeb, 0xdd, 0x6e, 0xea, 0x3f, 0xaa, 0x50, 0xde, 0xfa, 0x80, 0x34, 0x3c, 0x46, 0x30,
	0x79, 0xe6, 0x11, 0xca, 0xd0, 0x1a, 0xe4, 0x1b, 0x66, 0xbb, 0x4d, 0x5c, 0xff, 0x25, 0xb1, 0xc6,
	0x54, 0x5d, 0xd0, 0xb8, 0xc9, 0xfb, 0xb7, 0xef, 0xe3, 0x9c, 0x98, 0xb1, 0xdd, 0x44, 0x37, 0x21,
	0x2b, 0xa9, 0xe1, 0x0b, 0x88, 0xb9, 0x71, 0x66, 0x70, 0x30, 0x8e, 0x6e, 0x40, 0x9a, 0x43, 0xe5,
	0x14, 0x14, 0xd6, 0x67, 0x24, 0xf0, 0x0d, 0xc7, 0xb3, 0x9b, 0x6f, 0xfa, 0x8f, 0x58, 0x8c, 0xa3,
	0xbf, 0x43, 0x81, 0x99, 0x7b, 0x6d, 0xc2, 0x0c, 0x76, 0xd8, 0x25, 0x9c, 0x93, 0xf2, 0x7a, 0xa5,
	0x1e, 0xba, 0x76, 0x97, 0x0f, 0xee, 0x1e, 0x76, 0x09, 0x06, 0x16, 0x3e, 0xa3, 0x35, 0x40, 0xb6,
	0xc3, 0x8c, 0x84, 0x5b, 0xd3, 0x9c, 0xd1, 0x69, 0xdb, 0x61, 0xdb, 0x7d, 0x9e, 0x5d, 0x81, 0x72,
	0x8b, 0x1c, 0xd2, 0xae, 0xd9, 0x20, 0x06, 0x77, 0x57, 0x35, 0xb3, 0xac, 0xac, 0xe6, 0x71, 0x29,
	0xe8, 0xe5, 0xac, 0xa3, 0xdb, 0x90, 0x75, 0xba, 0x8c, 0x7b, 0x3e, 0xcb, 0x61, 0xcf, 0x49, 0xd8,
	0x92, 0xb5, 0x37, 0xc4, 0x20, 0x0e, 0x66, 0xe9, 0x2f, 0x15, 0x98, 0x0a, 0x19, 0xa5, 0x5d, 0xc7,
	0xa6, 0x04, 0xad, 0x40, 0x9a, 0xb8, 0xae, 0xe3, 0x26, 0xe8, 0xc4, 0x8f, 0x37, 0xb7, 0xfc, 0x6e,
	0x2c, 0x46, 0x4f, 0xc3, 0xe5, 0x5f, 0x20, 0xe3, 0x12, 0xea, 0xb5, 0x99, 0x24, 0x13, 0x49, 0x54,
	0x82, 0x47, 0x3e, 0x82, 0xe5, 0x0c, 0xfd, 0x17, 0x15, 0x2a, 0x12, 0x11, 0xdf, 0x13, 0x9d, 0x1c,
	0x4f, 0xd7, 0x20, 0x17, 0xd0, 0xcd, 0xdd, 0x9c, 0xc7, 0x61, 0x1b, 0xcd, 0x43, 0x86, 0xfb, 0x85,
	0x56, 0xd3, 0xcb, 0xda, 0x6a, 0x1e, 0xcb, 0x56, 0x52, 0x1d, 0x99, 0x33, 0xa9, 0x23, 0x3b, 0x40,
	0x1d, 0x31, 0xb7, 0xe7, 0x46, 0x72, 0xfb, 0xa7, 0x0a, 0xcc, 0x25, 0x48, 0x9e, 0x08, 0xe7, 0xff,
	0xa6, 0xc2, 0x55, 0x89, 0xeb, 0x81, 0x64, 0x76, 0xfb, 0x75, 0x51, 0xc0, 0x75, 0x28, 0x86, 0x47,
	0xd4, 0x92, 0x3a, 0x28, 0xe2, 0x42, 0x2b, 0xda, 0xc7, 0x84, 0x8a, 0xe1, 0x95, 0x02, 0xb5, 0xe3,
	0x48, 0x9f, 0x08, 0x45, 0xbc, 0xd0, 0xe0, 0x4a, 0x04, 0x0e, 0x9b, 0xf6, 0x3e, 0x79, 0x4d, 0xf4,
	0x70, 0x07, 0xa0, 0x45, 0x0e, 0x0d, 0x97, 0x43, 0xe6, 0x6a, 0xf0, 0x77, 0x1a, 0xfa, 0x3a, 0xd8,
	0x0d, 0xce, 0xb7, 0x82, 0x7d, 0x4d, 0xa8, 0x3e, 0x3e, 0x53, 0xa0, 0x7a, 0xd4, 0x05, 0x13, 0xa1,
	0x8e, 0x6f, 0x53, 0xa1, 0x3a, 0xb6, 0x6c, 0x66, 0xb1, 0xc3, 0xd7, 0x26, 0x5a, 0xac, 0x01, 0x22,
	0x1c, 0xb1, 0xd1, 0x70, 0xda, 0x5e, 0xc7, 0x36, 0x6c, 0xb3, 0x43, 0x78, 0xfa, 0xcf, 0xe3, 0x69,
	0x31, 0xb2, 0xc9, 0x07, 0x1e, 0x99, 0x1d, 0x82, 0xde, 0x81, 0x59, 0x39, 0xbb, 0x2f, 0xc4, 0x64,
	0xb8, 0xa8, 0x56, 0x03, 0xa4, 0x03, 0x98, 0xa8, 0x07, 0x1d, 0x78, 0x46, 0x18, 0x79, 0x30, 0x38,
	0x24, 0x65, 0xcf, 0x24, 0xb9, 0xdc, 0xc9, 0x92, 0xcb, 0x8f, 0x22, 0xb9, 0xda, 0x1e, 0xe4, 0x02,
	0xd0, 0x68, 0x09, 0x52, 0x1c, 0x9a, 0xc2, 0xa1, 0x15, 0x82, 0x02, 0xd2, 0x47, 0xc4, 0x07, 0x50,
	0x05, 0xd2, 0x3d, 0xb3, 0xed, 0x11, 0xee, 0xb8, 0x22, 0x16, 0x0d, 0xb4, 0x04, 0x85, 0x18, 0x57,
	0xdc, 0x57, 0x45, 0x0c, 0x51, 0x34, 0x8e, 0xcb, 0x3a, 0xc6, 0xd8, 0x44, 0xc8, 0xfa, 0x27, 0x15,
	0x66, 0x25, 0xb4, 0x0d, 0x93, 0x35, 0x0e, 0x2e, 0x5c, 0xd2, 0xb7, 0x20, 0xeb, 0xa3, 0xb1, 0x08,
	0xad, 0x6a, 0x5c, 0x53, 0xc7, 0x88, 0x3a, 0x98, 0x31, 0x6e, 0xc1, 0xbb, 0x02, 0x65, 0x93, 0x1e,
	0x53, 0xec, 0x96, 0x4c, 0x7a, 0x19, 0x95, 0xee, 0x2b, 0x25, 0xac, 0x2b, 0x25, 0xa7, 0x17, 0xe6,
	0xea, 0xbf, 0x42, 0x56, 0x38, 0x32, 0x60, 0x73, 0x5e, 0x62, 0x13, 0x6e, 0x7e, 0xdb, 0x62, 0x07,
	0xc2, 0x74, 0x30, 0x4d, 0xb7, 0x61, 0x8a, 0x33, 0xcd, 0xf7, 0xc6, 0xe9, 0x8e, 0xa2, 0x8c, 0x72,
	0x8a, 0x28, 0xa3, 0x0e, 0xac, 0x4a, 0xb5, 0x78, 0x55, 0xaa, 0x7f, 0x13, 0xd5, 0x59, 0x9c, 0x8c,
	0x4b, 0xaa, 0xb4, 0xef, 0x24, 0x65, 0x76, 0x25, 0x98, 0x9a, 0xd8, 0xfd, 0x65, 0x89, 0x2d, 0xa6,
	0xa2, 0xcc, 0x48, 0x2a, 0xfa, 0x3c, 0xaa, 0x95, 0xfa, 0x88, 0xbb, 0x30, 0x2d, 0xad, 0x25, 0xb5,
	0x74, 0x5c, 0xdc, 0x08, 0x75, 0xf4, 0x11, 0x54, 0x38, 0x93, 0x51, 0x84, 0x3f, 0x47, 0x31, 0x25,
	0x0b, 0x5c, 0xed, 0x48, 0x81, 0xab, 0x7f, 0xaf, 0xc2, 0x62, 0x9c, 0x9e, 0xcb, 0x2c, 0xe2, 0xff,
	0x91, 0x14, 0xd7, 0x42, 0x9f, 0xb8, 0x12, 0x94, 0x4c, 0xac, 0xc2, 0xbe, 0x54, 0x60, 0x69, 0x20,
	0x85, 0x13, 0x22, 0xb3, 0xdf, 0x15, 0xa8, 0xec, 0x30, 0x97, 0x98, 0x9d, 0x33, 0xdd, 0xc6, 0x84,
	0xaa, 0x54, 0x4f, 0x77, 0xc5, 0xa2, 0x8d, 0xee, 0xa2, 0x44, 0x2a, 0x49, 0x9d, 0x90, 0x4a, 0xd2,
	0x23, 0xb9, 0x68, 0x13, 0xe6, 0x12, 0xbb, 0x97, 0x7e, 0x89, 0x72, 0xbc, 0x72, 0x62, 0x8e, 0x7f,
	0xa9, 0x42, 0xad, 0xcf, 0xca, 0x59, 0x62, 0xf0, 0xc8, 0x4c, 0xc6, 0xcf, 0xb7, 0x36, 0x30, 0x59,
	0xa4, 0x86, 0x5d, 0x61, 0xa4, 0x47, 0x64, 0xff, 0xd4, 0xca, 0xdf, 0x86, 0x6b, 0xc7, 0x12, 0x32,
	0x06, 0xb9, 0x5f, 0xa8, 0xb0, 0xd4, 0x67, 0xeb, 0xcc, 0x81, 0xe8, 0x5c, 0x18, 0x4e, 0x46, 0xd0,
	0xd4, 0x89, 0x57, 0x04, 0x17, 0x46, 0xf6, 0x23, 0x58, 0x1e, 0x4c, 0xd0, 0x18, 0x8c, 0x7f, 0xad,
	0xc2, 0x9f, 0x92, 0x06, 0xcf, 0xf2, 0x6b, 0xfd, 0x5c, 0xf8, 0xee, 0xff, 0x09, 0x9e, 0x1a, 0xe3,
	0x27, 0xf8, 0x85, 0xf1, 0xff, 0x7f, 0x58, 0x1c, 0x44, 0xd7, 0x18, 0xec, 0xbf, 0x0b, 0xc5, 0x0d,
	0xb2, 0x6f, 0xd9, 0xe3, 0x71, 0xdd, 0x77, 0xe3, 0xaf, 0xf6, 0xdf, 0xf8, 0xeb, 0xff, 0x86, 0x92,
	0x34, 0x2d, 0x71, 0xc5, 0xb2, 0x8a, 0x32, 0x3c, 0xab, 0xe8, 0x2f, 0x14, 0x28, 0x6d, 0xf2, 0x0f,
	0x03, 0x17, 0x9e, 0xfd, 0xe7, 0x21, 0x63, 0x32, 0xa7, 0x63, 0x35, 0xe4, 0x27, 0x0b, 0xd9, 0xd2,
	0xa7, 0xa1, 0x1c, 0x20, 0x10, 0xf8, 0xf5, 0xf7, 0x61, 0x0a, 0x3b, 0xed, 0xf6, 0x9e, 0xd9, 0x68,
	0x5d, 0x34, 0x2a, 0x1d, 0xc1, 0x74, 0xb4, 0x96, 0x5c, 0xff, 0x29, 0x5c, 0xc5, 0x84, 0x3a, 0xed,
	0x1e, 0x89, 0xd5, 0x09, 0xe3, 0x21, 0x41, 0x90, 0x6a, 0x32, 0xf9, 0xb1, 0x24, 0x8f, 0xf9, 0xb3,
	0xfe, 0x9d, 0x02, 0x95, 0x87, 0x84, 0x52, 0x73, 0x9f, 0x08, 0x81, 0x8d, 0x67, 0x7a, 0x58, 0x21,
	0x58, 0x81, 0xb4, 0x48, 0xa7, 0xe2, 0xbc, 0x89, 0x06, 0xba, 0x0d, 0xf9, 0xf0, 0xb0, 0xf1, 0x44,
	0x7b, 0xfc, 0x59, 0xcb, 0x05, 0x67, 0xcd, 0x47, 0x1f, 0xbb, 0xf4, 0xe0, 0xcf, 0xfa, 0x27, 0x0a,
	0xcc, 0x48, 0xf4, 0xf7, 0xc6, 0xf5, 0xcf, 0x30, 0xe8, 0xc1, 0x9a, 0x5a, 0xb4, 0x26, 0x5a, 0x04,
	0x2d, 0x08, 0xc6, 0x85, 0xf5, 0xa2, 0x3c, 0x65, 0x4f, 0xcc, 0xb6, 0x47, 0xb0, 0x3f, 0xa0, 0x2f,
	0x40, 0xed, 0x38, 0x87, 0x49, 0x77, 0xfe, 0xaa, 0xc2, 0xcc, 0x4e, 0xb7, 0x6d, 0x31, 0x79, 0x2e,
	0xcf, 0x1b, 0xf1, 0xc8, 0xb7, 0x4d, 0xd7, 0xa1, 0x48, 0x7d, 0x1c, 0xf2, 0x42, 0x49, 0x26, 0xf1,
	0x02, 0xef, 0x13, 0x57, 0x49, 0x68, 0x09, 0x0a, 0xc1, 0x14, 0xcf, 0x66, 0x9c, 0x78, 0x0d, 0x83,
	0x9c, 0xe1, 0xd9, 0x0c, 0xfd, 0x0d, 0xae, 0xd8, 0x5e, 0xc7, 0x70, 0x9d, 0xe7, 0xd4, 0xe8, 0x12,
	0xd7, 0xe0, 0x96, 0x8d, 0xae, 0xe9, 0x32, 0x1e, 0xd6, 0x34, 0x3c, 0x6b, 0x7b, 0x1d, 0xec, 0x3c,
	0xa7, 0x8f, 0x89, 0xcb, 0x17, 0x7f, 0x6c, 0xba, 0x0c, 0xfd, 0x17, 0xf2, 0x66, 0x7b, 0xdf, 0x71,
	0x2d, 0x76, 0xd0, 0x91, 0x37, 0x48, 0xba, 0x84, 0x79, 0x84, 0x99, 0xfa, 0xbd, 0x60, 0x26, 0x8e,
	0x5e, 0x42, 0xb7, 0x00, 0x79, 0x94, 0x18, 0x02, 0x9c, 0x58, 0xb4, 0xb7, 0x2e, 0xaf, 0x93, 0xa6,
	0x3c, 0x4a, 0x22, 0x33, 0x4f, 0xd6, 0xf5, 0x1f, 0x34, 0x40, 0x71, 0xbb, 0x32, 0x2e, 0xfd, 0x13,
	0x32, 0xfc, 0x7d, 0x5a, 0x55, 0xb8, 0x27, 0x97, 0xc2, 0x53, 0x79, 0x64, 0x6e, 0xdd, 0x87, 0x8d,
	0xe5, 0xf4, 0xda, 0x53, 0x28, 0x06, 0xea, 0xe4, 0xdb, 0x89, 0x7b, 0x43, 0x19, 0x9a, 0x51, 0xd4,
	0x11, 0x32, 0x4a, 0xed, 0x3f, 0x90, 0xe7, 0x95, 0xcc, 0x89, 0xb6, 0xa3, 0xfa, 0x4b, 0x8d, 0xd7,
	0x5f, 0xb5, 0x9f, 0x15, 0x48, 0xf1, 0x97, 0x47, 0xfe, 0x15, 0xf7, 0x90, 0x17, 0xbe, 0x02, 0xa5,
	0xf0, 0x9e, 0x08, 0x54, 0x37, 0x86, 0x50, 0x12, 0xa7, 0x00, 0x17, 0x5b, 0x71, 0x42, 0x36, 0x01,
	0xc4, 0x67, 0x65, 0x6e, 0x4a, 0xe8, 0xf0, 0xcf, 0x43, 0x4c, 0x85, 0xdb, 0xc5, 0x79, 0x1a, 0xee,
	0x1c, 0x41, 0x8a, 0x5a, 0x1f, 0x8a, 0xc8, 0xa0, 0x61, 0xfe, 0xac, 0xdf, 0x85, 0xb9, 0xff, 0x11,
	0xb6, 0xe3, 0xf6, 0x82, 0xea, 0x23, 0x38, 0x3e, 0x43, 0x68, 0xd2, 0x31, 0xcc, 0x27, 0x5f, 0x92,
	0x0a, 0xf8, 0x17, 0x14, 0xa9, 0xdb, 0x33, 0xfa, 0xde, 0xf4, 0x33, 0x71, 0xe8, 0x9e, 0xf8, 0x4b,
	0x05, 0x1a, 0x35, 0xf4, 0xaf, 0x54, 0x98, 0x7d, 0xab, 0xdb, 0x34, 0xd9, 0xa4, 0xc7, 0xcc, 0x31,
	0xcb, 0x93, 0x05, 0xc8, 0x33, 0xab, 0x43, 0x28, 0x33, 0x3b, 0x5d, 0x79, 0x92, 0xa3, 0x0e, 0x5f,
	0x57, 0xa4, 0x47, 0x6c, 0x26, 0x6f, 0xd2, 0x02, 0x5d, 0x6d, 0xf9, 0x7d, 0xbb, 0x4e, 0x8b, 0xd8,
	0x58, 0x8c, 0xeb, 0x2d, 0xa8, 0xf4, 0xb3, 0x24, 0x89, 0x5f, 0x0d, 0x0c, 0xf4, 0x57, 0x2a, 0xb2,
	0xc0, 0xf1, 0x47, 0xa4, 0x05, 0x74, 0x13, 0xa6, 0xfd, 0x92, 0xa5, 0x43, 0x8c, 0x08, 0x8f, 0xf8,
	0xd4, 0x3f, 0x25, 0xfa, 0x77, 0x83, 0xee, 0x8d, 0x19, 0x98, 0xb2, 0x9c, 0x7a, 0xcf, 0x62, 0x84,
	0x52, 0xf1, 0x2f, 0x11, 0x7b, 0x19, 0xfe, 0xe7, 0xee, 0x1f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x67,
	0xe8, 0x1c, 0x2c, 0x5b, 0x21, 0x00, 0x00,
}
