################################################################################
# Bioconductor libraries
################################################################################

if(!require("GenomicRanges", character.only = TRUE)){
  source("https://bioconductor.org/biocLite.R")
  biocLite("GenomicRanges")
}
library(GenomicRanges)

if(!require("rtracklayer", character.only = TRUE)){
  source("https://bioconductor.org/biocLite.R")
  biocLite("rtracklayer")
}
library(rtracklayer)

########################################
# Read TADs
########################################
BG3_TADs_hicexplorer <- import("../data/TADs/BG3_merged_hic_matrix_dpnII_corrected_domains.bed")
Kc167_TADs_hicexplorer <- import("../data/TADs/Kc167_merged_hic_matrix_dpnII_corrected_domains.bed")
Kc167_sub_TADs_hicexplorer <- import("../data/TADs/Kc167_sub_merged_hic_matrix_dpnII_corrected_domains.bed")

BG3_TADs_hicexplorer_autosomes <- BG3_TADs_hicexplorer[!(seqnames(BG3_TADs_hicexplorer)%in%c("X","Y"))]
seqlevels(BG3_TADs_hicexplorer_autosomes) <- seqlevelsInUse(BG3_TADs_hicexplorer_autosomes)

Kc167_TADs_hicexplorer_autosomes <- Kc167_TADs_hicexplorer[!(seqnames(Kc167_TADs_hicexplorer)%in%c("X","Y"))]
seqlevels(Kc167_TADs_hicexplorer_autosomes) <- seqlevelsInUse(Kc167_TADs_hicexplorer_autosomes)

Kc167_TADs_sub_hicexplorer_autosomes <- Kc167_sub_TADs_hicexplorer[!(seqnames(Kc167_sub_TADs_hicexplorer)%in%c("X","Y"))]
seqlevels(Kc167_TADs_sub_hicexplorer_autosomes) <- seqlevelsInUse(Kc167_TADs_sub_hicexplorer_autosomes)

########################################
# Read strong TADs
########################################

BG3_TADs_strong_hicexplorer <- import("../data/TADs/BG3_merged_hic_matrix_dpnII_corrected_strong_domains.bed")
Kc167_TADs_strong_hicexplorer <- import("../data/TADs/Kc167_merged_hic_matrix_dpnII_corrected_strong_domains.bed")
Kc167_sub_TADs_strong_hicexplorer <- import("../data/TADs/Kc167_sub_merged_hic_matrix_dpnII_corrected_strong_domains.bed")

BG3_TADs_strong_hicexplorer_autosomes <- BG3_TADs_strong_hicexplorer[!(seqnames(BG3_TADs_strong_hicexplorer)%in%c("X","Y"))]
seqlevels(BG3_TADs_strong_hicexplorer_autosomes) <- seqlevelsInUse(BG3_TADs_strong_hicexplorer_autosomes)

Kc167_TADs_strong_hicexplorer_autosomes <- Kc167_TADs_strong_hicexplorer[!(seqnames(Kc167_TADs_strong_hicexplorer)%in%c("X","Y"))]
seqlevels(Kc167_TADs_strong_hicexplorer_autosomes) <- seqlevelsInUse(Kc167_TADs_strong_hicexplorer_autosomes)

Kc167_TADs_strong_sub_hicexplorer_autosomes <- Kc167_sub_TADs_strong_hicexplorer[!(seqnames(Kc167_sub_TADs_strong_hicexplorer)%in%c("X","Y"))]
seqlevels(Kc167_TADs_strong_sub_hicexplorer_autosomes) <- seqlevelsInUse(Kc167_TADs_strong_sub_hicexplorer_autosomes)

########################################
# Extract TAD borders
########################################


BG3_TADs_hicexplorer_autosomes_upstream <- BG3_TADs_hicexplorer_autosomes
end(BG3_TADs_hicexplorer_autosomes_upstream) <- start(BG3_TADs_hicexplorer_autosomes_upstream)


BG3_TADs_hicexplorer_autosomes_downstream <- BG3_TADs_hicexplorer_autosomes
start(BG3_TADs_hicexplorer_autosomes_downstream) <- end(BG3_TADs_hicexplorer_autosomes_downstream)

Kc167_TADs_hicexplorer_autosomes_upstream <- Kc167_TADs_hicexplorer_autosomes
end(Kc167_TADs_hicexplorer_autosomes_upstream) <- start(Kc167_TADs_hicexplorer_autosomes_upstream)


Kc167_TADs_hicexplorer_autosomes_downstream <- Kc167_TADs_hicexplorer_autosomes
start(Kc167_TADs_hicexplorer_autosomes_downstream) <- end(Kc167_TADs_hicexplorer_autosomes_downstream)


Kc167_TADs_sub_hicexplorer_autosomes_upstream <- Kc167_TADs_sub_hicexplorer_autosomes
end(Kc167_TADs_sub_hicexplorer_autosomes_upstream) <- start(Kc167_TADs_sub_hicexplorer_autosomes_upstream)


Kc167_TADs_sub_hicexplorer_autosomes_downstream <- Kc167_TADs_sub_hicexplorer_autosomes
start(Kc167_TADs_sub_hicexplorer_autosomes_downstream) <- end(Kc167_TADs_sub_hicexplorer_autosomes_downstream)

BG3_TADs_hicexplorer_autosomes_borders <- union(BG3_TADs_hicexplorer_autosomes_upstream, BG3_TADs_hicexplorer_autosomes_downstream)
Kc167_TADs_hicexplorer_autosomes_borders <- union(Kc167_TADs_hicexplorer_autosomes_upstream, Kc167_TADs_hicexplorer_autosomes_downstream)
Kc167_TADs_sub_hicexplorer_autosomes_borders <- union(Kc167_TADs_sub_hicexplorer_autosomes_upstream, Kc167_TADs_sub_hicexplorer_autosomes_downstream)

########################################
# Extract strong TAD borders
########################################

BG3_TADs_strong_hicexplorer_autosomes_upstream <- BG3_TADs_strong_hicexplorer_autosomes
end(BG3_TADs_strong_hicexplorer_autosomes_upstream) <- start(BG3_TADs_strong_hicexplorer_autosomes_upstream)


BG3_TADs_strong_hicexplorer_autosomes_downstream <- BG3_TADs_strong_hicexplorer_autosomes
start(BG3_TADs_strong_hicexplorer_autosomes_downstream) <- end(BG3_TADs_strong_hicexplorer_autosomes_downstream)

Kc167_TADs_strong_hicexplorer_autosomes_upstream <- Kc167_TADs_strong_hicexplorer_autosomes
end(Kc167_TADs_strong_hicexplorer_autosomes_upstream) <- start(Kc167_TADs_strong_hicexplorer_autosomes_upstream)


Kc167_TADs_strong_hicexplorer_autosomes_downstream <- Kc167_TADs_strong_hicexplorer_autosomes
start(Kc167_TADs_strong_hicexplorer_autosomes_downstream) <- end(Kc167_TADs_strong_hicexplorer_autosomes_downstream)


Kc167_TADs_strong_sub_hicexplorer_autosomes_upstream <- Kc167_TADs_strong_sub_hicexplorer_autosomes
end(Kc167_TADs_strong_sub_hicexplorer_autosomes_upstream) <- start(Kc167_TADs_strong_sub_hicexplorer_autosomes_upstream)


Kc167_TADs_strong_sub_hicexplorer_autosomes_downstream <- Kc167_TADs_strong_sub_hicexplorer_autosomes
start(Kc167_TADs_strong_sub_hicexplorer_autosomes_downstream) <- end(Kc167_TADs_strong_sub_hicexplorer_autosomes_downstream)

BG3_TADs_strong_hicexplorer_autosomes_borders <- union(BG3_TADs_strong_hicexplorer_autosomes_upstream, BG3_TADs_strong_hicexplorer_autosomes_downstream)
Kc167_TADs_strong_hicexplorer_autosomes_borders <- union(Kc167_TADs_strong_hicexplorer_autosomes_upstream, Kc167_TADs_strong_hicexplorer_autosomes_downstream)
Kc167_TADs_strong_sub_hicexplorer_autosomes_borders <- union(Kc167_TADs_strong_sub_hicexplorer_autosomes_upstream, Kc167_TADs_strong_sub_hicexplorer_autosomes_downstream)


########################################
# Compute distance between TAD borders
########################################

BG3_closest_TADs_border_in_Kc167_ids <- nearest(BG3_TADs_hicexplorer_autosomes_borders, Kc167_TADs_hicexplorer_autosomes_borders)
BG3_closest_TADs_border_in_Kc167_distance <- distance(BG3_TADs_hicexplorer_autosomes_borders, Kc167_TADs_hicexplorer_autosomes_borders[BG3_closest_TADs_border_in_Kc167_ids] )


Kc167_closest_TADs_border_in_BG3_ids <- nearest(Kc167_TADs_hicexplorer_autosomes_borders, BG3_TADs_hicexplorer_autosomes_borders)
Kc167_closest_TADs_border_in_BG3_distance <- distance(Kc167_TADs_hicexplorer_autosomes_borders, BG3_TADs_hicexplorer_autosomes_borders[Kc167_closest_TADs_border_in_BG3_ids] )



BG3_closest_TADs_border_in_Kc167_sub_ids <- nearest(BG3_TADs_hicexplorer_autosomes_borders, Kc167_TADs_sub_hicexplorer_autosomes_borders)
BG3_closest_TADs_border_in_Kc167_sub_distance <- distance(BG3_TADs_hicexplorer_autosomes_borders, Kc167_TADs_sub_hicexplorer_autosomes_borders[BG3_closest_TADs_border_in_Kc167_sub_ids] )


Kc167_sub_closest_TADs_border_in_BG3_ids <- nearest(Kc167_TADs_sub_hicexplorer_autosomes_borders, BG3_TADs_hicexplorer_autosomes_borders)
Kc167_sub_closest_TADs_border_in_BG3_distance <- distance(Kc167_TADs_sub_hicexplorer_autosomes_borders, BG3_TADs_hicexplorer_autosomes_borders[Kc167_sub_closest_TADs_border_in_BG3_ids] )


Kc167_sub_closest_TADs_border_in_Kc167_ids <- nearest(Kc167_TADs_sub_hicexplorer_autosomes_borders, Kc167_TADs_hicexplorer_autosomes_borders)
Kc167_sub_closest_TADs_border_in_Kc167_distance <- distance(Kc167_TADs_sub_hicexplorer_autosomes_borders, Kc167_TADs_hicexplorer_autosomes_borders[Kc167_sub_closest_TADs_border_in_Kc167_ids] )


Kc167_closest_TADs_border_in_Kc167_sub_ids <- nearest(Kc167_TADs_hicexplorer_autosomes_borders, Kc167_TADs_sub_hicexplorer_autosomes_borders)
Kc167_closest_TADs_border_in_Kc167_sub_distance <- distance(Kc167_TADs_hicexplorer_autosomes_borders, Kc167_TADs_sub_hicexplorer_autosomes_borders[Kc167_closest_TADs_border_in_Kc167_sub_ids] )

save(BG3_closest_TADs_border_in_Kc167_distance, Kc167_closest_TADs_border_in_BG3_distance,
     BG3_closest_TADs_border_in_Kc167_sub_distance, Kc167_sub_closest_TADs_border_in_BG3_distance,
     Kc167_sub_closest_TADs_border_in_Kc167_distance, Kc167_closest_TADs_border_in_Kc167_sub_distance,
     file="../objects/strong_weak/BG3_Kc167_Kc167_sub_closest_TADs_borders_distance.RData")


########################################
# create TAD borders classes
########################################

end(BG3_TADs_hicexplorer_autosomes_borders) <- start(BG3_TADs_hicexplorer_autosomes_borders)
end(Kc167_TADs_hicexplorer_autosomes_borders) <- start(Kc167_TADs_hicexplorer_autosomes_borders)

end(BG3_TADs_strong_hicexplorer_autosomes_borders) <- start(BG3_TADs_strong_hicexplorer_autosomes_borders)
end(Kc167_TADs_strong_hicexplorer_autosomes_borders) <- start(Kc167_TADs_strong_hicexplorer_autosomes_borders)



BG3_TADs_hicexplorer_autosomes_borders_1Kb <- BG3_TADs_hicexplorer_autosomes_borders + 1000
Kc167_TADs_hicexplorer_autosomes_borders_1Kb <- Kc167_TADs_hicexplorer_autosomes_borders + 1000


BG3_Kc167_TADs_hicexplorer_autosomes_borders_1Kb_ids <- which(overlapsAny(BG3_TADs_hicexplorer_autosomes_borders_1Kb, Kc167_TADs_hicexplorer_autosomes_borders_1Kb))

Kc167_BG3_TADs_hicexplorer_autosomes_borders_1Kb_ids <- which(overlapsAny(Kc167_TADs_hicexplorer_autosomes_borders_1Kb, BG3_TADs_hicexplorer_autosomes_borders_1Kb))


BG3_TADs_hicexplorer_autosomes_borders_10bp <- BG3_TADs_hicexplorer_autosomes_borders + 10
Kc167_TADs_hicexplorer_autosomes_borders_10bp <- Kc167_TADs_hicexplorer_autosomes_borders + 10

BG3_Kc167_TADs_hicexplorer_autosomes_borders_10bp_ids <- which(overlapsAny(BG3_TADs_hicexplorer_autosomes_borders_10bp, Kc167_TADs_hicexplorer_autosomes_borders_10bp))

Kc167_BG3_TADs_hicexplorer_autosomes_borders_10bp_ids <- which(overlapsAny(Kc167_TADs_hicexplorer_autosomes_borders_10bp, BG3_TADs_hicexplorer_autosomes_borders_10bp))




BG3_TADs_strong_hicexplorer_autosomes_borders_1Kb <- BG3_TADs_strong_hicexplorer_autosomes_borders + 1000
Kc167_TADs_strong_hicexplorer_autosomes_borders_1Kb <- Kc167_TADs_strong_hicexplorer_autosomes_borders + 1000


BG3_Kc167_TADs_strong_hicexplorer_autosomes_borders_1Kb_ids <- which(overlapsAny(BG3_TADs_strong_hicexplorer_autosomes_borders_1Kb, Kc167_TADs_strong_hicexplorer_autosomes_borders_1Kb))

Kc167_BG3_TADs_strong_hicexplorer_autosomes_borders_1Kb_ids <- which(overlapsAny(Kc167_TADs_strong_hicexplorer_autosomes_borders_1Kb, BG3_TADs_strong_hicexplorer_autosomes_borders_1Kb))


BG3_TADs_strong_hicexplorer_autosomes_borders_10bp <- BG3_TADs_strong_hicexplorer_autosomes_borders + 10
Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp <- Kc167_TADs_strong_hicexplorer_autosomes_borders + 10

BG3_Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp_ids <- which(overlapsAny(BG3_TADs_strong_hicexplorer_autosomes_borders_10bp, Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp))

Kc167_BG3_TADs_strong_hicexplorer_autosomes_borders_10bp_ids <- which(overlapsAny(Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp, BG3_TADs_strong_hicexplorer_autosomes_borders_10bp))



#classification
dm6_TADs_borders_conserved <- BG3_TADs_strong_hicexplorer_autosomes_borders[BG3_Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp_ids]
dm6_TADs_borders_conserved_weak <- setdiff(BG3_TADs_hicexplorer_autosomes_borders[BG3_Kc167_TADs_hicexplorer_autosomes_borders_10bp_ids], dm6_TADs_borders_conserved)

dm6_TADs_borders_BG3_specific <- BG3_TADs_strong_hicexplorer_autosomes_borders[(1:length(BG3_TADs_strong_hicexplorer_autosomes_borders_1Kb))[-BG3_Kc167_TADs_strong_hicexplorer_autosomes_borders_1Kb_ids]]
dm6_TADs_borders_BG3_specific_weak <- setdiff(BG3_TADs_hicexplorer_autosomes_borders[(1:length(BG3_TADs_hicexplorer_autosomes_borders_1Kb))[-BG3_Kc167_TADs_hicexplorer_autosomes_borders_1Kb_ids]], dm6_TADs_borders_BG3_specific)

dm6_TADs_borders_Kc167_specific <- Kc167_TADs_strong_hicexplorer_autosomes_borders[(1:length(Kc167_TADs_strong_hicexplorer_autosomes_borders_1Kb))[-Kc167_BG3_TADs_strong_hicexplorer_autosomes_borders_1Kb_ids]]
dm6_TADs_borders_Kc167_specific_weak <- setdiff(Kc167_TADs_hicexplorer_autosomes_borders[(1:length(Kc167_TADs_hicexplorer_autosomes_borders_1Kb))[-Kc167_BG3_TADs_hicexplorer_autosomes_borders_1Kb_ids]], dm6_TADs_borders_Kc167_specific)







BG3_Kc167_TAD_borders_classes <- list("BG3_specific" = (1:length(BG3_TADs_hicexplorer_autosomes_borders_1Kb))[-BG3_Kc167_TADs_hicexplorer_autosomes_borders_1Kb_ids],
                                      "conserved" = BG3_Kc167_TADs_hicexplorer_autosomes_borders_10bp_ids,
                                      "BG3_fuzzy" = setdiff(BG3_Kc167_TADs_hicexplorer_autosomes_borders_1Kb_ids, BG3_Kc167_TADs_hicexplorer_autosomes_borders_10bp_ids),
                                      "Kc167_fuzzy" = setdiff(Kc167_BG3_TADs_hicexplorer_autosomes_borders_1Kb_ids, Kc167_BG3_TADs_hicexplorer_autosomes_borders_10bp_ids),
                                      "Kc167_specific" = (1:length(Kc167_TADs_hicexplorer_autosomes_borders_1Kb))[-BG3_Kc167_TADs_hicexplorer_autosomes_borders_1Kb_ids])

dm6_TADs_borders_conserved <- BG3_TADs_hicexplorer_autosomes_borders[BG3_Kc167_TAD_borders_classes[["conserved"]]]
dm6_TADs_borders_conserved_strong <- dm6_TADs_borders_conserved[overlapsAny(dm6_TADs_borders_conserved, BG3_TADs_strong_hicexplorer_autosomes_borders_10bp) &
                                                                  overlapsAny(dm6_TADs_borders_conserved, Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp)]
dm6_TADs_borders_conserved_weak <- dm6_TADs_borders_conserved[!overlapsAny(dm6_TADs_borders_conserved, BG3_TADs_strong_hicexplorer_autosomes_borders_10bp) |
                                                                !overlapsAny(dm6_TADs_borders_conserved, Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp)]

dm6_TADs_borders_BG3_specific <- BG3_TADs_hicexplorer_autosomes_borders[BG3_Kc167_TAD_borders_classes[["BG3_specific"]]]
dm6_TADs_borders_BG3_specific_strong <- dm6_TADs_borders_BG3_specific[overlapsAny(dm6_TADs_borders_BG3_specific, BG3_TADs_strong_hicexplorer_autosomes_borders_10bp)]
dm6_TADs_borders_BG3_specific_weak <- dm6_TADs_borders_BG3_specific[!overlapsAny(dm6_TADs_borders_BG3_specific, BG3_TADs_strong_hicexplorer_autosomes_borders_10bp)]

dm6_TADs_borders_BG3_fuzzy <- BG3_TADs_hicexplorer_autosomes_borders[BG3_Kc167_TAD_borders_classes[["BG3_fuzzy"]]]
dm6_TADs_borders_BG3_fuzzy_strong <- dm6_TADs_borders_BG3_fuzzy[overlapsAny(dm6_TADs_borders_BG3_fuzzy, BG3_TADs_strong_hicexplorer_autosomes_borders_10bp)]
dm6_TADs_borders_BG3_fuzzy_weak <- dm6_TADs_borders_BG3_fuzzy[!overlapsAny(dm6_TADs_borders_BG3_fuzzy, BG3_TADs_strong_hicexplorer_autosomes_borders_10bp)]

dm6_TADs_borders_Kc167_specific <- Kc167_TADs_hicexplorer_autosomes_borders[BG3_Kc167_TAD_borders_classes[["Kc167_specific"]]]
dm6_TADs_borders_Kc167_specific_strong <- dm6_TADs_borders_Kc167_specific[overlapsAny(dm6_TADs_borders_Kc167_specific, Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp)]
dm6_TADs_borders_Kc167_specific_weak <- dm6_TADs_borders_Kc167_specific[!overlapsAny(dm6_TADs_borders_Kc167_specific, Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp)]

dm6_TADs_borders_Kc167_fuzzy <- Kc167_TADs_hicexplorer_autosomes_borders[BG3_Kc167_TAD_borders_classes[["Kc167_fuzzy"]]]
dm6_TADs_borders_Kc167_fuzzy_strong <- dm6_TADs_borders_Kc167_fuzzy[overlapsAny(dm6_TADs_borders_Kc167_fuzzy, Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp)]
dm6_TADs_borders_Kc167_fuzzy_weak <- dm6_TADs_borders_Kc167_fuzzy[!overlapsAny(dm6_TADs_borders_Kc167_fuzzy, Kc167_TADs_strong_hicexplorer_autosomes_borders_10bp)]


dm6_TADs_classes <- list("conserved" = dm6_TADs_borders_conserved,
                         "conserved strong" = dm6_TADs_borders_conserved_strong,
                         "conserved weak" = dm6_TADs_borders_conserved_weak,
                         "BG3 specific" = dm6_TADs_borders_BG3_specific,
                         "BG3 specific strong" = dm6_TADs_borders_BG3_specific_strong,
                         "BG3 specific weak" = dm6_TADs_borders_BG3_specific_weak,
                         "BG3 fuzzy" = dm6_TADs_borders_BG3_fuzzy,
                         "BG3 fuzzy strong" = dm6_TADs_borders_BG3_fuzzy_strong,
                         "BG3 fuzzy weak" = dm6_TADs_borders_BG3_fuzzy_weak,
                         "Kc167 specific" = dm6_TADs_borders_Kc167_specific,
                         "Kc167 specific strong" = dm6_TADs_borders_Kc167_specific_strong,
                         "Kc167 specific weak" = dm6_TADs_borders_Kc167_specific_weak,
                         "Kc167 fuzzy" = dm6_TADs_borders_Kc167_fuzzy,
                         "Kc167 fuzzy strong" = dm6_TADs_borders_Kc167_fuzzy_strong,
                         "Kc167 fuzzy_weak" = dm6_TADs_borders_Kc167_fuzzy_weak)


save(dm6_TADs_classes, file="../objects/strong_weak/dm6_TADs_original_grouped_classes.RData")

export(dm6_TADs_borders_conserved, "../data/TADs_classes/strong_weak/dm6_TADs_borders_conserved_original_grouped.bed")
export(dm6_TADs_borders_conserved_strong, "../data/TADs_classes/strong_weak/dm6_TADs_borders_conserved_strong_original_grouped.bed")
export(dm6_TADs_borders_conserved_weak, "../data/TADs_classes/strong_weak/dm6_TADs_borders_conserved_weak_original_grouped.bed")

export(dm6_TADs_borders_BG3_specific, "../data/TADs_classes/strong_weak/dm6_TADs_borders_BG3_specific_original_grouped.bed")
export(dm6_TADs_borders_BG3_specific_strong, "../data/TADs_classes/strong_weak/dm6_TADs_borders_BG3_specific_strong_original_grouped.bed")
export(dm6_TADs_borders_BG3_specific_weak, "../data/TADs_classes/strong_weak/dm6_TADs_borders_BG3_specific_weak_original_grouped.bed")


export(dm6_TADs_borders_BG3_fuzzy, "../data/TADs_classes/strong_weak/dm6_TADs_borders_BG3_fuzzy_original_grouped.bed")
export(dm6_TADs_borders_BG3_fuzzy_strong, "../data/TADs_classes/strong_weak/dm6_TADs_borders_BG3_fuzzy_strong_original_grouped.bed")
export(dm6_TADs_borders_BG3_fuzzy_weak, "../data/TADs_classes/strong_weak/dm6_TADs_borders_BG3_fuzzy_weak_original_grouped.bed")

export(dm6_TADs_borders_Kc167_specific, "../data/TADs_classes/strong_weak/dm6_TADs_borders_Kc167_specific_original_grouped.bed")
export(dm6_TADs_borders_Kc167_specific_strong, "../data/TADs_classes/strong_weak/dm6_TADs_borders_Kc167_specific_strong_original_grouped.bed")
export(dm6_TADs_borders_Kc167_specific_weak, "../data/TADs_classes/strong_weak/dm6_TADs_borders_Kc167_specific_weak_original_grouped.bed")

export(dm6_TADs_borders_Kc167_fuzzy, "../data/TADs_classes/strong_weak/dm6_TADs_borders_Kc167_fuzzy_original_grouped.bed")
export(dm6_TADs_borders_Kc167_fuzzy_strong, "../data/TADs_classes/strong_weak/dm6_TADs_borders_Kc167_fuzzy_strong_original_grouped.bed")
export(dm6_TADs_borders_Kc167_fuzzy_weak, "../data/TADs_classes/strong_weak/dm6_TADs_borders_Kc167_fuzzy_weak_original_grouped.bed")


export(BG3_TADs_hicexplorer_autosomes_borders, "../data/TADs_classes/strong_weak/BG3_TADs_hicexplorer_autosomes_borders_original_grouped.bed")
export(Kc167_TADs_hicexplorer_autosomes_borders, "../data/TADs_classes/strong_weak/Kc167_TADs_hicexplorer_autosomes_borders_original_grouped.bed")
export(BG3_TADs_strong_hicexplorer_autosomes_borders, "../data/TADs_classes/strong_weak/BG3_TADs_strong_hicexplorer_autosomes_borders_original_grouped.bed")
export(Kc167_TADs_strong_hicexplorer_autosomes_borders, "../data/TADs_classes/strong_weak/Kc167_TADs_strong_hicexplorer_autosomes_borders_original_grouped.bed")
