# setwd("/Volumes/guacamole/Berenice/count_matrices/") # Ben Dulken
setwd("/Users/benayoun/Dropbox/Manuscripts_and_Publications/2018_aging_epigenomics_data_description/Aging_omics_paper/Github_folder/FigureS5_CIBERSORT/Immune_Gene_Expression/") # Ben Dulken
rm(list=ls())
library(ggplot2)
library(edgeR)

fpkm_glm_genefilt<-read.table("2016-02-05_ALL_global_variance estimate_DESeq2_LINEAR_model_with_age _log2_counts_matrix.txt",header=T,sep="\t")

#List of genes I profiled - various immune markers.
int_list<-c("Mertk","Cd34","Cd3eap","Cd47","Cd44","Cd8a","Cd4","Ccl5","Cd3e","Cd3g","Tcf7","Itgam","Ptprc","Klrb1c","Klrk1","Il2rb","Ccr3","Itga2b","Itga2","Kit","Itgb7","Fcgr1","Adgre1","Ly6c","Cd28")

# All cell types
fpkm_glm_int<-fpkm_glm_genefilt[na.omit(match(int_list,rownames(fpkm_glm_genefilt))),]
tissue<-c(rep("Liver",9),rep("Heart",9),rep("Cerebellum1",9),rep("OlfactoryBulb",8),rep("NPC",6))
age<-c(rep(c("3m","3m","3m","12m","12m","12m","29m","29m","29m"),3),"3m","3m","3m","12m","12m","29m","29m","29m","3m","3m","12m","12m","29m","29m")

# Remove NSPCs
fpkm_glm_int_noNPC<-fpkm_glm_genefilt[na.omit(match(int_list,rownames(fpkm_glm_genefilt))),-c(36:41)]
tissue_nonpc<-c(rep("Liver",9),rep("Heart",9),rep("Cerebellum1",9),rep("OlfactoryBulb",8))
age_nonpc<-c(rep(c("3m","3m","3m","12m","12m","12m","29m","29m","29m"),3),"3m","3m","3m","12m","12m","29m","29m","29m")


# setwd("/Volumes/guacamole/BereniceCodeChecking/Output/")
for(i in 1:length(fpkm_glm_int[,1])){
  data<-data.frame(values=t(fpkm_glm_int[i,]),age=age,tissue=tissue)
  data$age<-factor(data$age,levels=c("3m","12m","29m"),ordered=T)
  data$tissue<-factor(data$tissue,levels=c("Heart","OlfactoryBulb","Cerebellum1","Liver","NPC"),ordered=T)
  p<-ggplot(data,aes(x=data$tissue,y=data[,1],color=data$age))
  p<-p + geom_boxplot(position=position_dodge(0.8)) + geom_jitter(position = position_dodge(0.8), alpha=0.7,size=2.5) 
  #    stat_summary(aes(x=data$age,y=data$values),fun.y=mean, geom = "point",size=9,alpha=0.7,shape=95) + 
  #    stat_summary(aes(x=data$age,y=data$values),fun.data=mean_se, geom = "errorbar",width=0.2,size=0.4,alpha=0.7)
  p<-p+theme_classic() + theme(
    axis.line.x = element_line(colour = 'black', size=0.5, linetype='solid'),
    axis.line.y = element_line(colour = 'black', size=0.5, linetype='solid'))
  p<-p+labs(x="Age",y="Log-Normalized",title=rownames(fpkm_glm_int)[i])
  p<-p+theme(axis.text.x=element_text(size=18))
  p<-p+theme(axis.text.x=element_text(angle=45,hjust=1))
  p<-p+theme(axis.text.y=element_text(size=16))
  p<-p+theme(axis.title.y=element_text(size=15))
  p<-p+theme(axis.title.y=element_text(vjust=1))
  p<-p+theme(axis.title.x=element_text(vjust=-0.10))
  pdf(paste0(rownames(fpkm_glm_int)[i],"_allcelltypes_berenice_normalized.pdf"),width=5,height=4)
  print(p)
  dev.off()
}

# setwd("/Volumes/guacamole/BereniceCodeChecking/Output/")
for(i in 1:length(fpkm_glm_int_noNPC[,1])){
  data<-data.frame(values=t(fpkm_glm_int_noNPC[i,]),age=age_nonpc,tissue=tissue_nonpc)
  data$age<-factor(data$age,levels=c("3m","12m","29m"),ordered=T)
  data$tissue<-factor(data$tissue,levels=c("Heart","OlfactoryBulb","Cerebellum1","Liver","NPC"),ordered=T)
  p<-ggplot(data,aes(x=data$tissue,y=data[,1],color=data$age))
  p<-p + geom_boxplot(position=position_dodge(0.8)) + geom_jitter(position = position_dodge(0.8), alpha=0.7,size=2.5) 
  #    stat_summary(aes(x=data$age,y=data$values),fun.y=mean, geom = "point",size=9,alpha=0.7,shape=95) + 
  #    stat_summary(aes(x=data$age,y=data$values),fun.data=mean_se, geom = "errorbar",width=0.2,size=0.4,alpha=0.7)
  p<-p+theme_classic() + theme(
    axis.line.x = element_line(colour = 'black', size=0.5, linetype='solid'),
    axis.line.y = element_line(colour = 'black', size=0.5, linetype='solid'))
  p<-p+labs(x="Age",y="Log-Normalized",title=rownames(fpkm_glm_int_noNPC)[i])
  p<-p+theme(axis.text.x=element_text(size=18))
  p<-p+theme(axis.text.x=element_text(angle=45,hjust=1))
  p<-p+theme(axis.text.y=element_text(size=16))
  p<-p+theme(axis.title.y=element_text(size=15))
  p<-p+theme(axis.title.y=element_text(vjust=1))
  p<-p+theme(axis.title.x=element_text(vjust=-0.10))
  pdf(paste0(rownames(fpkm_glm_int_noNPC)[i],"_allcelltypes_berenice_normalized_nonpc.pdf"),width=5,height=4)
  print(p)
  dev.off()
}




#Controls - general cell markers or cell type specific markers
cont_list<-c("Actb","Gapdh","Sox2","Nestin","Map2","Gfap","Tubb3","Tnnt2","Apoa2")

fpkm_glm_cont<-fpkm_glm_genefilt[na.omit(match(cont_list,rownames(fpkm_glm_genefilt))),]
tissue<-c(rep("Liver",9),rep("Heart",9),rep("Cerebellum1",9),rep("OlfactoryBulb",8),rep("NPC",6))
age<-c(rep(c("3m","3m","3m","12m","12m","12m","29m","29m","29m"),3),"3m","3m","3m","12m","12m","29m","29m","29m","3m","3m","12m","12m","29m","29m")

for(i in 1:length(fpkm_glm_cont[,1])){
  data<-data.frame(values=t(fpkm_glm_cont[i,]),age=age,tissue=tissue)
  data$age<-factor(data$age,levels=c("3m","12m","29m"),ordered=T)
  data$tissue<-factor(data$tissue,levels=c("Heart","OlfactoryBulb","Cerebellum1","Liver","NPC"),ordered=T)
  p<-ggplot(data,aes(x=data$tissue,y=data[,1],color=data$age))
  p<-p + geom_boxplot(position=position_dodge(0.8)) + geom_jitter(position = position_dodge(0.8), alpha=0.7,size=2.5) 
  #    stat_summary(aes(x=data$age,y=data$values),fun.y=mean, geom = "point",size=9,alpha=0.7,shape=95) + 
  #    stat_summary(aes(x=data$age,y=data$values),fun.data=mean_se, geom = "errorbar",width=0.2,size=0.4,alpha=0.7)
  p<-p+theme_classic() + theme(
    axis.line.x = element_line(colour = 'black', size=0.5, linetype='solid'),
    axis.line.y = element_line(colour = 'black', size=0.5, linetype='solid'))
  p<-p+labs(x="Age",y="Log-Normalized",title=rownames(fpkm_glm_cont)[i])
  p<-p+theme(axis.text.x=element_text(size=18))
  p<-p+theme(axis.text.x=element_text(angle=45,hjust=1))
  p<-p+theme(axis.text.y=element_text(size=16))
  p<-p+theme(axis.title.y=element_text(size=15))
  p<-p+theme(axis.title.y=element_text(vjust=1))
  p<-p+theme(axis.title.x=element_text(vjust=-0.10))
  pdf(paste0(rownames(fpkm_glm_cont)[i],"_allcelltypes_berenice_normalized.pdf"),width=5,height=4)
  print(p)
  dev.off()
}

#########################################################
# pvalues
int_list<-c("Itgam","Ptprc")

fpkm_glm_int_noNPC<-fpkm_glm_genefilt[na.omit(match(int_list,rownames(fpkm_glm_genefilt))),-c(36:41)]
tissue_nonpc<-c(rep("Liver",9),rep("Heart",9),rep("Cerebellum1",9),rep("OlfactoryBulb",8))
age_nonpc<-c(rep(c("3m","3m","3m","12m","12m","12m","29m","29m","29m"),3),"3m","3m","3m","12m","12m","29m","29m","29m")

my.heart <- fpkm_glm_int_noNPC[,tissue_nonpc == "Heart"]
my.liver <- fpkm_glm_int_noNPC[,tissue_nonpc == "Liver"]
my.cereb <- fpkm_glm_int_noNPC[,tissue_nonpc == "Cerebellum1"]
my.ob    <- fpkm_glm_int_noNPC[,tissue_nonpc == "OlfactoryBulb"]

wilcox.test(as.numeric(my.heart["Itgam",1:3]),as.numeric(my.heart["Itgam",7:9]), alternative = "less")
# p-value = 0.05
wilcox.test(as.numeric(my.liver["Itgam",1:3]),as.numeric(my.liver["Itgam",7:9]), alternative = "less")
# p-value = 0.05
wilcox.test(as.numeric(my.cereb["Itgam",1:3]),as.numeric(my.cereb["Itgam",7:9]), alternative = "less")
# p-value = 0.05
wilcox.test(as.numeric(my.ob["Itgam",1:3]),as.numeric(my.ob["Itgam",6:8]), alternative = "less")
# p-value = 0.05


wilcox.test(as.numeric(my.heart["Itgam",1:3]),as.numeric(my.heart["Itgam",7:9]), alternative = "less")
# p-value = 0.05
wilcox.test(as.numeric(my.liver["Itgam",1:3]),as.numeric(my.liver["Itgam",7:9]), alternative = "less")
# p-value = 0.05
wilcox.test(as.numeric(my.cereb["Itgam",1:3]),as.numeric(my.cereb["Itgam",7:9]), alternative = "less")
# p-value = 0.05
wilcox.test(as.numeric(my.ob["Itgam",1:3]),as.numeric(my.ob["Itgam",6:8]), alternative = "less")
# p-value = 0.05

