setwd('/Volumes/MyBook_3/BD_aging_project/Public_datasets/RNA_profile_other_species/GSE53960_Rat_aging/DESeq2/')
source('RNAseq_process_functions.R')

# 2017-05-19
# analyze conservation of DE genes of mouse cerebellum, HEART and liver in Rat Bodymap dataset
# got the young adult (5.25m) and old adult (26m) time points for this analysis

# BIOMART mouse/RAT orthology
my.orthology <- read.csv('2017-05-15_Rat_mouse_biomart_orthology.txt', sep = "\t", header = T)

my.orth.table <- unique(data.frame(cbind(my.orthology$Gene.name,my.orthology$Mouse.gene.name)))
colnames(my.orth.table) <- c("Rat_Symbol","Mouse_Symbol")

#############################
########    Brain    ########
#############################
my.rat.brain.process <- process_aging_rat_rna("Brain", "kallisto_output/2017-05-19_Rat_aging_Brain_Kallisto_MaleOnly.txt")
my.rat.brain.process.withfem <- process_aging_rat_rna("Brain_withFEM", "../Kallisto//2017-05-19_Rat_aging_Brain_Kallisto_bothSexes.txt", my.5m = 8, my.26m = 8, my.sex = rep(c(rep('F',4),rep('M',4)),2))
save(my.rat.brain.process, my.rat.brain.process.withfem, file = paste (Sys.Date(),"Rat_aging_brain_RNAseq.RData", sep ="_"))


#############################
########    Liver    ########
#############################
my.rat.liver.process <- process_aging_rat_rna("Liver", "kallisto_output/2017-05-19_Rat_aging_liver_Kallisto_MaleOnly.txt")
my.rat.liver.process.withfem <- process_aging_rat_rna("Liver_withFEM", "../Kallisto//2017-05-19_Rat_aging_liver_Kallisto_bothSexes.txt", my.5m = 8, my.26m = 8, my.sex = rep(c(rep('F',4),rep('M',4)),2))
save(my.rat.liver.process, my.rat.liver.process.withfem, file = paste (Sys.Date(),"Rat_aging_Liver_RNAseq.RData", sep ="_"))


#############################
########    Heart    ########
#############################
my.rat.heart.process <- process_aging_rat_rna("heart", "kallisto_output/2017-05-19_Rat_aging_heart_Kallisto_MaleOnly.txt")
my.rat.heart.process.withfem <- process_aging_rat_rna("heart_withFEM", "../Kallisto//2017-05-19_Rat_aging_heart_Kallisto_bothSexes.txt", my.5m = 8, my.26m = 8, my.sex = rep(c(rep('F',4),rep('M',4)),2))
save(my.rat.heart.process, my.rat.heart.process.withfem, file = paste (Sys.Date(),"Rat_aging_Heart_RNAseq.RData", sep ="_"))



