
# DEBUG
# my.tissue <- "Liver"
# my.rat.process <- my.rat.liver.process
# my.mouse.process <- my.liver.RNAseq.process[[1]]
# 

perform_tissue_comp <- function(my.tissue, my.rat.process,my.mouse.process, my.orth.table) {
  
  my.rat.process$Rat_Symbol <- rownames(my.rat.process)
  my.mouse.process$Mouse_Symbol <- rownames(my.mouse.process)
  
  my.merge1 <- merge(data.frame(my.rat.process),my.orth.table)
  my.merge2 <- merge(data.frame(my.mouse.process),my.merge1, by='Mouse_Symbol')
  
  my.mouse.sig <- my.merge2$padj.x < 0.05 
  my.rat.sig <- my.merge2$padj.y < 0.05 
  my.both.sig <- bitAnd(my.mouse.sig,my.rat.sig)>0
  
  test.mouse.neg <- wilcox.test(my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x <0)], alternative = "less")
  test.mouse.pos <- wilcox.test(my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x >0)], alternative = "greater")
  
  pdf(paste(Sys.Date(),my.tissue,"LogFC_of_mouse_orthologs_in_aging_Rat.pdf",sep="_"))
  boxplot(my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x <0)],
          my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x >0)],
          names = c("Mouse Ortholog Down","Mouse Ortholog Up"),
          ylab = "Rat aging log2FC per m",
          ylim = c(-0.08,0.08), col = c("cadetblue2","brown1"),
          main = paste(my.tissue,"(Rat)")
  )
  text(1,0.07,signif(test.mouse.neg$p.value, digits = 3))
  text(2,0.07,signif(test.mouse.pos$p.value, digits = 3))
  abline(h=0,lty="dashed", col = "red", lwd = 2)
  dev.off()
  
  #### Plot reference mouse
  pdf(paste(Sys.Date(),my.tissue,"LogFC_of_Mouse_sig_Control.pdf",sep="_"))
  boxplot(my.merge2$log2FoldChange.x[my.mouse.sig & (my.merge2$log2FoldChange.x <0)],
          my.merge2$log2FoldChange.x[my.mouse.sig & (my.merge2$log2FoldChange.x >0)],
          names = c("Mouse Down","Mouse  Up"),
          ylab = "Mouse aging log2FC per m",
          ylim = c(-0.08,0.08), col = c("cadetblue2","brown1"),
          main = paste(my.tissue,"(Mouse)")
  )
  abline(h=0,lty="dashed", col = "red", lwd = 2)
  dev.off()
  
}

