setwd('/Volumes/MyBook_3/BD_aging_project/Public_datasets/RNA_profile_other_species/GSE53960_Rat_aging/DESeq2/')
options(stringsAsFactors=F)
library(bitops)

source('cross_species_comparison_FUN.R')

# 2017-05-19
# try to compare Rat Bodymap againg and my data

load("DEseq2_output/2017-05-19_Rat_aging_Heart_RNAseq.RData")
load("DEseq2_output/2017-05-19_Rat_aging_Liver_RNAseq.RData")
load("DEseq2_output/2017-05-19_Rat_aging_brain_RNAseq.RData")

load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_cereb_2015-11-19.RData")
load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_Heart_2015-11-19.RData")
load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_Liver_2015-11-19.RData")


# BIOMART mouse/RAT orthology
my.orthology <- read.csv('2017-05-15_Rat_mouse_biomart_orthology.txt', sep = "\t", header = T)
my.orth.table <- unique(data.frame(cbind(my.orthology$Gene.name,my.orthology$Mouse.gene.name)))
colnames(my.orth.table) <- c("Rat_Symbol","Mouse_Symbol")

# get comparison boxplots
perform_tissue_comp("Liver", my.rat.liver.process, my.liver.RNAseq.process[[1]], my.orth.table)
perform_tissue_comp("Heart", my.rat.heart.process, my.heart.RNAseq.process[[1]], my.orth.table)
perform_tissue_comp("Brain", my.rat.brain.process, my.cereb.RNAseq.process[[1]], my.orth.table)

perform_tissue_comp("Liver_bothSex", my.rat.liver.process.withfem, my.liver.RNAseq.process[[1]], my.orth.table)
perform_tissue_comp("Heart_bothSex", my.rat.heart.process.withfem, my.heart.RNAseq.process[[1]], my.orth.table)
perform_tissue_comp("Brain_bothSex", my.rat.brain.process.withfem, my.cereb.RNAseq.process[[1]], my.orth.table)
