setwd('/Volumes/MyBook_3/BD_aging_project/Public_datasets/GTex/')
source('GTEX_analysis_functions_v3.R')


my.gene.counts <- read.csv('2016-12-16_GTex_Heart_Cerebellum_Liver_FILTERED.txt', header = F, sep="\t")
my.meta.data.patient <- read.csv('2016-12-01_GTex_Heart_Cerebellum_Liver_METADATA.txt',header=T, sep="\t")

#############
# male only
my.liver.gtex.process <- process_aging_rnaseq("Liver", my.gene.counts, my.meta.data.patient)
save(my.liver.gtex.process, file = paste(Sys.Date(),"Liver_GTEx_data_DEseq2_aging_genename_ONLYmale_no_batch.RData"))

my.cereb.gtex.process <- process_aging_rnaseq("Cerebellum", my.gene.counts, my.meta.data.patient)
save(my.cereb.gtex.process, file = paste(Sys.Date(),"Cerebellum_GTEx_data_DEseq2_aging_genename_ONLYmale_no_batch.RData"))

my.heart.gtex.process <- process_aging_rnaseq("Heart", my.gene.counts, my.meta.data.patient)
save(my.heart.gtex.process, file = paste(Sys.Date(),"Heart_GTEx_data_DEseq2_aging_genename_ONLYmale_no_batch.RData"))


#####
# run for male and female
source('GTEX_analysis_functions_v3bis.R')
my.liver.gtex.process <- process_aging_rnaseq_both("Liver", my.gene.counts, my.meta.data.patient)
save(my.liver.gtex.process, file = paste(Sys.Date(),"Liver_GTEx_data_DEseq2_aging_genename_maleFemale.RData"))

my.cereb.gtex.process <- process_aging_rnaseq_both("Cerebellum", my.gene.counts, my.meta.data.patient)
save(my.cereb.gtex.process, file = paste(Sys.Date(),"Cerebellum_GTEx_data_DEseq2_aging_genename_maleFemale.RData"))

my.heart.gtex.process <- process_aging_rnaseq_both("Heart", my.gene.counts, my.meta.data.patient)
save(my.heart.gtex.process, file = paste(Sys.Date(),"Heart_GTEx_data_DEseq2_aging_genename_maleFemale.RData"))

