

perform_tissue_comp <- function(my.tissue, my.gtex.process,my.mouse.process, my.ortho.table) {
  
  my.gtex.process$Human_Symbol <- rownames(my.gtex.process)
  my.mouse.process$Mouse_Symbol <- rownames(my.mouse.process)
  
  my.merge1 <- merge(data.frame(my.gtex.process),my.ortho.table)
  my.merge2 <- merge(data.frame(my.mouse.process),my.merge1, by='Mouse_Symbol')
  
  my.mouse.sig <- my.merge2$padj.x < 0.05 # 549
  my.gtex.sig <- my.merge2$padj.y < 0.05 # 302
  my.both.sig <- bitAnd(my.mouse.sig,my.gtex.sig)>0 # 66
  
  test.mouse.neg <- wilcox.test(my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x <0)], alternative = "less")
  test.mouse.pos <- wilcox.test(my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x >0)], alternative = "greater")
  
  pdf(paste(Sys.Date(),my.tissue,"LogFC_of_mouse_orthologs_in_aging_gtex.pdf",sep="_"))
  boxplot(my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x <0)],
          my.merge2$log2FoldChange.y[my.mouse.sig & (my.merge2$log2FoldChange.x >0)],
          names = c("Mouse Ortholog Down","Mouse Ortholog Up"),
          ylab = "Human aging log2FC per y",
          ylim = c(-0.08,0.08), col = c("cadetblue2","brown1"),
          main = paste(my.tissue,"(Human)")
  )
  text(1,0.07,signif(test.mouse.neg$p.value, digits = 3))
  text(2,0.07,signif(test.mouse.pos$p.value, digits = 3))
  abline(h=0,lty="dashed", col = "red", lwd = 2)
  dev.off()
  
}

