# setwd('/Volumes/BB_USC_2/Aging_RNA_New_species/GSE61260_RAW')
setwd('/Users/benayoun/Dropbox/Manuscripts_and_Publications/2018_aging_epigenomics_data_description/Aging_omics_paper/Github_folder/Figure5_Conservation/Comparisons/Human_microarray/')

options(stringsAsFactors=F)
library(bitops)

# 2017-10-04
# try to compare Horvath Liver againg and my data
load("/Users/benayoun/Dropbox/Manuscripts_and_Publications/2018_aging_epigenomics_data_description/Aging_omics_paper/Github_folder/Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_Liver_2015-11-19.RData")

load("Output/2017-10-04_Horvath_Human_Liver_aging_Male_Only.RData")
my.liver.maleonly <- my.sig
rm(my.sig)

load("Output/2017-10-04_Horvath_Human_Liver_aging_bothSexes.RData")
my.liver.both <- my.sig
rm(my.sig)

# read orthology on Gencode v19 (same as GTEX)
my.orthology <- read.table("../GTex/2016-12-16_Correspondence_GeneName_Human_Mouse_Orthologs.txt",header=T,sep="\t")

my.liver.maleonly$Human_Symbol <- rownames(my.liver.maleonly)
my.liver.both$Human_Symbol <- rownames(my.liver.both)
my.liver.RNAseq.process[[1]]$Mouse_Symbol <- rownames(my.liver.RNAseq.process[[1]])

#### Liver, maleonly #####
my.liver.merge1 <- merge(data.frame(my.liver.maleonly),my.orthology[,4:5])
my.liver.merge2 <- merge(as.data.frame(my.liver.RNAseq.process[[1]]),my.liver.merge1, by='Mouse_Symbol')

my.mouse.sig <- my.liver.merge2$padj < 0.05
my.human.sig <- my.liver.merge2$adj.P.Val < 0.05
my.both.sig <- bitAnd(my.mouse.sig,my.human.sig)>0 # 18

test.mouse.neg <- wilcox.test(my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange <0)], alternative = "less")
test.mouse.pos <- wilcox.test(my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange >0)], alternative = "greater")

pdf(paste(Sys.Date(),"LogFC_of_mouse_orthologs_Liver_HorvathGSE61260_male_only.pdf",sep="_"))
boxplot(my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange <0)],
        my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange >0)],
        names = c("Mouse Ortholog Down","Mouse Ortholog Up"),
        ylab = "Human Liver aging log2FC per y",
        ylim = c(-0.04,0.04), col = c("cadetblue2","brown1"),
        main = "Liver"
)
text(1,0.035,signif(test.mouse.neg$p.value, digits = 3))
text(2,0.035,signif(test.mouse.pos$p.value, digits = 3))
abline(h=0,lty="dashed", col = "red", lwd = 2)
dev.off()


#### Liver, both #####
my.liver.merge1 <- merge(data.frame(my.liver.both),my.orthology[,4:5])
my.liver.merge2 <- merge(data.frame(my.liver.RNAseq.process[[1]]),my.liver.merge1, by='Mouse_Symbol')

my.mouse.sig <- my.liver.merge2$padj < 0.05
my.human.sig <- my.liver.merge2$adj.P.Val < 0.05
my.both.sig <- bitAnd(my.mouse.sig,my.human.sig)>0 # 18

test.mouse.neg <- wilcox.test(my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange <0)], alternative = "less")
test.mouse.pos <- wilcox.test(my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange >0)], alternative = "greater")

pdf(paste(Sys.Date(),"LogFC_of_mouse_orthologs_Liver_HorvathGSE61260_BOTHsexes.pdf",sep="_"))
boxplot(my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange <0)],
        my.liver.merge2$logFC[my.mouse.sig & (my.liver.merge2$log2FoldChange >0)],
        names = c("Mouse Ortholog Down","Mouse Ortholog Up"),
        ylab = "Human Liver aging log2FC per y",
        ylim = c(-0.04,0.04), col = c("cadetblue2","brown1"),
        main = "Liver"
)
text(1,0.035,signif(test.mouse.neg$p.value, digits = 3))
text(2,0.035,signif(test.mouse.pos$p.value, digits = 3))
abline(h=0,lty="dashed", col = "red", lwd = 2)
dev.off()

