setwd('/Volumes/MyBook_3/BD_aging_project/Venn_different_molecules')
options(stringsAsFactors=F)

library('Vennerable')



#####################################################################################################
######################################      RNA results        ######################################  
# no NPCs significant
my.liver.rna.sig <- read.table('Inputs/2015-11-19_Liver_DESeq2_LINEAR_model_with_age _FDR5_genes_statistics.txt',sep="\t",header=T)
my.liver.rna_dwn.sig <- my.liver.rna.sig[my.liver.rna.sig$log2FoldChange < 0,]
my.liver.rna_up.sig <- my.liver.rna.sig[my.liver.rna.sig$log2FoldChange > 0,]

my.cerebellum.rna.sig <- read.table('Inputs/2015-11-19_cerebellum_DESeq2_LINEAR_model_with_age _FDR5_genes_statistics.txt',sep="\t",header=T)
my.cerebellum.rna_dwn.sig <- my.cerebellum.rna.sig[my.cerebellum.rna.sig$log2FoldChange < 0,]
my.cerebellum.rna_up.sig <- my.cerebellum.rna.sig[my.cerebellum.rna.sig$log2FoldChange > 0,]

my.heart.rna.sig <- read.table('Inputs/2015-11-19_heart_DESeq2_LINEAR_model_with_age _FDR5_genes_statistics.txt',sep="\t",header=T)
my.heart.rna_dwn.sig <- my.heart.rna.sig[my.heart.rna.sig$log2FoldChange < 0,]
my.heart.rna_up.sig <- my.heart.rna.sig[my.heart.rna.sig$log2FoldChange > 0,]

my.OB.rna.sig <- read.table('Inputs/2015-11-19_OlfactoryBulb_DESeq2_LINEAR_model_with_age _FDR5_genes_statistics.txt',sep="\t",header=T)
my.OB.rna_dwn.sig <- my.OB.rna.sig[my.OB.rna.sig$log2FoldChange < 0,]
my.OB.rna_up.sig <- my.OB.rna.sig[my.OB.rna.sig$log2FoldChange > 0,]


# UP
my.RNA.up <- list("Heart" = unique(rownames(my.heart.rna_up.sig)),
                  "Liver" = unique(rownames(my.liver.rna_up.sig)),
                  "Cerebellum" = unique(rownames(my.cerebellum.rna_up.sig)),
                  "Olfactory Bulb" = unique(rownames(my.OB.rna_up.sig)))

my.alway.up <- intersect(intersect(my.RNA.up[[1]],my.RNA.up[[2]]),intersect(my.RNA.up[[3]],my.RNA.up[[4]]))
write.table(my.alway.up, file = "2017-05-02_gene_always_up_RNA_all4tissues.txt", quote=F, sep = "\n", row.names=F)
Venn.RNA.up <- Venn(my.RNA.up)

pdf("2017-05-02_Venn_Aging_RNA_UP.pdf")
plot(Venn.RNA.up, type= "ellipses",doWeights=F)
dev.off()

# DOWN
my.RNA.dwn <- list("Heart" = unique(rownames(my.heart.rna_dwn.sig)),
                   "Liver" = unique(rownames(my.liver.rna_dwn.sig)),
                   "Cerebellum" = unique(rownames(my.cerebellum.rna_dwn.sig)),
                   "Olfactory Bulb" = unique(rownames(my.OB.rna_dwn.sig)))

Venn.RNA.dwn <- Venn(my.RNA.dwn)

pdf("2017-05-02_Venn_Aging_RNA_DOWN.pdf")
plot(Venn.RNA.dwn, type= "ellipses",doWeights=F)
dev.off()
#####################################################################################################

