setwd('/Volumes/MyBook_3/BD_aging_project/ChIP-seq/All_tissues_analysis/Pathway_Enrichments/GOrilla_analysis')
library('mHG')
options(stringsAsFactors=F)

source('GOrilla_statistics_functions.R')


my.gmt.sets <- c("h.all.v5.1.symbols.gmt",
                 "M.musculus_KEGG-pathways_04-2017_NO_DISEASES_UC.gmt",
                 "TF-LOF_Expression_from_GEO_WITH_FOXO_2016-08-02_TF_targets.gmt")
                 
my.gmt.set.names <- c("MSIgDB_Hallmark_Datasets",
                    "KEGG_2017_no_diseases_UC",
                    "TF-LOF_Expression_from_GEO_WITH_FOXO_parsed-and-aggregated")
 
cbind(my.gmt.sets, my.gmt.set.names)

my.run <- 1:3


source('GOrilla_statistics_functions.R')

##################################################################################### 

# H3K27ac intensity
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K27ac_height_result_OB_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K27ac_height_result_NPCs_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K27ac_height_result_Cerebellum_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K27ac_height_result_Heart_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K27ac_height_result_Liver_2016-06-01.RData')

run_pathway_enrich(my.OB.height.process, "H3K27ac_intensity", "OB")
run_pathway_enrich(my.Cerebellum.height.process, "H3K27ac_intensity", "Cerebellum")
run_pathway_enrich(my.NPCs.height.process, "H3K27ac_intensity", "NPCs")
run_pathway_enrich(my.Heart.height.process, "H3K27ac_intensity", "Heart")
run_pathway_enrich(my.liver.height.process, "H3K27ac_intensity", "Liver")

rm(my.OB.height.process,my.Cerebellum.height.process,my.NPCs.height.process,my.Heart.height.process,my.liver.height.process)

# H3K4me3 intensity
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K4me3_height_result_NPCs-combined_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K4me3_height_result_OB_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K4me3_height_result_cerebellum_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K4me3_height_result_heart_2016-06-01.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/H3K4me3_height_result_Liver_2016-06-01.RData')

run_pathway_enrich(my.OB.height.process, "H3K4me3_intensity", "OB")
run_pathway_enrich(my.cerebellum.height.process, "H3K4me3_intensity", "Cerebellum")
run_pathway_enrich(my.NPCs.height.process.batch, "H3K4me3_intensity", "NPCs")
run_pathway_enrich(my.heart.height.process, "H3K4me3_intensity", "Heart")
run_pathway_enrich(my.liver.height.process, "H3K4me3_intensity", "Liver")

rm(my.OB.height.process,my.cerebellum.height.process,my.NPCs.height.process.batch,my.heart.height.process,my.liver.height.process)


# H3K4me3 breadth
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/Breadth_result_npc.ALL.batchperlane_2015-12-08.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/Breadth_result_ob_2015-12-08.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/Breadth_result_cereb_2015-12-08.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/Breadth_result_heart_2015-12-08.RData')
load('/Volumes/MyBook_3/BD_aging_project/SMITE_data_intergration/ChIP-seq_data_files/Breadth_result_Liver_2015-12-08.RData')

run_pathway_enrich(my.ob.breadth.process, "H3K4me3_breadth", "OB")
run_pathway_enrich(my.cereb.breadth.process, "H3K4me3_breadth", "Cerebellum")
run_pathway_enrich(my.npc.breadth.process.batch, "H3K4me3_breadth", "NPCs")
run_pathway_enrich(my.heart.breadth.process, "H3K4me3_breadth", "Heart")
run_pathway_enrich(my.liver.breadth.process, "H3K4me3_breadth", "Liver")

rm(my.ob.breadth.process,my.cereb.breadth.process,my.npc.breadth.process.batch,my.heart.breadth.process,my.liver.breadth.process)