setwd('/Volumes/BB_Backup_3/BD_aging_project/2018-09_revision_analyses/TE_chromatin/RepeatMasker/H3K4me3_TEs')

source('height_analysis_functions_linear_vREPEATS.R')

# 2018-09-12
# Run for repetitive elements

####################################    Liver    #################################### 
# read in Diffbind vector matrix
my.liver.data <- read.table("../Diffbind/2018-09-13_Liver_H3K4me3_aging_Repeats_DiffBind_normalized_counts.txt",header=T,sep="\t")
my.liver <- my.liver.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.liver) <- paste(my.liver.data[,1],my.liver.data[,2],my.liver.data[,3],sep="-")
colnames(my.liver) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data
process_aging_height_TE("Liver", my.liver, "../Diffbind/2018-09-13_Liver_H3K4me3_aging_diffbind.Repeat_ANNOT.txt")
# All changed domains   decreased domains   increased domains 
# 39                  17                  22 
##################################################################################### 


####################################    heart    ####################################
# read in Diffbind vector matrix
my.heart.data <- read.table("../Diffbind/2018-09-13_Heart_H3K4me3_aging_Repeats_DiffBind_normalized_counts.txt",header=T,sep="\t")
my.heart <- my.heart.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.heart) <- paste(my.heart.data[,1],my.heart.data[,2],my.heart.data[,3],sep="-")
colnames(my.heart) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data
process_aging_height_TE("heart", my.heart, "../Diffbind/2018-09-13_Heart_H3K4me3_aging_diffbind.Repeat_ANNOT.txt")
# All changed domains   decreased domains   increased domains
# 7                   0                   7 
#####################################################################################


####################################    cerebellum    ####################################
# read in Diffbind vector matrix
my.cerebellum.data <- read.table("../Diffbind/2018-09-13_Cerebellum_H3K4me3_aging_Repeats_DiffBind_normalized_counts.txt",header=T,sep="\t")
my.cerebellum <- my.cerebellum.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.cerebellum) <- paste(my.cerebellum.data[,1],my.cerebellum.data[,2],my.cerebellum.data[,3],sep="-")
colnames(my.cerebellum) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data
process_aging_height_TE("cerebellum", my.cerebellum, "../Diffbind/2018-09-13_Cerebellum_H3K4me3_aging_diffbind.Repeat_ANNOT.txt")
# All changed domains   decreased domains   increased domains
# 5                   5                   0 
#####################################################################################


####################################    OB    ####################################
# read in Diffbind vector matrix
my.OB.data <- read.table("../Diffbind/2018-09-13_OB_H3K4me3_aging_Repeats_DiffBind_normalized_counts.txt",header=T,sep="\t")
my.OB <- my.OB.data[,4:9]
# generate unique rownames based on peak coordinates
rownames(my.OB) <- paste(my.OB.data[,1],my.OB.data[,2],my.OB.data[,3],sep="-")
colnames(my.OB) <- c("3m1","3m2","12m1","12m2","29m1","29m2")

# process data
process_aging_height_TE("OB", my.OB, "../Diffbind/2018-09-13_OB_H3K4me3_aging_diffbind.Repeat_ANNOT.txt")
# All changed domains   decreased domains   increased domains
# 0                   0                   0 
#####################################################################################


####################################    NPCs    ####################################
# read in Diffbind vector matrix for the COMBINED (will have to apply batch correction in model)
my.NPCs.data <- read.table("../Diffbind/2018-09-13_NSPC_H3K4me3_aging_Repeats_DiffBind_normalized_counts.txt",header=T,sep="\t")
my.cols <- c(4:5,10:11,6:7,12:13,8:9,14:15) # reorder by age group
my.NPCs <- my.NPCs.data[,my.cols]

# generate unique rownames based on peak coordinates
rownames(my.NPCs) <- paste(my.NPCs.data[,1],my.NPCs.data[,2],my.NPCs.data[,3],sep="-")
colnames(my.NPCs) <- c("3m1","3m2","3m5","3m6","12m1","12m2","12m5","12m6","29m1","29m2","29m5","29m6")

my.batch.per.seq <- factor(paste("experiment",rep(c(1,1,2,2),3),sep=""))

# process data and save RData NPCsject
process_aging_height_TE_batch("NPCs", my.NPCs,"../Diffbind/2018-09-13_NSPC_H3K4me3_aging_diffbind.Repeat_ANNOT.txt",my.batch.per.seq)
# All changed domains   decreased domains   increased domains
# 0                   0                   0 
#####################################################################################