setwd('/Volumes/MyBook_3/BD_aging_project/RNAseq/All_tissues_analysis/Pathway_enrichment/GOrilla_like')
library('mHG')
options(stringsAsFactors=F)

source('GOrilla_statistics_functions.R')

# need to create 3 folders to get the results: 
# RData, FDR5percent and ALL_PATHWAYS (see path of created files in functions called)

my.gmt.sets <- c("Figure4_enrichments/PATHWAYS/h.all.v5.1.symbols.gmt",
                 "Figure4_enrichments/PATHWAYS/M.musculus_KEGG-pathways_04-2017_NO_DISEASES_UC.gmt",
                 "Figure4_enrichments/PATHWAYS/TF-LOF_Expression_from_GEO_WITH_FOXO_2016-08-02_TF_targets.gmt")
                 
my.gmt.set.names <- c("MSIgDB_Hallmark_Datasets",
                    "KEGG_2017_no_diseases_UC",
                    "TF-LOF_Expression_from_GEO_WITH_FOXO_parsed-and-aggregated")
 
cbind(my.gmt.sets, my.gmt.set.names)

my.run <- 1:3

source('GOrilla_statistics_functions.R')


##################################################################################### 
# Load RData RNA with age results
load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_Liver_2015-11-19.RData")
load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_cereb_2015-11-19.RData")
load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_Heart_2015-11-19.RData")
load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_OB_2015-11-19.RData")
load("Figure3_Machine_learning/Feature_extraction/Feature_folders/RNAseq_DEseq2_results/RNA_seq_result_NPCs_2015-11-19.RData")

# My data
run_pathway_enrich("Heart", my.heart.RNAseq.process[[1]])
run_pathway_enrich("Cerebellum", my.cereb.RNAseq.process[[1]])
run_pathway_enrich("Liver", my.liver.RNAseq.process[[1]])
run_pathway_enrich("OB", my.ob.RNAseq.process[[1]])
run_pathway_enrich("NPCs", my.npc.RNAseq.process[[1]])

  
# All tissues
load("2016-02-05_ALL_global_variance\ estimate_DESeq2_LINEAR_model_with_age\ _statistics.RData") # same code as above, input is not provided
run_pathway_enrich("Aging_across_tissues", res.1)