setwd('/Volumes/BB_USC_1/Aging_IPA/')

# 2018/03/19
# Parse IPA results from Salah
# he rerun with newest function
# need to use bias corrected Z-score when bias term exists

source('Parse_IPA_functions_v2.R')

# Direct and indirect files
ALL.ipa.both     <- read.csv('New_IPA/ALL_global_variance_IPA.txt',sep = "\t",header=T)
Cereb.ipa.both   <- read.csv('New_IPA/Cerebellum_IPA.txt',sep = "\t",header=T)
Heart.ipa.both   <- read.csv('New_IPA/Heart_IPA.txt',sep = "\t",header=T)
Liver.ipa.both   <- read.csv('New_IPA/Liver_IPA.txt',sep = "\t",header=T)
OB.ipa.both      <- read.csv('New_IPA/OB_IPA.txt',sep = "\t",header=T)


# clean bias
ALL.ipa.clean     <- clean_ipa_bias(ALL.ipa.both  )
Cereb.ipa.clean   <- clean_ipa_bias(Cereb.ipa.both)
Heart.ipa.clean   <- clean_ipa_bias(Heart.ipa.both)
Liver.ipa.clean   <- clean_ipa_bias(Liver.ipa.both)
OB.ipa.clean      <- clean_ipa_bias(OB.ipa.both   )



#### run summary function
get_enrich_balloons("IPA",
                    my.ips.res = list(ALL.ipa.clean  ,
                                      Cereb.ipa.clean,
                                      Heart.ipa.clean,
                                      Liver.ipa.clean,
                                      OB.ipa.clean   ))

  