setwd('/Volumes/BB_Backup_3/BD_aging_project/2018-09_revision_analyses/Machine_learning/Accuracies_comparison/')
library(pheatmap)
options(stringsAsFactors = F)

# 2018-09-24
# compare accuracies of models built on different sets of features

my.acc.cereb.dyn.gbm.noCST      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/Cerebellum/2018-09-17_Cerebellum_DYNAMIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.heart.dyn.gbm.noCST      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/Heart/2018-09-17_Heart_DYNAMIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.liver.dyn.gbm.noCST      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/Liver/2018-09-17_Liver_DYNAMIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.olbub.dyn.gbm.noCST      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/OB/2018-09-17_Olfactory_Bulb_DYNAMIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.cereb.stc.gbm.noCST      <- read.table("../STATIC/Model_RData/GBM/Chromatin/Cerebellum/2018-09-14_Cerebellum_STATIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.heart.stc.gbm.noCST      <- read.table("../STATIC/Model_RData/GBM/Chromatin/Heart/2018-09-14_Heart_STATIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.liver.stc.gbm.noCST      <- read.table("../STATIC/Model_RData/GBM/Chromatin/Liver/2018-09-14_Liver_STATIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.olbub.stc.gbm.noCST      <- read.table("../STATIC/Model_RData/GBM/Chromatin/OB/2018-09-14_Olfactory_Bulb_STATIC_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.cereb.bth.gbm.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/Cerebellum/2018-09-20_Cerebellum_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.heart.bth.gbm.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/Heart/2018-09-20_Heart_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.liver.bth.gbm.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/Liver/2018-09-20_Liver_GBM_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.olbub.bth.gbm.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/OB/2018-09-20_Olfactory_Bulb_GBM_metrics_classification_noCST.txt", sep = " ", header = T)

my.acc.cereb.dyn.rf.noCST      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/Cerebellum/2018-09-17_Cerebellum_DYNAMIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.heart.dyn.rf.noCST      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/Heart/2018-09-17_Heart_DYNAMIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.liver.dyn.rf.noCST      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/Liver/2018-09-17_Liver_DYNAMIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.olbub.dyn.rf.noCST      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/OB/2018-09-17_Olfactory_Bulb_DYNAMIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.cereb.stc.rf.noCST      <- read.table("../STATIC/Model_RData/RF/Chromatin/Cerebellum/2018-09-14_Cerebellum_STATIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.heart.stc.rf.noCST      <- read.table("../STATIC/Model_RData/RF/Chromatin/Heart/2018-09-14_Heart_STATIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.liver.stc.rf.noCST      <- read.table("../STATIC/Model_RData/RF/Chromatin/Liver/2018-09-14_Liver_STATIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.olbub.stc.rf.noCST      <- read.table("../STATIC/Model_RData/RF/Chromatin/OB/2018-09-14_Olfactory_Bulb_STATIC_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.cereb.bth.rf.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/Cerebellum/2018-09-20_Cerebellum_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.heart.bth.rf.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/Heart/2018-09-20_Heart_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.liver.bth.rf.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/Liver/2018-09-20_Liver_RF_metrics_classification_noCST.txt", sep = " ", header = T)
my.acc.olbub.bth.rf.noCST      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/OB/2018-09-20_Olfactory_Bulb_RF_metrics_classification_noCST.txt", sep = " ", header = T)

my.acc.cereb.dyn.gbm.SAMP      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/Cerebellum/2018-09-17_Cerebellum_DYNAMIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.heart.dyn.gbm.SAMP      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/Heart/2018-09-17_Heart_DYNAMIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.liver.dyn.gbm.SAMP      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/Liver/2018-09-17_Liver_DYNAMIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.olbub.dyn.gbm.SAMP      <- read.table("../DYNAMIC/Model_RData/GBM/Chromatin/OB/2018-09-17_Olfactory_Bulb_DYNAMIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.cereb.stc.gbm.SAMP      <- read.table("../STATIC/Model_RData/GBM/Chromatin/Cerebellum/2018-09-14_Cerebellum_STATIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.heart.stc.gbm.SAMP      <- read.table("../STATIC/Model_RData/GBM/Chromatin/Heart/2018-09-14_Heart_STATIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.liver.stc.gbm.SAMP      <- read.table("../STATIC/Model_RData/GBM/Chromatin/Liver/2018-09-14_Liver_STATIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.olbub.stc.gbm.SAMP      <- read.table("../STATIC/Model_RData/GBM/Chromatin/OB/2018-09-14_Olfactory_Bulb_STATIC_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.cereb.bth.gbm.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/Cerebellum/2018-09-20_Cerebellum_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.heart.bth.gbm.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/Heart/2018-09-20_Heart_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.liver.bth.gbm.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/Liver/2018-09-20_Liver_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.olbub.bth.gbm.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/GBM/Chromatin/OB/2018-09-20_Olfactory_Bulb_GBM_metrics_classification_withSampling.txt", sep = " ", header = T)

my.acc.cereb.dyn.rf.SAMP      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/Cerebellum/2018-09-17_Cerebellum_DYNAMIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.heart.dyn.rf.SAMP      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/Heart/2018-09-17_Heart_DYNAMIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.liver.dyn.rf.SAMP      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/Liver/2018-09-17_Liver_DYNAMIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.olbub.dyn.rf.SAMP      <- read.table("../DYNAMIC/Model_RData/RF/Chromatin/OB/2018-09-17_Olfactory_Bulb_DYNAMIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.cereb.stc.rf.SAMP      <- read.table("../STATIC/Model_RData/RF/Chromatin/Cerebellum/2018-09-14_Cerebellum_STATIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.heart.stc.rf.SAMP      <- read.table("../STATIC/Model_RData/RF/Chromatin/Heart/2018-09-14_Heart_STATIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.liver.stc.rf.SAMP      <- read.table("../STATIC/Model_RData/RF/Chromatin/Liver/2018-09-14_Liver_STATIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.olbub.stc.rf.SAMP      <- read.table("../STATIC/Model_RData/RF/Chromatin/OB/2018-09-14_Olfactory_Bulb_STATIC_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.cereb.bth.rf.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/Cerebellum/2018-09-20_Cerebellum_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.heart.bth.rf.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/Heart/2018-09-20_Heart_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.liver.bth.rf.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/Liver/2018-09-20_Liver_RF_metrics_classification_withSampling.txt", sep = " ", header = T)
my.acc.olbub.bth.rf.SAMP      <- read.table("../rerun_with_same_package_version/Model_RData/RF/Chromatin/OB/2018-09-20_Olfactory_Bulb_RF_metrics_classification_withSampling.txt", sep = " ", header = T)

##################################################################################
## consolidate accuracies for plotting
my.random <- rep(0.5,3)
my.perfect <- rep(1,3)


my.dyn.gbm.no.cst <- as.numeric(c(my.acc.heart.dyn.gbm.noCST[1],
                                  my.acc.liver.dyn.gbm.noCST[1],
                                  my.acc.cereb.dyn.gbm.noCST[1],
                                  my.acc.olbub.dyn.gbm.noCST[1]))

my.stc.gbm.no.cst <- as.numeric(c(my.acc.heart.stc.gbm.noCST[1],
                                  my.acc.liver.stc.gbm.noCST[1],
                                  my.acc.cereb.stc.gbm.noCST[1],
                                  my.acc.olbub.stc.gbm.noCST[1]))

my.bth.gbm.no.cst <- as.numeric(c(my.acc.heart.bth.gbm.noCST[1],
                                  my.acc.liver.bth.gbm.noCST[1],
                                  my.acc.cereb.bth.gbm.noCST[1],
                                  my.acc.olbub.bth.gbm.noCST[1]))

my.gbm.noCST.table <- data.frame(rbind(cbind(my.dyn.gbm.no.cst,
                                             my.stc.gbm.no.cst,
                                             my.bth.gbm.no.cst),
                                       my.random,
                                       my.perfect))
colnames(my.gbm.noCST.table)  <- c("Dynamic","Static","Both")
rownames(my.gbm.noCST.table)  <- c("Heart","Liver","Cerebellum","OB", "Random", "Perfect")

####
my.dyn.rf.no.cst <- as.numeric(c(my.acc.heart.dyn.rf.noCST[1],
                                 my.acc.liver.dyn.rf.noCST[1],
                                 my.acc.cereb.dyn.rf.noCST[1],
                                 my.acc.olbub.dyn.rf.noCST[1]))

my.stc.rf.no.cst <- as.numeric(c(my.acc.heart.stc.rf.noCST[1],
                                 my.acc.liver.stc.rf.noCST[1],
                                 my.acc.cereb.stc.rf.noCST[1],
                                 my.acc.olbub.stc.rf.noCST[1]))

my.bth.rf.no.cst <- as.numeric(c(my.acc.heart.bth.rf.noCST[1],
                                 my.acc.liver.bth.rf.noCST[1],
                                 my.acc.cereb.bth.rf.noCST[1],
                                 my.acc.olbub.bth.rf.noCST[1]))


my.rf.noCST.table <- data.frame(rbind(cbind(my.dyn.rf.no.cst,
                                            my.stc.rf.no.cst,
                                            my.bth.rf.no.cst),
                                      my.random,
                                      my.perfect))
colnames(my.rf.noCST.table)  <- c("Dynamic","Static","Both")
rownames(my.rf.noCST.table)  <- c("Heart","Liver","Cerebellum","OB", "Random", "Perfect")

####
my.dyn.gbm.samp <- as.numeric(c(my.acc.heart.dyn.gbm.SAMP[4,1],
                                my.acc.liver.dyn.gbm.SAMP[4,1],
                                my.acc.cereb.dyn.gbm.SAMP[4,1],
                                my.acc.olbub.dyn.gbm.SAMP[4,1]))

my.stc.gbm.samp <- as.numeric(c(my.acc.heart.stc.gbm.SAMP[4,1],
                                my.acc.liver.stc.gbm.SAMP[4,1],
                                my.acc.cereb.stc.gbm.SAMP[4,1],
                                my.acc.olbub.stc.gbm.SAMP[4,1]))

my.bth.gbm.samp <- as.numeric(c(my.acc.heart.bth.gbm.SAMP[4,1],
                                my.acc.liver.bth.gbm.SAMP[4,1],
                                my.acc.cereb.bth.gbm.SAMP[4,1],
                                my.acc.olbub.bth.gbm.SAMP[4,1]))

my.gbm.samp.table <- data.frame(rbind(cbind(my.dyn.gbm.samp,
                                            my.stc.gbm.samp,
                                            my.bth.gbm.samp),
                                      my.random,
                                      my.perfect))
colnames(my.gbm.samp.table)  <- c("Dynamic","Static","Both")
rownames(my.gbm.samp.table)  <- c("Heart","Liver","Cerebellum","OB", "Random", "Perfect")

####
my.dyn.rf.samp <- c(my.acc.heart.dyn.rf.SAMP[4,1],
                    my.acc.liver.dyn.rf.SAMP[4,1],
                    my.acc.cereb.dyn.rf.SAMP[4,1],
                    my.acc.olbub.dyn.rf.SAMP[4,1])

my.stc.rf.samp <- c(my.acc.heart.stc.rf.SAMP[4,1],
                    my.acc.liver.stc.rf.SAMP[4,1],
                    my.acc.cereb.stc.rf.SAMP[4,1],
                    my.acc.olbub.stc.rf.SAMP[4,1])

my.bth.rf.samp <- c(my.acc.heart.bth.rf.SAMP[4,1],
                    my.acc.liver.bth.rf.SAMP[4,1],
                    my.acc.cereb.bth.rf.SAMP[4,1],
                    my.acc.olbub.bth.rf.SAMP[4,1])

my.rf.samp.table <- data.frame(rbind(cbind(my.dyn.rf.samp,
                                           my.stc.rf.samp,
                                           my.bth.rf.samp),
                                     my.random,
                                     my.perfect))

colnames(my.rf.samp.table)  <- c("Dynamic","Static","Both")
rownames(my.rf.samp.table)  <- c("Heart","Liver","Cerebellum","OB", "Random", "Perfect")

######################################################################
# Make plots
# my.gbm.noCST.table
# my.rf.noCST.table
# my.gbm.samp.table
# my.rf.samp.table


my.accuracy.colors <- c("floralwhite","lightsalmon","indianred1","firebrick3","firebrick","firebrick4")

# plot combined accuracy heatmaps
pdf(paste(Sys.Date(),"GBM_accuracies_2class_model_comparisons.pdf", sep="_"), onefile=F)
pheatmap(data.frame(my.gbm.noCST.table), cluster_rows = F, cluster_cols = F, 
         col = colorRampPalette(my.accuracy.colors)(50),
         main = "2-class classification")
dev.off()


pdf(paste(Sys.Date(),"RF_accuracies_2class_model_comparisons.pdf", sep="_"), onefile=F)
pheatmap(data.frame(my.rf.noCST.table), cluster_rows = F, cluster_cols = F, 
         col = colorRampPalette(my.accuracy.colors)(50),
         main = "2-class classification")
dev.off()


pdf(paste(Sys.Date(),"GBM_accuracies_3class_model_comparisons.pdf", sep="_"), onefile=F)
pheatmap(data.frame(my.gbm.samp.table), cluster_rows = F, cluster_cols = F, 
         col = colorRampPalette(my.accuracy.colors)(50),
         main = "3-class classification")
dev.off()


pdf(paste(Sys.Date(),"RF_accuracies_3class_model_comparisons.pdf", sep="_"), onefile=F)
pheatmap(data.frame(my.rf.samp.table), cluster_rows = F, cluster_cols = F, 
         col = colorRampPalette(my.accuracy.colors)(50),
         main = "3-class classification")
dev.off()
