setwd('/home/benayoun/Projects/ML')
source('GBM_helper_functions_v3.R')

load("2016-11-21_Complete_feature_matrices_FOLD_CHANGE_NA_RM.RData")
load("2017-03-20_Complete_feature_matrices_CEREB_FOLD_CHANGE_NA_RM.RData")

#####################################
## 2018-09-10
# for revision, learn iwht only static

# Keep only static features for revision
my.col.include <- c("age_change","TR","FPKM_3m", "H3K4me3_averageIntensity_3m", "H3K27ac_averageIntensity_3m", "SE_3m","SE_score_3m","SE_TSS_Dist","maxbreadth_y","BD_qt_y",
					"BD_stat_y","H3K4me1_prom","CTCF_prom","Pol2_prom","Pol2_peaks","Pol2_abs_TSS_dist","Pol2_MACS2_max_score","CpG_promoter_percentage","CG_promoter_percentage","CTCF_peaks",
					"CTCF_abs_TSS_dist","CTCF_MACS2_max_score","Constitutive.Exon","CpG_islands" , "H3K27me3_prom","DNAseI_prom","Bivalent_status")

###########################################
############        Heart      ############ 
###########################################

# get data partition
my.heart.training.idx <- get_training_idx(my.heart.features.v2) 

# run random forest
my.heart.gbm.samp.fit <- get_gbm_fit_with_sampling(my.heart.features.v2[,my.col.include], my.heart.training.idx, my.samples = 50)
save(my.heart.gbm.samp.fit,my.heart.training.idx,
     file = paste(Sys.Date(),"Heart_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))

my.heart.gbm.noCST.fit <- get_gbm_fit_noCST(my.heart.features.v2[,my.col.include], my.heart.training.idx)
save(my.heart.gbm.noCST.fit,my.heart.training.idx,
     file = paste(Sys.Date(),"Heart_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))

###########################################
############        Liver      ############ 
###########################################

# get data partition
my.liver.training.idx <- get_training_idx(my.liver.features.v2) 

# run random forest
my.liver.gbm.samp.fit <- get_gbm_fit_with_sampling(my.liver.features.v2[,my.col.include], my.liver.training.idx, my.samples = 50)
save(my.liver.gbm.samp.fit,my.liver.training.idx,
     file = paste(Sys.Date(),"Liver_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))

my.liver.gbm.noCST.fit <- get_gbm_fit_noCST(my.liver.features.v2[,my.col.include], my.liver.training.idx)
save(my.liver.gbm.noCST.fit,my.liver.training.idx,
     file = paste(Sys.Date(),"Liver_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))


###########################################
############     Cerebellum    ############ 
###########################################

# get data partition
my.cereb.training.idx <- get_training_idx(my.cereb.features.v2) 

# run random forest
my.cereb.gbm.samp.fit <- get_gbm_fit_with_sampling(my.cereb.features.v2[,my.col.include], my.cereb.training.idx, my.samples = 50)
save(my.cereb.gbm.samp.fit,my.cereb.training.idx,
     file = paste(Sys.Date(),"cereb_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))

my.cereb.gbm.noCST.fit <- get_gbm_fit_noCST(my.cereb.features.v2[,my.col.include], my.cereb.training.idx)
save(my.cereb.gbm.noCST.fit,my.cereb.training.idx,
     file = paste(Sys.Date(),"cereb_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))


###########################################
############         OB        ############ 
###########################################

# get data partition
my.OB.training.idx <- get_training_idx(my.ob.features) 

#run with extra features
my.OB.gbm.samp.fit <- get_gbm_fit_with_sampling(my.ob.features.v2[,my.col.include], my.OB.training.idx)
save(my.OB.gbm.samp.fit,my.OB.training.idx,
     file = paste(Sys.Date(),"OB_withBrainExtra_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))

my.OB.gbm.noCST.fit <- get_gbm_fit_noCST(my.ob.features.v2[,my.col.include], my.OB.training.idx)
save(my.OB.gbm.noCST.fit,my.OB.training.idx,
     file = paste(Sys.Date(),"OB_withBrainExtra_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_STATIC_ONLY.RData",sep="_"))
