setwd('/home/benayoun/Projects/ML')
source('RF_helper_functions_v3.R')

load("2016-11-21_Complete_feature_matrices_FOLD_CHANGE_NA_RM.RData")
load("2017-03-20_Complete_feature_matrices_CEREB_FOLD_CHANGE_NA_RM.RData")


#####################################
## 2018-09-14
# for revision, learn with only dynamic

# Keep only dynamic features for revision (compare to both and only static)
my.col.include <- c("age_change","H3K4me3_age_slope","H3K27ac_age_slope","SE_aging_slope","breadth_qt_slope","Increased_Nucs","Decreased_Nucs","Max_occupancy_log2FC_age")


###########################################
############        Heart      ############ 
###########################################

# get data partition
my.heart.training.idx <- get_training_idx(my.heart.features.v2) 

# run random forest
my.heart.rf.samp.fit <- get_rf_fit_with_sampling(my.heart.features.v2[,my.col.include], my.heart.training.idx)
save(my.heart.rf.samp.fit,my.heart.training.idx,
     file = paste(Sys.Date(),"Heart_RF_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))

my.heart.rf.noCST.fit <- get_rf_fit_noCST(my.heart.features.v2[,my.col.include], my.heart.training.idx)
save(my.heart.rf.noCST.fit,my.heart.training.idx,
     file = paste(Sys.Date(),"Heart_RF_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))



###########################################
############        Liver      ############ 
###########################################

# get data partition
my.liver.training.idx <- get_training_idx(my.liver.features.v2) 

# run random forest
my.liver.rf.samp.fit <- get_rf_fit_with_sampling(my.liver.features.v2[,my.col.include], my.liver.training.idx)
save(my.liver.rf.samp.fit,my.liver.training.idx,
     file = paste(Sys.Date(),"Liver_RF_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))

my.liver.rf.noCST.fit <- get_rf_fit_noCST(my.liver.features.v2[,my.col.include], my.liver.training.idx)
save(my.liver.rf.noCST.fit,my.liver.training.idx,
     file = paste(Sys.Date(),"Liver_RF_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))

###########################################
############     Cerebellum    ############ 
###########################################

# get data partition
my.cereb.training.idx <- get_training_idx(my.cereb.features.v2) 

# run random forest
my.cereb.rf.samp.fit <- get_rf_fit_with_sampling(my.cereb.features.v2[,my.col.include], my.cereb.training.idx)
save(my.cereb.rf.samp.fit,my.cereb.training.idx,
     file = paste(Sys.Date(),"cereb_RF_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))

my.cereb.rf.noCST.fit <- get_rf_fit_noCST(my.cereb.features.v2[,my.col.include], my.cereb.training.idx)
save(my.cereb.rf.noCST.fit,my.cereb.training.idx,
     file = paste(Sys.Date(),"cereb_RF_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))

###########################################
############         OB        ############ 
###########################################

# get data partition
my.OB.training.idx <- get_training_idx(my.ob.features) 

#run with extra features
my.OB.rf.samp.fit <- get_rf_fit_with_sampling(my.ob.features.v2[,my.col.include], my.OB.training.idx)
save(my.OB.rf.samp.fit,my.OB.training.idx,
     file = paste(Sys.Date(),"OB_withBrainExtra_RF_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))

my.OB.rf.noCST.fit <- get_rf_fit_noCST(my.ob.features.v2[,my.col.include], my.OB.training.idx)
save(my.OB.rf.noCST.fit,my.OB.training.idx,
     file = paste(Sys.Date(),"OB_withBrainExtra_RF_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData",sep="_"))
