setwd('/Volumes/BB_Backup_3/BD_aging_project/2018-09_revision_analyses/Machine_learning/DYNAMIC/Model_RData/GBM/')
source('parsing_functions_vGBM_newCaret.R')

# load input data
load('/Volumes/BB_Backup_3/BD_aging_project/Machine_learning_aging/Predict_Fold_change/2016-11-21_Complete_feature_matrices_FOLD_CHANGE_NA_RM.RData')
load('/Volumes/BB_Backup_3/BD_aging_project/Machine_learning_aging/Predict_Fold_change/2017-03-20_Complete_feature_matrices_CEREB_FOLD_CHANGE_NA_RM.RData')

# 2018-09-17
# run for dynamic (revision)
# new caret version (6.0-80))

#####################################
##########       Liver       ########
#####################################

### 1. Learning with Samplings ###
load('Chromatin/2018-09-14_Liver_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_withSAMP("Liver_DYNAMIC", my.liver.gbm.samp.fit,my.liver.features.v2[-my.liver.training.idx,])
  
### 2. Learning without constant class
my.no.cst.testing <- remove_cst(my.liver.features.v2[-my.liver.training.idx,])

load('Chromatin/2018-09-14_Liver_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_noCST("Liver_DYNAMIC", my.liver.gbm.noCST.fit,my.no.cst.testing)
#####################################
#####################################


#####################################
##########       Heart       ########
#####################################
### 1. Learning with Samplings ###
load('Chromatin/2018-09-14_Heart_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_withSAMP("Heart_DYNAMIC", my.heart.gbm.samp.fit,my.heart.features.v2[-my.heart.training.idx,])

### 2. Learning without constant class
my.no.cst.testing <- remove_cst(my.heart.features.v2[-my.heart.training.idx,])

load('Chromatin/2018-09-14_Heart_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_noCST("Heart_DYNAMIC", my.heart.gbm.noCST.fit,my.no.cst.testing)
#####################################
#####################################


#####################################
##########    Cerebellum     ########
#####################################

### 1. Learning with Samplings ###
load('Chromatin/2018-09-14_cereb_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_withSAMP("Cerebellum_DYNAMIC", my.cereb.gbm.samp.fit,my.cereb.features.v2[-my.cereb.training.idx,])

### 2. Learning without constant class
my.no.cst.testing <- remove_cst(my.cereb.features.v2[-my.cereb.training.idx,])

load('Chromatin/2018-09-14_cereb_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_noCST("Cerebellum_DYNAMIC", my.cereb.gbm.noCST.fit,my.no.cst.testing)
#####################################
#####################################


#####################################
##########       OB       ########
#####################################

### 1. Learning with Samplings ###
load('Chromatin/2018-09-14_OB_withBrainExtra_GBM_model_withSampling_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_withSAMP("Olfactory_Bulb_DYNAMIC", my.OB.gbm.samp.fit,my.ob.features.v2[-my.OB.training.idx,])

### 2. Learning without constant class
my.no.cst.testing <- remove_cst(my.ob.features.v2[-my.OB.training.idx,])

load('Chromatin/2018-09-14_OB_withBrainExtra_GBM_model_noCONSTANT_aging_changes_noRNA_FDR0.1_DYNAMIC_ONLY.RData')
get_gbm_metrics_and_summarize_noCST("Olfactory_Bulb_DYNAMIC", my.OB.gbm.noCST.fit,my.no.cst.testing)
#####################################
#####################################