#! /usr/bin/perl

use warnings;
use strict;


# a script to downsample to desired size
unless (scalar @ARGV == 2) {
	die "Usage : get_densities_per_DS.pl <prefix> <bed of calibration regions>.\n";

}

my $prefix = shift @ARGV;
my $bed = shift @ARGV;

#my $bed = "Intersect_common_peaks_all_reps_yg_old.bed";

my @outs = ();

for (my $i = 1; $i <= 20; ++$i) {
	
	# calculate downsize factor for picard tool P option, 5 % decrements in depth
	my $percent = $i * 5;
	
	#sort bam file before call to samtools
	my $currentfile = $prefix.($percent)."percent.bed";
	
	my $out = $prefix.($percent)."percent.COVERAGE.bed";
	
	push (@outs, $out);
	
	my $shell_line = "coveragebed -hist -a $currentfile -b $bed > $out";
	system($shell_line);
}


my $resultfile = $prefix."_coverage_per_DS_all_histo.bed";

foreach my $covfile (@outs) {

	system("cat $covfile | grep 'all' > hist_$covfile");
	system("rm $covfile"); # keep only hist files

}

exit;
