#! /usr/bin/perl

use warnings;
use strict;

# a script to downsample to desired size
unless (scalar @ARGV >= 2) {
	die "\nNot enough command line arguments.\n".
	"Usage : compare_adjusted_peaks.pl <assembly> <REF bed> <adjusted bed file list>.\n";

}

my $ass = shift @ARGV; 

# broad peaks bed file from MERGED samples
my $ref_file = shift @ARGV; 

$ref_file =~ m/(.+)_broad_peaks\.bed/;
my $ref_name = $1;

my $tempreffile =  $ref_name.".tmp";
my $cmd = "cat $ref_file | cut -f 1,2,3,4 > $tempreffile";
system($cmd);

# create an array that contains the list of files to be treated
my @bed_files = @ARGV;
my @new_files = ();

foreach my $bed (@bed_files) {

	# matched pattern containing the mark
	# $1 is set to the pattern in the parentheses
	$bed =~ m/(.+)_broad_peaks\.bed/;
	my $sample = $1;
	
	#sort bam file before call to samtools
	my $new_filename = $ref_name."_intersected_by_".$sample.".bed";
	push(@new_files,$new_filename);

	my $shell_line = "intersectBed -wao -b $bed -a $tempreffile | cut -f 1,2,3,4,5,6,7,8,17 > $new_filename";
	system($shell_line);
	
}

unlink $tempreffile;

my $homerfile = "HOMER_".$ref_name.".xls";

my $annot_cmd = "annotatePeaks.pl $ref_file $ass > $homerfile";
system($annot_cmd);

my $mergefile = "Merged_".$ref_name.".PARSED_INTERSECTIONS.xls";
my $bedlist = join(" ",@new_files);

my $merge_cmd = "merge_homer_intersect_files.pl $homerfile $bedlist > $mergefile";
system($merge_cmd);

exit;

###########################################################
# SUBROUTINES
###########################################################

###########################################################
# a subroutine that separates fields from a data line and
# returns them in an array

sub get_line_data {

    my $line = $_[0];
    
    chomp $line;
    
    my @linedata = split(/\t/, $line);
       
    return @linedata;
}
