#!/bin/bash

if [[ "$#" -lt 2 ]]
then
    echo "$(basename $0) [bedFile reads] [bedFile peaks]"  1>&2
    echo "   [bedFile reads]: BED file of reads (mapped/rm dup/sort)" 1>&2
    echo "   [bedFile peaks]: bed file of calibration regions" 1>&2
    exit 1
fi

bamFile=$(echo $1 | sed 's:/$::g')
bedFile=$(echo $2 | sed 's:/$::g')


###########################
# 1) Generate initial coverage files
outCov=$(basename "${bamFile}" | sed 's/\.bed/_cov_regions\.bed/g');

coveragebed -hist -a $bamFile -b $bedFile > $outCov
echo "Finished coverage analysis pre-downsampling"

###########################
# 2) Run gradual DS script
Gradual_down_sampling_bed_file.pl $bamFile
echo "Finished downsampling $bamFile"



###########################
# 3) generate coverage calibrations files
outPrefix=$(basename "${bamFile}" | sed 's/\.bed//g');
get_densities_per_DS_BED.pl $outPrefix $bedFile
echo "Finished generating calibration files"
