#! /usr/bin/perl

use warnings;
use strict;

# a script to downsample to desired size
unless (scalar @ARGV) {
	die "Usage : Gradual_down_sampling_bed_file.pl <bed file list>.\n";

}

# create an array that contains the list of files to be treated
my @bed_files = @ARGV;

foreach my $elem (@bed_files) {

	# matched pattern containing the mark
	# $1 is set to the pattern in the parentheses
	$elem =~ m/(.+)\.bed/;
	my $mark = $1;
	print "Now processing $mark...\n";
	
	srand(time|$$);
	my $seed = int(rand(1000));

	for (my $i = 1; $i <= 20; ++$i) {
		
		# calculate downsize factor for picard tool P option, 5 % decrements in depth
		my $ds_proba = $i * 0.05;
		
		#sort bam file before call to samtools
		my $new_filename = "$mark".(100*$ds_proba)."percent.bed";

		print "Downsizing randomly $elem by ".(100*$ds_proba)." %...\n";
		
		open (BED, $elem) or die "Could not open $elem: $!\n";
		open (OUT, '>',$new_filename) or die "Could not create $new_filename: $!\n";
	
		while (my $line = <BED>) {
			my $num = rand(100);
			#print $num."\n";
			if ( $num < 100*$ds_proba) { # proba of keeping the read
				print OUT $line;
			}
		
		}
		
		close BED;
		close OUT;

	}
}


exit;
