#!/bin/bash

if [[ "$#" -lt 1 ]]
then
    echo "$(basename $0) [oDir]"  1>&2
    echo "   [oDir]: input/output directory" 1>&2
    exit 1
fi

oDir=$(echo $1 | sed 's:/$::g')

# make output directory if it doesnt exist
[[ ! -d "${oDir}" ]] && mkdir "${oDir}"
[[ ! -d "${oDir}/FASTQ_Filter" ]] && mkdir "${oDir}/FASTQ_trimmed"
[[ ! -d "${oDir}/FASTQ_Filter/reports" ]] && mkdir "${oDir}/FASTQ_trimmed/reports"

# 1) quality trimming to remove bases that have phred <15 
filePath="${oDir}"
for f in $(find "$filePath" -name '*.fastq')
do
	echo "Filtering file $f\n"
 	fileName=$(basename "${f}" | sed 's/\.fastq/_filter\.fastq/g');
 	filePath2="${oDir}/FASTQ_trimmed"
 	repPath="${oDir}/FASTQ_trimmed/reports"
	oFname="${filePath}/${fileName}"
	trim_galore -s 13 --length 36 --phred33 -q 15 $f
	mv $filePath/*_trimmed.fq $filePath2
	mv $filePath/*_trimming_report.txt $repPath
done
echo "Finished fastq quality trimming\n"


