# Merge all H3K27ac reads for meta peak calling (references)
cat ../BAM_clean/12m1_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed \
../BAM_clean/12m2_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed \
../BAM_clean/29m1_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed \
../BAM_clean/29m2_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed \
../BAM_clean/3m2_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed \
../BAM_clean/3m3_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed \
 > ALL_AGES_MERGED_Heart_H3K27ac.FIXSEQ_CLEANED_READS.bed

# get a link to the metareads for H3 ChIPs
#ln -s ../H3K4me3_Breadth/ALL_AGES_MERGED_Heart_H3.FIXSEQ_CLEANED_READS.bed

# Call meta peaks
macs2 -t ALL_AGES_MERGED_Heart_H3K27ac.FIXSEQ_CLEANED_READS.bed -c ALL_AGES_MERGED_Heart_H3.FIXSEQ_CLEANED_READS.bed -n ALL_AGES_MERGED_Heart_H3K27ac -f 'BED' -g 'mm' --broad --keep-dup=all

# script from bedtools that remove overhangs that extend outside of the chromosomes in assembly (MACS extends peaks)
bedEndRepair.pl /Users/benayoun/Softwares/BedTools-2.16.1/genomes/mouse.mm9.genome ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.bed

# Stcik within 12.5kb, as in the Super Enhancer paper
mergeBed -d 12500 -i ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.repaired.bed | perl -lane 'print "$_\tStitchedEnhancer_$."' > ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed

# get coverage to build the super enhancer curve (bedtools functions)
coverageBed -counts -a ../BAM_clean/12m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 12m1_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/12m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 12m2_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/29m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 29m1_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/29m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 29m2_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/3m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 3m2_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/3m3_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 3m3_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed

coverageBed -counts -a ../BAM_clean/12m1_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 12m1_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/12m2_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 12m3_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/29m1_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 29m1_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/29m2_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 29m2_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/3m2_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 3m2_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed
coverageBed -counts -a ../BAM_clean/3m3_Heart_H3K27ac_trimmed.FIXSEQ_CLEANED_READS.bed -b ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed > 3m3_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed

# annotate peaks (HOMER function)
annotatePeaks.pl ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed mm9 > HOMER_ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.xls


# Merge coverage files for R analysis
merge_coverage_files.pl HOMER_ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.xls 3m2_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 3m3_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 12m1_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 12m3_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 29m1_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 29m2_Heart_H3K27ac_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 3m2_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 3m3_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 12m1_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 12m2_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 29m1_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed 29m2_Heart_H3_COMBINED_ENHANCERS.peaks.SampleCoverage.bed \
 > STITCHED_MACS2_ENHANCERS.Heart_SampleCoverage_Combined.xls

