#setwd('/Volumes/MyBookStudio/BD_aging_project/Heart/SuperEnhancer')
setwd('/Volumes/MyBook_3/BD_aging_project/ChIP-seq/Heart/SuperEnhancer')
source('~/Softwares/my_useful_scripts/SuperEnhancerScripts.R')
### script can be found in "Figure1_General/SuperEnhancer_scripts"

library(scales)

# read in coverage files (file is in this folder)
my.Heart.k27 <- read.csv('STITCHED_MACS2_ENHANCERS.Heart_SampleCoverage_Combined.xls',header=T, sep="\t")

my.lib.size <- apply(my.Heart.k27[,8:19],2,sum)

# apply lib size normalization
my.Heart.libSnorm <- my.Heart.k27[,8:19]
for (i in 1:12) {
  my.Heart.libSnorm[,i] <- 1e6 * my.Heart.libSnorm[,i]/my.lib.size[i]
}


# normalization of libs per bp

my.Heart.intnorm <- matrix(0,dim(my.Heart.k27)[1],6)
my.Heart_enh.breadth <- my.Heart.k27$End - my.Heart.k27$Start
for (i in 1:6) {
  my.Heart.intnorm[,i] <- my.Heart.libSnorm[,i]/my.Heart_enh.breadth
}


######## Combined determination, defined on 3m young
my.Heart.libSnorm.K27 <- apply(my.Heart.intnorm[,1:2],1,mean)

my.sort <- sort(my.Heart.libSnorm.K27,index.return=T,decreasing=T)

cutoff_options.cb <- calculate_cutoff(my.Heart.libSnorm.K27[my.sort$ix],"cb_Heart_H3K27ac_MACS_Se-Lite")
superEnhancerRows.cb <- which(my.Heart.libSnorm.K27 > cutoff_options.cb$absolute)
typicalEnhancers.cb <- setdiff(1:length(my.sort$ix),superEnhancerRows.cb)
length(superEnhancerRows.cb) # 1927

pdf("cb_Heart_H3K27ac_MACS_SE-Lite_plot.pdf")
plot(1:length(my.sort$ix),my.Heart.intnorm[my.sort$ix],xlim=c(length(my.sort$ix),1),
     type="b",col="red",ylab="H3K27ac signal at enhancers per million mapped reads per bp",
     xlab = "Rank by decreasing H3K27ac intensity",pch=16,cex=0.25)
abline(v=length(superEnhancerRows.cb),col="blue")
dev.off()


my.status <- c(rep("Super",length(superEnhancerRows.cb)), rep("Typical",length(my.sort$ix)-length(superEnhancerRows.cb)) )

my.data <- cbind(my.Heart.k27[my.sort$ix,c(2,3,4,1,5,6,7)],my.status)
my.data2 <- cbind(my.Heart.k27[my.sort$ix,c(2,3,4,1)],my.Heart.intnorm[my.sort$ix],my.status,my.Heart.k27[my.sort$ix,c(5,6,7)])

write.table(my.data, file="Annotated_ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.SuperEnhancers-Lite.xls",sep="\t",quote=F,row.names=F,col.names=F)
write.table(my.data[1:length(superEnhancerRows.cb),1:4], file="SuperEnhancers-Lite_ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed",sep="\t",quote=F,row.names=F,col.names=F)
write.table(my.data[(1+length(superEnhancerRows.cb)):length(my.sort$ix),1:4], file="TypicalEnhancers-Lite_Annotated_ALL_AGES_MERGED_Heart_H3K27ac_broad_peaks.stitched.bed",sep="\t",quote=F,row.names=F,col.names=F)
write.table(my.data2, file="Annotated_ALL_AGES_MERGED_Heart_H3K27ac_broad_peaksWITH-SELite-SCORE.xls",sep="\t",quote=F,row.names=F,col.names=F)


######## Per sample determination
my.Heart.3m1 <- get_sample_se(my.Heart.intnorm[,1],my.Heart.k27,"3m1_Heart") # 1936
my.Heart.3m2 <- get_sample_se(my.Heart.intnorm[,2],my.Heart.k27,"3m2_Heart") # 1924
my.Heart.12m1 <- get_sample_se(my.Heart.intnorm[,3],my.Heart.k27,"12m1_Heart") # 2188
my.Heart.12m3 <- get_sample_se(my.Heart.intnorm[,4],my.Heart.k27,"12m2_Heart") # 2502
my.Heart.29m1 <- get_sample_se(my.Heart.intnorm[,5],my.Heart.k27,"29m1_Heart") # 2279
my.Heart.29m2 <- get_sample_se(my.Heart.intnorm[,6],my.Heart.k27,"29m2_Heart") # 2408


################################################################################################################################################################
library('DiffBind')
library("rtracklayer")

################################################################################
##################   Diffbind Analysis: Super Enhancer Lite  ###################
################################################################################
load("/Volumes/MyBook_3/BD_aging_project/ChIP-seq/Heart/SuperEnhancer/SE_diffbind_data.RData")

Heart.aging.SE <- dba(sampleSheet="Heart_FIXSEQ_exp_K27ac_SuperEnhancersLite.csv",skipLines=1,attributes=c(DBA_ID,DBA_CONDITION))
Heart.aging.SE <- dba.count(Heart.aging.SE)


pdf("Heart_aging_K27ac_Super_Enhancers_Lite_clust_heatmap_Stitched.pdf")
plot(Heart.aging.SE, colScheme="Reds")
dev.off()

Heart.aging.SE <- dba.contrast(Heart.aging.SE, categories=DBA_CONDITION,minMembers=2)
Heart.aging.SE <- dba.analyze(Heart.aging.SE,method=DBA_ALL_METHODS)
Heart.aging.SE

#6 Samples, 2543 sites in matrix:
  
# 6 Contrasts:
#   Group1 Members1 Group2 Members2 DB.edgeR DB.DESeq DB.DESeq2
# 1     3m        2    12m        2      337      318       241
# 2     3m        2    29m        2       87       54       106
# 3     3m        2    !3m        4       36        3        13
# 4    12m        2    29m        2      169      166       313
# 5    12m        2   !12m        4       62       34       160
# 6    29m        2   !29m        4      111      108       299


#############
# linear modeling: export !!!!
write.table(Heart.aging.SE$allvectors,file="Heart_Diffbind_matrix_H3K27ac_concentration_in_SuperEnhancers.txt",quote=F,row.names=F,sep="\t")

