setwd('/Volumes/MyBook_3/BD_aging_project/Heart//H3K4me3_height_heart/')
load("/Volumes/MyBook_3/BD_aging_project/Heart/H3K4me3_height_heart/H3K4me3_height_data.RData")

library('DiffBind')
library("rtracklayer")

################################################################################
####################   Diffbind Analysis : H3K4me3 height  ####################
################################################################################

heart.aging <- dba(sampleSheet="Heart_FIXSEQ_exp_K4me3_height1.csv",skipLines=1,attributes=c(DBA_ID,DBA_CONDITION))
heart.aging <- dba.count(heart.aging)


pdf("heart_aging_H3K4me3_height_clust_heatmap_Stitched.pdf")
plot(heart.aging, colScheme="Reds")
dev.off()

heart.aging <- dba.contrast(heart.aging, categories=DBA_CONDITION,minMembers=2)
heart.aging <- dba.analyze(heart.aging,method=DBA_ALL_METHODS)
heart.aging
# 
# 6 Contrasts:
#   Group1 Members1 Group2 Members2 DB.edgeR DB.DESeq DB.DESeq2
# 1     3m        2    12m        2     1894      455        18
# 2     3m        2    29m        2     1570      143        34
# 3     3m        2    !3m        4      983        5        12
# 4    12m        2    29m        2     1182       23         5
# 5    12m        2   !12m        4      573        0         2
# 6    29m        2   !29m        4     1400      630      2274

#############
# DESeq2 table norm needed for linear modeling
# export normalized counts

write.table(heart.aging$allvectors,file="Heart_Diffbind_matrix_concentration_forS2norm.txt",quote=F,row.names=F,sep="\t")
