# Merge reads for meta peak calling
cat /Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/3m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/3m3_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/12m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/12m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/29m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/29m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed \
 > ALL_AGES_MERGED_Heart_H3.FIXSEQ_CLEANED_READS.bed

cat /Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/3m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/3m3_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/12m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/12m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/29m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed \
/Volumes/MyBookStudio/BD_aging_project/Heart/BAM_clean/29m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed \
 > ALL_AGES_MERGED_Heart_H3K4me3.FIXSEQ_CLEANED_READS.bed


# call meta peaks, all age merged
macs2 -t ALL_AGES_MERGED_Heart_H3K4me3.FIXSEQ_CLEANED_READS.bed -c ALL_AGES_MERGED_Heart_H3.FIXSEQ_CLEANED_READS.bed -n ALL_AGES_MERGED_Heart_H3K4me3 -f 'BED' -g 'mm' --broad --keep-dup=all


#### To adjust control track to same depth, count unique reads and adjust to lowest
#../BAM_clean/12m1_Heart_H3_trimmed.mp.srt.bam: 1.11 % PCR duplication rate (9251218 retained reads).
#../BAM_clean/12m2_Heart_H3_trimmed.mp.srt.bam: 1.17 % PCR duplication rate (11084036 retained reads).
#../BAM_clean/29m1_Heart_H3_trimmed.mp.srt.bam: 1.26 % PCR duplication rate (9016385 retained reads).
#../BAM_clean/29m2_Heart_H3_trimmed.mp.srt.bam: 5.99 % PCR duplication rate (8973317 retained reads).
#../BAM_clean/3m2_Heart_H3_trimmed.mp.srt.bam: 1.14 % PCR duplication rate (8351540 retained reads).
#../BAM_clean/3m3_Heart_H3_trimmed.mp.srt.bam: 1.24 % PCR duplication rate (8294887 retained reads). ===> Lowest depth, all H3 adjusted to that depth

ln -s ../BAM_clean/12m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/12m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/29m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/29m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/3m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/3m3_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed

# Down_sampling_bed_file.pl perl script is in "Figure1_General/Breadth_compare_bundle"
Down_sampling_bed_file.pl 8294887 12m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed 12m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed 29m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed 29m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed 3m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed 3m3_Heart_H3_trimmed.FIXSEQ_CLEANED_READS.bed


#### create coverage files for each 5% downsampling slice to make the CDF test
ln -s ../BAM_clean/3m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/3m3_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/12m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/12m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/29m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed
ln -s ../BAM_clean/29m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed

# breadth_ds_coverage_BED.sh bash script is in "Figure1_General/Breadth_compare_bundle"
breadth_ds_coverage_BED.sh 3m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed ALL_AGES_MERGED_Heart_H3K4me3_peaks.bed
breadth_ds_coverage_BED.sh 3m3_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed ALL_AGES_MERGED_Heart_H3K4me3_peaks.bed
breadth_ds_coverage_BED.sh 12m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed ALL_AGES_MERGED_Heart_H3K4me3_peaks.bed
breadth_ds_coverage_BED.sh 12m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed ALL_AGES_MERGED_Heart_H3K4me3_peaks.bed
breadth_ds_coverage_BED.sh 29m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed ALL_AGES_MERGED_Heart_H3K4me3_peaks.bed
breadth_ds_coverage_BED.sh 29m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS.bed ALL_AGES_MERGED_Heart_H3K4me3_peaks.bed


############ find appropriate adjustment level in R (get_cov_cdf_heart.R) #############

# call peaks with appropriate depth adjustment level
macs2 -t 3m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS40percent.bed -c 3m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -n 3m2_Heart_H3K4me3_ADJ -f 'BED' -g 'mm' --broad --keep-dup=all
macs2 -t 3m3_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS65percent.bed -c 3m3_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -n 3m3_Heart_H3K4me3_ADJ -f 'BED' -g 'mm' --broad --keep-dup=all
macs2 -t 12m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS55percent.bed -c 12m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -n 12m1_Heart_H3K4me3_ADJ -f 'BED' -g 'mm' --broad --keep-dup=all
macs2 -t 12m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS35percent.bed -c 12m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -n 12m2_Heart_H3K4me3_ADJ -f 'BED' -g 'mm' --broad --keep-dup=all
macs2 -t 29m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS45percent.bed -c 29m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -n 29m1_Heart_H3K4me3_ADJ -f 'BED' -g 'mm' --broad --keep-dup=all
macs2 -t 29m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS100percent.bed -c 29m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -n 29m2_Heart_H3K4me3_ADJ -f 'BED' -g 'mm' --broad --keep-dup=all

# create joint file for DEseq2 analysis
# compare_adjusted_peaks.pl perl script is in "Figure1_General/Breadth_compare_bundle"
compare_adjusted_peaks.pl mm9 ALL_AGES_MERGED_Heart_H3K4me3_broad_peaks.bed 3m2_Heart_H3K4me3_ADJ_broad_peaks.bed 3m3_Heart_H3K4me3_ADJ_broad_peaks.bed 12m1_Heart_H3K4me3_ADJ_broad_peaks.bed 12m2_Heart_H3K4me3_ADJ_broad_peaks.bed 29m1_Heart_H3K4me3_ADJ_broad_peaks.bed 29m2_Heart_H3K4me3_ADJ_broad_peaks.bed


#######
# greate bedgraphs for visualization (HOMER functions are used)
makeTagDirectory Heart_3m2_H3K4me3_ADJ_TAGs 3m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS40percent.bed -genome mm9 -format bed
makeTagDirectory Heart_3m2_H3_ADJ_TAGs 3m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -genome mm9 -format bed
makeTagDirectory Heart_3m3_H3K4me3_ADJ_TAGs 3m3_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS65percent.bed -genome mm9 -format bed
makeTagDirectory Heart_3m3_H3_ADJ_TAGs 3m3_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -genome mm9 -format bed
makeTagDirectory Heart_12m1_H3K4me3_ADJ_TAGs 12m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS55percent.bed -genome mm9 -format bed
makeTagDirectory Heart_12m1_H3_ADJ_TAGs 12m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -genome mm9 -format bed
makeTagDirectory Heart_12m2_H3K4me3_ADJ_TAGs 12m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS35percent.bed -genome mm9 -format bed
makeTagDirectory Heart_12m2_H3_ADJ_TAGs 12m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -genome mm9 -format bed
makeTagDirectory Heart_29m1_H3K4me3_ADJ_TAGs 29m1_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS45percent.bed -genome mm9 -format bed
makeTagDirectory Heart_29m1_H3_ADJ_TAGs 29m1_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -genome mm9 -format bed
makeTagDirectory Heart_29m2_H3K4me3_ADJ_TAGs 29m2_Heart_H3K4me3_trimmed.FIXSEQ_CLEANED_READS100percent.bed -genome mm9 -format bed
makeTagDirectory Heart_29m2_H3_ADJ_TAGs 29m2_Heart_H3_trimmed.FIXSEQ_CLEANED_READS_DS_8294887.bed -genome mm9 -format bed

makeUCSCfile Heart_3m2_H3K4me3_ADJ_TAGs/ -i Heart_3m2_H3_ADJ_TAGs/ -o Heart_3m2_H3K4me3_norm_to_H3.BREADTH.bedgraph -noadj -style chipseq -fsize 5e7 -res 1 -pseudo 1
makeUCSCfile Heart_3m3_H3K4me3_ADJ_TAGs/ -i Heart_3m3_H3_ADJ_TAGs/ -o Heart_3m3_H3K4me3_norm_to_H3.BREADTH.bedgraph -noadj -style chipseq -fsize 5e7 -res 1 -pseudo 1
makeUCSCfile Heart_12m1_H3K4me3_ADJ_TAGs/ -i Heart_12m1_H3_ADJ_TAGs/ -o Heart_12m1_H3K4me3_norm_to_H3.BREADTH.bedgraph -noadj -style chipseq -fsize 5e7 -res 1 -pseudo 1
makeUCSCfile Heart_12m2_H3K4me3_ADJ_TAGs/ -i Heart_12m2_H3_ADJ_TAGs/ -o Heart_12m2_H3K4me3_norm_to_H3.BREADTH.bedgraph -noadj -style chipseq -fsize 5e7 -res 1 -pseudo 1
makeUCSCfile Heart_29m1_H3K4me3_ADJ_TAGs/ -i Heart_29m1_H3_ADJ_TAGs/ -o Heart_29m1_H3K4me3_norm_to_H3.BREADTH.bedgraph -noadj -style chipseq -fsize 5e7 -res 1 -pseudo 1
makeUCSCfile Heart_29m2_H3K4me3_ADJ_TAGs/ -i Heart_29m2_H3_ADJ_TAGs/ -o Heart_29m2_H3K4me3_norm_to_H3.BREADTH.bedgraph -noadj -style chipseq -fsize 5e7 -res 1 -pseudo 1
